#ifndef __gifh__
  #include "gif.h"
#endif

bool IsGIF(FILE *file){
  unsigned char header[8];
  if(fseek(file,0,SEEK_SET)!=0) return false;
  if(fread(header,1,6,file)!=6) return false;
  if((memcmp(header,"GIF87a",6)==0)||(memcmp(header,"GIF89a",6)==0)) return true;
  return false;
}

bool GIFSize(FILE *file, int& height, int& width){
  unsigned char hi,lo;
  if(fseek(file,6,SEEK_SET)!=0) return false;
  if(fread(&lo,1,1,file)!=1) return false;
  if(fread(&hi,1,1,file)!=1) return false;
  width=(hi<<8)+lo;
  if(fread(&lo,1,1,file)!=1) return false;
  if(fread(&hi,1,1,file)!=1) return false;
  height=(hi<<8)+lo;
  return true;
}
