# 2023-10-03 Triage Log

A week completely free of pure regressions! The compiler has definitely come out of this week a decent amount faster and less memory hungry than before with the large gain coming from building the compiler with a single CGU on x64 Linux. This not only allows LLVM to do more optimizations across the entire compiler, but should hopefully also result in less non-deterministic performance regressions in the future. This improvement largely comes only at the expense of a few more minutes spent when bootstrapping the compiler.

Triage done by **@rylev**.
Revision range: [27b4eb..9998f4](https://perf.rust-lang.org/?start=27b4eb96d13106332d511be2ea6d0c008a57aa6e&end=9998f4add08c3d09c82e00975cf3a293b30160ec&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.3%, 6.1%]   | 41    |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.9%, 7.8%]   | 21    |
| Improvements ✅ <br /> (primary)   | -1.3% | [-5.1%, -0.2%] | 134   |
| Improvements ✅ <br /> (secondary) | -1.8% | [-6.9%, -0.2%] | 175   |
| All ❌✅ (primary)                 | -0.8% | [-5.1%, 6.1%]  | 175   |


0 Regressions, 2 Improvements, 4 Mixed; 0 of them in rollups
74 artifact comparisons made in total

#### Regressions


#### Improvements

rustdoc: speed up processing of cross-crate fns to fix a perf regression [#116195](https://github.com/rust-lang/rust/pull/116195) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=177091258c039398d30137b52e1c575a98aa7597&end=5282e5e120128ba589728ee4bcb4f18511ba9fb0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.3%] | 11    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 6     |


Cleanup number handling in match exhaustiveness [#116281](https://github.com/rust-lang/rust/pull/116281) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=51ddc7467978e265d2004d58980580293734ca93&end=e0d7ed1f453fb54578cc96dfea859b0e7be15016&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.5%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-1.5%, -0.3%] | 3     |


#### Mixed

Don't use a thread to load the dep graph [#116109](https://github.com/rust-lang/rust/pull/116109) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d23062b5be6bbf5be15226c7f497c89cf7d3d6e1&end=8bf0dec101dc458a411401a826994006abd2f022&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.5%, 1.1%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.3%, 1.1%]  | 6     |
- A very small regression that basically results in net zero change to performance.


Build `rustc` with a single CGU on x64 Linux [#115554](https://github.com/rust-lang/rust/pull/115554) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c16823d757b376f90c5f5cbd542ce83235befbc4&end=871407a0341262d2a86703ca43b449d35fa5f236&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.3%, 2.6%]   | 39    |
| Regressions ❌ <br /> (secondary)  | 1.6%  | [0.7%, 2.5%]   | 23    |
| Improvements ✅ <br /> (primary)   | -1.2% | [-3.9%, -0.2%] | 89    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-3.5%, -0.4%] | 124   |
| All ❌✅ (primary)                 | -0.6% | [-3.9%, 2.6%]  | 128   |
- The change is overwhelmingly positive (especially when taking other measures like max RSS and artifact size) making the small regressions acceptable
- Take a [look at cycles](https://perf.rust-lang.org/compare.html?start=c16823d757b376f90c5f5cbd542ce83235befbc4&end=871407a0341262d2a86703ca43b449d35fa5f236&stat=cycles%3Au) for a nearly completely regression free view of the positive nature of this change.


Rebased: Mark drop calls in landing pads cold instead of noinline [#102099](https://github.com/rust-lang/rust/pull/102099) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5333b878c8bc1c4267a67ea3682663629e47541a&end=2e5a9dd6c9eaa42f0684b4b760bd68fc27cbe51b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.5%  | [0.3%, 5.9%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 2.7%  | [0.4%, 7.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-4.5%, -0.2%] | 78    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-6.9%, -0.1%] | 65    |
| All ❌✅ (primary)                 | -0.2% | [-4.5%, 5.9%]  | 90    |
- Largely positive with a few large regressions caused by more time spent in LLVM. This seems to be expected and acceptable.


Make subtyping explicit in MIR [#115025](https://github.com/rust-lang/rust/pull/115025) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9998f4add08c3d09c82e00975cf3a293b30160ec&end=eb0f3ed59c6508a37c6598bc9762987f053993a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.4%, 0.8%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.1%]   | 17    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 0.0%  | [-0.6%, 0.8%]  | 4     |
- Small regression that is basically only seen in some secondary benchmarks. Unlikely to be worth deep investigation.

