// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/datacatalog/v1/policytagmanager.proto

package datacatalogpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines policy types where the policy tags can be used for.
type Taxonomy_PolicyType int32

const (
	// Unspecified policy type.
	Taxonomy_POLICY_TYPE_UNSPECIFIED Taxonomy_PolicyType = 0
	// Fine-grained access control policy that enables access control on
	// tagged sub-resources.
	Taxonomy_FINE_GRAINED_ACCESS_CONTROL Taxonomy_PolicyType = 1
)

// Enum value maps for Taxonomy_PolicyType.
var (
	Taxonomy_PolicyType_name = map[int32]string{
		0: "POLICY_TYPE_UNSPECIFIED",
		1: "FINE_GRAINED_ACCESS_CONTROL",
	}
	Taxonomy_PolicyType_value = map[string]int32{
		"POLICY_TYPE_UNSPECIFIED":     0,
		"FINE_GRAINED_ACCESS_CONTROL": 1,
	}
)

func (x Taxonomy_PolicyType) Enum() *Taxonomy_PolicyType {
	p := new(Taxonomy_PolicyType)
	*p = x
	return p
}

func (x Taxonomy_PolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Taxonomy_PolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_enumTypes[0].Descriptor()
}

func (Taxonomy_PolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_policytagmanager_proto_enumTypes[0]
}

func (x Taxonomy_PolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Taxonomy_PolicyType.Descriptor instead.
func (Taxonomy_PolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{0, 0}
}

// A taxonomy is a collection of hierarchical policy tags that classify data
// along a common axis.
//
// For example, a "data sensitivity" taxonomy might contain the following policy
// tags:
//
// ```
// + PII
//   - Account number
//   - Age
//   - SSN
//   - Zipcode
//
// + Financials
//   - Revenue
//
// ```
//
// A "data origin" taxonomy might contain the following policy tags:
//
// ```
// + User data
// + Employee data
// + Partner data
// + Public data
// ```
type Taxonomy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of this taxonomy in URL format.
	//
	// Note: Policy tag manager generates unique taxonomy IDs.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User-defined name of this taxonomy.
	//
	// The name can't start or end with spaces, must contain only Unicode letters,
	// numbers, underscores, dashes, and spaces, and be at most 200 bytes long
	// when encoded in UTF-8.
	//
	// The taxonomy display name must be unique within an organization.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of this taxonomy. If not set, defaults to empty.
	//
	// The description must contain only Unicode characters, tabs, newlines,
	// carriage returns, and page breaks, and be at most 2000 bytes long when
	// encoded in UTF-8.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Number of policy tags in this taxonomy.
	PolicyTagCount int32 `protobuf:"varint,4,opt,name=policy_tag_count,json=policyTagCount,proto3" json:"policy_tag_count,omitempty"`
	// Output only. Creation and modification timestamps of this taxonomy.
	TaxonomyTimestamps *SystemTimestamps `protobuf:"bytes,5,opt,name=taxonomy_timestamps,json=taxonomyTimestamps,proto3" json:"taxonomy_timestamps,omitempty"`
	// Optional. A list of policy types that are activated for this taxonomy. If
	// not set, defaults to an empty list.
	ActivatedPolicyTypes []Taxonomy_PolicyType `protobuf:"varint,6,rep,packed,name=activated_policy_types,json=activatedPolicyTypes,proto3,enum=google.cloud.datacatalog.v1.Taxonomy_PolicyType" json:"activated_policy_types,omitempty"`
	// Output only. Identity of the service which owns the Taxonomy. This field is
	// only populated when the taxonomy is created by a Google Cloud service.
	// Currently only 'DATAPLEX' is supported.
	Service *Taxonomy_Service `protobuf:"bytes,7,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Taxonomy) Reset() {
	*x = Taxonomy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Taxonomy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Taxonomy) ProtoMessage() {}

func (x *Taxonomy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Taxonomy.ProtoReflect.Descriptor instead.
func (*Taxonomy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{0}
}

func (x *Taxonomy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Taxonomy) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Taxonomy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Taxonomy) GetPolicyTagCount() int32 {
	if x != nil {
		return x.PolicyTagCount
	}
	return 0
}

func (x *Taxonomy) GetTaxonomyTimestamps() *SystemTimestamps {
	if x != nil {
		return x.TaxonomyTimestamps
	}
	return nil
}

func (x *Taxonomy) GetActivatedPolicyTypes() []Taxonomy_PolicyType {
	if x != nil {
		return x.ActivatedPolicyTypes
	}
	return nil
}

func (x *Taxonomy) GetService() *Taxonomy_Service {
	if x != nil {
		return x.Service
	}
	return nil
}

// Denotes one policy tag in a taxonomy, for example, SSN.
//
// Policy tags can be defined in a hierarchy. For example:
//
// ```
// + Geolocation
//   - LatLong
//   - City
//   - ZipCode
//
// ```
//
// Where the "Geolocation" policy tag contains three children.
type PolicyTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of this policy tag in the URL format.
	//
	// The policy tag manager generates unique taxonomy IDs and policy tag IDs.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User-defined name of this policy tag.
	//
	// The name can't start or end with spaces and must be unique within the
	// parent taxonomy, contain only Unicode letters, numbers, underscores, dashes
	// and spaces, and be at most 200 bytes long when encoded in UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of this policy tag. If not set, defaults to empty.
	//
	// The description must contain only Unicode characters,
	// tabs, newlines, carriage returns and page breaks, and be at most 2000 bytes
	// long when encoded in UTF-8.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource name of this policy tag's parent policy tag. If empty, this is a
	// top level tag. If not set, defaults to an empty string.
	//
	// For example, for the "LatLong" policy tag in the example above, this field
	// contains the resource name of the "Geolocation" policy tag, and, for
	// "Geolocation", this field is empty.
	ParentPolicyTag string `protobuf:"bytes,4,opt,name=parent_policy_tag,json=parentPolicyTag,proto3" json:"parent_policy_tag,omitempty"`
	// Output only. Resource names of child policy tags of this policy tag.
	ChildPolicyTags []string `protobuf:"bytes,5,rep,name=child_policy_tags,json=childPolicyTags,proto3" json:"child_policy_tags,omitempty"`
}

func (x *PolicyTag) Reset() {
	*x = PolicyTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyTag) ProtoMessage() {}

func (x *PolicyTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyTag.ProtoReflect.Descriptor instead.
func (*PolicyTag) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{1}
}

func (x *PolicyTag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyTag) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PolicyTag) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PolicyTag) GetParentPolicyTag() string {
	if x != nil {
		return x.ParentPolicyTag
	}
	return ""
}

func (x *PolicyTag) GetChildPolicyTags() []string {
	if x != nil {
		return x.ChildPolicyTags
	}
	return nil
}

// Request message for
// [CreateTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.CreateTaxonomy].
type CreateTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project that the taxonomy will belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The taxonomy to create.
	Taxonomy *Taxonomy `protobuf:"bytes,2,opt,name=taxonomy,proto3" json:"taxonomy,omitempty"`
}

func (x *CreateTaxonomyRequest) Reset() {
	*x = CreateTaxonomyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTaxonomyRequest) ProtoMessage() {}

func (x *CreateTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*CreateTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{2}
}

func (x *CreateTaxonomyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTaxonomyRequest) GetTaxonomy() *Taxonomy {
	if x != nil {
		return x.Taxonomy
	}
	return nil
}

// Request message for
// [DeleteTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.DeleteTaxonomy].
type DeleteTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the taxonomy to delete.
	//
	// Note: All policy tags in this taxonomy are also deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTaxonomyRequest) Reset() {
	*x = DeleteTaxonomyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTaxonomyRequest) ProtoMessage() {}

func (x *DeleteTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*DeleteTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteTaxonomyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [UpdateTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.UpdateTaxonomy].
type UpdateTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The taxonomy to update. You can update only its description, display name,
	// and activated policy types.
	Taxonomy *Taxonomy `protobuf:"bytes,1,opt,name=taxonomy,proto3" json:"taxonomy,omitempty"`
	// Specifies fields to update. If not set, defaults to all fields you can
	// update.
	//
	// For more information, see [FieldMask]
	// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTaxonomyRequest) Reset() {
	*x = UpdateTaxonomyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTaxonomyRequest) ProtoMessage() {}

func (x *UpdateTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*UpdateTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateTaxonomyRequest) GetTaxonomy() *Taxonomy {
	if x != nil {
		return x.Taxonomy
	}
	return nil
}

func (x *UpdateTaxonomyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [ListTaxonomies][google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies].
type ListTaxonomiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the project to list the taxonomies of.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Must be a value between 1 and 1000
	// inclusively. If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The pagination token of the next results page. If not set,
	// the first page is returned.
	//
	// The token is returned in the response to a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Supported field for filter is 'service' and value is 'dataplex'.
	// Eg: service=dataplex.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListTaxonomiesRequest) Reset() {
	*x = ListTaxonomiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTaxonomiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTaxonomiesRequest) ProtoMessage() {}

func (x *ListTaxonomiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTaxonomiesRequest.ProtoReflect.Descriptor instead.
func (*ListTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{5}
}

func (x *ListTaxonomiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTaxonomiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTaxonomiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTaxonomiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [ListTaxonomies][google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies].
type ListTaxonomiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Taxonomies that the project contains.
	Taxonomies []*Taxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
	// Pagination token of the next results page. Empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTaxonomiesResponse) Reset() {
	*x = ListTaxonomiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTaxonomiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTaxonomiesResponse) ProtoMessage() {}

func (x *ListTaxonomiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTaxonomiesResponse.ProtoReflect.Descriptor instead.
func (*ListTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{6}
}

func (x *ListTaxonomiesResponse) GetTaxonomies() []*Taxonomy {
	if x != nil {
		return x.Taxonomies
	}
	return nil
}

func (x *ListTaxonomiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [GetTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.GetTaxonomy].
type GetTaxonomyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the taxonomy to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTaxonomyRequest) Reset() {
	*x = GetTaxonomyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTaxonomyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTaxonomyRequest) ProtoMessage() {}

func (x *GetTaxonomyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTaxonomyRequest.ProtoReflect.Descriptor instead.
func (*GetTaxonomyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{7}
}

func (x *GetTaxonomyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CreatePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.CreatePolicyTag].
type CreatePolicyTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the taxonomy that the policy tag will belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The policy tag to create.
	PolicyTag *PolicyTag `protobuf:"bytes,2,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
}

func (x *CreatePolicyTagRequest) Reset() {
	*x = CreatePolicyTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePolicyTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePolicyTagRequest) ProtoMessage() {}

func (x *CreatePolicyTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePolicyTagRequest.ProtoReflect.Descriptor instead.
func (*CreatePolicyTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{8}
}

func (x *CreatePolicyTagRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePolicyTagRequest) GetPolicyTag() *PolicyTag {
	if x != nil {
		return x.PolicyTag
	}
	return nil
}

// Request message for
// [DeletePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.DeletePolicyTag].
type DeletePolicyTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the policy tag to delete.
	//
	// Note: All of its descendant policy tags are also deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePolicyTagRequest) Reset() {
	*x = DeletePolicyTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePolicyTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePolicyTagRequest) ProtoMessage() {}

func (x *DeletePolicyTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePolicyTagRequest.ProtoReflect.Descriptor instead.
func (*DeletePolicyTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{9}
}

func (x *DeletePolicyTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [UpdatePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.UpdatePolicyTag].
type UpdatePolicyTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy tag to update. You can update only its description, display
	// name, and parent policy tag fields.
	PolicyTag *PolicyTag `protobuf:"bytes,1,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
	// Specifies the fields to update.
	//
	// You can update only display name, description, and parent policy tag.
	// If not set, defaults to all updatable fields.
	// For more information, see [FieldMask]
	// (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePolicyTagRequest) Reset() {
	*x = UpdatePolicyTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePolicyTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePolicyTagRequest) ProtoMessage() {}

func (x *UpdatePolicyTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePolicyTagRequest.ProtoReflect.Descriptor instead.
func (*UpdatePolicyTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{10}
}

func (x *UpdatePolicyTagRequest) GetPolicyTag() *PolicyTag {
	if x != nil {
		return x.PolicyTag
	}
	return nil
}

func (x *UpdatePolicyTagRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [ListPolicyTags][google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags].
type ListPolicyTagsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the taxonomy to list the policy tags of.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Must be a value between 1 and 1000
	// inclusively.
	// If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The pagination token of the next results page. If not set, returns the
	// first page.
	//
	// The token is returned in the response to a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPolicyTagsRequest) Reset() {
	*x = ListPolicyTagsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPolicyTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyTagsRequest) ProtoMessage() {}

func (x *ListPolicyTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyTagsRequest.ProtoReflect.Descriptor instead.
func (*ListPolicyTagsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{11}
}

func (x *ListPolicyTagsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPolicyTagsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPolicyTagsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListPolicyTags][google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags].
type ListPolicyTagsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy tags that belong to the taxonomy.
	PolicyTags []*PolicyTag `protobuf:"bytes,1,rep,name=policy_tags,json=policyTags,proto3" json:"policy_tags,omitempty"`
	// Pagination token of the next results page. Empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPolicyTagsResponse) Reset() {
	*x = ListPolicyTagsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPolicyTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPolicyTagsResponse) ProtoMessage() {}

func (x *ListPolicyTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPolicyTagsResponse.ProtoReflect.Descriptor instead.
func (*ListPolicyTagsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{12}
}

func (x *ListPolicyTagsResponse) GetPolicyTags() []*PolicyTag {
	if x != nil {
		return x.PolicyTags
	}
	return nil
}

func (x *ListPolicyTagsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [GetPolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.GetPolicyTag].
type GetPolicyTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the policy tag.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPolicyTagRequest) Reset() {
	*x = GetPolicyTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPolicyTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPolicyTagRequest) ProtoMessage() {}

func (x *GetPolicyTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPolicyTagRequest.ProtoReflect.Descriptor instead.
func (*GetPolicyTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{13}
}

func (x *GetPolicyTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The source system of the Taxonomy.
type Taxonomy_Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud service name.
	Name ManagingSystem `protobuf:"varint,1,opt,name=name,proto3,enum=google.cloud.datacatalog.v1.ManagingSystem" json:"name,omitempty"`
	// The service agent for the service.
	Identity string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *Taxonomy_Service) Reset() {
	*x = Taxonomy_Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Taxonomy_Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Taxonomy_Service) ProtoMessage() {}

func (x *Taxonomy_Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Taxonomy_Service.ProtoReflect.Descriptor instead.
func (*Taxonomy_Service) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Taxonomy_Service) GetName() ManagingSystem {
	if x != nil {
		return x.Name
	}
	return ManagingSystem_MANAGING_SYSTEM_UNSPECIFIED
}

func (x *Taxonomy_Service) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

var File_google_cloud_datacatalog_v1_policytagmanager_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x74, 0x61, 0x67, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xde, 0x05, 0x0a, 0x08, 0x54, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x10,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x74, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73,
	0x12, 0x6b, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4c, 0x0a,
	0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x66, 0x0a, 0x07, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x22, 0x4a, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f,
	0x0a, 0x1b, 0x46, 0x49, 0x4e, 0x45, 0x5f, 0x47, 0x52, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x10, 0x01, 0x3a,
	0x67, 0xea, 0x41, 0x64, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x7d, 0x22, 0xce, 0x02, 0x0a, 0x09, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x24, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x61, 0x67, 0x12, 0x55, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
	0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f, 0x7b, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x7d, 0x22, 0x9f, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x08, 0x74, 0x61, 0x78, 0x6f,
	0x6e, 0x6f, 0x6d, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x79, 0x52, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x58, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xb0, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x12, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0x87, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e,
	0x6f, 0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a,
	0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x55, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74,
	0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67,
	0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x22, 0x5a, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x09,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x99, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x89, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x57,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xbb, 0x15, 0x0a, 0x10, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0xbf, 0x01, 0x0a,
	0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x52, 0xda, 0x41, 0x0f, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x08, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x12, 0x9b,
	0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc1, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x54, 0xda, 0x41, 0x08, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x08, 0x74,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x32, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61,
	0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xba, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x69, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f,
	0x6d, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x12, 0xa4, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54,
	0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x54, 0x61, 0x67, 0x22, 0x63, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x49, 0x3a, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x22, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x0f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78,
	0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd7, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x22, 0x67, 0xda, 0x41, 0x0a, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x0a, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x32, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x54, 0x61, 0x67, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x9e,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x51, 0x3a, 0x01, 0x2a,
	0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x3f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0xea, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x9e, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x97, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x3f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x96, 0x02, 0x0a,
	0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xaa, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xa3, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x54, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x45,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xdd, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x41, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescData = file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_policytagmanager_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_datacatalog_v1_policytagmanager_proto_goTypes = []interface{}{
	(Taxonomy_PolicyType)(0),                 // 0: google.cloud.datacatalog.v1.Taxonomy.PolicyType
	(*Taxonomy)(nil),                         // 1: google.cloud.datacatalog.v1.Taxonomy
	(*PolicyTag)(nil),                        // 2: google.cloud.datacatalog.v1.PolicyTag
	(*CreateTaxonomyRequest)(nil),            // 3: google.cloud.datacatalog.v1.CreateTaxonomyRequest
	(*DeleteTaxonomyRequest)(nil),            // 4: google.cloud.datacatalog.v1.DeleteTaxonomyRequest
	(*UpdateTaxonomyRequest)(nil),            // 5: google.cloud.datacatalog.v1.UpdateTaxonomyRequest
	(*ListTaxonomiesRequest)(nil),            // 6: google.cloud.datacatalog.v1.ListTaxonomiesRequest
	(*ListTaxonomiesResponse)(nil),           // 7: google.cloud.datacatalog.v1.ListTaxonomiesResponse
	(*GetTaxonomyRequest)(nil),               // 8: google.cloud.datacatalog.v1.GetTaxonomyRequest
	(*CreatePolicyTagRequest)(nil),           // 9: google.cloud.datacatalog.v1.CreatePolicyTagRequest
	(*DeletePolicyTagRequest)(nil),           // 10: google.cloud.datacatalog.v1.DeletePolicyTagRequest
	(*UpdatePolicyTagRequest)(nil),           // 11: google.cloud.datacatalog.v1.UpdatePolicyTagRequest
	(*ListPolicyTagsRequest)(nil),            // 12: google.cloud.datacatalog.v1.ListPolicyTagsRequest
	(*ListPolicyTagsResponse)(nil),           // 13: google.cloud.datacatalog.v1.ListPolicyTagsResponse
	(*GetPolicyTagRequest)(nil),              // 14: google.cloud.datacatalog.v1.GetPolicyTagRequest
	(*Taxonomy_Service)(nil),                 // 15: google.cloud.datacatalog.v1.Taxonomy.Service
	(*SystemTimestamps)(nil),                 // 16: google.cloud.datacatalog.v1.SystemTimestamps
	(*fieldmaskpb.FieldMask)(nil),            // 17: google.protobuf.FieldMask
	(ManagingSystem)(0),                      // 18: google.cloud.datacatalog.v1.ManagingSystem
	(*iampb.GetIamPolicyRequest)(nil),        // 19: google.iam.v1.GetIamPolicyRequest
	(*iampb.SetIamPolicyRequest)(nil),        // 20: google.iam.v1.SetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 21: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                    // 22: google.protobuf.Empty
	(*iampb.Policy)(nil),                     // 23: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 24: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_datacatalog_v1_policytagmanager_proto_depIdxs = []int32{
	16, // 0: google.cloud.datacatalog.v1.Taxonomy.taxonomy_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	0,  // 1: google.cloud.datacatalog.v1.Taxonomy.activated_policy_types:type_name -> google.cloud.datacatalog.v1.Taxonomy.PolicyType
	15, // 2: google.cloud.datacatalog.v1.Taxonomy.service:type_name -> google.cloud.datacatalog.v1.Taxonomy.Service
	1,  // 3: google.cloud.datacatalog.v1.CreateTaxonomyRequest.taxonomy:type_name -> google.cloud.datacatalog.v1.Taxonomy
	1,  // 4: google.cloud.datacatalog.v1.UpdateTaxonomyRequest.taxonomy:type_name -> google.cloud.datacatalog.v1.Taxonomy
	17, // 5: google.cloud.datacatalog.v1.UpdateTaxonomyRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 6: google.cloud.datacatalog.v1.ListTaxonomiesResponse.taxonomies:type_name -> google.cloud.datacatalog.v1.Taxonomy
	2,  // 7: google.cloud.datacatalog.v1.CreatePolicyTagRequest.policy_tag:type_name -> google.cloud.datacatalog.v1.PolicyTag
	2,  // 8: google.cloud.datacatalog.v1.UpdatePolicyTagRequest.policy_tag:type_name -> google.cloud.datacatalog.v1.PolicyTag
	17, // 9: google.cloud.datacatalog.v1.UpdatePolicyTagRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 10: google.cloud.datacatalog.v1.ListPolicyTagsResponse.policy_tags:type_name -> google.cloud.datacatalog.v1.PolicyTag
	18, // 11: google.cloud.datacatalog.v1.Taxonomy.Service.name:type_name -> google.cloud.datacatalog.v1.ManagingSystem
	3,  // 12: google.cloud.datacatalog.v1.PolicyTagManager.CreateTaxonomy:input_type -> google.cloud.datacatalog.v1.CreateTaxonomyRequest
	4,  // 13: google.cloud.datacatalog.v1.PolicyTagManager.DeleteTaxonomy:input_type -> google.cloud.datacatalog.v1.DeleteTaxonomyRequest
	5,  // 14: google.cloud.datacatalog.v1.PolicyTagManager.UpdateTaxonomy:input_type -> google.cloud.datacatalog.v1.UpdateTaxonomyRequest
	6,  // 15: google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies:input_type -> google.cloud.datacatalog.v1.ListTaxonomiesRequest
	8,  // 16: google.cloud.datacatalog.v1.PolicyTagManager.GetTaxonomy:input_type -> google.cloud.datacatalog.v1.GetTaxonomyRequest
	9,  // 17: google.cloud.datacatalog.v1.PolicyTagManager.CreatePolicyTag:input_type -> google.cloud.datacatalog.v1.CreatePolicyTagRequest
	10, // 18: google.cloud.datacatalog.v1.PolicyTagManager.DeletePolicyTag:input_type -> google.cloud.datacatalog.v1.DeletePolicyTagRequest
	11, // 19: google.cloud.datacatalog.v1.PolicyTagManager.UpdatePolicyTag:input_type -> google.cloud.datacatalog.v1.UpdatePolicyTagRequest
	12, // 20: google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags:input_type -> google.cloud.datacatalog.v1.ListPolicyTagsRequest
	14, // 21: google.cloud.datacatalog.v1.PolicyTagManager.GetPolicyTag:input_type -> google.cloud.datacatalog.v1.GetPolicyTagRequest
	19, // 22: google.cloud.datacatalog.v1.PolicyTagManager.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	20, // 23: google.cloud.datacatalog.v1.PolicyTagManager.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	21, // 24: google.cloud.datacatalog.v1.PolicyTagManager.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	1,  // 25: google.cloud.datacatalog.v1.PolicyTagManager.CreateTaxonomy:output_type -> google.cloud.datacatalog.v1.Taxonomy
	22, // 26: google.cloud.datacatalog.v1.PolicyTagManager.DeleteTaxonomy:output_type -> google.protobuf.Empty
	1,  // 27: google.cloud.datacatalog.v1.PolicyTagManager.UpdateTaxonomy:output_type -> google.cloud.datacatalog.v1.Taxonomy
	7,  // 28: google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies:output_type -> google.cloud.datacatalog.v1.ListTaxonomiesResponse
	1,  // 29: google.cloud.datacatalog.v1.PolicyTagManager.GetTaxonomy:output_type -> google.cloud.datacatalog.v1.Taxonomy
	2,  // 30: google.cloud.datacatalog.v1.PolicyTagManager.CreatePolicyTag:output_type -> google.cloud.datacatalog.v1.PolicyTag
	22, // 31: google.cloud.datacatalog.v1.PolicyTagManager.DeletePolicyTag:output_type -> google.protobuf.Empty
	2,  // 32: google.cloud.datacatalog.v1.PolicyTagManager.UpdatePolicyTag:output_type -> google.cloud.datacatalog.v1.PolicyTag
	13, // 33: google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags:output_type -> google.cloud.datacatalog.v1.ListPolicyTagsResponse
	2,  // 34: google.cloud.datacatalog.v1.PolicyTagManager.GetPolicyTag:output_type -> google.cloud.datacatalog.v1.PolicyTag
	23, // 35: google.cloud.datacatalog.v1.PolicyTagManager.GetIamPolicy:output_type -> google.iam.v1.Policy
	23, // 36: google.cloud.datacatalog.v1.PolicyTagManager.SetIamPolicy:output_type -> google.iam.v1.Policy
	24, // 37: google.cloud.datacatalog.v1.PolicyTagManager.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	25, // [25:38] is the sub-list for method output_type
	12, // [12:25] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_policytagmanager_proto_init() }
func file_google_cloud_datacatalog_v1_policytagmanager_proto_init() {
	if File_google_cloud_datacatalog_v1_policytagmanager_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_common_proto_init()
	file_google_cloud_datacatalog_v1_timestamps_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Taxonomy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTaxonomyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTaxonomyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTaxonomyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTaxonomiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTaxonomiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTaxonomyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePolicyTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePolicyTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePolicyTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPolicyTagsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPolicyTagsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPolicyTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Taxonomy_Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_policytagmanager_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_policytagmanager_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_v1_policytagmanager_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_v1_policytagmanager_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_policytagmanager_proto = out.File
	file_google_cloud_datacatalog_v1_policytagmanager_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_policytagmanager_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_policytagmanager_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyTagManagerClient is the client API for PolicyTagManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyTagManagerClient interface {
	// Creates a taxonomy in a specified project.
	//
	// The taxonomy is initially empty, that is, it doesn't contain policy tags.
	CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Deletes a taxonomy, including all policy tags in this
	// taxonomy, their associated policies, and the policy tags references from
	// BigQuery columns.
	DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a taxonomy, including its display name,
	// description, and activated policy types.
	UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that you
	// have a permission to view.
	ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Creates a policy tag in a taxonomy.
	CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Deletes a policy tag together with the following:
	//
	//   - All of its descendant policy tags, if any
	//   - Policies associated with the policy tag and its descendants
	//   - References from BigQuery table schema of the policy tag and its
	//     descendants
	DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a policy tag, including its display
	// name, description, and parent policy tag.
	UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Gets the IAM policy for a policy tag or a taxonomy.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the IAM policy for a policy tag or a taxonomy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns your permissions on a specified policy tag or
	// taxonomy.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type policyTagManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTagManagerClient(cc grpc.ClientConnInterface) PolicyTagManagerClient {
	return &policyTagManagerClient{cc}
}

func (c *policyTagManagerClient) CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/CreateTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/DeleteTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/UpdateTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error) {
	out := new(ListTaxonomiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/ListTaxonomies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/GetTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/CreatePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/DeletePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/UpdatePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error) {
	out := new(ListPolicyTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/ListPolicyTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/GetPolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.PolicyTagManager/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTagManagerServer is the server API for PolicyTagManager service.
type PolicyTagManagerServer interface {
	// Creates a taxonomy in a specified project.
	//
	// The taxonomy is initially empty, that is, it doesn't contain policy tags.
	CreateTaxonomy(context.Context, *CreateTaxonomyRequest) (*Taxonomy, error)
	// Deletes a taxonomy, including all policy tags in this
	// taxonomy, their associated policies, and the policy tags references from
	// BigQuery columns.
	DeleteTaxonomy(context.Context, *DeleteTaxonomyRequest) (*emptypb.Empty, error)
	// Updates a taxonomy, including its display name,
	// description, and activated policy types.
	UpdateTaxonomy(context.Context, *UpdateTaxonomyRequest) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that you
	// have a permission to view.
	ListTaxonomies(context.Context, *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(context.Context, *GetTaxonomyRequest) (*Taxonomy, error)
	// Creates a policy tag in a taxonomy.
	CreatePolicyTag(context.Context, *CreatePolicyTagRequest) (*PolicyTag, error)
	// Deletes a policy tag together with the following:
	//
	//   - All of its descendant policy tags, if any
	//   - Policies associated with the policy tag and its descendants
	//   - References from BigQuery table schema of the policy tag and its
	//     descendants
	DeletePolicyTag(context.Context, *DeletePolicyTagRequest) (*emptypb.Empty, error)
	// Updates a policy tag, including its display
	// name, description, and parent policy tag.
	UpdatePolicyTag(context.Context, *UpdatePolicyTagRequest) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(context.Context, *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(context.Context, *GetPolicyTagRequest) (*PolicyTag, error)
	// Gets the IAM policy for a policy tag or a taxonomy.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the IAM policy for a policy tag or a taxonomy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns your permissions on a specified policy tag or
	// taxonomy.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedPolicyTagManagerServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyTagManagerServer struct {
}

func (*UnimplementedPolicyTagManagerServer) CreateTaxonomy(context.Context, *CreateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) DeleteTaxonomy(context.Context, *DeleteTaxonomyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) UpdateTaxonomy(context.Context, *UpdateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) ListTaxonomies(context.Context, *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTaxonomies not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetTaxonomy(context.Context, *GetTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) CreatePolicyTag(context.Context, *CreatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) DeletePolicyTag(context.Context, *DeletePolicyTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) UpdatePolicyTag(context.Context, *UpdatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) ListPolicyTags(context.Context, *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyTags not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetPolicyTag(context.Context, *GetPolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterPolicyTagManagerServer(s *grpc.Server, srv PolicyTagManagerServer) {
	s.RegisterService(&_PolicyTagManager_serviceDesc, srv)
}

func _PolicyTagManager_CreateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/CreateTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, req.(*CreateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeleteTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/DeleteTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, req.(*DeleteTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/UpdateTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, req.(*UpdateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/ListTaxonomies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, req.(*ListTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/GetTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, req.(*GetTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_CreatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/CreatePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, req.(*CreatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeletePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/DeletePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, req.(*DeletePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/UpdatePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, req.(*UpdatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListPolicyTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/ListPolicyTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, req.(*ListPolicyTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetPolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/GetPolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, req.(*GetPolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.PolicyTagManager/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyTagManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.PolicyTagManager",
	HandlerType: (*PolicyTagManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTaxonomy",
			Handler:    _PolicyTagManager_CreateTaxonomy_Handler,
		},
		{
			MethodName: "DeleteTaxonomy",
			Handler:    _PolicyTagManager_DeleteTaxonomy_Handler,
		},
		{
			MethodName: "UpdateTaxonomy",
			Handler:    _PolicyTagManager_UpdateTaxonomy_Handler,
		},
		{
			MethodName: "ListTaxonomies",
			Handler:    _PolicyTagManager_ListTaxonomies_Handler,
		},
		{
			MethodName: "GetTaxonomy",
			Handler:    _PolicyTagManager_GetTaxonomy_Handler,
		},
		{
			MethodName: "CreatePolicyTag",
			Handler:    _PolicyTagManager_CreatePolicyTag_Handler,
		},
		{
			MethodName: "DeletePolicyTag",
			Handler:    _PolicyTagManager_DeletePolicyTag_Handler,
		},
		{
			MethodName: "UpdatePolicyTag",
			Handler:    _PolicyTagManager_UpdatePolicyTag_Handler,
		},
		{
			MethodName: "ListPolicyTags",
			Handler:    _PolicyTagManager_ListPolicyTags_Handler,
		},
		{
			MethodName: "GetPolicyTag",
			Handler:    _PolicyTagManager_GetPolicyTag_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _PolicyTagManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _PolicyTagManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _PolicyTagManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/policytagmanager.proto",
}
