// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/inventories/v1beta/regionalinventory.proto

package inventoriespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Regional inventory information for the product. Represents specific
// information like price and availability for a given product in a specific
// [`region`][google.shopping.merchant.inventories.v1beta.RegionalInventory.region].
// For a list of all accepted attribute values, see the [regional product
// inventory data
// specification](https://support.google.com/merchants/answer/9698880).
type RegionalInventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the `RegionalInventory` resource.
	// Format:
	// `{regional_inventory.name=accounts/{account}/products/{product}/regionalInventories/{region}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The account that owns the product. This field will be ignored
	// if set by the client.
	Account int64 `protobuf:"varint,2,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Immutable. ID of the region for this
	// `RegionalInventory` resource. See the [Regional availability and
	// pricing](https://support.google.com/merchants/answer/9698880) for more
	// details.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Price of the product in this region.
	Price *typepb.Price `protobuf:"bytes,4,opt,name=price,proto3" json:"price,omitempty"`
	// Sale price of the product in this region. Mandatory if
	// [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.RegionalInventory.sale_price_effective_date]
	// is defined.
	SalePrice *typepb.Price `protobuf:"bytes,5,opt,name=sale_price,json=salePrice,proto3" json:"sale_price,omitempty"`
	// The `TimePeriod` of the
	// sale price in this region.
	SalePriceEffectiveDate *interval.Interval `protobuf:"bytes,6,opt,name=sale_price_effective_date,json=salePriceEffectiveDate,proto3" json:"sale_price_effective_date,omitempty"`
	// Availability of the product in this region.
	// For accepted attribute values, see the [regional product inventory data
	// specification](https://support.google.com/merchants/answer/3061342)
	Availability *string `protobuf:"bytes,7,opt,name=availability,proto3,oneof" json:"availability,omitempty"`
	// A list of custom (merchant-provided) attributes. You can also use
	// `CustomAttribute` to submit any attribute of the data specification in its
	// generic form.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,8,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
}

func (x *RegionalInventory) Reset() {
	*x = RegionalInventory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegionalInventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegionalInventory) ProtoMessage() {}

func (x *RegionalInventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegionalInventory.ProtoReflect.Descriptor instead.
func (*RegionalInventory) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP(), []int{0}
}

func (x *RegionalInventory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RegionalInventory) GetAccount() int64 {
	if x != nil {
		return x.Account
	}
	return 0
}

func (x *RegionalInventory) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *RegionalInventory) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *RegionalInventory) GetSalePrice() *typepb.Price {
	if x != nil {
		return x.SalePrice
	}
	return nil
}

func (x *RegionalInventory) GetSalePriceEffectiveDate() *interval.Interval {
	if x != nil {
		return x.SalePriceEffectiveDate
	}
	return nil
}

func (x *RegionalInventory) GetAvailability() string {
	if x != nil && x.Availability != nil {
		return *x.Availability
	}
	return ""
}

func (x *RegionalInventory) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

// Request message for the `ListRegionalInventories` method.
type ListRegionalInventoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` of the parent product to list `RegionalInventory`
	// resources for. Format: `accounts/{account}/products/{product}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of `RegionalInventory` resources for the given product
	// to return. The service returns fewer than this value if the number of
	// inventories for the given product is less that than the `pageSize`. The
	// default value is 25000. The maximum value is 100000; If a value higher than
	// the maximum is specified, then the `pageSize` will default to the maximum.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListRegionalInventories` call.
	// Provide the page token to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListRegionalInventories`
	// must match the call that provided the page token. The token returned as
	// [nextPageToken][google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesResponse.next_page_token]
	// in the response to the previous request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRegionalInventoriesRequest) Reset() {
	*x = ListRegionalInventoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRegionalInventoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegionalInventoriesRequest) ProtoMessage() {}

func (x *ListRegionalInventoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegionalInventoriesRequest.ProtoReflect.Descriptor instead.
func (*ListRegionalInventoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP(), []int{1}
}

func (x *ListRegionalInventoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRegionalInventoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRegionalInventoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListRegionalInventories` method.
type ListRegionalInventoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `RegionalInventory` resources for the given product from the specified
	// account.
	RegionalInventories []*RegionalInventory `protobuf:"bytes,1,rep,name=regional_inventories,json=regionalInventories,proto3" json:"regional_inventories,omitempty"`
	// A token, which can be sent as `pageToken` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRegionalInventoriesResponse) Reset() {
	*x = ListRegionalInventoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRegionalInventoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegionalInventoriesResponse) ProtoMessage() {}

func (x *ListRegionalInventoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegionalInventoriesResponse.ProtoReflect.Descriptor instead.
func (*ListRegionalInventoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP(), []int{2}
}

func (x *ListRegionalInventoriesResponse) GetRegionalInventories() []*RegionalInventory {
	if x != nil {
		return x.RegionalInventories
	}
	return nil
}

func (x *ListRegionalInventoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `InsertRegionalInventory` method.
type InsertRegionalInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account and product where this inventory will be inserted.
	// Format: `accounts/{account}/products/{product}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Regional inventory information to add to the product. If the
	// product already has a `RegionalInventory` resource for the same `region`,
	// full replacement of the `RegionalInventory` resource is performed.
	RegionalInventory *RegionalInventory `protobuf:"bytes,2,opt,name=regional_inventory,json=regionalInventory,proto3" json:"regional_inventory,omitempty"`
}

func (x *InsertRegionalInventoryRequest) Reset() {
	*x = InsertRegionalInventoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertRegionalInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertRegionalInventoryRequest) ProtoMessage() {}

func (x *InsertRegionalInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertRegionalInventoryRequest.ProtoReflect.Descriptor instead.
func (*InsertRegionalInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP(), []int{3}
}

func (x *InsertRegionalInventoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertRegionalInventoryRequest) GetRegionalInventory() *RegionalInventory {
	if x != nil {
		return x.RegionalInventory
	}
	return nil
}

// Request message for the `DeleteRegionalInventory` method.
type DeleteRegionalInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `RegionalInventory` resource to delete.
	// Format:
	// `accounts/{account}/products/{product}/regionalInventories/{region}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRegionalInventoryRequest) Reset() {
	*x = DeleteRegionalInventoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRegionalInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRegionalInventoryRequest) ProtoMessage() {}

func (x *DeleteRegionalInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRegionalInventoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteRegionalInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRegionalInventoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_shopping_merchant_inventories_v1beta_regionalinventory_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb1, 0x04, 0x0a, 0x11, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1e,
	0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x31,
	0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63,
	0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x73, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x52, 0x09, 0x73, 0x61, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x50, 0x0a,
	0x19, 0x73, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x16, 0x73, 0x61, 0x6c, 0x65, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x27, 0x0a, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x3a, 0x75, 0xea, 0x41,
	0x72, 0x0a, 0x2c, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x42, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x22, 0xaa, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12,
	0x2c, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x14, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x13, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xe2, 0x01, 0x0a, 0x1e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x72, 0x0a, 0x12, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x6a, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0xdf, 0x06, 0x0a, 0x18, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8d,
	0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x91,
	0x02, 0x0a, 0x17, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x3a,
	0x12, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x22, 0x4d, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x12, 0xd5, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x4b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x2a, 0x46, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0xa4, 0x01, 0x0a, 0x2f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x57, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescData = file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDesc
)

func file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescData)
	})
	return file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDescData
}

var file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_goTypes = []interface{}{
	(*RegionalInventory)(nil),               // 0: google.shopping.merchant.inventories.v1beta.RegionalInventory
	(*ListRegionalInventoriesRequest)(nil),  // 1: google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesRequest
	(*ListRegionalInventoriesResponse)(nil), // 2: google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesResponse
	(*InsertRegionalInventoryRequest)(nil),  // 3: google.shopping.merchant.inventories.v1beta.InsertRegionalInventoryRequest
	(*DeleteRegionalInventoryRequest)(nil),  // 4: google.shopping.merchant.inventories.v1beta.DeleteRegionalInventoryRequest
	(*typepb.Price)(nil),                    // 5: google.shopping.type.Price
	(*interval.Interval)(nil),               // 6: google.type.Interval
	(*typepb.CustomAttribute)(nil),          // 7: google.shopping.type.CustomAttribute
	(*emptypb.Empty)(nil),                   // 8: google.protobuf.Empty
}
var file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.inventories.v1beta.RegionalInventory.price:type_name -> google.shopping.type.Price
	5, // 1: google.shopping.merchant.inventories.v1beta.RegionalInventory.sale_price:type_name -> google.shopping.type.Price
	6, // 2: google.shopping.merchant.inventories.v1beta.RegionalInventory.sale_price_effective_date:type_name -> google.type.Interval
	7, // 3: google.shopping.merchant.inventories.v1beta.RegionalInventory.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	0, // 4: google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesResponse.regional_inventories:type_name -> google.shopping.merchant.inventories.v1beta.RegionalInventory
	0, // 5: google.shopping.merchant.inventories.v1beta.InsertRegionalInventoryRequest.regional_inventory:type_name -> google.shopping.merchant.inventories.v1beta.RegionalInventory
	1, // 6: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.ListRegionalInventories:input_type -> google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesRequest
	3, // 7: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.InsertRegionalInventory:input_type -> google.shopping.merchant.inventories.v1beta.InsertRegionalInventoryRequest
	4, // 8: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.DeleteRegionalInventory:input_type -> google.shopping.merchant.inventories.v1beta.DeleteRegionalInventoryRequest
	2, // 9: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.ListRegionalInventories:output_type -> google.shopping.merchant.inventories.v1beta.ListRegionalInventoriesResponse
	0, // 10: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.InsertRegionalInventory:output_type -> google.shopping.merchant.inventories.v1beta.RegionalInventory
	8, // 11: google.shopping.merchant.inventories.v1beta.RegionalInventoryService.DeleteRegionalInventory:output_type -> google.protobuf.Empty
	9, // [9:12] is the sub-list for method output_type
	6, // [6:9] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_init() }
func file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_init() {
	if File_google_shopping_merchant_inventories_v1beta_regionalinventory_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegionalInventory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRegionalInventoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRegionalInventoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertRegionalInventoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRegionalInventoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes[0].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_inventories_v1beta_regionalinventory_proto = out.File
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_rawDesc = nil
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_goTypes = nil
	file_google_shopping_merchant_inventories_v1beta_regionalinventory_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RegionalInventoryServiceClient is the client API for RegionalInventoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RegionalInventoryServiceClient interface {
	// Lists the `RegionalInventory` resources for the given product in your
	// merchant account. The response might contain fewer items than specified by
	// `pageSize`.  If `pageToken` was returned in previous request, it can be
	// used to obtain additional results.
	//
	// `RegionalInventory` resources are listed per product for a given account.
	ListRegionalInventories(ctx context.Context, in *ListRegionalInventoriesRequest, opts ...grpc.CallOption) (*ListRegionalInventoriesResponse, error)
	// Inserts a `RegionalInventory` to a given product in your
	// merchant account.
	//
	// Replaces the full `RegionalInventory` resource if an entry with the same
	// [`region`][google.shopping.merchant.inventories.v1beta.RegionalInventory.region]
	// already exists for the product.
	//
	// It might take up to 30 minutes for the new or updated `RegionalInventory`
	// resource to appear in products.
	InsertRegionalInventory(ctx context.Context, in *InsertRegionalInventoryRequest, opts ...grpc.CallOption) (*RegionalInventory, error)
	// Deletes the specified `RegionalInventory` resource from the given product
	// in your merchant account.  It might take up to an hour for the
	// `RegionalInventory` to be deleted from the specific product.
	// Once you have received a successful delete response, wait for that
	// period before attempting a delete again.
	DeleteRegionalInventory(ctx context.Context, in *DeleteRegionalInventoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type regionalInventoryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRegionalInventoryServiceClient(cc grpc.ClientConnInterface) RegionalInventoryServiceClient {
	return &regionalInventoryServiceClient{cc}
}

func (c *regionalInventoryServiceClient) ListRegionalInventories(ctx context.Context, in *ListRegionalInventoriesRequest, opts ...grpc.CallOption) (*ListRegionalInventoriesResponse, error) {
	out := new(ListRegionalInventoriesResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/ListRegionalInventories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *regionalInventoryServiceClient) InsertRegionalInventory(ctx context.Context, in *InsertRegionalInventoryRequest, opts ...grpc.CallOption) (*RegionalInventory, error) {
	out := new(RegionalInventory)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/InsertRegionalInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *regionalInventoryServiceClient) DeleteRegionalInventory(ctx context.Context, in *DeleteRegionalInventoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/DeleteRegionalInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RegionalInventoryServiceServer is the server API for RegionalInventoryService service.
type RegionalInventoryServiceServer interface {
	// Lists the `RegionalInventory` resources for the given product in your
	// merchant account. The response might contain fewer items than specified by
	// `pageSize`.  If `pageToken` was returned in previous request, it can be
	// used to obtain additional results.
	//
	// `RegionalInventory` resources are listed per product for a given account.
	ListRegionalInventories(context.Context, *ListRegionalInventoriesRequest) (*ListRegionalInventoriesResponse, error)
	// Inserts a `RegionalInventory` to a given product in your
	// merchant account.
	//
	// Replaces the full `RegionalInventory` resource if an entry with the same
	// [`region`][google.shopping.merchant.inventories.v1beta.RegionalInventory.region]
	// already exists for the product.
	//
	// It might take up to 30 minutes for the new or updated `RegionalInventory`
	// resource to appear in products.
	InsertRegionalInventory(context.Context, *InsertRegionalInventoryRequest) (*RegionalInventory, error)
	// Deletes the specified `RegionalInventory` resource from the given product
	// in your merchant account.  It might take up to an hour for the
	// `RegionalInventory` to be deleted from the specific product.
	// Once you have received a successful delete response, wait for that
	// period before attempting a delete again.
	DeleteRegionalInventory(context.Context, *DeleteRegionalInventoryRequest) (*emptypb.Empty, error)
}

// UnimplementedRegionalInventoryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRegionalInventoryServiceServer struct {
}

func (*UnimplementedRegionalInventoryServiceServer) ListRegionalInventories(context.Context, *ListRegionalInventoriesRequest) (*ListRegionalInventoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRegionalInventories not implemented")
}
func (*UnimplementedRegionalInventoryServiceServer) InsertRegionalInventory(context.Context, *InsertRegionalInventoryRequest) (*RegionalInventory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertRegionalInventory not implemented")
}
func (*UnimplementedRegionalInventoryServiceServer) DeleteRegionalInventory(context.Context, *DeleteRegionalInventoryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRegionalInventory not implemented")
}

func RegisterRegionalInventoryServiceServer(s *grpc.Server, srv RegionalInventoryServiceServer) {
	s.RegisterService(&_RegionalInventoryService_serviceDesc, srv)
}

func _RegionalInventoryService_ListRegionalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegionalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegionalInventoryServiceServer).ListRegionalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/ListRegionalInventories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegionalInventoryServiceServer).ListRegionalInventories(ctx, req.(*ListRegionalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegionalInventoryService_InsertRegionalInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertRegionalInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegionalInventoryServiceServer).InsertRegionalInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/InsertRegionalInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegionalInventoryServiceServer).InsertRegionalInventory(ctx, req.(*InsertRegionalInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RegionalInventoryService_DeleteRegionalInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegionalInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegionalInventoryServiceServer).DeleteRegionalInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.RegionalInventoryService/DeleteRegionalInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegionalInventoryServiceServer).DeleteRegionalInventory(ctx, req.(*DeleteRegionalInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RegionalInventoryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.inventories.v1beta.RegionalInventoryService",
	HandlerType: (*RegionalInventoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRegionalInventories",
			Handler:    _RegionalInventoryService_ListRegionalInventories_Handler,
		},
		{
			MethodName: "InsertRegionalInventory",
			Handler:    _RegionalInventoryService_InsertRegionalInventory_Handler,
		},
		{
			MethodName: "DeleteRegionalInventory",
			Handler:    _RegionalInventoryService_DeleteRegionalInventory_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/inventories/v1beta/regionalinventory.proto",
}
