#pragma once
/*
 *  $Id: raw-data.h 28232 2025-07-16 10:46:35Z yeti-dn $
 *  Copyright (C) 2003-2021 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_RAW_DATA_H__
#define __GWY_RAW_DATA_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
    GWY_RAW_DATA_SINT8,
    GWY_RAW_DATA_UINT8,
    GWY_RAW_DATA_SINT16,
    GWY_RAW_DATA_UINT16,
    GWY_RAW_DATA_SINT32,
    GWY_RAW_DATA_UINT32,
    GWY_RAW_DATA_SINT64,
    GWY_RAW_DATA_UINT64,
    GWY_RAW_DATA_HALF,
    GWY_RAW_DATA_FLOAT,
    GWY_RAW_DATA_REAL,
    GWY_RAW_DATA_DOUBLE,
    GWY_RAW_DATA_BIT,
    GWY_RAW_DATA_SINT4,
    GWY_RAW_DATA_UINT4,
    GWY_RAW_DATA_SINT12,
    GWY_RAW_DATA_UINT12,
    GWY_RAW_DATA_SINT24,
    GWY_RAW_DATA_UINT24,
    GWY_RAW_DATA_EXTENDED,
} GwyRawDataType;

typedef enum {
    GWY_BYTE_ORDER_NATIVE        = 0,
    GWY_BYTE_ORDER_LITTLE_ENDIAN = G_LITTLE_ENDIAN,
    GWY_BYTE_ORDER_BIG_ENDIAN    = G_BIG_ENDIAN,
    GWY_BYTE_ORDER_IMPLICIT      = 9999,
} GwyByteOrder;

void  gwy_convert_raw_data  (gconstpointer data,
                             gsize nitems,
                             gssize stride,
                             GwyRawDataType datatype,
                             GwyByteOrder byteorder,
                             gdouble *target,
                             gdouble scale,
                             gdouble offset);
guint gwy_raw_data_size     (GwyRawDataType datatype);
guint gwy_raw_data_size_bits(GwyRawDataType datatype);
void  gwy_memcpy_byte_swap  (const guint8 *source,
                             guint8 *dest,
                             gsize item_size,
                             gsize nitems,
                             gsize byteswap);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
