/**
 * \file pappsomspp/processing/cbor/jsonstreamwriter.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief PAPPSO JSON stream writer
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include <QTextStream>
#include <QCborMap>
#include <QCborArray>
#include <QIODevice>


#include "pappsomspp/export-import-config.h"

namespace pappso::cbor
{
/**
 * @todo write docs
 */
 class PMSPP_LIB_DECL JsonStreamWriter : public QTextStream
{
  public:
  /**
   * Default constructor
   */
  JsonStreamWriter(QIODevice *device);

  /**
   * Destructor
   */
  virtual ~JsonStreamWriter();

  void startArray();
  void endArray();
  void startMap();
  void endMap();


  void writeCborMap(const QCborMap &cbor_map);
  void writeCborArray(const QCborArray &cbor_array);
  void appendKey(const QString &key);
  void appendValue(const QString &value);
  void appendValue(std::size_t integer_size_value);
  void writeArray(QStringList &str_list);

  protected:
  void comma();

  private:
  bool m_isStart     = true;
  bool m_nextIsValue = false;
};
} // namespace pappso::cbor
