/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQGRIBMESSAGESCANNER_H
#define MVQGRIBMESSAGESCANNER_H

#include "MvQAbstractMessageScanner.h"

class GribMessageScanner : public MvQAbstractMessageScanner
{
    Q_OBJECT

public:
    GribMessageScanner(MvMessageMetaData*, QObject* parent = 0);
    ~GribMessageScanner();

protected slots:
    void slotProgress(int percent, MvKeyProfile* chunkProf, int chunkStart, int chunkSize);
    void slotTotalMessageNumComputed();

signals:
    void progress(int percent, MvKeyProfile* chunkProf, int chunkStart, int chunkSize);

protected:
    bool useThreadForScanning(qint64 fSize) const;
    bool precomputeMessageNum() const;
    void readMessages(MvKeyProfile* prof);
    void readMessage(MvKeyProfile* prof, codes_handle* ch, int msgCnt, int profIndex);

    bool hasMultiMessage_;
};

#endif  // MVQGRIBMESSAGESCANNER_H
