# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AccountSas(_serialization.Model):
    """The details for storage account sas creation.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time_stamp: Sas token start timestamp. Required.
    :vartype start_time_stamp: ~datetime.datetime
    :ivar expiry_time_stamp: Sas token expiry timestamp. Required.
    :vartype expiry_time_stamp: ~datetime.datetime
    :ivar ip_address: Ip Address. Required.
    :vartype ip_address: str
    """

    _validation = {
        "start_time_stamp": {"required": True},
        "expiry_time_stamp": {"required": True},
        "ip_address": {"required": True},
    }

    _attribute_map = {
        "start_time_stamp": {"key": "startTimeStamp", "type": "iso-8601"},
        "expiry_time_stamp": {"key": "expiryTimeStamp", "type": "iso-8601"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_time_stamp: datetime.datetime,
        expiry_time_stamp: datetime.datetime,
        ip_address: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time_stamp: Sas token start timestamp. Required.
        :paramtype start_time_stamp: ~datetime.datetime
        :keyword expiry_time_stamp: Sas token expiry timestamp. Required.
        :paramtype expiry_time_stamp: ~datetime.datetime
        :keyword ip_address: Ip Address. Required.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.start_time_stamp = start_time_stamp
        self.expiry_time_stamp = expiry_time_stamp
        self.ip_address = ip_address


class AccountSasToken(_serialization.Model):
    """Details of storage account sas token .

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_sas_token: Field to specify storage account sas token. Required.
    :vartype storage_account_sas_token: str
    """

    _validation = {
        "storage_account_sas_token": {"required": True},
    }

    _attribute_map = {
        "storage_account_sas_token": {"key": "storageAccountSasToken", "type": "str"},
    }

    def __init__(self, *, storage_account_sas_token: str, **kwargs: Any) -> None:
        """
        :keyword storage_account_sas_token: Field to specify storage account sas token. Required.
        :paramtype storage_account_sas_token: str
        """
        super().__init__(**kwargs)
        self.storage_account_sas_token = storage_account_sas_token


class ConsumptionEndpointsProperties(_serialization.Model):
    """Details of Consumption Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ingestion_url: Ingestion url to upload the data.
    :vartype ingestion_url: str
    :ivar ingestion_resource_id: Resource Id of ingestion endpoint.
    :vartype ingestion_resource_id: str
    :ivar file_access_url: Url to consume file type.
    :vartype file_access_url: str
    :ivar file_access_resource_id: Resource Id of file access endpoint.
    :vartype file_access_resource_id: str
    :ivar query_url: Url to consume the processed data.
    :vartype query_url: str
    :ivar query_resource_id: Resource Id of query endpoint.
    :vartype query_resource_id: str
    """

    _validation = {
        "ingestion_url": {"readonly": True},
        "ingestion_resource_id": {"readonly": True},
        "file_access_url": {"readonly": True},
        "file_access_resource_id": {"readonly": True},
        "query_url": {"readonly": True},
        "query_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "ingestion_url": {"key": "ingestionUrl", "type": "str"},
        "ingestion_resource_id": {"key": "ingestionResourceId", "type": "str"},
        "file_access_url": {"key": "fileAccessUrl", "type": "str"},
        "file_access_resource_id": {"key": "fileAccessResourceId", "type": "str"},
        "query_url": {"key": "queryUrl", "type": "str"},
        "query_resource_id": {"key": "queryResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ingestion_url = None
        self.ingestion_resource_id = None
        self.file_access_url = None
        self.file_access_resource_id = None
        self.query_url = None
        self.query_resource_id = None


class ContainerSaS(_serialization.Model):
    """The details for container sas creation.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time_stamp: Sas token start timestamp. Required.
    :vartype start_time_stamp: ~datetime.datetime
    :ivar expiry_time_stamp: Sas token expiry timestamp. Required.
    :vartype expiry_time_stamp: ~datetime.datetime
    :ivar ip_address: Ip Address. Required.
    :vartype ip_address: str
    """

    _validation = {
        "start_time_stamp": {"required": True},
        "expiry_time_stamp": {"required": True},
        "ip_address": {"required": True},
    }

    _attribute_map = {
        "start_time_stamp": {"key": "startTimeStamp", "type": "iso-8601"},
        "expiry_time_stamp": {"key": "expiryTimeStamp", "type": "iso-8601"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_time_stamp: datetime.datetime,
        expiry_time_stamp: datetime.datetime,
        ip_address: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time_stamp: Sas token start timestamp. Required.
        :paramtype start_time_stamp: ~datetime.datetime
        :keyword expiry_time_stamp: Sas token expiry timestamp. Required.
        :paramtype expiry_time_stamp: ~datetime.datetime
        :keyword ip_address: Ip Address. Required.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.start_time_stamp = start_time_stamp
        self.expiry_time_stamp = expiry_time_stamp
        self.ip_address = ip_address


class ContainerSasToken(_serialization.Model):
    """Details of storage container account sas token .

    All required parameters must be populated in order to send to Azure.

    :ivar storage_container_sas_token: Field to specify storage container sas token. Required.
    :vartype storage_container_sas_token: str
    """

    _validation = {
        "storage_container_sas_token": {"required": True},
    }

    _attribute_map = {
        "storage_container_sas_token": {"key": "storageContainerSasToken", "type": "str"},
    }

    def __init__(self, *, storage_container_sas_token: str, **kwargs: Any) -> None:
        """
        :keyword storage_container_sas_token: Field to specify storage container sas token. Required.
        :paramtype storage_container_sas_token: str
        """
        super().__init__(**kwargs)
        self.storage_container_sas_token = storage_container_sas_token


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DataProduct(TrackedResource):
    """The data product resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.networkanalytics.models.DataProductProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.networkanalytics.models.ManagedServiceIdentity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DataProductProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.DataProductProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.networkanalytics.models.DataProductProperties
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.networkanalytics.models.ManagedServiceIdentity
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.identity = identity


class DataProductInformation(_serialization.Model):
    """Data Product Information.

    All required parameters must be populated in order to send to Azure.

    :ivar data_product_name: Name of data product. Required.
    :vartype data_product_name: str
    :ivar description: Description about data product. Required.
    :vartype description: str
    :ivar data_product_versions: Version information of data product. Required.
    :vartype data_product_versions: list[~azure.mgmt.networkanalytics.models.DataProductVersion]
    """

    _validation = {
        "data_product_name": {"required": True},
        "description": {"required": True},
        "data_product_versions": {"required": True},
    }

    _attribute_map = {
        "data_product_name": {"key": "dataProductName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "data_product_versions": {"key": "dataProductVersions", "type": "[DataProductVersion]"},
    }

    def __init__(
        self,
        *,
        data_product_name: str,
        description: str,
        data_product_versions: List["_models.DataProductVersion"],
        **kwargs: Any
    ) -> None:
        """
        :keyword data_product_name: Name of data product. Required.
        :paramtype data_product_name: str
        :keyword description: Description about data product. Required.
        :paramtype description: str
        :keyword data_product_versions: Version information of data product. Required.
        :paramtype data_product_versions: list[~azure.mgmt.networkanalytics.models.DataProductVersion]
        """
        super().__init__(**kwargs)
        self.data_product_name = data_product_name
        self.description = description
        self.data_product_versions = data_product_versions


class DataProductListResult(_serialization.Model):
    """The response of a DataProduct list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The DataProduct items on this page. Required.
    :vartype value: list[~azure.mgmt.networkanalytics.models.DataProduct]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataProduct]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DataProduct"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DataProduct items on this page. Required.
        :paramtype value: list[~azure.mgmt.networkanalytics.models.DataProduct]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataProductNetworkAcls(_serialization.Model):
    """Data Product Network rule set.

    All required parameters must be populated in order to send to Azure.

    :ivar virtual_network_rule: Virtual Network Rule. Required.
    :vartype virtual_network_rule: list[~azure.mgmt.networkanalytics.models.VirtualNetworkRule]
    :ivar ip_rules: IP rule with specific IP or IP range in CIDR format. Required.
    :vartype ip_rules: list[~azure.mgmt.networkanalytics.models.IPRules]
    :ivar allowed_query_ip_range_list: The list of query ips in the format of CIDR allowed to
     connect to query/visualization endpoint. Required.
    :vartype allowed_query_ip_range_list: list[str]
    :ivar default_action: Default Action. Required. Known values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.networkanalytics.models.DefaultAction
    """

    _validation = {
        "virtual_network_rule": {"required": True},
        "ip_rules": {"required": True},
        "allowed_query_ip_range_list": {"required": True},
        "default_action": {"required": True},
    }

    _attribute_map = {
        "virtual_network_rule": {"key": "virtualNetworkRule", "type": "[VirtualNetworkRule]"},
        "ip_rules": {"key": "ipRules", "type": "[IPRules]"},
        "allowed_query_ip_range_list": {"key": "allowedQueryIpRangeList", "type": "[str]"},
        "default_action": {"key": "defaultAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network_rule: List["_models.VirtualNetworkRule"],
        ip_rules: List["_models.IPRules"],
        allowed_query_ip_range_list: List[str],
        default_action: Union[str, "_models.DefaultAction"],
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network_rule: Virtual Network Rule. Required.
        :paramtype virtual_network_rule: list[~azure.mgmt.networkanalytics.models.VirtualNetworkRule]
        :keyword ip_rules: IP rule with specific IP or IP range in CIDR format. Required.
        :paramtype ip_rules: list[~azure.mgmt.networkanalytics.models.IPRules]
        :keyword allowed_query_ip_range_list: The list of query ips in the format of CIDR allowed to
         connect to query/visualization endpoint. Required.
        :paramtype allowed_query_ip_range_list: list[str]
        :keyword default_action: Default Action. Required. Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.networkanalytics.models.DefaultAction
        """
        super().__init__(**kwargs)
        self.virtual_network_rule = virtual_network_rule
        self.ip_rules = ip_rules
        self.allowed_query_ip_range_list = allowed_query_ip_range_list
        self.default_action = default_action


class DataProductProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The data product properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_guid: The resource GUID property of the data product resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Latest provisioning state  of data product. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkanalytics.models.ProvisioningState
    :ivar publisher: Data product publisher name. Required.
    :vartype publisher: str
    :ivar product: Product name of data product. Required.
    :vartype product: str
    :ivar major_version: Major version of data product. Required.
    :vartype major_version: str
    :ivar owners: List of name or email associated with data product resource deployment.
    :vartype owners: list[str]
    :ivar redundancy: Flag to enable or disable redundancy for data product. Known values are:
     "Enabled" and "Disabled".
    :vartype redundancy: str or ~azure.mgmt.networkanalytics.models.ControlState
    :ivar purview_account: Purview account url for data product to connect to.
    :vartype purview_account: str
    :ivar purview_collection: Purview collection url for data product to connect to.
    :vartype purview_collection: str
    :ivar private_links_enabled: Flag to enable or disable private link for data product resource.
     Known values are: "Enabled" and "Disabled".
    :vartype private_links_enabled: str or ~azure.mgmt.networkanalytics.models.ControlState
    :ivar public_network_access: Flag to enable or disable public access of data product resource.
     Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.networkanalytics.models.ControlState
    :ivar customer_managed_key_encryption_enabled: Flag to enable customer managed key encryption
     for data product. Known values are: "Enabled" and "Disabled".
    :vartype customer_managed_key_encryption_enabled: str or
     ~azure.mgmt.networkanalytics.models.ControlState
    :ivar customer_encryption_key: Customer managed encryption key details for data product.
    :vartype customer_encryption_key: ~azure.mgmt.networkanalytics.models.EncryptionKeyDetails
    :ivar networkacls: Network rule set for data product.
    :vartype networkacls: ~azure.mgmt.networkanalytics.models.DataProductNetworkAcls
    :ivar managed_resource_group_configuration: Managed resource group configuration.
    :vartype managed_resource_group_configuration:
     ~azure.mgmt.networkanalytics.models.ManagedResourceGroupConfiguration
    :ivar available_minor_versions: List of available minor versions of the data product resource.
    :vartype available_minor_versions: list[str]
    :ivar current_minor_version: Current configured minor version of the data product resource.
    :vartype current_minor_version: str
    :ivar documentation: Documentation link for the data product based on definition file.
    :vartype documentation: str
    :ivar consumption_endpoints: Resource links which exposed to the customer to query the data.
    :vartype consumption_endpoints:
     ~azure.mgmt.networkanalytics.models.ConsumptionEndpointsProperties
    :ivar key_vault_url: Key vault url.
    :vartype key_vault_url: str
    """

    _validation = {
        "resource_guid": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "publisher": {"required": True},
        "product": {"required": True},
        "major_version": {"required": True},
        "available_minor_versions": {"readonly": True},
        "documentation": {"readonly": True},
        "consumption_endpoints": {"readonly": True},
        "key_vault_url": {"readonly": True},
    }

    _attribute_map = {
        "resource_guid": {"key": "resourceGuid", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "major_version": {"key": "majorVersion", "type": "str"},
        "owners": {"key": "owners", "type": "[str]"},
        "redundancy": {"key": "redundancy", "type": "str"},
        "purview_account": {"key": "purviewAccount", "type": "str"},
        "purview_collection": {"key": "purviewCollection", "type": "str"},
        "private_links_enabled": {"key": "privateLinksEnabled", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "customer_managed_key_encryption_enabled": {"key": "customerManagedKeyEncryptionEnabled", "type": "str"},
        "customer_encryption_key": {"key": "customerEncryptionKey", "type": "EncryptionKeyDetails"},
        "networkacls": {"key": "networkacls", "type": "DataProductNetworkAcls"},
        "managed_resource_group_configuration": {
            "key": "managedResourceGroupConfiguration",
            "type": "ManagedResourceGroupConfiguration",
        },
        "available_minor_versions": {"key": "availableMinorVersions", "type": "[str]"},
        "current_minor_version": {"key": "currentMinorVersion", "type": "str"},
        "documentation": {"key": "documentation", "type": "str"},
        "consumption_endpoints": {"key": "consumptionEndpoints", "type": "ConsumptionEndpointsProperties"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: str,
        product: str,
        major_version: str,
        owners: Optional[List[str]] = None,
        redundancy: Optional[Union[str, "_models.ControlState"]] = None,
        purview_account: Optional[str] = None,
        purview_collection: Optional[str] = None,
        private_links_enabled: Optional[Union[str, "_models.ControlState"]] = None,
        public_network_access: Optional[Union[str, "_models.ControlState"]] = None,
        customer_managed_key_encryption_enabled: Optional[Union[str, "_models.ControlState"]] = None,
        customer_encryption_key: Optional["_models.EncryptionKeyDetails"] = None,
        networkacls: Optional["_models.DataProductNetworkAcls"] = None,
        managed_resource_group_configuration: Optional["_models.ManagedResourceGroupConfiguration"] = None,
        current_minor_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: Data product publisher name. Required.
        :paramtype publisher: str
        :keyword product: Product name of data product. Required.
        :paramtype product: str
        :keyword major_version: Major version of data product. Required.
        :paramtype major_version: str
        :keyword owners: List of name or email associated with data product resource deployment.
        :paramtype owners: list[str]
        :keyword redundancy: Flag to enable or disable redundancy for data product. Known values are:
         "Enabled" and "Disabled".
        :paramtype redundancy: str or ~azure.mgmt.networkanalytics.models.ControlState
        :keyword purview_account: Purview account url for data product to connect to.
        :paramtype purview_account: str
        :keyword purview_collection: Purview collection url for data product to connect to.
        :paramtype purview_collection: str
        :keyword private_links_enabled: Flag to enable or disable private link for data product
         resource. Known values are: "Enabled" and "Disabled".
        :paramtype private_links_enabled: str or ~azure.mgmt.networkanalytics.models.ControlState
        :keyword public_network_access: Flag to enable or disable public access of data product
         resource. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.networkanalytics.models.ControlState
        :keyword customer_managed_key_encryption_enabled: Flag to enable customer managed key
         encryption for data product. Known values are: "Enabled" and "Disabled".
        :paramtype customer_managed_key_encryption_enabled: str or
         ~azure.mgmt.networkanalytics.models.ControlState
        :keyword customer_encryption_key: Customer managed encryption key details for data product.
        :paramtype customer_encryption_key: ~azure.mgmt.networkanalytics.models.EncryptionKeyDetails
        :keyword networkacls: Network rule set for data product.
        :paramtype networkacls: ~azure.mgmt.networkanalytics.models.DataProductNetworkAcls
        :keyword managed_resource_group_configuration: Managed resource group configuration.
        :paramtype managed_resource_group_configuration:
         ~azure.mgmt.networkanalytics.models.ManagedResourceGroupConfiguration
        :keyword current_minor_version: Current configured minor version of the data product resource.
        :paramtype current_minor_version: str
        """
        super().__init__(**kwargs)
        self.resource_guid = None
        self.provisioning_state = None
        self.publisher = publisher
        self.product = product
        self.major_version = major_version
        self.owners = owners
        self.redundancy = redundancy
        self.purview_account = purview_account
        self.purview_collection = purview_collection
        self.private_links_enabled = private_links_enabled
        self.public_network_access = public_network_access
        self.customer_managed_key_encryption_enabled = customer_managed_key_encryption_enabled
        self.customer_encryption_key = customer_encryption_key
        self.networkacls = networkacls
        self.managed_resource_group_configuration = managed_resource_group_configuration
        self.available_minor_versions = None
        self.current_minor_version = current_minor_version
        self.documentation = None
        self.consumption_endpoints = None
        self.key_vault_url = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class DataProductsCatalog(ProxyResource):
    """The data catalog resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.networkanalytics.models.DataProductsCatalogProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DataProductsCatalogProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DataProductsCatalogProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.networkanalytics.models.DataProductsCatalogProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataProductsCatalogListResult(_serialization.Model):
    """The response of a DataProductsCatalog list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The DataProductsCatalog items on this page. Required.
    :vartype value: list[~azure.mgmt.networkanalytics.models.DataProductsCatalog]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataProductsCatalog]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DataProductsCatalog"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The DataProductsCatalog items on this page. Required.
        :paramtype value: list[~azure.mgmt.networkanalytics.models.DataProductsCatalog]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataProductsCatalogProperties(_serialization.Model):
    """Details for data catalog properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The data catalog provisioning state. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkanalytics.models.ProvisioningState
    :ivar publishers: The data product publisher information. Required.
    :vartype publishers: list[~azure.mgmt.networkanalytics.models.PublisherInformation]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "publishers": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "publishers": {"key": "publishers", "type": "[PublisherInformation]"},
    }

    def __init__(self, *, publishers: List["_models.PublisherInformation"], **kwargs: Any) -> None:
        """
        :keyword publishers: The data product publisher information. Required.
        :paramtype publishers: list[~azure.mgmt.networkanalytics.models.PublisherInformation]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.publishers = publishers


class DataProductUpdate(_serialization.Model):
    """The type used for update operations of the DataProduct.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.networkanalytics.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the DataProduct.
    :vartype properties: ~azure.mgmt.networkanalytics.models.DataProductUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "DataProductUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.DataProductUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.networkanalytics.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the DataProduct.
        :paramtype properties: ~azure.mgmt.networkanalytics.models.DataProductUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.properties = properties


class DataProductUpdateProperties(_serialization.Model):
    """The updatable properties of the DataProduct.

    :ivar owners: List of name or email associated with data product resource deployment.
    :vartype owners: list[str]
    :ivar purview_account: Purview account url for data product to connect to.
    :vartype purview_account: str
    :ivar purview_collection: Purview collection url for data product to connect to.
    :vartype purview_collection: str
    :ivar private_links_enabled: Flag to enable or disable private link for data product resource.
     Known values are: "Enabled" and "Disabled".
    :vartype private_links_enabled: str or ~azure.mgmt.networkanalytics.models.ControlState
    :ivar current_minor_version: Current configured minor version of the data product resource.
    :vartype current_minor_version: str
    """

    _attribute_map = {
        "owners": {"key": "owners", "type": "[str]"},
        "purview_account": {"key": "purviewAccount", "type": "str"},
        "purview_collection": {"key": "purviewCollection", "type": "str"},
        "private_links_enabled": {"key": "privateLinksEnabled", "type": "str"},
        "current_minor_version": {"key": "currentMinorVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        owners: Optional[List[str]] = None,
        purview_account: Optional[str] = None,
        purview_collection: Optional[str] = None,
        private_links_enabled: Optional[Union[str, "_models.ControlState"]] = None,
        current_minor_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword owners: List of name or email associated with data product resource deployment.
        :paramtype owners: list[str]
        :keyword purview_account: Purview account url for data product to connect to.
        :paramtype purview_account: str
        :keyword purview_collection: Purview collection url for data product to connect to.
        :paramtype purview_collection: str
        :keyword private_links_enabled: Flag to enable or disable private link for data product
         resource. Known values are: "Enabled" and "Disabled".
        :paramtype private_links_enabled: str or ~azure.mgmt.networkanalytics.models.ControlState
        :keyword current_minor_version: Current configured minor version of the data product resource.
        :paramtype current_minor_version: str
        """
        super().__init__(**kwargs)
        self.owners = owners
        self.purview_account = purview_account
        self.purview_collection = purview_collection
        self.private_links_enabled = private_links_enabled
        self.current_minor_version = current_minor_version


class DataProductVersion(_serialization.Model):
    """Data Product Version.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Version of data product. Required.
    :vartype version: str
    """

    _validation = {
        "version": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: str, **kwargs: Any) -> None:
        """
        :keyword version: Version of data product. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class DataType(ProxyResource):
    """The data type resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.networkanalytics.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.networkanalytics.models.DataTypeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DataTypeProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DataTypeProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.networkanalytics.models.DataTypeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataTypeListResult(_serialization.Model):
    """The response of a DataType list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The DataType items on this page. Required.
    :vartype value: list[~azure.mgmt.networkanalytics.models.DataType]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DataType"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The DataType items on this page. Required.
        :paramtype value: list[~azure.mgmt.networkanalytics.models.DataType]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataTypeProperties(_serialization.Model):
    """The data type properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Latest provisioning state  of data product. Known values are:
     "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.networkanalytics.models.ProvisioningState
    :ivar state: State of data type. Known values are: "Stopped" and "Running".
    :vartype state: str or ~azure.mgmt.networkanalytics.models.DataTypeState
    :ivar state_reason: Reason for the state of data type.
    :vartype state_reason: str
    :ivar storage_output_retention: Field for storage output retention in days.
    :vartype storage_output_retention: int
    :ivar database_cache_retention: Field for database cache retention in days.
    :vartype database_cache_retention: int
    :ivar database_retention: Field for database data retention in days.
    :vartype database_retention: int
    :ivar visualization_url: Url for data visualization.
    :vartype visualization_url: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "state_reason": {"readonly": True},
        "visualization_url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "state_reason": {"key": "stateReason", "type": "str"},
        "storage_output_retention": {"key": "storageOutputRetention", "type": "int"},
        "database_cache_retention": {"key": "databaseCacheRetention", "type": "int"},
        "database_retention": {"key": "databaseRetention", "type": "int"},
        "visualization_url": {"key": "visualizationUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.DataTypeState"]] = None,
        storage_output_retention: Optional[int] = None,
        database_cache_retention: Optional[int] = None,
        database_retention: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: State of data type. Known values are: "Stopped" and "Running".
        :paramtype state: str or ~azure.mgmt.networkanalytics.models.DataTypeState
        :keyword storage_output_retention: Field for storage output retention in days.
        :paramtype storage_output_retention: int
        :keyword database_cache_retention: Field for database cache retention in days.
        :paramtype database_cache_retention: int
        :keyword database_retention: Field for database data retention in days.
        :paramtype database_retention: int
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.state = state
        self.state_reason = None
        self.storage_output_retention = storage_output_retention
        self.database_cache_retention = database_cache_retention
        self.database_retention = database_retention
        self.visualization_url = None


class DataTypeUpdate(_serialization.Model):
    """The type used for update operations of the DataType.

    :ivar properties: The updatable properties of the DataType.
    :vartype properties: ~azure.mgmt.networkanalytics.models.DataTypeUpdateProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "DataTypeUpdateProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DataTypeUpdateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The updatable properties of the DataType.
        :paramtype properties: ~azure.mgmt.networkanalytics.models.DataTypeUpdateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DataTypeUpdateProperties(_serialization.Model):
    """The updatable properties of the DataType.

    :ivar state: State of data type. Known values are: "Stopped" and "Running".
    :vartype state: str or ~azure.mgmt.networkanalytics.models.DataTypeState
    :ivar storage_output_retention: Field for storage output retention in days.
    :vartype storage_output_retention: int
    :ivar database_cache_retention: Field for database cache retention in days.
    :vartype database_cache_retention: int
    :ivar database_retention: Field for database data retention in days.
    :vartype database_retention: int
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "storage_output_retention": {"key": "storageOutputRetention", "type": "int"},
        "database_cache_retention": {"key": "databaseCacheRetention", "type": "int"},
        "database_retention": {"key": "databaseRetention", "type": "int"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.DataTypeState"]] = None,
        storage_output_retention: Optional[int] = None,
        database_cache_retention: Optional[int] = None,
        database_retention: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: State of data type. Known values are: "Stopped" and "Running".
        :paramtype state: str or ~azure.mgmt.networkanalytics.models.DataTypeState
        :keyword storage_output_retention: Field for storage output retention in days.
        :paramtype storage_output_retention: int
        :keyword database_cache_retention: Field for database cache retention in days.
        :paramtype database_cache_retention: int
        :keyword database_retention: Field for database data retention in days.
        :paramtype database_retention: int
        """
        super().__init__(**kwargs)
        self.state = state
        self.storage_output_retention = storage_output_retention
        self.database_cache_retention = database_cache_retention
        self.database_retention = database_retention


class EncryptionKeyDetails(_serialization.Model):
    """Encryption key details.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_uri: The Uri of the key vault. Required.
    :vartype key_vault_uri: str
    :ivar key_name: The name of the key vault key. Required.
    :vartype key_name: str
    :ivar key_version: The version of the key vault key. Required.
    :vartype key_version: str
    """

    _validation = {
        "key_vault_uri": {"required": True},
        "key_name": {"required": True},
        "key_version": {"required": True},
    }

    _attribute_map = {
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
    }

    def __init__(self, *, key_vault_uri: str, key_name: str, key_version: str, **kwargs: Any) -> None:
        """
        :keyword key_vault_uri: The Uri of the key vault. Required.
        :paramtype key_vault_uri: str
        :keyword key_name: The name of the key vault key. Required.
        :paramtype key_name: str
        :keyword key_version: The version of the key vault key. Required.
        :paramtype key_version: str
        """
        super().__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_name = key_name
        self.key_version = key_version


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.networkanalytics.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.networkanalytics.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.networkanalytics.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.networkanalytics.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class IPRules(_serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar value: IP Rules Value.
    :vartype value: str
    :ivar action: The action of virtual network rule. Required.
    :vartype action: str
    """

    _validation = {
        "action": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(self, *, action: str, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: IP Rules Value.
        :paramtype value: str
        :keyword action: The action of virtual network rule. Required.
        :paramtype action: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.action = action


class KeyVaultInfo(_serialization.Model):
    """Details for KeyVault.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_url: key vault url. Required.
    :vartype key_vault_url: str
    """

    _validation = {
        "key_vault_url": {"required": True},
    }

    _attribute_map = {
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(self, *, key_vault_url: str, **kwargs: Any) -> None:
        """
        :keyword key_vault_url: key vault url. Required.
        :paramtype key_vault_url: str
        """
        super().__init__(**kwargs)
        self.key_vault_url = key_vault_url


class ListRoleAssignments(_serialization.Model):
    """list role assignments.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Count of role assignments. Required.
    :vartype count: int
    :ivar role_assignment_response: list of role assignments. Required.
    :vartype role_assignment_response:
     list[~azure.mgmt.networkanalytics.models.RoleAssignmentDetail]
    """

    _validation = {
        "count": {"required": True},
        "role_assignment_response": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "role_assignment_response": {"key": "roleAssignmentResponse", "type": "[RoleAssignmentDetail]"},
    }

    def __init__(
        self, *, count: int, role_assignment_response: List["_models.RoleAssignmentDetail"], **kwargs: Any
    ) -> None:
        """
        :keyword count: Count of role assignments. Required.
        :paramtype count: int
        :keyword role_assignment_response: list of role assignments. Required.
        :paramtype role_assignment_response:
         list[~azure.mgmt.networkanalytics.models.RoleAssignmentDetail]
        """
        super().__init__(**kwargs)
        self.count = count
        self.role_assignment_response = role_assignment_response


class ManagedResourceGroupConfiguration(_serialization.Model):
    """ManagedResourceGroup related properties.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of managed resource group. Required.
    :vartype name: str
    :ivar location: Managed Resource Group location. Required.
    :vartype location: str
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: str, location: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of managed resource group. Required.
        :paramtype name: str
        :keyword location: Managed Resource Group location. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.networkanalytics.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.networkanalytics.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.networkanalytics.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.networkanalytics.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.networkanalytics.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.networkanalytics.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.networkanalytics.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.networkanalytics.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.networkanalytics.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PublisherInformation(_serialization.Model):
    """Details for Publisher Information.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher_name: Name of the publisher. Required.
    :vartype publisher_name: str
    :ivar data_products: Data product information. Required.
    :vartype data_products: list[~azure.mgmt.networkanalytics.models.DataProductInformation]
    """

    _validation = {
        "publisher_name": {"required": True},
        "data_products": {"required": True},
    }

    _attribute_map = {
        "publisher_name": {"key": "publisherName", "type": "str"},
        "data_products": {"key": "dataProducts", "type": "[DataProductInformation]"},
    }

    def __init__(
        self, *, publisher_name: str, data_products: List["_models.DataProductInformation"], **kwargs: Any
    ) -> None:
        """
        :keyword publisher_name: Name of the publisher. Required.
        :paramtype publisher_name: str
        :keyword data_products: Data product information. Required.
        :paramtype data_products: list[~azure.mgmt.networkanalytics.models.DataProductInformation]
        """
        super().__init__(**kwargs)
        self.publisher_name = publisher_name
        self.data_products = data_products


class ResourceAccessRules(_serialization.Model):
    """Resource Access Rules.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant ID of resource. Required.
    :vartype tenant_id: str
    :ivar resource_id: Resource ID. Required.
    :vartype resource_id: str
    """

    _validation = {
        "tenant_id": {"required": True},
        "resource_id": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, tenant_id: str, resource_id: str, **kwargs: Any) -> None:
        """
        :keyword tenant_id: The tenant ID of resource. Required.
        :paramtype tenant_id: str
        :keyword resource_id: Resource ID. Required.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.resource_id = resource_id


class RoleAssignmentCommonProperties(_serialization.Model):
    """The details for role assignment common properties.

    All required parameters must be populated in order to send to Azure.

    :ivar role_id: Role Id of the Built-In Role. Required.
    :vartype role_id: str
    :ivar principal_id: Object ID of the AAD principal or security-group. Required.
    :vartype principal_id: str
    :ivar user_name: User name. Required.
    :vartype user_name: str
    :ivar data_type_scope: Data Type Scope at which the role assignment is created. Required.
    :vartype data_type_scope: list[str]
    :ivar principal_type: Type of the principal Id: User, Group or ServicePrincipal. Required.
    :vartype principal_type: str
    :ivar role: Data Product role to be assigned to a user. Required. Known values are: "Reader"
     and "SensitiveReader".
    :vartype role: str or ~azure.mgmt.networkanalytics.models.DataProductUserRole
    """

    _validation = {
        "role_id": {"required": True},
        "principal_id": {"required": True},
        "user_name": {"required": True},
        "data_type_scope": {"required": True},
        "principal_type": {"required": True},
        "role": {"required": True},
    }

    _attribute_map = {
        "role_id": {"key": "roleId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "data_type_scope": {"key": "dataTypeScope", "type": "[str]"},
        "principal_type": {"key": "principalType", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_id: str,
        principal_id: str,
        user_name: str,
        data_type_scope: List[str],
        principal_type: str,
        role: Union[str, "_models.DataProductUserRole"],
        **kwargs: Any
    ) -> None:
        """
        :keyword role_id: Role Id of the Built-In Role. Required.
        :paramtype role_id: str
        :keyword principal_id: Object ID of the AAD principal or security-group. Required.
        :paramtype principal_id: str
        :keyword user_name: User name. Required.
        :paramtype user_name: str
        :keyword data_type_scope: Data Type Scope at which the role assignment is created. Required.
        :paramtype data_type_scope: list[str]
        :keyword principal_type: Type of the principal Id: User, Group or ServicePrincipal. Required.
        :paramtype principal_type: str
        :keyword role: Data Product role to be assigned to a user. Required. Known values are: "Reader"
         and "SensitiveReader".
        :paramtype role: str or ~azure.mgmt.networkanalytics.models.DataProductUserRole
        """
        super().__init__(**kwargs)
        self.role_id = role_id
        self.principal_id = principal_id
        self.user_name = user_name
        self.data_type_scope = data_type_scope
        self.principal_type = principal_type
        self.role = role


class RoleAssignmentDetail(_serialization.Model):
    """The details for role assignment response.

    All required parameters must be populated in order to send to Azure.

    :ivar role_id: Role Id of the Built-In Role. Required.
    :vartype role_id: str
    :ivar principal_id: Object ID of the AAD principal or security-group. Required.
    :vartype principal_id: str
    :ivar user_name: User name. Required.
    :vartype user_name: str
    :ivar data_type_scope: Data Type Scope at which the role assignment is created. Required.
    :vartype data_type_scope: list[str]
    :ivar principal_type: Type of the principal Id: User, Group or ServicePrincipal. Required.
    :vartype principal_type: str
    :ivar role: Data Product role to be assigned to a user. Required. Known values are: "Reader"
     and "SensitiveReader".
    :vartype role: str or ~azure.mgmt.networkanalytics.models.DataProductUserRole
    :ivar role_assignment_id: Id of role assignment request. Required.
    :vartype role_assignment_id: str
    """

    _validation = {
        "role_id": {"required": True},
        "principal_id": {"required": True},
        "user_name": {"required": True},
        "data_type_scope": {"required": True},
        "principal_type": {"required": True},
        "role": {"required": True},
        "role_assignment_id": {"required": True},
    }

    _attribute_map = {
        "role_id": {"key": "roleId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "data_type_scope": {"key": "dataTypeScope", "type": "[str]"},
        "principal_type": {"key": "principalType", "type": "str"},
        "role": {"key": "role", "type": "str"},
        "role_assignment_id": {"key": "roleAssignmentId", "type": "str"},
    }

    def __init__(
        self,
        *,
        role_id: str,
        principal_id: str,
        user_name: str,
        data_type_scope: List[str],
        principal_type: str,
        role: Union[str, "_models.DataProductUserRole"],
        role_assignment_id: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword role_id: Role Id of the Built-In Role. Required.
        :paramtype role_id: str
        :keyword principal_id: Object ID of the AAD principal or security-group. Required.
        :paramtype principal_id: str
        :keyword user_name: User name. Required.
        :paramtype user_name: str
        :keyword data_type_scope: Data Type Scope at which the role assignment is created. Required.
        :paramtype data_type_scope: list[str]
        :keyword principal_type: Type of the principal Id: User, Group or ServicePrincipal. Required.
        :paramtype principal_type: str
        :keyword role: Data Product role to be assigned to a user. Required. Known values are: "Reader"
         and "SensitiveReader".
        :paramtype role: str or ~azure.mgmt.networkanalytics.models.DataProductUserRole
        :keyword role_assignment_id: Id of role assignment request. Required.
        :paramtype role_assignment_id: str
        """
        super().__init__(**kwargs)
        self.role_id = role_id
        self.principal_id = principal_id
        self.user_name = user_name
        self.data_type_scope = data_type_scope
        self.principal_type = principal_type
        self.role = role
        self.role_assignment_id = role_assignment_id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.networkanalytics.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.networkanalytics.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.networkanalytics.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.networkanalytics.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualNetworkRule(_serialization.Model):
    """Virtual Network Rule.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID of a subnet. Required.
    :vartype id: str
    :ivar action: The action of virtual network rule.
    :vartype action: str
    :ivar state: Gets the state of virtual network rule.
    :vartype state: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        action: Optional[str] = None,
        state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of a subnet. Required.
        :paramtype id: str
        :keyword action: The action of virtual network rule.
        :paramtype action: str
        :keyword state: Gets the state of virtual network rule.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.action = action
        self.state = state
