#' Gene Expression Data for Wood Formation in Poplar Trees
#'
#' A data matrix containing a sample of the normalized gene expression data for
#' 6 locations in the stem of Popla trees published in the study by Herzberg et
#' al (2001). The sample of 136 genes selected by Caraux and Pinloche (2005).
#'
#' @name Wood
#' @family data
#' @docType data
#' @format The format is a 136 x 6 matrix.
#' @references Hertzberg M., H. Aspeborg, J. Schrader, A. Andersson,
#' R.Erlandsson, K. Blomqvist, R. Bhalerao, M. Uhlen, T. T. Teeri, J.
#' Lundeberg, Bjoern Sundberg, P. Nilsson and Goeran Sandberg (2001): A
#' transcriptional roadmap to wood formation, _PNAS,_ **98**(25),
#' 14732--14737.
#'
#' Caraux G. and Pinloche S. (2005): PermutMatrix: a graphical environment to
#' arrange gene expression profiles in optimal linear order,
#' _Bioinformatics,_ **21**(7) 1280--1281.
#' @source The data was obtained from
#' \url{http://www.atgc-montpellier.fr/permutmatrix/manual/Exemples/Wood/Wood.htm}.
#' @keywords datasets
#' @examples
#' data(Wood)
#' head(Wood)
NULL
