% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-combine.R
\name{list_combine}
\alias{list_combine}
\title{Combine a list of vectors}
\usage{
list_combine(
  x,
  ...,
  indices,
  size,
  default = NULL,
  unmatched = "default",
  multiple = "last",
  slice_x = FALSE,
  ptype = NULL,
  name_spec = NULL,
  name_repair = c("minimal", "unique", "check_unique", "universal", "unique_quiet",
    "universal_quiet"),
  x_arg = "x",
  indices_arg = "indices",
  default_arg = "default",
  error_call = current_env()
)
}
\arguments{
\item{x}{A list of vectors.

If \code{slice_x = FALSE}, each element must be size 1 or the same size as its
corresponding index in \code{indices} after that index has been converted to
a positive integer location vector with \code{\link[=vec_as_location]{vec_as_location()}}.

If \code{slice_x = TRUE}, each element must be size 1 or size \code{size}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{indices}{A list of indices.

Indices can be provided in one of two forms:
\itemize{
\item Positive integer vectors of locations less than or equal to \code{size}. Each
vector can be any size.
\item Logical vectors of size \code{size} where \code{TRUE} denotes the location in the
output to assign to, and the location from the \code{x} element to pull from.
Both \code{NA} and \code{FALSE} are considered unmatched.
}

The size of \code{indices} must match the size of \code{x}.}

\item{size}{The output size.}

\item{default}{If \code{NULL}, a missing value is used for locations unmatched by
\code{indices}, otherwise the provided \code{default} is used.

If provided, \code{default} must be size 1 or size \code{size}.

Can only be set when \code{unmatched = "default"}.}

\item{unmatched}{Handling of locations in the output unmatched by \code{indices}.
One of:
\itemize{
\item \code{"default"} to use \code{default} in unmatched locations.
\item \code{"error"} to error when there are unmatched locations.
}}

\item{multiple}{Handling of locations in the output matched by multiple
\code{indices}.
\itemize{
\item \code{"last"} uses the value from the last matched index.
\item \code{"first"} uses the value from the first matched index.
}

Note that \code{multiple} only applies across \code{indices}. Within a single index
if there are overlapping locations, then the last will always win. This can
only occur with integer \code{indices}, as you can't overlap within an index
when using logical \code{indices}.}

\item{slice_x}{A boolean.

If \code{TRUE}, each element of \code{x} is sliced by its corresponding index from
\code{indices} before being assigned into the output, which is effectively the
same as \code{map2(list(x, indices), function(x, index) vec_slice(x, index))},
but is optimized to avoid materializing the slices.

See the \code{slice_value} argument of \code{\link[=vec_assign]{vec_assign()}} for more examples.}

\item{ptype}{If \code{NULL}, the output type is determined by computing the common
type across all elements of \code{x} and \code{default}. Alternatively, you can
supply \code{ptype} to give the output a known type.}

\item{name_spec}{A name specification for combining
inner and outer names. This is relevant for inputs passed with a
name, when these inputs are themselves named, like \code{outer = c(inner = 1)}, or when they have length greater than 1: \code{outer = 1:2}. By default, these cases trigger an error. You can resolve
the error by providing a specification that describes how to
combine the names or the indices of the inner vector with the
name of the input. This specification can be:
\itemize{
\item A function of two arguments. The outer name is passed as a
string to the first argument, and the inner names or positions
are passed as second argument.
\item An anonymous function as a purrr-style formula.
\item A glue specification of the form \code{"{outer}_{inner}"}.
\item \code{"inner"}, in which case outer names are ignored, and inner
names are used if they exist. Note that outer names may still
be used to provide informative error messages.
\item An \code{\link[rlang:zap]{rlang::zap()}} object, in which case both outer and inner
names are ignored and the result is unnamed.
}

See the \link[=name_spec]{name specification topic}.}

\item{name_repair}{How to repair names, see \code{repair} options in
\code{\link[=vec_as_names]{vec_as_names()}}.}

\item{x_arg, indices_arg, default_arg}{An argument name as a string. This
argument will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector of type \code{vec_ptype_common(!!!x)}, or \code{ptype}, if specified.

The size of the output is determined by \code{size}.
}
\description{
\code{list_combine()} is a more powerful version of \code{\link[=vec_c]{vec_c()}}. While \code{vec_c()} is
used for sequential combination, \code{list_combine()} takes a list of \code{indices}
that specify where to place each element in the output.

If you have a list of vectors and just need to combine them sequentially,
you'll still want to use \code{vec_c(!!!x)}.
}
\examples{
# Combine a list of vectors using
# a list of `indices`
x <- list(
  1:3,
  4:6,
  7:8
)
indices <- list(
  c(1, 3, 7),
  c(8, 6, 5),
  c(2, 4)
)
list_combine(x, indices = indices, size = 8)

# Overlapping `indices` are allowed.
# The last match "wins" by default.
x <- list(
  1:3,
  4:6
)
indices <- list(
  c(1, 2, 3),
  c(1, 2, 6)
)
list_combine(x, indices = indices, size = 6)

# Use `multiple` to force the first match to win.
# This is similar to how `dplyr::case_when()` works.
list_combine(x, indices = indices, size = 6, multiple = "first")

# Works with data frames as well.
# Now how index 2 is not assigned to.
x <- list(
  data.frame(x = 1:2, y = c("a", "b")),
  data.frame(x = 3:4, y = c("c", "d"))
)
indices <- list(
  c(4, 1),
  c(3, NA)
)
list_combine(x, indices = indices, size = 4)

# You can use `size` to combine into a larger object than you have values for
list_combine(list(1:2, 4:5), indices = list(1:2, 4:5), size = 8)

# Additionally specifying `default` allows you to control the value used in
# unfilled locations
list_combine(
  list(1:2, 4:5),
  indices = list(1:2, 4:5),
  size = 8,
  default = 0L
)

# Alternatively, if you'd like to assert that you've covered all output
# locations through `indices`, set `unmatched = "error"`.
# Here, we've set the size to 5 but missed location 3:
try(list_combine(
  list(1:2, 4:5),
  indices = list(1:2, 4:5),
  size = 5,
  unmatched = "error"
))
}
