use core:io;

// Helper to make a string into lowercase (only considering ASCII). Modifies 'src'.
Str toAsciiLowercase(Buffer src) {
	Nat c = src.filled;
	for (Nat i = 0; i < c; i++) {
		Byte ch = src[i];
		if (ch >= 0x41 & ch <= 0x5A)
			src[i] = ch + 0x20;
	}
	return src.fromUtf8();
}

Str toAsciiLowercase(Str src) {
	Bool change = false;
	for (ch in src) {
		Nat code = ch.codepoint;
		if (code >= 0x41 & code <= 0x5A) {
			change = true;
			break;
		}
	}

	// It was lowercase already!
	if (!change)
		return src;

	StrBuf changed;
	for (ch in src) {
		Nat code = ch.codepoint;
		if (code >= 0x41 & code <= 0x5A) {
			changed << Char(code + 0x20);
		} else {
			changed << ch;
		}
	}
	return changed.toS;
}

// Helper to compare two strings without ASCII case-sensitivity.
Bool noCaseEqual(Str a, Str b) {
	var ia = a.begin();
	var ib = b.begin();

	var ea = a.end();
	var eb = b.end();

	while (ia != ea & ib != eb) {
		Nat codeA = ia.v.codepoint;
		Nat codeB = ib.v.codepoint;

		if (codeA >= 0x41 & codeA <= 0x5A)
			codeA += 0x20;
		if (codeB >= 0x41 & codeB <= 0x5A)
			codeB += 0x20;

		if (codeA != codeB)
			return false;

		++ia;
		++ib;
	}

	return (ia == ea) & (ib == eb);
}
