/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.
This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/

/*
// https://github.com/opencv/opencv/blob/3e43d0cfca9753bcc4983f610b75d70c3f25f0cd/modules/objdetect/src/aruco/predefined_dictionaries.hpp
Copyright 2025 OpenCV

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <stdlib.h>
#include "tagAruco6x6_1000.h"

static uint64_t codedata[1000] = {
    0x0000000187359537UL,
    0x00000000bebe30f0UL,
    0x00000001674ad6c5UL,
    0x0000000cca05f46cUL,
    0x0000000d0d1ea69eUL,
    0x0000000db17045e8UL,
    0x000000041072bb74UL,
    0x00000008a0ad7603UL,
    0x00000003136ef12eUL,
    0x000000038c24efe6UL,
    0x000000047fdf132aUL,
    0x00000004b3cba425UL,
    0x0000000741459c8fUL,
    0x00000008371b88ffUL,
    0x00000008def1bd41UL,
    0x0000000a22f1f2bdUL,
    0x00000000f26c9aa7UL,
    0x000000015497da67UL,
    0x0000000308c11164UL,
    0x0000000489def7c3UL,
    0x000000053e85b9beUL,
    0x000000062448cc7cUL,
    0x0000000735ba1c39UL,
    0x000000099bd7319dUL,
    0x0000000af8148320UL,
    0x0000000c17a4301bUL,
    0x0000000c7a520881UL,
    0x0000000e54034939UL,
    0x0000000e897c40b3UL,
    0x0000000ed8be3f4cUL,
    0x0000000f8ba3d752UL,
    0x000000001f9eff7dUL,
    0x0000000055ddb604UL,
    0x00000000be25174aUL,
    0x0000000142fb59f0UL,
    0x0000000164f8a5acUL,
    0x00000003910df6ddUL,
    0x00000004c75c1458UL,
    0x00000005401c0bfeUL,
    0x00000005ab1ca5edUL,
    0x00000006051744e1UL,
    0x000000061b0e30c5UL,
    0x00000006520d7ba0UL,
    0x00000006fb6769ffUL,
    0x00000007207fc6a6UL,
    0x0000000765896e4bUL,
    0x00000007a2c4f517UL,
    0x00000008050d5374UL,
    0x000000088127e3baUL,
    0x000000097924acf5UL,
    0x00000009a054b06bUL,
    0x00000009bec85c73UL,
    0x0000000a45347d68UL,
    0x0000000b6e57e84dUL,
    0x0000000b7773c770UL,
    0x0000000b8569e404UL,
    0x0000000c10da8f0aUL,
    0x0000000c3c466640UL,
    0x0000000c64aed8adUL,
    0x0000000c9f3ccfd0UL,
    0x0000000cc4592762UL,
    0x0000000cd9c6c20dUL,
    0x0000000cee30adbaUL,
    0x0000000e56e7a3a6UL,
    0x0000000efcd25392UL,
    0x0000000f5ff92d7eUL,
    0x00000002b4e8a647UL,
    0x00000002f39b337fUL,
    0x000000037dd57e97UL,
    0x0000000a6923c68cUL,
    0x0000000ae992bd80UL,
    0x0000000d8b844ca1UL,
    0x0000000052819cf9UL,
    0x0000000074c0f91bUL,
    0x00000000fd6b6b50UL,
    0x00000001144a026cUL,
    0x0000000121afbfafUL,
    0x000000012893eb1cUL,
    0x0000000134e4c0d4UL,
    0x000000019ba03529UL,
    0x00000001b0392a30UL,
    0x00000001ca1e1341UL,
    0x00000001d8b7a6d6UL,
    0x0000000276934eaeUL,
    0x00000002a1c5ade8UL,
    0x000000035201571eUL,
    0x000000037147bb41UL,
    0x00000003784581bdUL,
    0x00000003bd17caf2UL,
    0x000000041407e597UL,
    0x000000042f638de4UL,
    0x0000000463485d62UL,
    0x00000004b296110cUL,
    0x0000000536f2cd8fUL,
    0x000000055e1322b5UL,
    0x000000056d84cf84UL,
    0x000000056f2fca56UL,
    0x0000000586689fceUL,
    0x000000059551ef6dUL,
    0x000000059db9027bUL,
    0x00000005cceff55dUL,
    0x00000005d229255bUL,
    0x000000064c9ddd62UL,
    0x000000067eccda0cUL,
    0x00000006a201db7aUL,
    0x00000006f1dd0046UL,
    0x00000006fb415109UL,
    0x00000007177d99e8UL,
    0x00000007388f55faUL,
    0x000000076734a21dUL,
    0x00000007848ba632UL,
    0x000000079167847cUL,
    0x00000007ab338c0dUL,
    0x00000007f094be0aUL,
    0x000000081de59cbfUL,
    0x000000083b6abd5eUL,
    0x000000085c88a26bUL,
    0x000000098294ab90UL,
    0x000000099727b0c8UL,
    0x00000009f6547e8cUL,
    0x0000000a0a0865beUL,
    0x0000000a9620c395UL,
    0x0000000ac4c618c0UL,
    0x0000000b02eddb87UL,
    0x0000000b1d50b035UL,
    0x0000000b4ea4b14eUL,
    0x0000000badbb67b8UL,
    0x0000000bd0e3def5UL,
    0x0000000c1ffa1654UL,
    0x0000000c79a75f83UL,
    0x0000000cd31efa5bUL,
    0x0000000ce1a88d1cUL,
    0x0000000d00ce33a9UL,
    0x0000000d1068a8efUL,
    0x0000000d7264a958UL,
    0x0000000e3caf9955UL,
    0x0000000e5a4d46d5UL,
    0x0000000e8818ae83UL,
    0x0000000e8d17b80aUL,
    0x0000000eba757c10UL,
    0x0000000f0eac5af8UL,
    0x0000000f48566d17UL,
    0x0000000f9c1e79f5UL,
    0x0000000ae1e743d7UL,
    0x0000000c330f5948UL,
    0x0000000179cb95f7UL,
    0x00000004a597a65dUL,
    0x0000000535280f54UL,
    0x0000000692780819UL,
    0x00000007203064b5UL,
    0x00000008530c1caaUL,
    0x0000000cd5dbe8baUL,
    0x0000000d2fe483f0UL,
    0x0000000ebe8e2584UL,
    0x0000000f45b78644UL,
    0x0000000fcad7bbeaUL,
    0x0000000001339f4eUL,
    0x00000000018112a1UL,
    0x00000000073a4daaUL,
    0x000000001f262424UL,
    0x000000001f32e2f8UL,
    0x00000000283b13a4UL,
    0x000000003604b4cdUL,
    0x0000000046517041UL,
    0x0000000050138044UL,
    0x00000000625617afUL,
    0x00000000838b678cUL,
    0x0000000098fd8fa4UL,
    0x00000000b431447dUL,
    0x00000000d12b7ef6UL,
    0x00000000f6d350f7UL,
    0x00000000fd981f31UL,
    0x0000000104b87a8fUL,
    0x000000010c46f942UL,
    0x000000014447a8acUL,
    0x00000001539b8e36UL,
    0x00000001581dbd87UL,
    0x00000001a6b46561UL,
    0x00000001b6cd8f2aUL,
    0x00000001cd634677UL,
    0x00000001d96ba10aUL,
    0x00000001db14928eUL,
    0x00000001e5308efcUL,
    0x00000001e9487698UL,
    0x00000001e9f1f172UL,
    0x0000000220795e56UL,
    0x000000022a37c936UL,
    0x0000000240e00eb6UL,
    0x000000025ed0c569UL,
    0x0000000264bfb6d3UL,
    0x00000002762a830bUL,
    0x0000000299e1f28eUL,
    0x000000029d481345UL,
    0x00000002a3643ef5UL,
    0x00000002d99309caUL,
    0x00000002ec20204bUL,
    0x00000002fa2599f0UL,
    0x000000032518f73eUL,
    0x000000032dcf9e4eUL,
    0x0000000337dc00e3UL,
    0x0000000367de375cUL,
    0x00000003887aab11UL,
    0x000000038e94425dUL,
    0x00000003a78911a8UL,
    0x00000003d2d26b25UL,
    0x00000003d37b558fUL,
    0x00000003d4362f7fUL,
    0x00000003dd34c828UL,
    0x00000003e8afb268UL,
    0x000000040d49e611UL,
    0x000000042c18f155UL,
    0x0000000431b5db39UL,
    0x00000004349fefe4UL,
    0x0000000439565b06UL,
    0x000000043e51d2dcUL,
    0x0000000443cf493cUL,
    0x00000004497a7ac8UL,
    0x000000045e975bd0UL,
    0x000000048f9044feUL,
    0x000000049d5009b0UL,
    0x000000049e5fc173UL,
    0x00000004a04f08f6UL,
    0x00000004c2166f86UL,
    0x00000004d59e052fUL,
    0x00000004e9a614daUL,
    0x00000004f299d88aUL,
    0x00000005046ccfb9UL,
    0x000000055bf0ffbeUL,
    0x0000000576fd77c2UL,
    0x00000005775fc44bUL,
    0x000000058add7861UL,
    0x00000005ae7af43eUL,
    0x00000005c792b9d5UL,
    0x00000005cfd8e6a7UL,
    0x00000005d6b50e99UL,
    0x00000005f46c430dUL,
    0x000000060aff8445UL,
    0x00000006164a1dadUL,
    0x0000000671d1a7b5UL,
    0x000000067ac2f3e5UL,
    0x000000068e6975f0UL,
    0x0000000694e62f90UL,
    0x00000006a094d4f9UL,
    0x00000006aa4eb15aUL,
    0x00000006cb9a0090UL,
    0x00000006d1a94531UL,
    0x00000006e7d2691aUL,
    0x00000006ed3ac6c7UL,
    0x00000006fd7ba039UL,
    0x00000007026405e7UL,
    0x0000000714e067feUL,
    0x0000000718c1bfa9UL,
    0x0000000756b010e9UL,
    0x0000000759006964UL,
    0x000000075e367fa3UL,
    0x000000078d262d41UL,
    0x00000007a6be2bcaUL,
    0x00000007b661f6e9UL,
    0x00000007c57bcc52UL,
    0x00000007dcc470d3UL,
    0x00000008368a68b8UL,
    0x00000008688f24b5UL,
    0x000000086de260ddUL,
    0x000000089945d2d0UL,
    0x00000008aacc504dUL,
    0x00000008c5ff131dUL,
    0x00000008e4824f4eUL,
    0x00000008e5dafb24UL,
    0x00000008eb46dcefUL,
    0x00000009182cfe3cUL,
    0x000000092c092ceaUL,
    0x00000009313fae42UL,
    0x0000000936921730UL,
    0x0000000946ed84e5UL,
    0x0000000947faf06fUL,
    0x000000094a398963UL,
    0x000000095d6e75b7UL,
    0x000000096ae17cc9UL,
    0x000000097b5e0d4dUL,
    0x0000000992385298UL,
    0x00000009a9922323UL,
    0x00000009b8456986UL,
    0x00000009fddd8169UL,
    0x0000000a05f1cfe4UL,
    0x0000000a4bb73c5eUL,
    0x0000000a51416c9aUL,
    0x0000000a5af462e3UL,
    0x0000000a7e1ae714UL,
    0x0000000a91077546UL,
    0x0000000a958a46f5UL,
    0x0000000a9c5c4beeUL,
    0x0000000aa1fb20a4UL,
    0x0000000ae80c71a9UL,
    0x0000000afe711babUL,
    0x0000000b3c6dd763UL,
    0x0000000b66d421b9UL,
    0x0000000b8458d172UL,
    0x0000000b962a5d48UL,
    0x0000000ba6a96af3UL,
    0x0000000bb02f18a1UL,
    0x0000000bcc4054ecUL,
    0x0000000c09122dd8UL,
    0x0000000c182fa5fcUL,
    0x0000000c3d085538UL,
    0x0000000c4f19d67bUL,
    0x0000000c562f2af3UL,
    0x0000000c86610c7aUL,
    0x0000000c9cd3a0edUL,
    0x0000000cbfeed8daUL,
    0x0000000cdc0d11c8UL,
    0x0000000cef743a13UL,
    0x0000000cf9516c23UL,
    0x0000000cffaf2c19UL,
    0x0000000d0daacc7fUL,
    0x0000000d0f8cbd03UL,
    0x0000000d655de9f7UL,
    0x0000000d73d22a6cUL,
    0x0000000d7d9669eaUL,
    0x0000000d8a5250dbUL,
    0x0000000d914262a2UL,
    0x0000000db74ed1e4UL,
    0x0000000ddce45d1eUL,
    0x0000000de3c787fdUL,
    0x0000000dec3dee21UL,
    0x0000000e0246d029UL,
    0x0000000e0f3a091fUL,
    0x0000000e21b83bb2UL,
    0x0000000e2484056aUL,
    0x0000000e3b7220beUL,
    0x0000000e4ba14365UL,
    0x0000000e77ca9195UL,
    0x0000000e8632b70dUL,
    0x0000000eada009a9UL,
    0x0000000eaf6d80ddUL,
    0x0000000eb1e91740UL,
    0x0000000eb1f4c616UL,
    0x0000000edc651625UL,
    0x0000000ef0d9ba71UL,
    0x0000000f014e88daUL,
    0x0000000f06153ffdUL,
    0x0000000f2d67761dUL,
    0x0000000f36f43345UL,
    0x0000000f58baa12dUL,
    0x0000000f6ab1f404UL,
    0x0000000f938aad9fUL,
    0x0000000f9c799e3aUL,
    0x0000000fc095216fUL,
    0x0000000fd12ef760UL,
    0x0000000fd19c9019UL,
    0x0000000fde9e9ac7UL,
    0x0000000fe2519d3cUL,
    0x0000000ffce301f8UL,
    0x0000000a61ec225bUL,
    0x0000000a63010c61UL,
    0x00000000cebc3512UL,
    0x0000000235612533UL,
    0x000000046213d4e5UL,
    0x00000004a7ac9192UL,
    0x00000006719d7d5aUL,
    0x0000000697d4c7bdUL,
    0x0000000833804c8fUL,
    0x000000098052f9a1UL,
    0x0000000a49cbc7d2UL,
    0x00000000025f8a70UL,
    0x00000000035d111bUL,
    0x0000000011327e21UL,
    0x0000000020ec5d8cUL,
    0x00000000236eae3cUL,
    0x000000003899295fUL,
    0x000000003aee7a15UL,
    0x000000004df31d38UL,
    0x000000004ef52b93UL,
    0x0000000058eea7afUL,
    0x000000005a66a846UL,
    0x00000000670d605eUL,
    0x0000000074d9c1f0UL,
    0x000000007ffa6defUL,
    0x00000000879e0846UL,
    0x000000009109c5daUL,
    0x000000009aca57eeUL,
    0x000000009b1acb05UL,
    0x000000009c326103UL,
    0x00000000a05be16fUL,
    0x00000000a4ea9b62UL,
    0x00000000aa27f145UL,
    0x00000000acb0bac8UL,
    0x00000000b92e008cUL,
    0x00000000bf65eebaUL,
    0x00000000bfa757bfUL,
    0x00000000c3a1f2dbUL,
    0x00000000c51f3fe5UL,
    0x00000000c61989d1UL,
    0x00000000cfc5e7e2UL,
    0x00000000e7ac0695UL,
    0x00000000eca32700UL,
    0x00000000ecaf79eaUL,
    0x00000000f2f097d8UL,
    0x00000000f491fdadUL,
    0x00000000f667a576UL,
    0x00000000f9c50b1fUL,
    0x0000000108bee072UL,
    0x0000000113268d1bUL,
    0x00000001181f876bUL,
    0x00000001201b54abUL,
    0x000000013b75d744UL,
    0x000000014b3d0e5bUL,
    0x000000014c8c35f8UL,
    0x000000014d8b7b41UL,
    0x0000000160bd31c9UL,
    0x00000001692ad09bUL,
    0x000000016cc332feUL,
    0x000000016dd4fae0UL,
    0x000000016df0bc5fUL,
    0x0000000176508ee2UL,
    0x000000017a84e32aUL,
    0x000000017e82a980UL,
    0x000000018a955febUL,
    0x00000001940af781UL,
    0x0000000195c13e37UL,
    0x00000001997e7f6eUL,
    0x000000019a07dec6UL,
    0x000000019e90a59bUL,
    0x00000001a3d68096UL,
    0x00000001a9bd4347UL,
    0x00000001aa91f0eeUL,
    0x00000001ae294409UL,
    0x00000001ae8212c4UL,
    0x00000001aedecbccUL,
    0x00000001b8121a7dUL,
    0x00000001bc706ec1UL,
    0x00000001d3f48371UL,
    0x00000001dca12975UL,
    0x00000001e6402c6dUL,
    0x000000020197e122UL,
    0x000000020734169eUL,
    0x0000000216647753UL,
    0x000000021ad5b380UL,
    0x00000002208b1f3dUL,
    0x00000002457aa4ffUL,
    0x0000000259276329UL,
    0x0000000267a97362UL,
    0x0000000269b5ccc1UL,
    0x000000026b1be8c6UL,
    0x000000026ce950d1UL,
    0x000000026f044d33UL,
    0x000000027833b2ddUL,
    0x0000000279ca0e8cUL,
    0x000000027c1f5cffUL,
    0x0000000288f746ffUL,
    0x000000029248d0d7UL,
    0x00000002b2dfe9d5UL,
    0x00000002ba2e256fUL,
    0x00000002d3907e92UL,
    0x00000002d4bd5b41UL,
    0x00000002e3f99d37UL,
    0x00000002ee5d3027UL,
    0x00000002ef2f157cUL,
    0x00000002f357bfb9UL,
    0x00000002f9d8d387UL,
    0x00000003048aa3efUL,
    0x00000003088dd405UL,
    0x0000000312e7168dUL,
    0x00000003151947a7UL,
    0x000000031a38f1b1UL,
    0x000000031fcd29daUL,
    0x00000003240d95e6UL,
    0x00000003251e2cd5UL,
    0x0000000327ceea71UL,
    0x000000033101ee73UL,
    0x0000000334e8b218UL,
    0x0000000350d29a91UL,
    0x00000003527d4ff3UL,
    0x000000035bda3e67UL,
    0x0000000365b35447UL,
    0x0000000368d081daUL,
    0x000000037468d9a5UL,
    0x0000000377031db5UL,
    0x00000003828cf84eUL,
    0x000000038b0cd568UL,
    0x000000038b21799eUL,
    0x00000003a1924dacUL,
    0x00000003b09112bbUL,
    0x00000003b7f36167UL,
    0x00000003beb0fc03UL,
    0x00000003c85e63fbUL,
    0x00000003cdcdaeadUL,
    0x00000003d09d95a0UL,
    0x00000003d6d9a6ebUL,
    0x00000003d9f51dbeUL,
    0x00000003dff393c8UL,
    0x00000003e0248c17UL,
    0x00000003fbddce1eUL,
    0x0000000402ce0392UL,
    0x000000040cea90ecUL,
    0x00000004102cc665UL,
    0x000000041500eeaeUL,
    0x0000000419daa223UL,
    0x000000043b4d80abUL,
    0x000000043f89db70UL,
    0x0000000441bacfd1UL,
    0x0000000459a78dcdUL,
    0x000000045ef55473UL,
    0x0000000460216f78UL,
    0x000000046c6a05a2UL,
    0x000000048385b76fUL,
    0x0000000490c09143UL,
    0x0000000496158deeUL,
    0x00000004985c126aUL,
    0x00000004a15f7444UL,
    0x00000004a18359e3UL,
    0x00000004bce922caUL,
    0x00000004c6ffb0faUL,
    0x00000004d1945ee5UL,
    0x00000004d78fba61UL,
    0x00000004ddd76736UL,
    0x00000004e34346daUL,
    0x00000004e529f4c1UL,
    0x00000004eb913d9cUL,
    0x00000004f4775db2UL,
    0x00000004fb6b37e1UL,
    0x000000050473a7c1UL,
    0x00000005065453e0UL,
    0x0000000517787917UL,
    0x0000000519c34a9aUL,
    0x00000005230700ecUL,
    0x0000000529329718UL,
    0x0000000530388169UL,
    0x000000053ab07a59UL,
    0x000000053bd94df9UL,
    0x000000054d3105efUL,
    0x0000000551450dc0UL,
    0x0000000554686a20UL,
    0x00000005590af37dUL,
    0x0000000559bf44bcUL,
    0x000000055e3b8998UL,
    0x0000000565951a1cUL,
    0x0000000565b8511aUL,
    0x000000056adc4ac3UL,
    0x000000056c8f6f3eUL,
    0x000000057d5031c8UL,
    0x000000057e7226daUL,
    0x00000005850e8307UL,
    0x0000000587703239UL,
    0x00000005956ebb52UL,
    0x00000005a1bebd5bUL,
    0x00000005a5a6c4beUL,
    0x00000005aaf61e88UL,
    0x00000005b154155fUL,
    0x00000005b3ac0449UL,
    0x00000005c2b04454UL,
    0x00000005c7fb67dbUL,
    0x00000005d1ca454cUL,
    0x00000005d4ee34a4UL,
    0x00000005da9365cdUL,
    0x00000005dd5116c6UL,
    0x00000005e4d05715UL,
    0x00000005f5b9c85dUL,
    0x00000005fdfc29bcUL,
    0x00000006143eaf28UL,
    0x00000006237070ebUL,
    0x000000062fd9a062UL,
    0x0000000632d2e652UL,
    0x000000063afb1393UL,
    0x0000000655638401UL,
    0x0000000662206a93UL,
    0x000000066b96f8f3UL,
    0x0000000675f79ae2UL,
    0x000000067dbc8e78UL,
    0x000000068154b891UL,
    0x00000006833c3166UL,
    0x00000006834afe68UL,
    0x000000069783c84aUL,
    0x000000069846ecadUL,
    0x00000006988422a6UL,
    0x000000069d303a7eUL,
    0x00000006a6528530UL,
    0x00000006a78b2d50UL,
    0x00000006b7379350UL,
    0x00000006bc441ec8UL,
    0x00000006c183f90cUL,
    0x00000006d008df99UL,
    0x00000006d2f3827eUL,
    0x00000006e1b113eeUL,
    0x00000006e96cefcaUL,
    0x00000006fc6f50e4UL,
    0x000000070f54d74fUL,
    0x00000007103cbcc1UL,
    0x000000071c86090cUL,
    0x0000000722be51e5UL,
    0x000000072648a6dfUL,
    0x0000000727224972UL,
    0x000000072acca6a0UL,
    0x000000072c9f2265UL,
    0x0000000733e3733dUL,
    0x000000073f5fe595UL,
    0x0000000745327c8eUL,
    0x0000000746318e67UL,
    0x000000074dd7e899UL,
    0x00000007508e9547UL,
    0x0000000750e239bfUL,
    0x0000000751595661UL,
    0x00000007586c1c7aUL,
    0x0000000763cdd5d0UL,
    0x000000076c5e5385UL,
    0x000000076f25bf7aUL,
    0x0000000770b54b57UL,
    0x00000007790700f3UL,
    0x000000077b2c1103UL,
    0x0000000781fda723UL,
    0x000000078c4bb8c5UL,
    0x0000000793189f33UL,
    0x000000079a63a114UL,
    0x00000007ae234ad8UL,
    0x00000007b3f52aaaUL,
    0x00000007b5e25bf4UL,
    0x00000007c2c9c07bUL,
    0x00000007c4111ddaUL,
    0x00000007c92f379bUL,
    0x00000007cdaa1f4fUL,
    0x00000007cef15959UL,
    0x00000007e23b95c3UL,
    0x00000007e7fb2604UL,
    0x00000007efcd1211UL,
    0x00000007f621012eUL,
    0x00000007f717e98fUL,
    0x0000000802636568UL,
    0x0000000806d709cdUL,
    0x000000080955464dUL,
    0x000000080aad7fb1UL,
    0x000000080cf96e78UL,
    0x000000080f87b12dUL,
    0x00000008108150deUL,
    0x0000000813572c3dUL,
    0x0000000814c9daadUL,
    0x0000000823b4b75aUL,
    0x000000082a6c2d83UL,
    0x000000082f217814UL,
    0x0000000830887f6bUL,
    0x00000008367c467eUL,
    0x0000000852665f65UL,
    0x0000000854736280UL,
    0x00000008582a8b94UL,
    0x0000000861d3fad8UL,
    0x0000000865213399UL,
    0x00000008667accb1UL,
    0x000000088c089e10UL,
    0x000000088fe396c7UL,
    0x0000000895d51441UL,
    0x00000008a6c8f5e5UL,
    0x00000008b3eb714bUL,
    0x00000008c5f092baUL,
    0x00000008cf2f2f4fUL,
    0x00000008d1cfbf13UL,
    0x00000008dec00bc2UL,
    0x00000008ea253c37UL,
    0x00000008eda8b002UL,
    0x00000008f7584581UL,
    0x00000008fa70b11fUL,
    0x000000090ad0a485UL,
    0x000000090c62a3b2UL,
    0x0000000912d808faUL,
    0x0000000920dd6f1bUL,
    0x0000000924e5626dUL,
    0x0000000941b92d44UL,
    0x0000000949e7334bUL,
    0x000000094fb576ddUL,
    0x00000009559b20f4UL,
    0x000000096e564172UL,
    0x0000000972c8ebddUL,
    0x000000097770152eUL,
    0x00000009781e3154UL,
    0x00000009790de000UL,
    0x000000098d124abcUL,
    0x000000098e60413fUL,
    0x00000009916e58ddUL,
    0x00000009b0dae628UL,
    0x00000009b19e4e05UL,
    0x00000009b624ddf9UL,
    0x00000009b6fa0951UL,
    0x00000009bba6f264UL,
    0x00000009c4e0ac10UL,
    0x00000009cb40e145UL,
    0x00000009e9d75f5cUL,
    0x00000009f376b4a1UL,
    0x00000009f46916cbUL,
    0x00000009fa1709bcUL,
    0x00000009fe33fab2UL,
    0x0000000a18526b99UL,
    0x0000000a34c7ac27UL,
    0x0000000a361c3852UL,
    0x0000000a3b158ca2UL,
    0x0000000a42348ad4UL,
    0x0000000a443bdf10UL,
    0x0000000a46a2d671UL,
    0x0000000a4b75dabbUL,
    0x0000000a4efb40e6UL,
    0x0000000a526bbc85UL,
    0x0000000a5de66f52UL,
    0x0000000a5f6c97e0UL,
    0x0000000a72852b87UL,
    0x0000000a73b1f9f1UL,
    0x0000000a7e9f1988UL,
    0x0000000a7fd99cc3UL,
    0x0000000a89fa69d2UL,
    0x0000000a8fd0fd33UL,
    0x0000000a9e7534cfUL,
    0x0000000aa17ff279UL,
    0x0000000aa18195d5UL,
    0x0000000abd0211d8UL,
    0x0000000aca33452dUL,
    0x0000000acb80d09cUL,
    0x0000000addbad88fUL,
    0x0000000adf92130dUL,
    0x0000000aeba04846UL,
    0x0000000aef782c60UL,
    0x0000000aefc4f98aUL,
    0x0000000afa7f9654UL,
    0x0000000b0d20ee59UL,
    0x0000000b0e839f6aUL,
    0x0000000b0fbf1192UL,
    0x0000000b11502f26UL,
    0x0000000b1aff2033UL,
    0x0000000b21368527UL,
    0x0000000b2e1f7520UL,
    0x0000000b3b0f0389UL,
    0x0000000b432de3efUL,
    0x0000000b4811e74aUL,
    0x0000000b4965ff74UL,
    0x0000000b4f5fc33eUL,
    0x0000000b59f28ceeUL,
    0x0000000b5ba9d1a6UL,
    0x0000000b5dfbaf15UL,
    0x0000000b617648e5UL,
    0x0000000b6bb4899fUL,
    0x0000000b78f9907fUL,
    0x0000000b80b08b6aUL,
    0x0000000b8283f78bUL,
    0x0000000b8757a3adUL,
    0x0000000b9609bec2UL,
    0x0000000b9cee82deUL,
    0x0000000bbb32a9e9UL,
    0x0000000bbc486d15UL,
    0x0000000bc3db46b1UL,
    0x0000000bc54ecfcdUL,
    0x0000000bccab8bc9UL,
    0x0000000bcdc2a284UL,
    0x0000000bdb2a8609UL,
    0x0000000bdf67cb07UL,
    0x0000000be0521761UL,
    0x0000000be46aa758UL,
    0x0000000be8199684UL,
    0x0000000bec8d5a06UL,
    0x0000000beffbb673UL,
    0x0000000bfebb8225UL,
    0x0000000c12a07fd4UL,
    0x0000000c14e2d6a2UL,
    0x0000000c17671aacUL,
    0x0000000c19e07034UL,
    0x0000000c24b8961fUL,
    0x0000000c2a00b7ebUL,
    0x0000000c2e82f058UL,
    0x0000000c2ef871a8UL,
    0x0000000c3cb7631aUL,
    0x0000000c3edc835bUL,
    0x0000000c4fe3720eUL,
    0x0000000c6bdfb255UL,
    0x0000000c736564c6UL,
    0x0000000c87e420ecUL,
    0x0000000c88913009UL,
    0x0000000c9322936aUL,
    0x0000000c99f7b052UL,
    0x0000000ca39d0368UL,
    0x0000000ca83a8864UL,
    0x0000000cadf33b86UL,
    0x0000000cb03dff9aUL,
    0x0000000cb307ee75UL,
    0x0000000cb5799113UL,
    0x0000000cc034cf72UL,
    0x0000000cdb1d0396UL,
    0x0000000ce2802cc0UL,
    0x0000000ce9894e85UL,
    0x0000000ceb538636UL,
    0x0000000cecdaf8c3UL,
    0x0000000cf056ad6cUL,
    0x0000000cfaa9272dUL,
    0x0000000cfb664112UL,
    0x0000000cfec3da21UL,
    0x0000000d081fe928UL,
    0x0000000d0fffcba9UL,
    0x0000000d1cbb68d9UL,
    0x0000000d1d33dd03UL,
    0x0000000d40215e0dUL,
    0x0000000d43a661b8UL,
    0x0000000d4854bccaUL,
    0x0000000d624d1147UL,
    0x0000000d676ef832UL,
    0x0000000d741aca58UL,
    0x0000000d74f4ee9bUL,
    0x0000000d75cf8d9eUL,
    0x0000000d7f205ce6UL,
    0x0000000d80d19de7UL,
    0x0000000d8679a457UL,
    0x0000000d8d19f3a2UL,
    0x0000000d8ddf46d4UL,
    0x0000000d928d11b3UL,
    0x0000000d93f7fd4dUL,
    0x0000000da67d25aaUL,
    0x0000000da76aa48dUL,
    0x0000000dab1c0a1dUL,
    0x0000000dabf47dd6UL,
    0x0000000dae0dcd32UL,
    0x0000000db0c02a1bUL,
    0x0000000db49dc0c3UL,
    0x0000000db8195d54UL,
    0x0000000dbb403cbdUL,
    0x0000000dc03e1683UL,
    0x0000000dc50dff46UL,
    0x0000000dccb0d027UL,
    0x0000000dd346a1cbUL,
    0x0000000dd3c31259UL,
    0x0000000dd4385c71UL,
    0x0000000dd8daa790UL,
    0x0000000de006edd1UL,
    0x0000000de93edd88UL,
    0x0000000dee2469cdUL,
    0x0000000df98a39e5UL,
    0x0000000dfa3b8e97UL,
    0x0000000e014077f1UL,
    0x0000000e0adc89e1UL,
    0x0000000e11882decUL,
    0x0000000e16b5f94bUL,
    0x0000000e25524e59UL,
    0x0000000e292f927eUL,
    0x0000000e2932e801UL,
    0x0000000e3984c87cUL,
    0x0000000e3bc3e089UL,
    0x0000000e411a41a2UL,
    0x0000000e5b670e22UL,
    0x0000000e65a5eeb2UL,
    0x0000000e6b6a7987UL,
    0x0000000e7620e07aUL,
    0x0000000e8fa61c10UL,
    0x0000000e9628af76UL,
    0x0000000e97a95ccdUL,
    0x0000000e9aedc5edUL,
    0x0000000ea3163c43UL,
    0x0000000ea4e2bc3bUL,
    0x0000000ea5f4ad01UL,
    0x0000000eaad6a2cfUL,
    0x0000000eb0483826UL,
    0x0000000eb484761dUL,
    0x0000000ecd9d7bcfUL,
    0x0000000ed5ff4d64UL,
    0x0000000ede60ee86UL,
    0x0000000ee483a8daUL,
    0x0000000ef33d1c1fUL,
    0x0000000ef3f6cbe8UL,
    0x0000000efa8e6a91UL,
    0x0000000efb964464UL,
    0x0000000f04fc7429UL,
    0x0000000f0c028774UL,
    0x0000000f17823ba4UL,
    0x0000000f1aab265eUL,
    0x0000000f1c0d84a9UL,
    0x0000000f1cb0f13aUL,
    0x0000000f1cc5921dUL,
    0x0000000f1e4e15caUL,
    0x0000000f27cf64acUL,
    0x0000000f32aabb63UL,
    0x0000000f440cf235UL,
    0x0000000f4da8039eUL,
    0x0000000f60cec18fUL,
    0x0000000f610a14f8UL,
    0x0000000f64bd97fcUL,
    0x0000000f6c591839UL,
    0x0000000f717d2832UL,
    0x0000000f76348f8eUL,
    0x0000000f884cb367UL,
    0x0000000fafe9fc6aUL,
    0x0000000fb0a7706aUL,
    0x0000000fb319c0b0UL,
    0x0000000fb4e59a92UL,
    0x0000000fb5907b57UL,
    0x0000000fbbd0b950UL,
    0x0000000fbd1d2f48UL,
    0x0000000fca7f556aUL,
    0x0000000fdb5b191aUL,
    0x0000000fdc13c7b3UL,
    0x0000000fdd0485feUL,
    0x0000000fe26e4c41UL,
    0x0000000fec1e1c1eUL,
    0x0000000ff8157245UL,
    0x0000000ffc80e8bdUL,
    0x0000000ffced66b6UL,
    0x0000000fff7a10a7UL,
    0x000000001d93b051UL,
    0x000000004062c35aUL,
    0x000000005f40e3b7UL,
    0x0000000065099db8UL,
    0x00000000881f7956UL,
    0x000000012311ee8fUL,
    0x000000012d2bcc95UL,
    0x0000000133fdf42bUL,
    0x000000014230c7c3UL,
    0x00000001682a0a47UL,
    0x00000001960107f9UL,
    0x00000001982c31c5UL,
    0x0000000198e6f510UL,
    0x00000001b3efd398UL,
    0x00000001d0b231e6UL,
    0x00000001e7dcda0bUL,
    0x00000001ea0109e7UL,
    0x00000001f7296736UL,
    0x000000020e872de1UL,
    0x000000023c742093UL,
    0x00000002484e1ec6UL,
    0x00000002914d4b2aUL,
    0x00000002b5f8607aUL,
    0x00000002ddd4b06aUL,
    0x00000002ec439c61UL,
    0x00000003366a2f65UL,
    0x0000000399e47e0dUL,
    0x00000003ec60c29dUL,
    0x0000000432ddd7b6UL,
    0x000000043e4f49aeUL,
    0x000000044bf056a9UL,
    0x000000047198b00dUL,
    0x00000004a622d08aUL,
    0x00000004c9652881UL,
    0x000000050af5985fUL,
    0x00000005124578ddUL,
    0x00000005963f201cUL,
    0x00000005afa2f5ccUL,
    0x00000005f8e98f76UL,
    0x0000000600552a02UL,
    0x0000000604106d20UL,
    0x0000000684fb12b0UL,
    0x000000069747ae86UL,
    0x00000006ab7a036dUL,
    0x00000006aba7938cUL,
    0x0000000766da452fUL,
    0x000000078d141121UL,
    0x00000007974640f9UL,
    0x0000000798e68e67UL,
    0x00000007b0dd7fcdUL,
    0x00000007bad1607dUL,
    0x0000000803e818e7UL,
    0x000000084703bc9fUL,
    0x000000084ac6e6b0UL,
    0x000000088a74a76cUL,
    0x00000008a47418a1UL,
    0x00000008a6af5910UL,
    0x00000008ccfc8f57UL,
    0x00000008ce9811deUL,
    0x000000090718132dUL,
    0x00000009504422daUL,
    0x00000009b6369aafUL,
    0x00000009c8aade5cUL,
    0x00000009fab9a8e8UL,
    0x0000000a2a470a3fUL,
    0x0000000a9d8f5927UL,
    0x0000000aafe58f63UL,
    0x0000000ae3244229UL,
    0x0000000b05b0c171UL,
    0x0000000b157c19afUL,
    0x0000000b193a1376UL,
    0x0000000b40b5f41fUL,
    0x0000000b5202a851UL,
    0x0000000b8689bd37UL,
    0x0000000b9fa5e72eUL,
    0x0000000bad7eb2e2UL,
    0x0000000bc47c9086UL,
    0x0000000c0f5e2fa4UL,
    0x0000000c1c7ddeddUL,
    0x0000000c1e1ae912UL,
    0x0000000c2dc54431UL,
    0x0000000c437d1fa3UL,
    0x0000000c47c63669UL,
    0x0000000c54c777ffUL,
    0x0000000c5aca58e9UL,
    0x0000000c892ce454UL,
    0x0000000cfd566adeUL,
    0x0000000d02ad87c8UL,
    0x0000000d1f641306UL,
    0x0000000d6881194eUL,
    0x0000000dd1035f7aUL,
    0x0000000de0984a92UL,
    0x0000000dfe080e3aUL,
    0x0000000e003c047dUL,
    0x0000000e5151b0c0UL,
    0x0000000e6a5124a4UL,
    0x0000000e7f325d98UL,
    0x0000000ea43c63f7UL,
    0x0000000f035a1c6eUL,
    0x0000000f54748553UL,
    0x0000000f75fac4b2UL,
    0x0000000f8124ae2eUL,
    0x0000000fa4df729bUL,
    0x0000000fb9adb105UL,
    0x0000000fbe4bfb57UL,
};
apriltag_family_t *tagAruco6x6_1000_create()
{
   apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
   tf->name = strdup("tagAruco6x6_1000");
   tf->h = 9;
   tf->ncodes = 1000;
   tf->codes = codedata;
   tf->nbits = 36;
   tf->bit_x = calloc(36, sizeof(uint32_t));
   tf->bit_y = calloc(36, sizeof(uint32_t));
   tf->bit_x[0] = 1;
   tf->bit_y[0] = 1;
   tf->bit_x[1] = 2;
   tf->bit_y[1] = 1;
   tf->bit_x[2] = 3;
   tf->bit_y[2] = 1;
   tf->bit_x[3] = 4;
   tf->bit_y[3] = 1;
   tf->bit_x[4] = 5;
   tf->bit_y[4] = 1;
   tf->bit_x[5] = 2;
   tf->bit_y[5] = 2;
   tf->bit_x[6] = 3;
   tf->bit_y[6] = 2;
   tf->bit_x[7] = 4;
   tf->bit_y[7] = 2;
   tf->bit_x[8] = 3;
   tf->bit_y[8] = 3;
   tf->bit_x[9] = 6;
   tf->bit_y[9] = 1;
   tf->bit_x[10] = 6;
   tf->bit_y[10] = 2;
   tf->bit_x[11] = 6;
   tf->bit_y[11] = 3;
   tf->bit_x[12] = 6;
   tf->bit_y[12] = 4;
   tf->bit_x[13] = 6;
   tf->bit_y[13] = 5;
   tf->bit_x[14] = 5;
   tf->bit_y[14] = 2;
   tf->bit_x[15] = 5;
   tf->bit_y[15] = 3;
   tf->bit_x[16] = 5;
   tf->bit_y[16] = 4;
   tf->bit_x[17] = 4;
   tf->bit_y[17] = 3;
   tf->bit_x[18] = 6;
   tf->bit_y[18] = 6;
   tf->bit_x[19] = 5;
   tf->bit_y[19] = 6;
   tf->bit_x[20] = 4;
   tf->bit_y[20] = 6;
   tf->bit_x[21] = 3;
   tf->bit_y[21] = 6;
   tf->bit_x[22] = 2;
   tf->bit_y[22] = 6;
   tf->bit_x[23] = 5;
   tf->bit_y[23] = 5;
   tf->bit_x[24] = 4;
   tf->bit_y[24] = 5;
   tf->bit_x[25] = 3;
   tf->bit_y[25] = 5;
   tf->bit_x[26] = 4;
   tf->bit_y[26] = 4;
   tf->bit_x[27] = 1;
   tf->bit_y[27] = 6;
   tf->bit_x[28] = 1;
   tf->bit_y[28] = 5;
   tf->bit_x[29] = 1;
   tf->bit_y[29] = 4;
   tf->bit_x[30] = 1;
   tf->bit_y[30] = 3;
   tf->bit_x[31] = 1;
   tf->bit_y[31] = 2;
   tf->bit_x[32] = 2;
   tf->bit_y[32] = 5;
   tf->bit_x[33] = 2;
   tf->bit_y[33] = 4;
   tf->bit_x[34] = 2;
   tf->bit_y[34] = 3;
   tf->bit_x[35] = 3;
   tf->bit_y[35] = 4;
   tf->width_at_border = 8;
   tf->total_width = 10;
   tf->reversed_border = false;
   return tf;
}

void tagAruco6x6_1000_destroy(apriltag_family_t *tf)
{
   free(tf->bit_x);
   free(tf->bit_y);
   free(tf->name);
   free(tf);
}
