//
// Created by uos on 2022/4/28.
//

#ifndef UOS_RECOVERY_JSONSERIALIZETEST_H
#define UOS_RECOVERY_JSONSERIALIZETEST_H

#include "utils/global.h"
#include <gtest/gtest.h>


class JsonSerializeTest : public testing::Test
{
public:
    void SetUp() override
    {

    }

    void TearDown() override
    {

    }

private:

};

TEST_F(JsonSerializeTest, UserDataBackupRequest)
{
    UserDataBackupRequest request1;
    request1.rootUUID = "88c470cb-0d04-480d-9296-7449cd1cd969";
    request1.destUUID = "88c470cb-0d04-480d-9296-7449cd1cd970";
    request1.username = "uos";
    request1.remark = "remark";
    request1.exclude = QStringList({"Desktop", "Downloads", "Music"});
    QJsonObject jsonObject = request1.marshal();

    UserDataBackupRequest request2;
    request2.unmarshal(jsonObject);

    EXPECT_EQ(request1.username, request2.username);
    EXPECT_EQ(request1.destUUID, request2.destUUID);
    EXPECT_EQ(request1.rootUUID, request2.rootUUID);
    EXPECT_EQ(request1.exclude, request2.exclude);
}

TEST_F(JsonSerializeTest, Partition)
{
    Partition partition1;
    partition1.name = "sda";
    partition1.label = "_data";
    partition1.uuid = "88c470cb-0d04-480d-9296-7449cd1cd970";
    partition1.fsType = "ext4";
    partition1.size = 100000000000000000;
    partition1.used = 50000000000000000;
    partition1.free = 50000000000000000;
    QJsonObject jsonObject = partition1.marshal();

    Partition partition2;
    partition2.unmarshal(jsonObject);

    EXPECT_EQ(partition1.name, partition2.name);
    EXPECT_EQ(partition1.label, partition2.label);
    EXPECT_EQ(partition1.uuid, partition2.uuid);
    EXPECT_EQ(partition1.fsType, partition2.fsType);
    EXPECT_EQ(partition1.size, partition2.size);
    EXPECT_EQ(partition1.used, partition2.used);
    EXPECT_EQ(partition1.free, partition2.free);
}

#endif //UOS_RECOVERY_JSONSERIALIZETEST_H
