#ifndef BASE_TABLE_VIEW_H
#define BASE_TABLE_VIEW_H

#include <DTreeView>

DWIDGET_USE_NAMESPACE

class BaseItemDelegate;
class BaseHeaderView;
class QModelIndex;

class BaseTableView : public DTreeView
{
    Q_OBJECT
public:
    explicit BaseTableView(DWidget *parent = nullptr);
    void setRowBackgroundDelta(int delta) { m_rowBackgroundDelta = delta; }
    void setCheckAllState(Qt::CheckState checkState);

Q_SIGNALS:
    void checkAllChanged(Qt::CheckState checkState);

protected:
    void paintEvent(QPaintEvent *event) override;
    void drawRow(QPainter *painter, const QStyleOptionViewItem &options,
                 const QModelIndex &index) const override;
    void currentChanged(const QModelIndex &current, const QModelIndex &previous) override;
    bool viewportEvent(QEvent *event) override;


protected:
    BaseHeaderView *m_headerView = nullptr;
    QModelIndex m_hover;
    QModelIndex m_pressed;
    int m_rowBackgroundDelta = 0;
};

#endif  // BASE_TABLE_VIEW_H
