//
// Created by uos on 2022/3/18.
//

#ifndef UOS_RECOVERY_SELECTPARTITIONWIDGET_H
#define UOS_RECOVERY_SELECTPARTITIONWIDGET_H

#include <DWidget>
#include <DDialog>
#include <DTreeView>
#include <QStandardItemModel>
#include <DMainWindow>
#include <DLabel>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class SelectPartitionTreeView;
class SelectPartitionItemModel;

class SelectPartitionDialog : public DMainWindow
{
    Q_OBJECT
public:
    explicit SelectPartitionDialog(QWidget *parent = nullptr);
    void setData(QString &jsonString, const QString &currUUID);
    void showToCenter();
    void startSpinner();
    void stopSpinner();
    void setErrorText(const QString &text);
    void setDestUUID(const QString &destUUID);

Q_SIGNALS:
    void destDeviceChange(const QJsonObject &jsonObject);
    void treeViewClicked(const QModelIndex &index);
//     void closeMainWindow();

// protected:
//     void closeEvent(QCloseEvent *event) override;

public Q_SLOTS:
    void onShowResult(int errorCode);
private Q_SLOTS:
    void onSelectPartitionTreeViewClicked(const QModelIndex &index);
private:
    SelectPartitionItemModel *m_model = Q_NULLPTR;
    SelectPartitionTreeView *m_view = Q_NULLPTR;
    DLabel *m_error = nullptr;
    DPushButton *m_okBtn = nullptr;
    QMap<QString, QList<QJsonObject>> m_partInfoMap;
    DSpinner *m_calculateTip = nullptr;
    QLabel *m_calculateText = nullptr;
    QString m_currDestUUID = "";
    QString m_curPartitionName = "";
    int m_lastPartionRowIndex = -1;
    int m_curPartionRowIndex = -1;
    int m_sucessPartionRowIndex = -1; // 用于更新校验空间不足时，界面蓝色标记可以回退到上一次设置成功的位置
};


#endif //UOS_RECOVERY_SELECTPARTITIONWIDGET_H
