/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MYTREEVIEWMODEL_H
#define MYTREEVIEWMODEL_H

#include <QStandardItemModel>

constexpr const char *kBackupFile = QT_TRANSLATE_NOOP("Recovery.Table.Header", "Backup File");
constexpr const char *kTime = QT_TRANSLATE_NOOP("Recovery.Table.Header", "Time");

class TreeViewModel : public QStandardItemModel
{
    Q_OBJECT
public:
    TreeViewModel(QObject *parent = nullptr);
    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
    void appendRow(const QList<QStandardItem*> &items);
    void clear();
    int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    int columnCount(const QModelIndex &parent = QModelIndex()) const override;

Q_SIGNALS:
    void itemsIsReady();

private:
    int m_rowNum;
};

#endif // MYTREEVIEWMODEL_H
