//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/12/4.
//

#ifndef UOS_RECOVERY_IMMU_GHOST_WIDGET_H
#define UOS_RECOVERY_IMMU_GHOST_WIDGET_H

#include "ImmuItemFrame.h"
#include <DWidget>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
#include <DSuggestButton>
#include <QHBoxLayout>
#include <dfilechooseredit.h>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

enum class LayoutType {
    tipsLayout, // only tips
    spinnerLayout, // spinner + space + tips
    tipsLabelLayout // label + space + tips
};

class TipsWidget : public QWidget {
    Q_OBJECT
public:
    explicit TipsWidget(QWidget *parent = nullptr);
    void initUI();
    void initLayout();
    void setTips(const QString &tips);
    void showSpinner(bool show);
    void resetLayout(LayoutType layoutType);
    void setTipsLabelIconPixmap(const QPixmap &iconPix);

private:
    DSpinner *m_spinner = nullptr;
    DLabel *m_tipsLabel = nullptr;
    DLabel *m_tips = nullptr;
    DLabel *m_spaceLabel = nullptr;
    QHBoxLayout *m_hLayout = nullptr;
};

class GhostItemFrame : public ImmuItemFrame
{
    Q_OBJECT
public:
    explicit GhostItemFrame(const QString &title, const QString &titleDes, const QString &icon, QWidget *parent = nullptr);
    virtual ~GhostItemFrame();
    void initUI() override;
    void initLayout() override;
    void setTips(const QString &tips);
    void showSpinner(bool show);
    void resetLayout(LayoutType layoutType);
    void setTipsLabelIconPixmap(const QPixmap &iconPix);

private:
    TipsWidget *m_tipsWidget = nullptr;
};

class ImmuGhostWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ImmuGhostWidget(DWidget *parent = nullptr);
    void initUI();
    void initLayout();
    void setGhostItemTips(const QString &tips);
    void setTipsStyleSheet(const QString &styleSheet);
    void setResultInfo(const QString &info, bool error = false);
    void setErrorInfo(const QString &info, bool normalStyle = false);
    void setStartEnable(bool enable);
    void setCancelEnable(bool enable);
    QString getDestDirText();
    void setStoreItemInfo(quint64 usedSize, quint64 totalSize);
    void resetLayout(LayoutType layoutType);
    void setDefaultStorePathTips();
    // status: 0: sucess icon, 1: warning icon
    void setGhostItemTipsLabelIcon(int status);

Q_SIGNALS:
    void cancel();
    void start(const QString &selectDir);
    void notifySetDestPartition(QWidget *parent);
    void checkSpaceSignal(const QString &selectDir);

private Q_SLOTS:
    void onFileDialogClosed(int code);
    void startBtnClicked();
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DLabel *m_titleDes = nullptr;
    DLabel *m_labelDest = nullptr;
    DFileChooserEdit* m_dirChooseWidget;
    DLabel *m_curPartitionText = nullptr;
    GhostItemFrame *m_ghostItem = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancel = nullptr;
    DPushButton *m_start = nullptr;
    QPixmap m_okIconPixmap;
    QPixmap m_warningIconPixmap;
};

#endif //UOS_RECOVERY_IMMU_GHOST_WIDGET_H
