//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/19.
//

#ifndef UOS_RECOVERY_IMMU_RESTORE_MODULE_H
#define UOS_RECOVERY_IMMU_RESTORE_MODULE_H

#include "interface/ModuleInterface.h"
#include "ImmuRestoreWidget.h"
#include "common/ResultWidget.h"
#include "common/ProgressWidget.h"
#include "common/AuthorityUtils.h"
#include <QObject>

class FrameProxyInterface;

class ImmuRestoreModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit ImmuRestoreModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                           QObject *parent = nullptr);
    ~ImmuRestoreModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;
    void updateData() override;
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);
    void setSelinuxEnable(bool enable);
    void setLVM(bool isLVM);
    void setEncrypted(bool isEncrypted);
    void setDevice(bool isDevice);
    void setFileMgrEncrypted(bool encrypt);
    void setMajorVersion(int version);
    void setMinorVersion(int version);
    void showSystemBackupFiles();
    void showDataBackupFiles();
    void showSystemCloneBackupFiles();

Q_SIGNALS:
    void notifyShowBackupPage();

public Q_SLOTS:
    void onSystemRestore();
    void onStartSystemRestore(const BackupInfo &backupInfo);
    void onDataRestore();
    void onStartUserDataRestore(const BackupInfo &backupInfo);
    void onDeleteBackupFiles(const BackupInfo &backupInfo);
    void onBack();
    void onBackHome();
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onShowResult(bool success, const Response &rsp);
    void onShowProgress(OperateType opType, const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
    void onSuccess(const QString &msg);
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);

private:
    int reboot();
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);

private:
    ImmuRestoreWidget *m_restoreWidget = nullptr;
    DefaultEmptyRestoreWidget *m_emptyRestoreWidget = nullptr;
    ProgressWidgetV2 *m_progressWidget = nullptr;
    ResultWidgetV2 *m_resultWidget = nullptr;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
    QString m_dimRestoreImgFilePath = "";
    QString seUser;
    QString m_curSysOpID = "";
    QString m_curUserOpID = "";
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    int m_totalBackupSize = 0;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
    QPixmap m_sysRestoreIcon;
};

#endif //UOS_RECOVERY_IMMU_RESTORE_MODULE_H
