#pragma once
#include "FrameProxyInterface.h"
#include "RecoveryProxy.h"

//左侧所有功能模块基类
class ModuleInterface
{
public:
    ModuleInterface(FrameProxyInterface *frameProxy, ComDeepinDaemonUosrecoveryInterface *interface)
            : m_frameProxy(frameProxy),
              m_recoveryInterface(interface)
    {
    }

    virtual ~ModuleInterface() {}

    // initialize的时候不能做资源占用较高的操作；
    virtual void initialize() = 0;

    virtual QString name() const = 0;

    virtual QString icons() const = 0;

    virtual QString text() const = 0;

    virtual void active() = 0;

    virtual void updateData() {};


protected:
    FrameProxyInterface *m_frameProxy = nullptr;
    ComDeepinDaemonUosrecoveryInterface *m_recoveryInterface = nullptr;
};