#pragma once
#include "utils/global.h"
#include "utils/data-collection/EventData.h"
#include <QString>
#include <QSharedPointer>
#include <QObject>

class UImgRecovery : public QObject
{
    Q_OBJECT

public:
    explicit UImgRecovery();
    ~UImgRecovery();

    // Ghost备份空间校验
    virtual ErrorCode CheckGhostBackupDiskSpace(const QString &selectDir) = 0;//制作uimg

    // 制作uimg文件
    virtual ErrorCode createUImg(const SystemCloneRequest &request) = 0;
    virtual ErrorCode removeUImgBackup(const RemoveUserDataBackupRequest &request) = 0;

    // 上报数据埋点信息
    virtual void reportEventLog(const ResultInfo &resultInfo, OperateType opType, RecoveryType recoveryType);
Q_SIGNALS:
    void progressChanged(const QString &progress);
    void error(const QString &errMsg);
    void success(const QString &msg);
    void spaceCheckFinished(const QString &space);
};

typedef QSharedPointer<UImgRecovery> UImgRecoveryPtr;
