/***
  This file is part of systemd.

  Copyright 2014 Emil Renner Berthing <systemd@esmil.dk>

  With parts from the GNU C Library
  Copyright 1991-2014 Free Software Foundation, Inc.

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/

#pragma once

#include "config.h"

#ifdef HAVE_PRINTF_H
#include <printf.h>
#else

#include <stddef.h>

enum {        /* C type: */
  PA_INT,     /* int */
  PA_CHAR,    /* int, cast to char */
  PA_WCHAR,   /* wide char */
  PA_STRING,  /* const char *, a '\0'-terminated string */
  PA_WSTRING, /* const wchar_t *, wide character string */
  PA_POINTER, /* void * */
  PA_FLOAT,   /* float */
  PA_DOUBLE,  /* double */
  PA_LAST
};

/* Flag bits that can be set in a type returned by `parse_printf_format'.  */
#define PA_FLAG_MASK        0xff00
#define PA_FLAG_LONG_LONG   (1 << 8)
#define PA_FLAG_LONG_DOUBLE PA_FLAG_LONG_LONG
#define PA_FLAG_LONG        (1 << 9)
#define PA_FLAG_SHORT       (1 << 10)
#define PA_FLAG_PTR         (1 << 11)

size_t parse_printf_format(const char *fmt, size_t n, int *types);

#endif /* HAVE_PRINTF_H */

