// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/media_file_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [MediaFileService.GetMediaFile][google.ads.googleads.v0.services.MediaFileService.GetMediaFile]
type GetMediaFileRequest struct {
	// The resource name of the media file to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMediaFileRequest) Reset()         { *m = GetMediaFileRequest{} }
func (m *GetMediaFileRequest) String() string { return proto.CompactTextString(m) }
func (*GetMediaFileRequest) ProtoMessage()    {}
func (*GetMediaFileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_service_636511ac02cf9dc1, []int{0}
}
func (m *GetMediaFileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMediaFileRequest.Unmarshal(m, b)
}
func (m *GetMediaFileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMediaFileRequest.Marshal(b, m, deterministic)
}
func (dst *GetMediaFileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMediaFileRequest.Merge(dst, src)
}
func (m *GetMediaFileRequest) XXX_Size() int {
	return xxx_messageInfo_GetMediaFileRequest.Size(m)
}
func (m *GetMediaFileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMediaFileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMediaFileRequest proto.InternalMessageInfo

func (m *GetMediaFileRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MediaFileService.MutateMediaFiles][google.ads.googleads.v0.services.MediaFileService.MutateMediaFiles]
type MutateMediaFilesRequest struct {
	// The ID of the customer whose media files are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual media file.
	Operations           []*MediaFileOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MutateMediaFilesRequest) Reset()         { *m = MutateMediaFilesRequest{} }
func (m *MutateMediaFilesRequest) String() string { return proto.CompactTextString(m) }
func (*MutateMediaFilesRequest) ProtoMessage()    {}
func (*MutateMediaFilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_service_636511ac02cf9dc1, []int{1}
}
func (m *MutateMediaFilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMediaFilesRequest.Unmarshal(m, b)
}
func (m *MutateMediaFilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMediaFilesRequest.Marshal(b, m, deterministic)
}
func (dst *MutateMediaFilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMediaFilesRequest.Merge(dst, src)
}
func (m *MutateMediaFilesRequest) XXX_Size() int {
	return xxx_messageInfo_MutateMediaFilesRequest.Size(m)
}
func (m *MutateMediaFilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMediaFilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMediaFilesRequest proto.InternalMessageInfo

func (m *MutateMediaFilesRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateMediaFilesRequest) GetOperations() []*MediaFileOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation to create media file.
type MediaFileOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*MediaFileOperation_Create
	Operation            isMediaFileOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *MediaFileOperation) Reset()         { *m = MediaFileOperation{} }
func (m *MediaFileOperation) String() string { return proto.CompactTextString(m) }
func (*MediaFileOperation) ProtoMessage()    {}
func (*MediaFileOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_service_636511ac02cf9dc1, []int{2}
}
func (m *MediaFileOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaFileOperation.Unmarshal(m, b)
}
func (m *MediaFileOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaFileOperation.Marshal(b, m, deterministic)
}
func (dst *MediaFileOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaFileOperation.Merge(dst, src)
}
func (m *MediaFileOperation) XXX_Size() int {
	return xxx_messageInfo_MediaFileOperation.Size(m)
}
func (m *MediaFileOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaFileOperation.DiscardUnknown(m)
}

var xxx_messageInfo_MediaFileOperation proto.InternalMessageInfo

type isMediaFileOperation_Operation interface {
	isMediaFileOperation_Operation()
}

type MediaFileOperation_Create struct {
	Create *resources.MediaFile `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

func (*MediaFileOperation_Create) isMediaFileOperation_Operation() {}

func (m *MediaFileOperation) GetOperation() isMediaFileOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MediaFileOperation) GetCreate() *resources.MediaFile {
	if x, ok := m.GetOperation().(*MediaFileOperation_Create); ok {
		return x.Create
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MediaFileOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MediaFileOperation_OneofMarshaler, _MediaFileOperation_OneofUnmarshaler, _MediaFileOperation_OneofSizer, []interface{}{
		(*MediaFileOperation_Create)(nil),
	}
}

func _MediaFileOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MediaFileOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MediaFileOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MediaFileOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _MediaFileOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MediaFileOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.MediaFile)
		err := b.DecodeMessage(msg)
		m.Operation = &MediaFileOperation_Create{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MediaFileOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MediaFileOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MediaFileOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for a media file mutate.
type MutateMediaFilesResponse struct {
	// All results for the mutate.
	Results              []*MutateMediaFileResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *MutateMediaFilesResponse) Reset()         { *m = MutateMediaFilesResponse{} }
func (m *MutateMediaFilesResponse) String() string { return proto.CompactTextString(m) }
func (*MutateMediaFilesResponse) ProtoMessage()    {}
func (*MutateMediaFilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_service_636511ac02cf9dc1, []int{3}
}
func (m *MutateMediaFilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMediaFilesResponse.Unmarshal(m, b)
}
func (m *MutateMediaFilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMediaFilesResponse.Marshal(b, m, deterministic)
}
func (dst *MutateMediaFilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMediaFilesResponse.Merge(dst, src)
}
func (m *MutateMediaFilesResponse) XXX_Size() int {
	return xxx_messageInfo_MutateMediaFilesResponse.Size(m)
}
func (m *MutateMediaFilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMediaFilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMediaFilesResponse proto.InternalMessageInfo

func (m *MutateMediaFilesResponse) GetResults() []*MutateMediaFileResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the media file mutate.
type MutateMediaFileResult struct {
	// The resource name returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateMediaFileResult) Reset()         { *m = MutateMediaFileResult{} }
func (m *MutateMediaFileResult) String() string { return proto.CompactTextString(m) }
func (*MutateMediaFileResult) ProtoMessage()    {}
func (*MutateMediaFileResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_service_636511ac02cf9dc1, []int{4}
}
func (m *MutateMediaFileResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMediaFileResult.Unmarshal(m, b)
}
func (m *MutateMediaFileResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMediaFileResult.Marshal(b, m, deterministic)
}
func (dst *MutateMediaFileResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMediaFileResult.Merge(dst, src)
}
func (m *MutateMediaFileResult) XXX_Size() int {
	return xxx_messageInfo_MutateMediaFileResult.Size(m)
}
func (m *MutateMediaFileResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMediaFileResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMediaFileResult proto.InternalMessageInfo

func (m *MutateMediaFileResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetMediaFileRequest)(nil), "google.ads.googleads.v0.services.GetMediaFileRequest")
	proto.RegisterType((*MutateMediaFilesRequest)(nil), "google.ads.googleads.v0.services.MutateMediaFilesRequest")
	proto.RegisterType((*MediaFileOperation)(nil), "google.ads.googleads.v0.services.MediaFileOperation")
	proto.RegisterType((*MutateMediaFilesResponse)(nil), "google.ads.googleads.v0.services.MutateMediaFilesResponse")
	proto.RegisterType((*MutateMediaFileResult)(nil), "google.ads.googleads.v0.services.MutateMediaFileResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MediaFileServiceClient is the client API for MediaFileService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MediaFileServiceClient interface {
	// Returns the requested media file in full detail.
	GetMediaFile(ctx context.Context, in *GetMediaFileRequest, opts ...grpc.CallOption) (*resources.MediaFile, error)
	// Creates media files. Operation statuses are returned.
	MutateMediaFiles(ctx context.Context, in *MutateMediaFilesRequest, opts ...grpc.CallOption) (*MutateMediaFilesResponse, error)
}

type mediaFileServiceClient struct {
	cc *grpc.ClientConn
}

func NewMediaFileServiceClient(cc *grpc.ClientConn) MediaFileServiceClient {
	return &mediaFileServiceClient{cc}
}

func (c *mediaFileServiceClient) GetMediaFile(ctx context.Context, in *GetMediaFileRequest, opts ...grpc.CallOption) (*resources.MediaFile, error) {
	out := new(resources.MediaFile)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.MediaFileService/GetMediaFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mediaFileServiceClient) MutateMediaFiles(ctx context.Context, in *MutateMediaFilesRequest, opts ...grpc.CallOption) (*MutateMediaFilesResponse, error) {
	out := new(MutateMediaFilesResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.MediaFileService/MutateMediaFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MediaFileServiceServer is the server API for MediaFileService service.
type MediaFileServiceServer interface {
	// Returns the requested media file in full detail.
	GetMediaFile(context.Context, *GetMediaFileRequest) (*resources.MediaFile, error)
	// Creates media files. Operation statuses are returned.
	MutateMediaFiles(context.Context, *MutateMediaFilesRequest) (*MutateMediaFilesResponse, error)
}

func RegisterMediaFileServiceServer(s *grpc.Server, srv MediaFileServiceServer) {
	s.RegisterService(&_MediaFileService_serviceDesc, srv)
}

func _MediaFileService_GetMediaFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMediaFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MediaFileServiceServer).GetMediaFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.MediaFileService/GetMediaFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MediaFileServiceServer).GetMediaFile(ctx, req.(*GetMediaFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MediaFileService_MutateMediaFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateMediaFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MediaFileServiceServer).MutateMediaFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.MediaFileService/MutateMediaFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MediaFileServiceServer).MutateMediaFiles(ctx, req.(*MutateMediaFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MediaFileService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.MediaFileService",
	HandlerType: (*MediaFileServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMediaFile",
			Handler:    _MediaFileService_GetMediaFile_Handler,
		},
		{
			MethodName: "MutateMediaFiles",
			Handler:    _MediaFileService_MutateMediaFiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/media_file_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/media_file_service.proto", fileDescriptor_media_file_service_636511ac02cf9dc1)
}

var fileDescriptor_media_file_service_636511ac02cf9dc1 = []byte{
	// 516 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xc5, 0x89, 0x54, 0xd4, 0x49, 0x91, 0xaa, 0x45, 0x15, 0x51, 0x84, 0x44, 0x64, 0x38, 0x54,
	0x51, 0xb5, 0x8e, 0x42, 0x10, 0xaa, 0xa1, 0x87, 0xe4, 0xd0, 0x94, 0x43, 0xa1, 0x18, 0xd4, 0x03,
	0x8a, 0x14, 0x2d, 0xf1, 0x60, 0x59, 0xb2, 0xbd, 0x66, 0x77, 0x9d, 0x4b, 0xd5, 0x0b, 0x07, 0xce,
	0x48, 0xfc, 0x01, 0x37, 0xf8, 0x0f, 0x2e, 0x5c, 0x11, 0x7f, 0xc0, 0x87, 0x20, 0x7b, 0xbd, 0x6e,
	0xd2, 0x36, 0x4a, 0xc3, 0x6d, 0x34, 0x9e, 0xf7, 0xde, 0xbc, 0x99, 0xf1, 0xc2, 0x7e, 0xc0, 0x79,
	0x10, 0xa1, 0xc3, 0x7c, 0xe9, 0xe8, 0x30, 0x8f, 0x66, 0x5d, 0x47, 0xa2, 0x98, 0x85, 0x53, 0x94,
	0x4e, 0x8c, 0x7e, 0xc8, 0x26, 0x1f, 0xc2, 0x08, 0x27, 0x65, 0x8e, 0xa6, 0x82, 0x2b, 0x4e, 0xda,
	0xba, 0x9e, 0x32, 0x5f, 0xd2, 0x0a, 0x4a, 0x67, 0x5d, 0x6a, 0xa0, 0xad, 0xde, 0x32, 0x72, 0x81,
	0x92, 0x67, 0x62, 0x91, 0x5d, 0xb3, 0xb6, 0xee, 0x1b, 0x4c, 0x1a, 0x3a, 0x2c, 0x49, 0xb8, 0x62,
	0x2a, 0xe4, 0x89, 0xd4, 0x5f, 0x6d, 0x17, 0xee, 0x8e, 0x50, 0x1d, 0xe7, 0xa0, 0xc3, 0x30, 0x42,
	0x0f, 0x3f, 0x66, 0x28, 0x15, 0x79, 0x08, 0x77, 0x0c, 0xe5, 0x24, 0x61, 0x31, 0x36, 0xad, 0xb6,
	0xb5, 0xbb, 0xe9, 0x6d, 0x99, 0xe4, 0x4b, 0x16, 0xa3, 0xfd, 0xc5, 0x82, 0x7b, 0xc7, 0x99, 0x62,
	0x0a, 0x2b, 0xbc, 0x34, 0x04, 0x0f, 0xa0, 0x31, 0xcd, 0xa4, 0xe2, 0x31, 0x8a, 0x49, 0xe8, 0x97,
	0x70, 0x30, 0xa9, 0x17, 0x3e, 0x79, 0x0b, 0xc0, 0x53, 0x14, 0xba, 0x99, 0x66, 0xad, 0x5d, 0xdf,
	0x6d, 0xf4, 0xfa, 0x74, 0xd5, 0x04, 0x68, 0xa5, 0xf4, 0xca, 0x80, 0xbd, 0x39, 0x1e, 0x3b, 0x04,
	0x72, 0xb5, 0x82, 0x1c, 0xc2, 0xc6, 0x54, 0x20, 0x53, 0xda, 0x46, 0xa3, 0xb7, 0xb7, 0x54, 0xa7,
	0x9a, 0xe3, 0x85, 0xd0, 0xd1, 0x2d, 0xaf, 0x44, 0x0f, 0x1b, 0xb0, 0x59, 0x69, 0xd9, 0x31, 0x34,
	0xaf, 0x9a, 0x97, 0x29, 0x4f, 0x24, 0x92, 0xd7, 0x70, 0x5b, 0xa0, 0xcc, 0x22, 0x65, 0x9c, 0x3d,
	0xbd, 0x81, 0xb3, 0x45, 0x32, 0xaf, 0xc0, 0x7b, 0x86, 0xc7, 0x7e, 0x0e, 0x3b, 0xd7, 0x56, 0xdc,
	0x68, 0x55, 0xbd, 0xcf, 0x75, 0xd8, 0xae, 0x80, 0x6f, 0xb4, 0x24, 0xf9, 0x6e, 0xc1, 0xd6, 0xfc,
	0xf2, 0xc9, 0x93, 0xd5, 0x5d, 0x5e, 0x73, 0x2c, 0xad, 0xb5, 0xc6, 0x69, 0xf7, 0x3f, 0xfd, 0xfe,
	0xfb, 0xb5, 0x46, 0xc9, 0x5e, 0x7e, 0xb7, 0x67, 0x0b, 0xad, 0x1f, 0x98, 0xfb, 0x90, 0x4e, 0x47,
	0x1f, 0x72, 0x31, 0x56, 0xa7, 0x73, 0x4e, 0x7e, 0x5a, 0xb0, 0x7d, 0x79, 0xdc, 0x64, 0x7f, 0xed,
	0xa9, 0x9a, 0xfb, 0x6c, 0xb9, 0xff, 0x03, 0xd5, 0xdb, 0xb5, 0xdd, 0xc2, 0x41, 0xdf, 0x76, 0x72,
	0x07, 0x17, 0x2d, 0x9f, 0xcd, 0x1d, 0xfc, 0x41, 0xe7, 0x7c, 0xce, 0x80, 0x1b, 0x17, 0x54, 0xae,
	0xd5, 0x19, 0xfe, 0xb1, 0xe0, 0xd1, 0x94, 0xc7, 0x2b, 0xd5, 0x87, 0x3b, 0x97, 0xd7, 0x75, 0x92,
	0xff, 0xaf, 0x27, 0xd6, 0xbb, 0xa3, 0x12, 0x1a, 0xf0, 0x88, 0x25, 0x01, 0xe5, 0x22, 0x70, 0x02,
	0x4c, 0x8a, 0xbf, 0xd9, 0xbc, 0x09, 0x69, 0x28, 0x97, 0xbf, 0x3f, 0xcf, 0x4c, 0xf0, 0xad, 0x56,
	0x1f, 0x0d, 0x06, 0x3f, 0x6a, 0xed, 0x91, 0x26, 0x1c, 0xf8, 0x92, 0xea, 0x30, 0x8f, 0x4e, 0xbb,
	0xb4, 0x14, 0x96, 0xbf, 0x4c, 0xc9, 0x78, 0xe0, 0xcb, 0x71, 0x55, 0x32, 0x3e, 0xed, 0x8e, 0x4d,
	0xc9, 0xfb, 0x8d, 0xa2, 0x81, 0xc7, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x1e, 0x8f, 0x2b,
	0xff, 0x04, 0x00, 0x00,
}
