// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/shared_set_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [SharedSetService.GetSharedSet][google.ads.googleads.v0.services.SharedSetService.GetSharedSet].
type GetSharedSetRequest struct {
	// The resource name of the shared set to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSharedSetRequest) Reset()         { *m = GetSharedSetRequest{} }
func (m *GetSharedSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetSharedSetRequest) ProtoMessage()    {}
func (*GetSharedSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_set_service_72af1c4c98b2939a, []int{0}
}
func (m *GetSharedSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSharedSetRequest.Unmarshal(m, b)
}
func (m *GetSharedSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSharedSetRequest.Marshal(b, m, deterministic)
}
func (dst *GetSharedSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSharedSetRequest.Merge(dst, src)
}
func (m *GetSharedSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetSharedSetRequest.Size(m)
}
func (m *GetSharedSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSharedSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSharedSetRequest proto.InternalMessageInfo

func (m *GetSharedSetRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [SharedSetService.MutateSharedSets][google.ads.googleads.v0.services.SharedSetService.MutateSharedSets].
type MutateSharedSetsRequest struct {
	// The ID of the customer whose shared sets are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual shared sets.
	Operations           []*SharedSetOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MutateSharedSetsRequest) Reset()         { *m = MutateSharedSetsRequest{} }
func (m *MutateSharedSetsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateSharedSetsRequest) ProtoMessage()    {}
func (*MutateSharedSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_set_service_72af1c4c98b2939a, []int{1}
}
func (m *MutateSharedSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedSetsRequest.Unmarshal(m, b)
}
func (m *MutateSharedSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedSetsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateSharedSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedSetsRequest.Merge(dst, src)
}
func (m *MutateSharedSetsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateSharedSetsRequest.Size(m)
}
func (m *MutateSharedSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedSetsRequest proto.InternalMessageInfo

func (m *MutateSharedSetsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateSharedSetsRequest) GetOperations() []*SharedSetOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on an shared set.
type SharedSetOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*SharedSetOperation_Create
	//	*SharedSetOperation_Update
	//	*SharedSetOperation_Remove
	Operation            isSharedSetOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *SharedSetOperation) Reset()         { *m = SharedSetOperation{} }
func (m *SharedSetOperation) String() string { return proto.CompactTextString(m) }
func (*SharedSetOperation) ProtoMessage()    {}
func (*SharedSetOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_set_service_72af1c4c98b2939a, []int{2}
}
func (m *SharedSetOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SharedSetOperation.Unmarshal(m, b)
}
func (m *SharedSetOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SharedSetOperation.Marshal(b, m, deterministic)
}
func (dst *SharedSetOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SharedSetOperation.Merge(dst, src)
}
func (m *SharedSetOperation) XXX_Size() int {
	return xxx_messageInfo_SharedSetOperation.Size(m)
}
func (m *SharedSetOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_SharedSetOperation.DiscardUnknown(m)
}

var xxx_messageInfo_SharedSetOperation proto.InternalMessageInfo

func (m *SharedSetOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isSharedSetOperation_Operation interface {
	isSharedSetOperation_Operation()
}

type SharedSetOperation_Create struct {
	Create *resources.SharedSet `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type SharedSetOperation_Update struct {
	Update *resources.SharedSet `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type SharedSetOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*SharedSetOperation_Create) isSharedSetOperation_Operation() {}

func (*SharedSetOperation_Update) isSharedSetOperation_Operation() {}

func (*SharedSetOperation_Remove) isSharedSetOperation_Operation() {}

func (m *SharedSetOperation) GetOperation() isSharedSetOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *SharedSetOperation) GetCreate() *resources.SharedSet {
	if x, ok := m.GetOperation().(*SharedSetOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *SharedSetOperation) GetUpdate() *resources.SharedSet {
	if x, ok := m.GetOperation().(*SharedSetOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *SharedSetOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*SharedSetOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SharedSetOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SharedSetOperation_OneofMarshaler, _SharedSetOperation_OneofUnmarshaler, _SharedSetOperation_OneofSizer, []interface{}{
		(*SharedSetOperation_Create)(nil),
		(*SharedSetOperation_Update)(nil),
		(*SharedSetOperation_Remove)(nil),
	}
}

func _SharedSetOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SharedSetOperation)
	// operation
	switch x := m.Operation.(type) {
	case *SharedSetOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *SharedSetOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *SharedSetOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("SharedSetOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _SharedSetOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SharedSetOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.SharedSet)
		err := b.DecodeMessage(msg)
		m.Operation = &SharedSetOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.SharedSet)
		err := b.DecodeMessage(msg)
		m.Operation = &SharedSetOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &SharedSetOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _SharedSetOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SharedSetOperation)
	// operation
	switch x := m.Operation.(type) {
	case *SharedSetOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SharedSetOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SharedSetOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for a shared set mutate.
type MutateSharedSetsResponse struct {
	// All results for the mutate.
	Results              []*MutateSharedSetResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *MutateSharedSetsResponse) Reset()         { *m = MutateSharedSetsResponse{} }
func (m *MutateSharedSetsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateSharedSetsResponse) ProtoMessage()    {}
func (*MutateSharedSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_set_service_72af1c4c98b2939a, []int{3}
}
func (m *MutateSharedSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedSetsResponse.Unmarshal(m, b)
}
func (m *MutateSharedSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedSetsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateSharedSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedSetsResponse.Merge(dst, src)
}
func (m *MutateSharedSetsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateSharedSetsResponse.Size(m)
}
func (m *MutateSharedSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedSetsResponse proto.InternalMessageInfo

func (m *MutateSharedSetsResponse) GetResults() []*MutateSharedSetResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the shared set mutate.
type MutateSharedSetResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateSharedSetResult) Reset()         { *m = MutateSharedSetResult{} }
func (m *MutateSharedSetResult) String() string { return proto.CompactTextString(m) }
func (*MutateSharedSetResult) ProtoMessage()    {}
func (*MutateSharedSetResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_set_service_72af1c4c98b2939a, []int{4}
}
func (m *MutateSharedSetResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedSetResult.Unmarshal(m, b)
}
func (m *MutateSharedSetResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedSetResult.Marshal(b, m, deterministic)
}
func (dst *MutateSharedSetResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedSetResult.Merge(dst, src)
}
func (m *MutateSharedSetResult) XXX_Size() int {
	return xxx_messageInfo_MutateSharedSetResult.Size(m)
}
func (m *MutateSharedSetResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedSetResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedSetResult proto.InternalMessageInfo

func (m *MutateSharedSetResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetSharedSetRequest)(nil), "google.ads.googleads.v0.services.GetSharedSetRequest")
	proto.RegisterType((*MutateSharedSetsRequest)(nil), "google.ads.googleads.v0.services.MutateSharedSetsRequest")
	proto.RegisterType((*SharedSetOperation)(nil), "google.ads.googleads.v0.services.SharedSetOperation")
	proto.RegisterType((*MutateSharedSetsResponse)(nil), "google.ads.googleads.v0.services.MutateSharedSetsResponse")
	proto.RegisterType((*MutateSharedSetResult)(nil), "google.ads.googleads.v0.services.MutateSharedSetResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SharedSetServiceClient is the client API for SharedSetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SharedSetServiceClient interface {
	// Returns the requested shared set in full detail.
	GetSharedSet(ctx context.Context, in *GetSharedSetRequest, opts ...grpc.CallOption) (*resources.SharedSet, error)
	// Creates, updates, or removes shared sets. Operation statuses are returned.
	MutateSharedSets(ctx context.Context, in *MutateSharedSetsRequest, opts ...grpc.CallOption) (*MutateSharedSetsResponse, error)
}

type sharedSetServiceClient struct {
	cc *grpc.ClientConn
}

func NewSharedSetServiceClient(cc *grpc.ClientConn) SharedSetServiceClient {
	return &sharedSetServiceClient{cc}
}

func (c *sharedSetServiceClient) GetSharedSet(ctx context.Context, in *GetSharedSetRequest, opts ...grpc.CallOption) (*resources.SharedSet, error) {
	out := new(resources.SharedSet)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.SharedSetService/GetSharedSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sharedSetServiceClient) MutateSharedSets(ctx context.Context, in *MutateSharedSetsRequest, opts ...grpc.CallOption) (*MutateSharedSetsResponse, error) {
	out := new(MutateSharedSetsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.SharedSetService/MutateSharedSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SharedSetServiceServer is the server API for SharedSetService service.
type SharedSetServiceServer interface {
	// Returns the requested shared set in full detail.
	GetSharedSet(context.Context, *GetSharedSetRequest) (*resources.SharedSet, error)
	// Creates, updates, or removes shared sets. Operation statuses are returned.
	MutateSharedSets(context.Context, *MutateSharedSetsRequest) (*MutateSharedSetsResponse, error)
}

func RegisterSharedSetServiceServer(s *grpc.Server, srv SharedSetServiceServer) {
	s.RegisterService(&_SharedSetService_serviceDesc, srv)
}

func _SharedSetService_GetSharedSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSharedSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedSetServiceServer).GetSharedSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.SharedSetService/GetSharedSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedSetServiceServer).GetSharedSet(ctx, req.(*GetSharedSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SharedSetService_MutateSharedSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateSharedSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedSetServiceServer).MutateSharedSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.SharedSetService/MutateSharedSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedSetServiceServer).MutateSharedSets(ctx, req.(*MutateSharedSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SharedSetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.SharedSetService",
	HandlerType: (*SharedSetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSharedSet",
			Handler:    _SharedSetService_GetSharedSet_Handler,
		},
		{
			MethodName: "MutateSharedSets",
			Handler:    _SharedSetService_MutateSharedSets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/shared_set_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/shared_set_service.proto", fileDescriptor_shared_set_service_72af1c4c98b2939a)
}

var fileDescriptor_shared_set_service_72af1c4c98b2939a = []byte{
	// 592 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xd3, 0x4c,
	0x10, 0xfe, 0xed, 0xfc, 0x0a, 0xea, 0xba, 0x48, 0xd5, 0xa2, 0x0a, 0x2b, 0x42, 0x22, 0x32, 0x1c,
	0xa2, 0xa8, 0x5a, 0x47, 0x21, 0x08, 0x35, 0xa5, 0x87, 0xe4, 0xd0, 0x94, 0x43, 0xa1, 0x38, 0xa8,
	0x07, 0x14, 0x29, 0xda, 0xc6, 0x53, 0x63, 0x35, 0xf6, 0x1a, 0xef, 0x3a, 0x97, 0xaa, 0x17, 0x0e,
	0x88, 0x23, 0x12, 0x6f, 0xc0, 0x0d, 0xde, 0x83, 0x0b, 0x57, 0xc4, 0x1b, 0xf0, 0x20, 0x68, 0xbd,
	0x5e, 0x37, 0x4d, 0x1b, 0x85, 0xf6, 0x36, 0x5e, 0x7f, 0xdf, 0x37, 0xb3, 0xdf, 0xcc, 0x2c, 0xda,
	0x0e, 0x18, 0x0b, 0xa6, 0xe0, 0x52, 0x9f, 0xbb, 0x2a, 0x94, 0xd1, 0xac, 0xe5, 0x72, 0x48, 0x67,
	0xe1, 0x04, 0xb8, 0xcb, 0xdf, 0xd1, 0x14, 0xfc, 0x31, 0x07, 0x31, 0x2e, 0xce, 0x48, 0x92, 0x32,
	0xc1, 0x70, 0x5d, 0xe1, 0x09, 0xf5, 0x39, 0x29, 0xa9, 0x64, 0xd6, 0x22, 0x9a, 0x5a, 0x6b, 0x2f,
	0x13, 0x4f, 0x81, 0xb3, 0x2c, 0xbd, 0xac, 0xae, 0x54, 0x6b, 0x0f, 0x34, 0x27, 0x09, 0x5d, 0x1a,
	0xc7, 0x4c, 0x50, 0x11, 0xb2, 0x98, 0x17, 0x7f, 0x8b, 0x9c, 0x6e, 0xfe, 0x75, 0x9c, 0x9d, 0xb8,
	0x27, 0x21, 0x4c, 0xfd, 0x71, 0x44, 0xf9, 0xa9, 0x42, 0x38, 0x5d, 0x74, 0x6f, 0x00, 0x62, 0x98,
	0xcb, 0x0e, 0x41, 0x78, 0xf0, 0x3e, 0x03, 0x2e, 0xf0, 0x23, 0x74, 0x57, 0x27, 0x1d, 0xc7, 0x34,
	0x02, 0xdb, 0xa8, 0x1b, 0x8d, 0x35, 0x6f, 0x5d, 0x1f, 0xbe, 0xa4, 0x11, 0x38, 0x9f, 0x0d, 0x74,
	0xff, 0x20, 0x13, 0x54, 0x40, 0xc9, 0xe7, 0x5a, 0xe0, 0x21, 0xb2, 0x26, 0x19, 0x17, 0x2c, 0x82,
	0x74, 0x1c, 0xfa, 0x05, 0x1d, 0xe9, 0xa3, 0x17, 0x3e, 0x7e, 0x83, 0x10, 0x4b, 0x20, 0x55, 0xe5,
	0xda, 0x66, 0xbd, 0xd2, 0xb0, 0xda, 0x1d, 0xb2, 0xca, 0x23, 0x52, 0x66, 0x7a, 0xa5, 0xc9, 0xde,
	0x9c, 0x8e, 0xf3, 0xc9, 0x44, 0xf8, 0x2a, 0x04, 0xef, 0x20, 0x2b, 0x4b, 0x7c, 0x2a, 0x20, 0xbf,
	0xba, 0xfd, 0x7f, 0xdd, 0x68, 0x58, 0xed, 0x9a, 0xce, 0xa6, 0xdd, 0x21, 0x7b, 0xd2, 0x9d, 0x03,
	0xca, 0x4f, 0x3d, 0xa4, 0xe0, 0x32, 0xc6, 0x7b, 0xa8, 0x3a, 0x49, 0x81, 0x0a, 0x65, 0x82, 0xd5,
	0xde, 0x5a, 0x5a, 0x65, 0xd9, 0xa7, 0x8b, 0x32, 0xf7, 0xff, 0xf3, 0x0a, 0xb6, 0xd4, 0x51, 0xaa,
	0xb6, 0x79, 0x3b, 0x1d, 0xc5, 0xc6, 0x36, 0xaa, 0xa6, 0x10, 0xb1, 0x19, 0xd8, 0x15, 0xe9, 0xaa,
	0xfc, 0xa3, 0xbe, 0xfb, 0x16, 0x5a, 0x2b, 0xbd, 0x70, 0x22, 0x64, 0x5f, 0x6d, 0x0e, 0x4f, 0x58,
	0xcc, 0x01, 0xbf, 0x46, 0x77, 0x52, 0xe0, 0xd9, 0x54, 0x68, 0xe7, 0x9f, 0xad, 0x76, 0x7e, 0x41,
	0xcc, 0xcb, 0xf9, 0x9e, 0xd6, 0x71, 0x9e, 0xa3, 0xcd, 0x6b, 0x11, 0xff, 0x34, 0x4a, 0xed, 0x8f,
	0x15, 0xb4, 0x51, 0x12, 0x87, 0x2a, 0x25, 0xfe, 0x66, 0xa0, 0xf5, 0xf9, 0xe1, 0xc4, 0x4f, 0x57,
	0x57, 0x79, 0xcd, 0x30, 0xd7, 0x6e, 0x64, 0xb4, 0xd3, 0xf9, 0xf0, 0xeb, 0xcf, 0x17, 0x93, 0xe0,
	0x2d, 0xb9, 0x79, 0x67, 0x97, 0x4a, 0xdf, 0xd5, 0xf3, 0xcb, 0xdd, 0x66, 0xb1, 0x8a, 0xd2, 0x56,
	0xb7, 0x79, 0x8e, 0x7f, 0x18, 0x68, 0x63, 0xd1, 0x6e, 0xbc, 0x7d, 0x63, 0x57, 0xf5, 0xfe, 0xd4,
	0xba, 0xb7, 0xa1, 0xaa, 0xee, 0x3a, 0xdd, 0xfc, 0x06, 0x1d, 0xc7, 0x95, 0x37, 0xb8, 0x28, 0xf9,
	0x6c, 0x6e, 0x21, 0x77, 0x9b, 0xe7, 0x73, 0x17, 0xe8, 0x46, 0xb9, 0x54, 0xd7, 0x68, 0xf6, 0x7f,
	0x1b, 0xe8, 0xf1, 0x84, 0x45, 0x2b, 0xb3, 0xf7, 0x37, 0x17, 0xdb, 0x75, 0x28, 0xb7, 0xe8, 0xd0,
	0x78, 0xbb, 0x5f, 0x50, 0x03, 0x36, 0xa5, 0x71, 0x40, 0x58, 0x1a, 0xb8, 0x01, 0xc4, 0xf9, 0x8e,
	0xe9, 0x57, 0x2d, 0x09, 0xf9, 0xf2, 0x17, 0x74, 0x47, 0x07, 0x5f, 0xcd, 0xca, 0xa0, 0xd7, 0xfb,
	0x6e, 0xd6, 0x07, 0x4a, 0xb0, 0xe7, 0x73, 0xa2, 0x42, 0x19, 0x1d, 0xb5, 0x48, 0x91, 0x98, 0xff,
	0xd4, 0x90, 0x51, 0xcf, 0xe7, 0xa3, 0x12, 0x32, 0x3a, 0x6a, 0x8d, 0x34, 0xe4, 0xb8, 0x9a, 0x17,
	0xf0, 0xe4, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0d, 0xd6, 0x84, 0x2a, 0xc1, 0x05, 0x00, 0x00,
}
