{- This module was generated from data in the Kate syntax
   highlighting file relaxngcompact.xml, version 1, by Rintze Zelle -}

module Text.Highlighting.Kate.Syntax.Relaxngcompact
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "RelaxNG-Compact"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.rnc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("RelaxNG-Compact","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("RelaxNG-Compact","Normal Text") -> return ()
      ("RelaxNG-Compact","Comments") -> (popContext) >> pEndLine
      ("RelaxNG-Compact","String") -> return ()
      ("RelaxNG-Compact","Node Names") -> (popContext) >> pEndLine
      ("RelaxNG-Compact","Definitions") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_Keywords = Set.fromList $ words $ "default datatypes div empty external grammar include inherit list mixed namespace notAllowed parent start token"
list_Node_Names = Set.fromList $ words $ "attribute element"
list_Datatypes = Set.fromList $ words $ "string text xsd:anyURI xsd:base64Binary xsd:boolean xsd:byte xsd:date xsd:dateTime xsd:decimal xsd:double xsd:duration xsd:ENTITIES xsd:ENTITY xsd:float xsd:gDay xsd:gMonth xsd:gMonthDay xsd:gYear xsd:gYearMonth xsd:hexBinary xsd:ID xsd:IDREF xsd:IDREFS xsd:int xsd:integer xsd:language xsd:long xsd:Name xsd:NCName xsd:negativeInteger xsd:NMTOKEN xsd:NMTOKENS xsd:nonNegativeInteger xsd:nonPositiveInteger xsd:normalizedString xsd:NOTATION xsd:positiveInteger xsd:QName xsd:short xsd:string xsd:time xsd:token xsd:unsignedByte xsd:unsignedInt xsd:unsignedLong xsd:unsignedShort"

regex_'5b'5cw'5c'2e'2d'5d'2b'5b'5cs'5d'2b'3d = compileRegex True "[\\w\\.-]+[\\s]+="

parseRules ("RelaxNG-Compact","Normal Text") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("RelaxNG-Compact","Comments"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("RelaxNG-Compact","String"))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Node_Names >>= withAttribute KeywordTok) >>~ pushContext ("RelaxNG-Compact","Node Names"))
   <|>
   ((pKeyword " \n\t.()!+,<=>%&*/;?[]^{|}~\\" list_Datatypes >>= withAttribute DataTypeTok))
   <|>
   ((lookAhead (pRegExpr regex_'5b'5cw'5c'2e'2d'5d'2b'5b'5cs'5d'2b'3d) >> pushContext ("RelaxNG-Compact","Definitions") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("RelaxNG-Compact","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("RelaxNG-Compact","Comments") =
  (currentContext >>= \x -> guard (x == ("RelaxNG-Compact","Comments")) >> pDefault >>= withAttribute CommentTok)

parseRules ("RelaxNG-Compact","String") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("RelaxNG-Compact","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("RelaxNG-Compact","Node Names") =
  (((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("RelaxNG-Compact","Node Names")) >> pDefault >>= withAttribute OtherTok))

parseRules ("RelaxNG-Compact","Definitions") =
  (((lookAhead (pDetectChar False '=') >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("RelaxNG-Compact","Definitions")) >> pDefault >>= withAttribute FunctionTok))


parseRules x = parseRules ("RelaxNG-Compact","Normal Text") <|> fail ("Unknown context" ++ show x)
