RabbitMQ `3.11.16` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25 and supports Erlang versions up to `25.3.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * [Automatic node removal](https://rabbitmq.com/cluster-formation.html#node-health-checks-and-cleanup) now will
   [remove quorum queue replicas](https://rabbitmq.com/quorum-queues.html#replica-management) from the node before removing it from the cluster.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#2882](https://github.com/rabbitmq/rabbitmq-server/issues/2882)

#### Enhancements

 * A new boolean setting, `quorum_queue.property_equivalence.relaxed_checks_on_redeclaration`,
   makes it possible to relax queue property equivalence checks
   for quorum queues. Specifically, when a quorum queue is redeclared and the client-provided
   type is set to "classic", this setting will help avoid a channel exception, making it
   easier to migrate to quorum queues step by step, without upgrading all applications in a short
   period of time.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#8076](https://github.com/rabbitmq/rabbitmq-server/issues/8076)


### CLI Tools

#### Enhancements

 * `rabbitmq-queues grow` and `rabbitmq-queues add_member` now verify cluster membership of the node
   new quorum queue replicas should be placed on.

   GitHub issue: [#8007](https://github.com/rabbitmq/rabbitmq-server/issues/8007)


### Federation Plugin

#### Bug Fixes

 * URI parser incorrectly used the `password` query parameter to override the password
   value in authority (user info) part.

   The `password` query parameter can be used to specify private key password for
   upstream connections that use TLS.

   GitHub issue: [#8129](https://github.com/rabbitmq/rabbitmq-server/issues/8129)


### Shovel Plugin

#### Bug Fixes

 * URI parser incorrectly used the `password` query parameter to override the password
   value in authority (user info) part.

   The `password` query parameter can be used to specify private key password for Shovels
   that use TLS.

   GitHub issue: [#8129](https://github.com/rabbitmq/rabbitmq-server/issues/8129)


## Dependency Upgrades

 * [`ra`](https://github.com/rabbitmq/ra) was upgraded [to `2.6.1`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.16.tar.xz`
instead of the source tarball produced by GitHub.
