/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package kotlin.collections

/**
 * Data class representing a value from a collection or sequence, along with its index in that collection or sequence.
 *
 * @property index the index of the value in the collection or sequence.
 * @property value the underlying value.
 */
public data class IndexedValue<out T>(public val index: Int, public val value: T)
