#!/usr/bin/env bash
# nbdkit
# tests/make-pki.sh.  Generated from make-pki.sh.in by configure.
# Copyright Red Hat
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# * Neither the name of Red Hat nor the names of its contributors may be
# used to endorse or promote products derived from this software without
# specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY RED HAT AND CONTRIBUTORS ''AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL RED HAT OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
# USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
# OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

set -e

# This creates the PKI files for the TLS tests.  However if certtool
# doesn't exist, just create an empty directory instead.
# See also: requires_tls_certificates in functions.sh.in

pkidir="$1"
test -n "$pkidir"

mkdir "$pkidir"

if ! certtool --help >/dev/null 2>&1; then
    echo "$0: certtool not found, TLS tests will be skipped."
    touch "$pkidir"/.stamp
    exit 0
fi

# Create the CA.
certtool --generate-privkey > "$pkidir"/ca-key.pem
chmod 0600 "$pkidir"/ca-key.pem

cat > "$pkidir"/ca.info <<EOF
cn = Test
ca
cert_signing_key
EOF
certtool --generate-self-signed \
           --load-privkey "$pkidir"/ca-key.pem \
           --template "$pkidir"/ca.info \
           --outfile "$pkidir"/ca-cert.pem

# Create the server certificate and key.
certtool --generate-privkey > "$pkidir"/server-key.pem
chmod 0600 "$pkidir"/server-key.pem

cat > "$pkidir"/server.info <<EOF
organization = Test
cn = localhost
dns_name = localhost
ip_address = 127.0.0.1
ip_address = ::1
tls_www_server
encryption_key
signing_key
EOF
certtool --generate-certificate \
           --load-ca-certificate "$pkidir"/ca-cert.pem \
           --load-ca-privkey "$pkidir"/ca-key.pem \
           --load-privkey "$pkidir"/server-key.pem \
           --template "$pkidir"/server.info \
           --outfile "$pkidir"/server-cert.pem

# Create a client certificate and key.
certtool --generate-privkey > "$pkidir"/client-key.pem
chmod 0600 "$pkidir"/client-key.pem

cat > "$pkidir"/client.info <<EOF
country = US
state = New York
locality = New York
organization = Test
cn = localhost
tls_www_client
encryption_key
signing_key
EOF
certtool --generate-certificate \
           --load-ca-certificate "$pkidir"/ca-cert.pem \
           --load-ca-privkey "$pkidir"/ca-key.pem \
           --load-privkey "$pkidir"/client-key.pem \
           --template "$pkidir"/client.info \
           --outfile "$pkidir"/client-cert.pem

# Finish off.
touch "$pkidir"/.stamp
