/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.httpClient.http.request.HttpRequestPlaceholderUtil;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.microservices.endpoints.EmbeddedHttpClientEditor;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.run.HttpRequestActionsProvider;
import com.intellij.httpClient.http.request.run.v2.HttpRequestRunLineMarkerV2ProviderKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestLineMarkerProvider
extends RunLineMarkerContributor
implements DumbAware {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        HttpRequest request;
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (HttpRequestRunLineMarkerV2ProviderKt.isV2RunLineMarkerPreferable()) {
            return null;
        }
        if (HttpRequestLineMarkerProvider.isHttpRequestRunElement(element) && (request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class)) != null) {
            if (!HttpRequestLineMarkerProvider.canBeExecuted(request)) {
                return null;
            }
            Project project = element.getProject();
            PsiFile containingFile = element.getContainingFile();
            HttpRequestEnvironment.clearDefaultIfInvalid(project, containingFile);
            List envs2 = ContainerUtil.packNullables((Object[])new String[]{HttpClientSelectedEnvironments.getInstance(project).get(containingFile.getVirtualFile())});
            HttpRequestActionsProvider.HttpRequestActionsProviderStrategy strategy = HttpRequestActionsProvider.getActionsProvider();
            HttpClientExecutionBlock parent = (HttpClientExecutionBlock)PsiTreeUtil.getParentOfType((PsiElement)element, HttpClientExecutionBlock.class);
            AnAction[] actions = strategy.provideActions(parent, envs2).toArray(AnAction.EMPTY_ARRAY);
            return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, actions, psiElement -> strategy.getTooltip());
        }
        return null;
    }

    public static boolean canBeExecuted(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return !EmbeddedHttpClientEditor.isInEmbeddedHttpClientEditor((PsiElement)request) && !HttpRequestPlaceholderUtil.containsPlaceholder(request);
    }

    @ApiStatus.Internal
    public static boolean isHttpRequestRunElement(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.REQUEST_METHOD)) {
            return true;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof HttpScheme) {
            HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)parent, HttpRequest.class);
            return request != null && request.getMethod() == null;
        }
        if (parent instanceof HttpHost && parent.getFirstChild() == element) {
            HttpRequestTarget requestTarget = (HttpRequestTarget)PsiTreeUtil.getParentOfType((PsiElement)parent, HttpRequestTarget.class);
            HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)requestTarget, HttpRequest.class);
            if (request == null || request.getMethod() != null) {
                return false;
            }
            return requestTarget.getFirstChild() == parent;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeExecuted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpRequestRunElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

