/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.javascript.structureView.JSSuperGroup;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class JSSuperGrouper
implements Grouper {
    @NonNls
    private static final String SHOW_CLASSES = "SHOW_CLASSES";

    JSSuperGrouper() {
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            JSSuperGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            JSSuperGrouper.$$$reportNull$$$0(1);
        }
        if (JSSuperGrouper.isParentGrouped(parent) || parent.getValue() instanceof CustomRegionTreeElement) {
            List<Group> list = Collections.emptyList();
            if (list == null) {
                JSSuperGrouper.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashMap<String, Group> groups = new HashMap<String, Group>();
        for (TreeElement _child : children) {
            JSQualifiedName ns;
            if (!(_child instanceof JSStructureViewElementBase)) continue;
            JSStructureViewElementBase child = (JSStructureViewElementBase)_child;
            PsiElement value = child.getValue();
            if (value instanceof JSVariable) {
                if (!child.isInherited()) continue;
                PsiElement parentElement = value.getParent();
                if (parentElement instanceof JSVarStatement) {
                    parentElement = parentElement.getParent();
                }
                if (parentElement instanceof JSClass) {
                    JSSuperGrouper.addGroup(groups, _child, ((JSClass)parentElement).getQualifiedName());
                    continue;
                }
            }
            if (!(value instanceof JSElementBase) || value instanceof JSFunctionItem && JSSuperGrouper.processFunction((JSStructureViewElementBase)((Object)parent.getValue()), groups, _child, value) || !child.isInherited() || (ns = ((JSElementBase)value).getNamespace()) == null) continue;
            JSSuperGrouper.addGroup(groups, _child, ns.getQualifiedName());
        }
        Collection<Group> collection = groups.values();
        if (collection == null) {
            JSSuperGrouper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static boolean processFunction(JSStructureViewElementBase parentElement, Map<String, Group> groups, TreeElement _child, PsiElement value) {
        PsiElement element2 = JSStructureViewElementBase.getPsiElement((StructureViewTreeElement)parentElement);
        if (element2 instanceof JSClass) {
            JSClass declaringClass;
            JSClass parentClass = (JSClass)element2;
            JSClass jSClass = declaringClass = value instanceof JSFunction ? JSInheritanceUtil.findSomeDeclaringClass((JSFunction)value) : null;
            if (parentClass != declaringClass && declaringClass != null) {
                JSSuperGrouper.addGroup(groups, _child, declaringClass.getQualifiedName());
                return true;
            }
        }
        return false;
    }

    private static void addGroup(Map<String, Group> groups, TreeElement _child, String qName) {
        JSSuperGroup group = (JSSuperGroup)groups.get(qName);
        if (group == null) {
            group = new JSSuperGroup(qName);
            groups.put(qName, group);
        }
        group.addChild(_child);
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.structureview.group.methods.by.defining.type", (Object[])new Object[0]), null, AllIcons.General.ImplementingMethod);
    }

    @NotNull
    public String getName() {
        return SHOW_CLASSES;
    }

    private static boolean isParentGrouped(AbstractTreeNode<?> parent) {
        while (parent != null) {
            if (parent.getValue() instanceof JSSuperGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSSuperGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSSuperGrouper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

