/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.specification.Openapi3PathsProvider;
import com.intellij.swagger.core.model.specification.Swagger2PathsProvider;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Callback;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Definition;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Example;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Header;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3RequestBody;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Response;
import com.intellij.swagger.core.refactoring.SwRefactoringUtilsKt;
import com.intellij.swagger.core.traverser.SpecificationTraverser;
import com.intellij.swagger.core.traverser.SpecificationTraverserFactory;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\"\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J+\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u00132\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001c\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0005H\u0002J\"\u0010*\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u00060"}, d2={"Lcom/intellij/swagger/core/intentions/SwExtractModelDeclarationIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "<init>", "()V", "getText", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "introduceModelDeclaration", "modelElement", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "suggestedModelData", "Lcom/intellij/swagger/core/intentions/SwExtractModelDeclarationIntention$SuggestedModelData;", "sourcePsi", "replaceInlinedDeclarationWithReference", "suggestModelPath", "swModelElement", "findOrCreateContainerNode", "pathSegments", "", "(Lcom/intellij/swagger/core/model/api/SwModelElement;[Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "findSuitableModelElements", "Lkotlin/sequences/Sequence;", "psiElement", "renameIntroducedModel", "keyElement", "createDeclarationNode", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "name", "childMapping", "createValue", "Lorg/jetbrains/yaml/psi/YAMLValue;", "value", "createNodeWithName", "createEol", "createIndent", "size", "", "SuggestedModelData", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwExtractModelDeclarationIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwExtractModelDeclarationIntention.kt\ncom/intellij/swagger/core/intentions/SwExtractModelDeclarationIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,134:1\n67#2:135\n66#2,2:143\n19#3:136\n19#3:141\n1#4:137\n13010#5,3:138\n13013#5:142\n*S KotlinDebug\n*F\n+ 1 SwExtractModelDeclarationIntention.kt\ncom/intellij/swagger/core/intentions/SwExtractModelDeclarationIntention\n*L\n46#1:135\n114#1:143,2\n60#1:136\n92#1:141\n90#1:138,3\n90#1:142\n*E\n"})
public final class SwExtractModelDeclarationIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        return SwaggerBundle.message("intention.extract.model.declaration.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return SwaggerBundle.message("intention.extract.model.declaration.name", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SwModelElement swModelElement = (SwModelElement)SequencesKt.firstOrNull(this.findSuitableModelElements(element));
        PsiElement it = swModelElement != null ? swModelElement.getSourcePsi() : null;
        boolean bl = false;
        if (!(it instanceof YAMLMapping)) return false;
        String string = ((YAMLMapping)it).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.startsWith$default((String)string, (String)"$ref", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiElement psiElement;
        SwModelElement modelElement;
        block8: {
            block7: {
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (editor == null) {
                    return;
                }
                SwModelElement swModelElement = (SwModelElement)SequencesKt.firstOrNull(this.findSuitableModelElements(element));
                if (swModelElement == null) {
                    return;
                }
                modelElement = swModelElement;
                psiElement = modelElement.getSourcePsi();
                if (psiElement == null) break block7;
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                psiElement = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLMapping.class, (boolean)false);
                if (psiElement != null) break block8;
            }
            return;
        }
        PsiElement sourcePsi = psiElement;
        SuggestedModelData suggestedModelData = this.suggestModelPath(modelElement);
        if (suggestedModelData == null) {
            return;
        }
        SuggestedModelData suggestedModelData2 = suggestedModelData;
        PsiElement psiElement3 = this.introduceModelDeclaration(modelElement, suggestedModelData2, sourcePsi);
        if (psiElement3 == null) {
            return;
        }
        PsiElement actualDeclarationKey = psiElement3;
        this.replaceInlinedDeclarationWithReference(suggestedModelData2, sourcePsi);
        this.renameIntroducedModel(actualDeclarationKey, editor);
    }

    private final PsiElement introduceModelDeclaration(SwModelElement modelElement, SuggestedModelData suggestedModelData, PsiElement sourcePsi) {
        Object object;
        String[] stringArray = suggestedModelData.getPath();
        PsiElement psiElement = this.findOrCreateContainerNode(modelElement, Arrays.copyOf(stringArray, stringArray.length));
        if (psiElement != null) {
            PsiElement $this$introduceModelDeclaration_u24lambda_u241 = psiElement;
            boolean bl = false;
            Project project = $this$introduceModelDeclaration_u24lambda_u241.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            $this$introduceModelDeclaration_u24lambda_u241.add(this.createEol(project));
            PsiElement $this$asSafely$iv = $this$introduceModelDeclaration_u24lambda_u241.add((PsiElement)this.createDeclarationNode(suggestedModelData.getName(), sourcePsi));
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof YAMLKeyValue)) {
                psiElement2 = null;
            }
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)psiElement2;
            object = yAMLKeyValue != null ? yAMLKeyValue.getKey() : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void replaceInlinedDeclarationWithReference(SuggestedModelData suggestedModelData, PsiElement sourcePsi) {
        String it = ArraysKt.joinToString$default((Object[])ArraysKt.plus((Object[])suggestedModelData.getPath(), (Object)suggestedModelData.getName()), (CharSequence)"/", (CharSequence)"#/", null, (int)0, null, null, (int)60, null);
        boolean bl = false;
        String referenceText = "$ref: '" + it + "'";
        Project project = sourcePsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        sourcePsi.replace((PsiElement)this.createValue(project, referenceText));
    }

    private final SuggestedModelData suggestModelPath(SwModelElement swModelElement) {
        SuggestedModelData suggestedModelData;
        SwModelElement swModelElement2 = swModelElement;
        if (swModelElement2 instanceof Openapi3RequestBody) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getREQUEST_BODIES()};
            SuggestedModelData suggestedModelData2 = new SuggestedModelData("RequestBody", stringArray);
            suggestedModelData = suggestedModelData2;
        } else if (swModelElement2 instanceof Openapi3Response) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getRESPONSES()};
            SuggestedModelData suggestedModelData3 = new SuggestedModelData("Response", stringArray);
            suggestedModelData = suggestedModelData3;
        } else if (swModelElement2 instanceof Openapi3Definition) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getOBJECT_DEFINITIONS()};
            SuggestedModelData suggestedModelData4 = new SuggestedModelData("Schema", stringArray);
            suggestedModelData = suggestedModelData4;
        } else if (swModelElement2 instanceof Openapi3Callback) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getCALLBACKS()};
            SuggestedModelData suggestedModelData5 = new SuggestedModelData("Callback", stringArray);
            suggestedModelData = suggestedModelData5;
        } else if (swModelElement2 instanceof Openapi3Header) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getHEADERS()};
            SuggestedModelData suggestedModelData6 = new SuggestedModelData("Header", stringArray);
            suggestedModelData = suggestedModelData6;
        } else if (swModelElement2 instanceof Openapi3Example) {
            String[] stringArray = new String[]{Openapi3PathsProvider.INSTANCE.getCOMPONENTS(), Openapi3PathsProvider.INSTANCE.getEXAMPLES()};
            SuggestedModelData suggestedModelData7 = new SuggestedModelData("Example", stringArray);
            suggestedModelData = suggestedModelData7;
        } else if (swModelElement2 instanceof SwDefinition) {
            String[] stringArray = new String[]{Swagger2PathsProvider.INSTANCE.getOBJECT_DEFINITIONS()};
            SuggestedModelData suggestedModelData8 = new SuggestedModelData("Definition", stringArray);
            suggestedModelData = suggestedModelData8;
        } else {
            suggestedModelData = null;
        }
        return suggestedModelData;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findOrCreateContainerNode(SwModelElement swModelElement, String ... pathSegments) {
        void $this$foldIndexed$iv;
        PsiElement psiElement = swModelElement.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return null;
        }
        PsiElement containingFile = psiElement;
        FileType fileType = containingFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        SpecificationTraverser specificationTraverser = SpecificationTraverserFactory.INSTANCE.getTraverserFor(fileType);
        if (specificationTraverser == null) {
            return null;
        }
        SpecificationTraverser traverser = specificationTraverser;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String[] stringArray = pathSegments;
        PsiElement initial$iv = containingFile;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        PsiElement accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void currentNode;
            void pathSegment;
            int n = index$iv++;
            void var14_14 = element$iv;
            PsiElement psiElement2 = accumulator$iv;
            int depth = n;
            boolean bl = false;
            String[] stringArray2 = new String[]{pathSegment};
            PsiElement psiElement3 = traverser.findByPath((PsiElement)currentNode, stringArray2);
            if (psiElement3 == null) {
                SwExtractModelDeclarationIntention $this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244 = this;
                boolean bl2 = false;
                void $this$asSafely$iv = currentNode;
                boolean $i$f$asSafely = false;
                Object v6 = $this$asSafely$iv;
                if (!(v6 instanceof PsiFile)) {
                    v6 = null;
                }
                PsiFile p0 = v6;
                boolean bl3 = false;
                PsiElement $this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244_u24lambda_u243 = (PsiElement)SwaggerUtilsKt.or(traverser.getTopLevelValueOf(p0), currentNode);
                boolean bl4 = false;
                $this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244_u24lambda_u243.add($this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244.createEol(project2));
                $this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244_u24lambda_u243.add($this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244.createIndent(project2, depth));
                PsiElement psiElement4 = $this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244_u24lambda_u243.add((PsiElement)SwExtractModelDeclarationIntention.createNodeWithName$default($this$findOrCreateContainerNode_u24lambda_u245_u24lambda_u244, project2, (String)pathSegment, null, 4, null));
                psiElement3 = psiElement4;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"run(...)");
            }
            accumulator$iv = psiElement3;
        }
        return accumulator$iv;
    }

    private final Sequence<SwModelElement> findSuitableModelElements(PsiElement psiElement) {
        Class[] classArray = new Class[]{SwDefinition.class, Openapi3Definition.class, Openapi3Callback.class, Openapi3RequestBody.class, Openapi3Header.class, Openapi3Example.class};
        return SwTreeUtil.INSTANCE.getParentsOfTypes(psiElement, classArray);
    }

    private final void renameIntroducedModel(PsiElement keyElement, Editor editor) {
        PsiElement psiElement;
        PsiElement psiElement2 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)keyElement);
        if (psiElement2 == null) {
            return;
        }
        PsiElement $this$parentOfType_u24default$iv = psiElement = psiElement2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLKeyValue.class, (boolean)true);
        Intrinsics.checkNotNull((Object)psiElement3);
        YAMLKeyValue reformattedKey = (YAMLKeyValue)psiElement3;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ActionsKt.invokeLater$default(null, () -> SwExtractModelDeclarationIntention.renameIntroducedModel$lambda$6(reformattedKey, editor), (int)1, null);
    }

    private final YAMLKeyValue createDeclarationNode(String name2, PsiElement childMapping) {
        Project project = childMapping.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.createNodeWithName(project, name2, SwRefactoringUtilsKt.getIndent(childMapping) + childMapping.getText());
    }

    private final YAMLValue createValue(Project project, String value) {
        YAMLValue yAMLValue = this.createNodeWithName(project, "nobodyShouldSeeIt", value).getValue();
        Intrinsics.checkNotNull((Object)yAMLValue);
        return yAMLValue;
    }

    private final YAMLKeyValue createNodeWithName(Project project, String name2, String value) {
        YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance((Project)project).createYamlKeyValue(name2, value);
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
        return yAMLKeyValue;
    }

    static /* synthetic */ YAMLKeyValue createNodeWithName$default(SwExtractModelDeclarationIntention swExtractModelDeclarationIntention, Project project, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return swExtractModelDeclarationIntention.createNodeWithName(project, string, string2);
    }

    private final PsiElement createEol(Project project) {
        PsiElement psiElement = YAMLElementGenerator.getInstance((Project)project).createEol();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createEol(...)");
        return psiElement;
    }

    private final PsiElement createIndent(Project project, int size) {
        PsiElement psiElement = YAMLElementGenerator.getInstance((Project)project).createIndent(size);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createIndent(...)");
        return psiElement;
    }

    private static final Unit renameIntroducedModel$lambda$6(YAMLKeyValue $reformattedKey, Editor $editor) {
        new RenameDialog($reformattedKey.getProject(), (PsiElement)$reformattedKey, null, $editor).show();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B$\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/swagger/core/intentions/SwExtractModelDeclarationIntention$SuggestedModelData;", "", "name", "", "path", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;[Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "intellij.swagger.core"})
    private static final class SuggestedModelData {
        @NotNull
        private final String name;
        @NotNull
        private final String[] path;

        public SuggestedModelData(@NlsSafe @NotNull String name2, @NotNull String[] path) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.name = name2;
            this.path = path;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String[] getPath() {
            return this.path;
        }
    }
}

