/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.PyIntroduceDialog;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;

public final class PyIntroduceHandlerUi {
    public static void performInplaceIntroduceVariable(IntroduceOperation operation, PsiElement statement) {
        if (statement instanceof PyAssignmentStatement) {
            PyTargetExpression target = (PyTargetExpression)((PyAssignmentStatement)statement).getTargets()[0];
            List<PsiElement> occurrences = operation.getOccurrences();
            PsiElement occurrence = IntroduceHandler.findOccurrenceUnderCaret(occurrences, operation.getEditor());
            PsiElement elementForCaret = occurrence != null ? occurrence : target;
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
            PyInplaceVariableIntroducer introducer = new PyInplaceVariableIntroducer(target, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet<String>(operation.getSuggestedNames()));
        }
    }

    public static void performIntroduceWithDialog(IntroduceOperation operation, @NlsContexts.DialogTitle String dialogTitle, IntroduceValidator validator, String id, Consumer<? super IntroduceOperation> performRefactoringCallback) {
        Project project = operation.getProject();
        if (operation.getName() == null) {
            PyIntroduceDialog dialog2 = new PyIntroduceDialog(project, dialogTitle, validator, id, operation);
            if (!dialog2.showAndGet()) {
                return;
            }
            operation.setName(dialog2.getName());
            operation.setReplaceAll(dialog2.doReplaceAllOccurrences());
            operation.setInitPlace(dialog2.getInitPlace());
        }
        performRefactoringCallback.accept(operation);
    }

    private static class PyInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyTargetExpression myTarget;

        PyInplaceVariableIntroducer(PyTargetExpression target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), PyBundle.message("python.introduce.variable.refactoring.name", new Object[0]), occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }
    }
}

