/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.codeInsight.RelationMethodInfo;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoClassMembersProvider
extends PyClassMembersProviderBase {
    @NotNull
    public Collection<PyCustomMember> getMembers(PyClassType classType, PsiElement location, @NotNull TypeEvalContext context) {
        PyClass clazz;
        if (context == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(0);
        }
        if (!DjangoFacet.isInProject((PsiElement)(clazz = classType.getPyClass()))) {
            List<PyCustomMember> list = Collections.emptyList();
            if (list == null) {
                DjangoClassMembersProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        String name = clazz.getQualifiedName();
        if (name == null) {
            List<PyCustomMember> list = Collections.emptyList();
            if (list == null) {
                DjangoClassMembersProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (name.equals("django.conf.LazySettings")) {
            Collection collection = DjangoSettingsPy.getSettingsMembers((Project)clazz.getProject());
            if (collection == null) {
                DjangoClassMembersProvider.$$$reportNull$$$0(3);
            }
            return collection;
        }
        PyCallExpression foreignKeyInitCall = (PyCallExpression)classType.getUserData(DjangoTypeProvider.RELATED_KEY);
        if (foreignKeyInitCall != null) {
            return DjangoClassMembersProvider.getRelatedManagerMembers(foreignKeyInitCall);
        }
        DjangoModel model = DjangoModel.createFromClass((PyClass)clazz, (TypeEvalContext)context);
        if (model != null) {
            Collection collection = classType.isDefinition() ? DjangoModel.getClassMembers() : model.getInstanceMembers(context);
            if (collection == null) {
                DjangoClassMembersProvider.$$$reportNull$$$0(4);
            }
            return collection;
        }
        List<PyCustomMember> list = Collections.emptyList();
        if (list == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public static RelationMethodInfo getRelatedMethodsInfo(@NotNull PyType classType) {
        PyCallExpression relationExpression;
        if (classType == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(6);
        }
        if ((relationExpression = (PyCallExpression)PyTypeUtil.findData((PyType)classType, (Key)DjangoTypeProvider.RELATED_KEY)) == null) {
            return null;
        }
        return DjangoClassMembersProvider.getRelatedMethodsInfo(relationExpression);
    }

    public static boolean isMethodMayBeRelated(@NotNull String methodName) {
        if (methodName == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(7);
        }
        for (MethodsDependsOnRelation value : MethodsDependsOnRelation.values()) {
            if (!value.toString().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<PyCustomMember> getRelatedManagerMembers(@NotNull PyCallExpression foreignKeyInitCall) {
        if (foreignKeyInitCall == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(8);
        }
        ArrayList<PyCustomMember> result = new ArrayList<PyCustomMember>();
        RelationMethodInfo names = DjangoClassMembersProvider.getRelatedMethodsInfo(foreignKeyInitCall);
        boolean manyToMany = DjangoClassMembersProvider.isManyToMany(foreignKeyInitCall);
        for (String methodName : names.getExistingMethods()) {
            PyCustomMember member = manyToMany ? DjangoClassMembersProvider.createManyRelatedManagerMethodMember(methodName) : DjangoClassMembersProvider.createRelatedManagerMethodMember(methodName);
            result.add(member);
        }
        ArrayList<PyCustomMember> arrayList = result;
        if (arrayList == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    static RelationMethodInfo getRelatedMethodsInfo(@NotNull PyCallExpression foreignKeyInitCall) {
        if (foreignKeyInitCall == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(10);
        }
        ArrayList<String> allowed = new ArrayList<String>();
        ArrayList<String> notAllowed = new ArrayList<String>();
        ArrayList<String> nonExistence = new ArrayList<String>();
        if (DjangoClassMembersProvider.isManyToMany(foreignKeyInitCall)) {
            allowed.add(MethodsDependsOnRelation.CLEAR.toString());
            boolean intermediate = DjangoClassMembersProvider.isThroughIntermediate(foreignKeyInitCall);
            (intermediate ? notAllowed : allowed).add(MethodsDependsOnRelation.ADD.toString());
            (intermediate ? notAllowed : allowed).add(MethodsDependsOnRelation.CREATE.toString());
            allowed.add(MethodsDependsOnRelation.THROUGH.toString());
            allowed.add(MethodsDependsOnRelation.REMOVE.toString());
        } else {
            allowed.add(MethodsDependsOnRelation.ADD.toString());
            allowed.add(MethodsDependsOnRelation.CREATE.toString());
            allowed.add(MethodsDependsOnRelation.GET_OR_CREATE.toString());
            boolean nullable = DjangoClassMembersProvider.isNullable(foreignKeyInitCall);
            (nullable ? allowed : nonExistence).add(MethodsDependsOnRelation.REMOVE.toString());
            (nullable ? allowed : nonExistence).add(MethodsDependsOnRelation.CLEAR.toString());
        }
        return new RelationMethodInfo(allowed, notAllowed, nonExistence);
    }

    private static boolean isThroughIntermediate(PyCallExpression call) {
        PyExpression keywordArgument = DjangoClassMembersProvider.getIntermediateExpression(call);
        return keywordArgument != null;
    }

    @Nullable
    public static PyExpression getIntermediateExpression(@NotNull PyCallExpression call) {
        if (call == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(11);
        }
        return (PyExpression)call.getArgument((FunctionParameter)DjangoFunctionParams.MANY_TO_MANY_THROUGH, PyExpression.class);
    }

    private static boolean isManyToMany(@NotNull PyCallExpression call) {
        if (call == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(12);
        }
        return PyCallExpressionExtKt.isCalleeName((PyCallExpression)call, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.RELATION_MANY_TO_MANY_KEY});
    }

    private static boolean isNullable(PyCallExpression foreignKeyInitCall) {
        PyExpression keywordArgument = foreignKeyInitCall.getKeywordArgument("null");
        return keywordArgument != null && "True".equals(keywordArgument.getText());
    }

    private static PyCustomMember createRelatedManagerMethodMember(String name) {
        return new PyCustomMember(name).resolvesTo("django.db.models.fields.related").toClass("ForeignRelatedObjectsDescriptor").toClass("RelatedManager").toFunctionRecursive(name);
    }

    private static PyCustomMember createManyRelatedManagerMethodMember(String name) {
        return new PyCustomMember(name).resolvesTo("django.db.models.fields.related").toFunction("create_many_related_manager").toClass("ManyRelatedManager").toFunctionRecursive(name);
    }

    @Nullable
    public PsiElement resolveMember(@NotNull PyClassType type, @NotNull String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (type == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(13);
        }
        if (name == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(14);
        }
        if (resolveContext == null) {
            DjangoClassMembersProvider.$$$reportNull$$$0(15);
        }
        PyClass clazz = type.getPyClass();
        PyPsiUtils.assertValid((PsiElement)clazz);
        if (!clazz.isValid() || !DjangoFacet.isInProject((PsiElement)clazz)) {
            return null;
        }
        if ("django.conf.LazySettings".equals(clazz.getQualifiedName())) {
            return DjangoSettingsPy.resolveSettingsMember((PsiElement)clazz, (String)name, (PyResolveContext)resolveContext);
        }
        PyCallExpression foreignKeyInitCall = (PyCallExpression)type.getUserData(DjangoTypeProvider.RELATED_KEY);
        if (foreignKeyInitCall != null) {
            Collection<PyCustomMember> members = DjangoClassMembersProvider.getRelatedManagerMembers(foreignKeyInitCall);
            return PyClassMembersProviderBase.resolveMemberByName(members, (String)name, (PsiElement)type.getPyClass(), (PyResolveContext)resolveContext);
        }
        DjangoModel model = DjangoModel.createFromClass((PyClass)clazz, (TypeEvalContext)resolveContext.getTypeEvalContext());
        if (model != null) {
            return type.isDefinition() ? model.resolveClassMember(name, resolveContext) : model.resolveInstanceMember(name, resolveContext);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/codeInsight/DjangoClassMembersProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreignKeyInitCall";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/codeInsight/DjangoClassMembersProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedManagerMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedMethodsInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMethodMayBeRelated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedManagerMembers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIntermediateExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isManyToMany";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    private static enum MethodsDependsOnRelation {
        CLEAR,
        ADD,
        REMOVE,
        CREATE,
        THROUGH,
        GET_OR_CREATE;


        public String toString() {
            return StringUtil.toLowerCase((String)super.toString());
        }
    }
}

