/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.surround;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public final class DjangoSurroundUtil {
    private DjangoSurroundUtil() {
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> findSurroundCandidates(PsiFile file, int startOffset, int endOffset) {
        PsiElement element;
        PsiElement first = file.getViewProvider().findElementAt(startOffset);
        PsiElement last = file.getViewProvider().findElementAt(endOffset - 1);
        if (first == null || last == null) {
            Pair pair = Pair.create((Object)first, (Object)last);
            if (pair == null) {
                DjangoSurroundUtil.$$$reportNull$$$0(0);
            }
            return pair;
        }
        while (DjangoSurroundUtil.isWhitespace(first) && (element = file.findElementAt(startOffset = first.getTextRange().getEndOffset())) != null) {
            first = element;
        }
        while (DjangoSurroundUtil.isWhitespace(last) && (element = file.findElementAt((endOffset = last.getTextRange().getStartOffset()) - 1)) != null) {
            last = element;
        }
        Pair pair = Pair.create((Object)first, (Object)last);
        if (pair == null) {
            DjangoSurroundUtil.$$$reportNull$$$0(1);
        }
        return pair;
    }

    static boolean isWhitespace(PsiElement element) {
        return element instanceof PsiWhiteSpace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/django/lang/template/surround/DjangoSurroundUtil", "findSurroundCandidates"));
    }
}

