/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.configuration;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.configuration.PreferredAssumptionException;
import org.assertj.core.description.Description;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;

public class Configuration {
    public static final int MAX_LENGTH_FOR_SINGLE_LINE_DESCRIPTION = 80;
    public static final int MAX_ELEMENTS_FOR_PRINTING = 1000;
    public static final int MAX_INDICES_FOR_PRINTING = 50;
    public static final boolean REMOVE_ASSERTJ_RELATED_ELEMENTS_FROM_STACK_TRACE = true;
    public static final boolean ALLOW_COMPARING_PRIVATE_FIELDS = true;
    public static final boolean ALLOW_EXTRACTING_PRIVATE_FIELDS = true;
    public static final boolean BARE_NAME_PROPERTY_EXTRACTION_ENABLED = true;
    public static final boolean LENIENT_DATE_PARSING = false;
    public static final boolean PRINT_ASSERTIONS_DESCRIPTION_ENABLED = false;
    public static final int MAX_STACKTRACE_ELEMENTS_DISPLAYED = 3;
    public static final PreferredAssumptionException PREFERRED_ASSUMPTION_EXCEPTION = PreferredAssumptionException.AUTO_DETECT;
    public static final Configuration DEFAULT_CONFIGURATION = new Configuration();
    private boolean comparingPrivateFields;
    private boolean extractingPrivateFields;
    private boolean bareNamePropertyExtraction;
    private boolean removeAssertJRelatedElementsFromStackTrace;
    private boolean lenientDateParsing;
    private List<DateFormat> additionalDateFormats;
    private int maxLengthForSingleLineDescription;
    private int maxElementsForPrinting;
    private boolean printAssertionsDescription;
    private Consumer<Description> descriptionConsumer;
    private int maxStackTraceElementsDisplayed;
    private PreferredAssumptionException preferredAssumptionException;

    public Configuration() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.comparingPrivateFields = true;
        this.extractingPrivateFields = true;
        this.bareNamePropertyExtraction = true;
        this.removeAssertJRelatedElementsFromStackTrace = true;
        this.lenientDateParsing = false;
        this.additionalDateFormats = Collections.emptyList();
        this.maxLengthForSingleLineDescription = 80;
        this.maxElementsForPrinting = 1000;
        this.printAssertionsDescription = false;
        this.descriptionConsumer = null;
        this.maxStackTraceElementsDisplayed = 3;
        this.preferredAssumptionException = PREFERRED_ASSUMPTION_EXCEPTION;
    }

    public Representation representation() {
        return StandardRepresentation.STANDARD_REPRESENTATION;
    }

    boolean hasCustomRepresentation() {
        return this.representation() != StandardRepresentation.STANDARD_REPRESENTATION;
    }

    public boolean comparingPrivateFieldsEnabled() {
        return this.comparingPrivateFields;
    }

    public void setComparingPrivateFields(boolean comparingPrivateFields) {
        this.comparingPrivateFields = comparingPrivateFields;
    }

    public boolean extractingPrivateFieldsEnabled() {
        return this.extractingPrivateFields;
    }

    public void setExtractingPrivateFields(boolean extractingPrivateFields) {
        this.extractingPrivateFields = extractingPrivateFields;
    }

    public boolean bareNamePropertyExtractionEnabled() {
        return this.bareNamePropertyExtraction;
    }

    public void setBareNamePropertyExtraction(boolean bareNamePropertyExtraction) {
        this.bareNamePropertyExtraction = bareNamePropertyExtraction;
    }

    public boolean removeAssertJRelatedElementsFromStackTraceEnabled() {
        return this.removeAssertJRelatedElementsFromStackTrace;
    }

    public void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        this.removeAssertJRelatedElementsFromStackTrace = removeAssertJRelatedElementsFromStackTrace;
    }

    public boolean lenientDateParsingEnabled() {
        return this.lenientDateParsing;
    }

    public void setLenientDateParsing(boolean lenientDateParsing) {
        this.lenientDateParsing = lenientDateParsing;
    }

    public List<DateFormat> additionalDateFormats() {
        return this.additionalDateFormats;
    }

    public void setAdditionalDateFormats(List<DateFormat> additionalDateFormats) {
        this.additionalDateFormats = additionalDateFormats;
    }

    public void addAdditionalDateFormats(DateFormat ... additionalDateFormats) {
        Stream.of(additionalDateFormats).forEach(this.additionalDateFormats::add);
    }

    public int maxLengthForSingleLineDescription() {
        return this.maxLengthForSingleLineDescription;
    }

    public void setMaxLengthForSingleLineDescription(int maxLengthForSingleLineDescription) {
        this.maxLengthForSingleLineDescription = maxLengthForSingleLineDescription;
    }

    public int maxElementsForPrinting() {
        return this.maxElementsForPrinting;
    }

    public void setMaxElementsForPrinting(int maxElementsForPrinting) {
        this.maxElementsForPrinting = maxElementsForPrinting;
    }

    public boolean printAssertionsDescription() {
        return this.printAssertionsDescription;
    }

    public void setPrintAssertionsDescriptionEnabled(boolean printAssertionsDescription) {
        this.printAssertionsDescription = printAssertionsDescription;
    }

    public Consumer<Description> descriptionConsumer() {
        return this.descriptionConsumer;
    }

    public void setDescriptionConsumer(Consumer<Description> descriptionConsumer) {
        this.descriptionConsumer = descriptionConsumer;
    }

    public int maxStackTraceElementsDisplayed() {
        return this.maxStackTraceElementsDisplayed;
    }

    public void setMaxStackTraceElementsDisplayed(int maxStackTraceElementsDisplayed) {
        this.maxStackTraceElementsDisplayed = maxStackTraceElementsDisplayed;
    }

    public PreferredAssumptionException preferredAssumptionException() {
        return this.preferredAssumptionException;
    }

    public void setPreferredAssumptionException(PreferredAssumptionException preferredAssumptionException) {
        this.preferredAssumptionException = preferredAssumptionException;
    }

    public void apply() {
        Assertions.setAllowComparingPrivateFields(this.comparingPrivateFieldsEnabled());
        Assertions.setAllowExtractingPrivateFields(this.extractingPrivateFieldsEnabled());
        Assertions.setExtractBareNamePropertyMethods(this.bareNamePropertyExtractionEnabled());
        Assertions.setLenientDateParsing(this.lenientDateParsingEnabled());
        Assertions.setMaxElementsForPrinting(this.maxElementsForPrinting());
        Assertions.setMaxLengthForSingleLineDescription(this.maxLengthForSingleLineDescription());
        Assertions.setRemoveAssertJRelatedElementsFromStackTrace(this.removeAssertJRelatedElementsFromStackTraceEnabled());
        Assertions.useRepresentation(this.representation());
        Assertions.setDescriptionConsumer(this.descriptionConsumer());
        Assertions.setPrintAssertionsDescription(this.printAssertionsDescription());
        Assertions.setMaxStackTraceElementsDisplayed(this.maxStackTraceElementsDisplayed());
        AbstractDateAssert.useDefaultDateFormatsOnly();
        this.additionalDateFormats().forEach(Assertions::registerCustomDateFormat);
        Assumptions.setPreferredAssumptionException(this.preferredAssumptionException());
    }

    public void applyAndDisplay() {
        this.apply();
        System.out.println(this.describe());
    }

    public String describe() {
        return String.format("Applying configuration %s%n- representation .................................. = %s%n- comparingPrivateFieldsEnabled ................... = %s%n- extractingPrivateFieldsEnabled .................. = %s%n- bareNamePropertyExtractionEnabled ............... = %s%n- lenientDateParsingEnabled ....................... = %s%n- additional date formats ......................... = %s%n- maxLengthForSingleLineDescription ............... = %s%n- maxElementsForPrinting .......................... = %s%n- maxStackTraceElementsDisplayed................... = %s%n- printAssertionsDescription ...................... = %s%n- descriptionConsumer ............................. = %s%n- removeAssertJRelatedElementsFromStackTraceEnabled = %s%n- preferredAssumptionException .................... = %s%n", new Object[]{this.getClass().getName(), this.representation(), this.comparingPrivateFieldsEnabled(), this.extractingPrivateFieldsEnabled(), this.bareNamePropertyExtractionEnabled(), this.lenientDateParsingEnabled(), this.describeAdditionalDateFormats(), this.maxLengthForSingleLineDescription(), this.maxElementsForPrinting(), this.maxStackTraceElementsDisplayed(), this.printAssertionsDescription(), this.descriptionConsumer(), this.removeAssertJRelatedElementsFromStackTraceEnabled(), this.preferredAssumptionException()});
    }

    private String describeAdditionalDateFormats() {
        return this.additionalDateFormats().stream().map(this::describe).collect(Collectors.toList()).toString();
    }

    private String describe(DateFormat dateFormat) {
        return dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
    }
}

