// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package workspaceswebiface provides an interface to enable mocking the Amazon WorkSpaces Web service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package workspaceswebiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/workspacesweb"
)

// WorkSpacesWebAPI provides an interface to enable mocking the
// workspacesweb.WorkSpacesWeb service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon WorkSpaces Web.
//    func myFunc(svc workspaceswebiface.WorkSpacesWebAPI) bool {
//        // Make svc.AssociateBrowserSettings request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := workspacesweb.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockWorkSpacesWebClient struct {
//        workspaceswebiface.WorkSpacesWebAPI
//    }
//    func (m *mockWorkSpacesWebClient) AssociateBrowserSettings(input *workspacesweb.AssociateBrowserSettingsInput) (*workspacesweb.AssociateBrowserSettingsOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockWorkSpacesWebClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type WorkSpacesWebAPI interface {
	AssociateBrowserSettings(*workspacesweb.AssociateBrowserSettingsInput) (*workspacesweb.AssociateBrowserSettingsOutput, error)
	AssociateBrowserSettingsWithContext(aws.Context, *workspacesweb.AssociateBrowserSettingsInput, ...request.Option) (*workspacesweb.AssociateBrowserSettingsOutput, error)
	AssociateBrowserSettingsRequest(*workspacesweb.AssociateBrowserSettingsInput) (*request.Request, *workspacesweb.AssociateBrowserSettingsOutput)

	AssociateNetworkSettings(*workspacesweb.AssociateNetworkSettingsInput) (*workspacesweb.AssociateNetworkSettingsOutput, error)
	AssociateNetworkSettingsWithContext(aws.Context, *workspacesweb.AssociateNetworkSettingsInput, ...request.Option) (*workspacesweb.AssociateNetworkSettingsOutput, error)
	AssociateNetworkSettingsRequest(*workspacesweb.AssociateNetworkSettingsInput) (*request.Request, *workspacesweb.AssociateNetworkSettingsOutput)

	AssociateTrustStore(*workspacesweb.AssociateTrustStoreInput) (*workspacesweb.AssociateTrustStoreOutput, error)
	AssociateTrustStoreWithContext(aws.Context, *workspacesweb.AssociateTrustStoreInput, ...request.Option) (*workspacesweb.AssociateTrustStoreOutput, error)
	AssociateTrustStoreRequest(*workspacesweb.AssociateTrustStoreInput) (*request.Request, *workspacesweb.AssociateTrustStoreOutput)

	AssociateUserSettings(*workspacesweb.AssociateUserSettingsInput) (*workspacesweb.AssociateUserSettingsOutput, error)
	AssociateUserSettingsWithContext(aws.Context, *workspacesweb.AssociateUserSettingsInput, ...request.Option) (*workspacesweb.AssociateUserSettingsOutput, error)
	AssociateUserSettingsRequest(*workspacesweb.AssociateUserSettingsInput) (*request.Request, *workspacesweb.AssociateUserSettingsOutput)

	CreateBrowserSettings(*workspacesweb.CreateBrowserSettingsInput) (*workspacesweb.CreateBrowserSettingsOutput, error)
	CreateBrowserSettingsWithContext(aws.Context, *workspacesweb.CreateBrowserSettingsInput, ...request.Option) (*workspacesweb.CreateBrowserSettingsOutput, error)
	CreateBrowserSettingsRequest(*workspacesweb.CreateBrowserSettingsInput) (*request.Request, *workspacesweb.CreateBrowserSettingsOutput)

	CreateIdentityProvider(*workspacesweb.CreateIdentityProviderInput) (*workspacesweb.CreateIdentityProviderOutput, error)
	CreateIdentityProviderWithContext(aws.Context, *workspacesweb.CreateIdentityProviderInput, ...request.Option) (*workspacesweb.CreateIdentityProviderOutput, error)
	CreateIdentityProviderRequest(*workspacesweb.CreateIdentityProviderInput) (*request.Request, *workspacesweb.CreateIdentityProviderOutput)

	CreateNetworkSettings(*workspacesweb.CreateNetworkSettingsInput) (*workspacesweb.CreateNetworkSettingsOutput, error)
	CreateNetworkSettingsWithContext(aws.Context, *workspacesweb.CreateNetworkSettingsInput, ...request.Option) (*workspacesweb.CreateNetworkSettingsOutput, error)
	CreateNetworkSettingsRequest(*workspacesweb.CreateNetworkSettingsInput) (*request.Request, *workspacesweb.CreateNetworkSettingsOutput)

	CreatePortal(*workspacesweb.CreatePortalInput) (*workspacesweb.CreatePortalOutput, error)
	CreatePortalWithContext(aws.Context, *workspacesweb.CreatePortalInput, ...request.Option) (*workspacesweb.CreatePortalOutput, error)
	CreatePortalRequest(*workspacesweb.CreatePortalInput) (*request.Request, *workspacesweb.CreatePortalOutput)

	CreateTrustStore(*workspacesweb.CreateTrustStoreInput) (*workspacesweb.CreateTrustStoreOutput, error)
	CreateTrustStoreWithContext(aws.Context, *workspacesweb.CreateTrustStoreInput, ...request.Option) (*workspacesweb.CreateTrustStoreOutput, error)
	CreateTrustStoreRequest(*workspacesweb.CreateTrustStoreInput) (*request.Request, *workspacesweb.CreateTrustStoreOutput)

	CreateUserSettings(*workspacesweb.CreateUserSettingsInput) (*workspacesweb.CreateUserSettingsOutput, error)
	CreateUserSettingsWithContext(aws.Context, *workspacesweb.CreateUserSettingsInput, ...request.Option) (*workspacesweb.CreateUserSettingsOutput, error)
	CreateUserSettingsRequest(*workspacesweb.CreateUserSettingsInput) (*request.Request, *workspacesweb.CreateUserSettingsOutput)

	DeleteBrowserSettings(*workspacesweb.DeleteBrowserSettingsInput) (*workspacesweb.DeleteBrowserSettingsOutput, error)
	DeleteBrowserSettingsWithContext(aws.Context, *workspacesweb.DeleteBrowserSettingsInput, ...request.Option) (*workspacesweb.DeleteBrowserSettingsOutput, error)
	DeleteBrowserSettingsRequest(*workspacesweb.DeleteBrowserSettingsInput) (*request.Request, *workspacesweb.DeleteBrowserSettingsOutput)

	DeleteIdentityProvider(*workspacesweb.DeleteIdentityProviderInput) (*workspacesweb.DeleteIdentityProviderOutput, error)
	DeleteIdentityProviderWithContext(aws.Context, *workspacesweb.DeleteIdentityProviderInput, ...request.Option) (*workspacesweb.DeleteIdentityProviderOutput, error)
	DeleteIdentityProviderRequest(*workspacesweb.DeleteIdentityProviderInput) (*request.Request, *workspacesweb.DeleteIdentityProviderOutput)

	DeleteNetworkSettings(*workspacesweb.DeleteNetworkSettingsInput) (*workspacesweb.DeleteNetworkSettingsOutput, error)
	DeleteNetworkSettingsWithContext(aws.Context, *workspacesweb.DeleteNetworkSettingsInput, ...request.Option) (*workspacesweb.DeleteNetworkSettingsOutput, error)
	DeleteNetworkSettingsRequest(*workspacesweb.DeleteNetworkSettingsInput) (*request.Request, *workspacesweb.DeleteNetworkSettingsOutput)

	DeletePortal(*workspacesweb.DeletePortalInput) (*workspacesweb.DeletePortalOutput, error)
	DeletePortalWithContext(aws.Context, *workspacesweb.DeletePortalInput, ...request.Option) (*workspacesweb.DeletePortalOutput, error)
	DeletePortalRequest(*workspacesweb.DeletePortalInput) (*request.Request, *workspacesweb.DeletePortalOutput)

	DeleteTrustStore(*workspacesweb.DeleteTrustStoreInput) (*workspacesweb.DeleteTrustStoreOutput, error)
	DeleteTrustStoreWithContext(aws.Context, *workspacesweb.DeleteTrustStoreInput, ...request.Option) (*workspacesweb.DeleteTrustStoreOutput, error)
	DeleteTrustStoreRequest(*workspacesweb.DeleteTrustStoreInput) (*request.Request, *workspacesweb.DeleteTrustStoreOutput)

	DeleteUserSettings(*workspacesweb.DeleteUserSettingsInput) (*workspacesweb.DeleteUserSettingsOutput, error)
	DeleteUserSettingsWithContext(aws.Context, *workspacesweb.DeleteUserSettingsInput, ...request.Option) (*workspacesweb.DeleteUserSettingsOutput, error)
	DeleteUserSettingsRequest(*workspacesweb.DeleteUserSettingsInput) (*request.Request, *workspacesweb.DeleteUserSettingsOutput)

	DisassociateBrowserSettings(*workspacesweb.DisassociateBrowserSettingsInput) (*workspacesweb.DisassociateBrowserSettingsOutput, error)
	DisassociateBrowserSettingsWithContext(aws.Context, *workspacesweb.DisassociateBrowserSettingsInput, ...request.Option) (*workspacesweb.DisassociateBrowserSettingsOutput, error)
	DisassociateBrowserSettingsRequest(*workspacesweb.DisassociateBrowserSettingsInput) (*request.Request, *workspacesweb.DisassociateBrowserSettingsOutput)

	DisassociateNetworkSettings(*workspacesweb.DisassociateNetworkSettingsInput) (*workspacesweb.DisassociateNetworkSettingsOutput, error)
	DisassociateNetworkSettingsWithContext(aws.Context, *workspacesweb.DisassociateNetworkSettingsInput, ...request.Option) (*workspacesweb.DisassociateNetworkSettingsOutput, error)
	DisassociateNetworkSettingsRequest(*workspacesweb.DisassociateNetworkSettingsInput) (*request.Request, *workspacesweb.DisassociateNetworkSettingsOutput)

	DisassociateTrustStore(*workspacesweb.DisassociateTrustStoreInput) (*workspacesweb.DisassociateTrustStoreOutput, error)
	DisassociateTrustStoreWithContext(aws.Context, *workspacesweb.DisassociateTrustStoreInput, ...request.Option) (*workspacesweb.DisassociateTrustStoreOutput, error)
	DisassociateTrustStoreRequest(*workspacesweb.DisassociateTrustStoreInput) (*request.Request, *workspacesweb.DisassociateTrustStoreOutput)

	DisassociateUserSettings(*workspacesweb.DisassociateUserSettingsInput) (*workspacesweb.DisassociateUserSettingsOutput, error)
	DisassociateUserSettingsWithContext(aws.Context, *workspacesweb.DisassociateUserSettingsInput, ...request.Option) (*workspacesweb.DisassociateUserSettingsOutput, error)
	DisassociateUserSettingsRequest(*workspacesweb.DisassociateUserSettingsInput) (*request.Request, *workspacesweb.DisassociateUserSettingsOutput)

	GetBrowserSettings(*workspacesweb.GetBrowserSettingsInput) (*workspacesweb.GetBrowserSettingsOutput, error)
	GetBrowserSettingsWithContext(aws.Context, *workspacesweb.GetBrowserSettingsInput, ...request.Option) (*workspacesweb.GetBrowserSettingsOutput, error)
	GetBrowserSettingsRequest(*workspacesweb.GetBrowserSettingsInput) (*request.Request, *workspacesweb.GetBrowserSettingsOutput)

	GetIdentityProvider(*workspacesweb.GetIdentityProviderInput) (*workspacesweb.GetIdentityProviderOutput, error)
	GetIdentityProviderWithContext(aws.Context, *workspacesweb.GetIdentityProviderInput, ...request.Option) (*workspacesweb.GetIdentityProviderOutput, error)
	GetIdentityProviderRequest(*workspacesweb.GetIdentityProviderInput) (*request.Request, *workspacesweb.GetIdentityProviderOutput)

	GetNetworkSettings(*workspacesweb.GetNetworkSettingsInput) (*workspacesweb.GetNetworkSettingsOutput, error)
	GetNetworkSettingsWithContext(aws.Context, *workspacesweb.GetNetworkSettingsInput, ...request.Option) (*workspacesweb.GetNetworkSettingsOutput, error)
	GetNetworkSettingsRequest(*workspacesweb.GetNetworkSettingsInput) (*request.Request, *workspacesweb.GetNetworkSettingsOutput)

	GetPortal(*workspacesweb.GetPortalInput) (*workspacesweb.GetPortalOutput, error)
	GetPortalWithContext(aws.Context, *workspacesweb.GetPortalInput, ...request.Option) (*workspacesweb.GetPortalOutput, error)
	GetPortalRequest(*workspacesweb.GetPortalInput) (*request.Request, *workspacesweb.GetPortalOutput)

	GetPortalServiceProviderMetadata(*workspacesweb.GetPortalServiceProviderMetadataInput) (*workspacesweb.GetPortalServiceProviderMetadataOutput, error)
	GetPortalServiceProviderMetadataWithContext(aws.Context, *workspacesweb.GetPortalServiceProviderMetadataInput, ...request.Option) (*workspacesweb.GetPortalServiceProviderMetadataOutput, error)
	GetPortalServiceProviderMetadataRequest(*workspacesweb.GetPortalServiceProviderMetadataInput) (*request.Request, *workspacesweb.GetPortalServiceProviderMetadataOutput)

	GetTrustStore(*workspacesweb.GetTrustStoreInput) (*workspacesweb.GetTrustStoreOutput, error)
	GetTrustStoreWithContext(aws.Context, *workspacesweb.GetTrustStoreInput, ...request.Option) (*workspacesweb.GetTrustStoreOutput, error)
	GetTrustStoreRequest(*workspacesweb.GetTrustStoreInput) (*request.Request, *workspacesweb.GetTrustStoreOutput)

	GetTrustStoreCertificate(*workspacesweb.GetTrustStoreCertificateInput) (*workspacesweb.GetTrustStoreCertificateOutput, error)
	GetTrustStoreCertificateWithContext(aws.Context, *workspacesweb.GetTrustStoreCertificateInput, ...request.Option) (*workspacesweb.GetTrustStoreCertificateOutput, error)
	GetTrustStoreCertificateRequest(*workspacesweb.GetTrustStoreCertificateInput) (*request.Request, *workspacesweb.GetTrustStoreCertificateOutput)

	GetUserSettings(*workspacesweb.GetUserSettingsInput) (*workspacesweb.GetUserSettingsOutput, error)
	GetUserSettingsWithContext(aws.Context, *workspacesweb.GetUserSettingsInput, ...request.Option) (*workspacesweb.GetUserSettingsOutput, error)
	GetUserSettingsRequest(*workspacesweb.GetUserSettingsInput) (*request.Request, *workspacesweb.GetUserSettingsOutput)

	ListBrowserSettings(*workspacesweb.ListBrowserSettingsInput) (*workspacesweb.ListBrowserSettingsOutput, error)
	ListBrowserSettingsWithContext(aws.Context, *workspacesweb.ListBrowserSettingsInput, ...request.Option) (*workspacesweb.ListBrowserSettingsOutput, error)
	ListBrowserSettingsRequest(*workspacesweb.ListBrowserSettingsInput) (*request.Request, *workspacesweb.ListBrowserSettingsOutput)

	ListBrowserSettingsPages(*workspacesweb.ListBrowserSettingsInput, func(*workspacesweb.ListBrowserSettingsOutput, bool) bool) error
	ListBrowserSettingsPagesWithContext(aws.Context, *workspacesweb.ListBrowserSettingsInput, func(*workspacesweb.ListBrowserSettingsOutput, bool) bool, ...request.Option) error

	ListIdentityProviders(*workspacesweb.ListIdentityProvidersInput) (*workspacesweb.ListIdentityProvidersOutput, error)
	ListIdentityProvidersWithContext(aws.Context, *workspacesweb.ListIdentityProvidersInput, ...request.Option) (*workspacesweb.ListIdentityProvidersOutput, error)
	ListIdentityProvidersRequest(*workspacesweb.ListIdentityProvidersInput) (*request.Request, *workspacesweb.ListIdentityProvidersOutput)

	ListIdentityProvidersPages(*workspacesweb.ListIdentityProvidersInput, func(*workspacesweb.ListIdentityProvidersOutput, bool) bool) error
	ListIdentityProvidersPagesWithContext(aws.Context, *workspacesweb.ListIdentityProvidersInput, func(*workspacesweb.ListIdentityProvidersOutput, bool) bool, ...request.Option) error

	ListNetworkSettings(*workspacesweb.ListNetworkSettingsInput) (*workspacesweb.ListNetworkSettingsOutput, error)
	ListNetworkSettingsWithContext(aws.Context, *workspacesweb.ListNetworkSettingsInput, ...request.Option) (*workspacesweb.ListNetworkSettingsOutput, error)
	ListNetworkSettingsRequest(*workspacesweb.ListNetworkSettingsInput) (*request.Request, *workspacesweb.ListNetworkSettingsOutput)

	ListNetworkSettingsPages(*workspacesweb.ListNetworkSettingsInput, func(*workspacesweb.ListNetworkSettingsOutput, bool) bool) error
	ListNetworkSettingsPagesWithContext(aws.Context, *workspacesweb.ListNetworkSettingsInput, func(*workspacesweb.ListNetworkSettingsOutput, bool) bool, ...request.Option) error

	ListPortals(*workspacesweb.ListPortalsInput) (*workspacesweb.ListPortalsOutput, error)
	ListPortalsWithContext(aws.Context, *workspacesweb.ListPortalsInput, ...request.Option) (*workspacesweb.ListPortalsOutput, error)
	ListPortalsRequest(*workspacesweb.ListPortalsInput) (*request.Request, *workspacesweb.ListPortalsOutput)

	ListPortalsPages(*workspacesweb.ListPortalsInput, func(*workspacesweb.ListPortalsOutput, bool) bool) error
	ListPortalsPagesWithContext(aws.Context, *workspacesweb.ListPortalsInput, func(*workspacesweb.ListPortalsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*workspacesweb.ListTagsForResourceInput) (*workspacesweb.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *workspacesweb.ListTagsForResourceInput, ...request.Option) (*workspacesweb.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*workspacesweb.ListTagsForResourceInput) (*request.Request, *workspacesweb.ListTagsForResourceOutput)

	ListTrustStoreCertificates(*workspacesweb.ListTrustStoreCertificatesInput) (*workspacesweb.ListTrustStoreCertificatesOutput, error)
	ListTrustStoreCertificatesWithContext(aws.Context, *workspacesweb.ListTrustStoreCertificatesInput, ...request.Option) (*workspacesweb.ListTrustStoreCertificatesOutput, error)
	ListTrustStoreCertificatesRequest(*workspacesweb.ListTrustStoreCertificatesInput) (*request.Request, *workspacesweb.ListTrustStoreCertificatesOutput)

	ListTrustStoreCertificatesPages(*workspacesweb.ListTrustStoreCertificatesInput, func(*workspacesweb.ListTrustStoreCertificatesOutput, bool) bool) error
	ListTrustStoreCertificatesPagesWithContext(aws.Context, *workspacesweb.ListTrustStoreCertificatesInput, func(*workspacesweb.ListTrustStoreCertificatesOutput, bool) bool, ...request.Option) error

	ListTrustStores(*workspacesweb.ListTrustStoresInput) (*workspacesweb.ListTrustStoresOutput, error)
	ListTrustStoresWithContext(aws.Context, *workspacesweb.ListTrustStoresInput, ...request.Option) (*workspacesweb.ListTrustStoresOutput, error)
	ListTrustStoresRequest(*workspacesweb.ListTrustStoresInput) (*request.Request, *workspacesweb.ListTrustStoresOutput)

	ListTrustStoresPages(*workspacesweb.ListTrustStoresInput, func(*workspacesweb.ListTrustStoresOutput, bool) bool) error
	ListTrustStoresPagesWithContext(aws.Context, *workspacesweb.ListTrustStoresInput, func(*workspacesweb.ListTrustStoresOutput, bool) bool, ...request.Option) error

	ListUserSettings(*workspacesweb.ListUserSettingsInput) (*workspacesweb.ListUserSettingsOutput, error)
	ListUserSettingsWithContext(aws.Context, *workspacesweb.ListUserSettingsInput, ...request.Option) (*workspacesweb.ListUserSettingsOutput, error)
	ListUserSettingsRequest(*workspacesweb.ListUserSettingsInput) (*request.Request, *workspacesweb.ListUserSettingsOutput)

	ListUserSettingsPages(*workspacesweb.ListUserSettingsInput, func(*workspacesweb.ListUserSettingsOutput, bool) bool) error
	ListUserSettingsPagesWithContext(aws.Context, *workspacesweb.ListUserSettingsInput, func(*workspacesweb.ListUserSettingsOutput, bool) bool, ...request.Option) error

	TagResource(*workspacesweb.TagResourceInput) (*workspacesweb.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *workspacesweb.TagResourceInput, ...request.Option) (*workspacesweb.TagResourceOutput, error)
	TagResourceRequest(*workspacesweb.TagResourceInput) (*request.Request, *workspacesweb.TagResourceOutput)

	UntagResource(*workspacesweb.UntagResourceInput) (*workspacesweb.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *workspacesweb.UntagResourceInput, ...request.Option) (*workspacesweb.UntagResourceOutput, error)
	UntagResourceRequest(*workspacesweb.UntagResourceInput) (*request.Request, *workspacesweb.UntagResourceOutput)

	UpdateBrowserSettings(*workspacesweb.UpdateBrowserSettingsInput) (*workspacesweb.UpdateBrowserSettingsOutput, error)
	UpdateBrowserSettingsWithContext(aws.Context, *workspacesweb.UpdateBrowserSettingsInput, ...request.Option) (*workspacesweb.UpdateBrowserSettingsOutput, error)
	UpdateBrowserSettingsRequest(*workspacesweb.UpdateBrowserSettingsInput) (*request.Request, *workspacesweb.UpdateBrowserSettingsOutput)

	UpdateIdentityProvider(*workspacesweb.UpdateIdentityProviderInput) (*workspacesweb.UpdateIdentityProviderOutput, error)
	UpdateIdentityProviderWithContext(aws.Context, *workspacesweb.UpdateIdentityProviderInput, ...request.Option) (*workspacesweb.UpdateIdentityProviderOutput, error)
	UpdateIdentityProviderRequest(*workspacesweb.UpdateIdentityProviderInput) (*request.Request, *workspacesweb.UpdateIdentityProviderOutput)

	UpdateNetworkSettings(*workspacesweb.UpdateNetworkSettingsInput) (*workspacesweb.UpdateNetworkSettingsOutput, error)
	UpdateNetworkSettingsWithContext(aws.Context, *workspacesweb.UpdateNetworkSettingsInput, ...request.Option) (*workspacesweb.UpdateNetworkSettingsOutput, error)
	UpdateNetworkSettingsRequest(*workspacesweb.UpdateNetworkSettingsInput) (*request.Request, *workspacesweb.UpdateNetworkSettingsOutput)

	UpdatePortal(*workspacesweb.UpdatePortalInput) (*workspacesweb.UpdatePortalOutput, error)
	UpdatePortalWithContext(aws.Context, *workspacesweb.UpdatePortalInput, ...request.Option) (*workspacesweb.UpdatePortalOutput, error)
	UpdatePortalRequest(*workspacesweb.UpdatePortalInput) (*request.Request, *workspacesweb.UpdatePortalOutput)

	UpdateTrustStore(*workspacesweb.UpdateTrustStoreInput) (*workspacesweb.UpdateTrustStoreOutput, error)
	UpdateTrustStoreWithContext(aws.Context, *workspacesweb.UpdateTrustStoreInput, ...request.Option) (*workspacesweb.UpdateTrustStoreOutput, error)
	UpdateTrustStoreRequest(*workspacesweb.UpdateTrustStoreInput) (*request.Request, *workspacesweb.UpdateTrustStoreOutput)

	UpdateUserSettings(*workspacesweb.UpdateUserSettingsInput) (*workspacesweb.UpdateUserSettingsOutput, error)
	UpdateUserSettingsWithContext(aws.Context, *workspacesweb.UpdateUserSettingsInput, ...request.Option) (*workspacesweb.UpdateUserSettingsOutput, error)
	UpdateUserSettingsRequest(*workspacesweb.UpdateUserSettingsInput) (*request.Request, *workspacesweb.UpdateUserSettingsOutput)
}

var _ WorkSpacesWebAPI = (*workspacesweb.WorkSpacesWeb)(nil)
