// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Information about a tool that you can use with the Converse API. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Tool use (function calling)</a> in the Amazon Bedrock User Guide.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum Tool {
    /// <p>CachePoint to include in the tool configuration.</p>
    CachePoint(crate::types::CachePointBlock),
    /// <p>The specfication for the tool.</p>
    ToolSpec(crate::types::ToolSpecification),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Tool {
    /// Tries to convert the enum instance into [`CachePoint`](crate::types::Tool::CachePoint), extracting the inner [`CachePointBlock`](crate::types::CachePointBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_cache_point(&self) -> ::std::result::Result<&crate::types::CachePointBlock, &Self> {
        if let Tool::CachePoint(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`CachePoint`](crate::types::Tool::CachePoint).
    pub fn is_cache_point(&self) -> bool {
        self.as_cache_point().is_ok()
    }
    /// Tries to convert the enum instance into [`ToolSpec`](crate::types::Tool::ToolSpec), extracting the inner [`ToolSpecification`](crate::types::ToolSpecification).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool_spec(&self) -> ::std::result::Result<&crate::types::ToolSpecification, &Self> {
        if let Tool::ToolSpec(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ToolSpec`](crate::types::Tool::ToolSpec).
    pub fn is_tool_spec(&self) -> bool {
        self.as_tool_spec().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
