/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.launcher;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eclipse.equinox.launcher.JNIBridge;
import org.jkiss.dbeaver.launcher.CommandLineExecuteResult;
import org.jkiss.dbeaver.launcher.LauncherUtils;

public class DBeaverLauncher {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected URL installLocation = null;
    protected URL configurationLocation = null;
    protected String parentConfigurationLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    private Properties devClassPathProps = null;
    protected boolean inDevelopmentMode = false;
    protected String os = null;
    protected String ws = null;
    protected String arch = null;
    private String library = null;
    private String exitData = null;
    private String vm = null;
    private String[] vmargs = null;
    private String[] commands = null;
    String[] extensionPaths = null;
    JNIBridge bridge = null;
    private boolean showSplash = false;
    private String splashLocation = null;
    private String endSplash = null;
    private boolean initialize = false;
    private boolean newInstance = false;
    protected boolean splashDown = false;
    protected boolean cliMode = false;
    private final Thread splashHandler = new SplashHandler();
    public static final String SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    public static final String SPLASH_LOCATION = "org.eclipse.equinox.launcher.splash.location";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String EXITDATA = "-exitdata";
    private static final String NAME = "-name";
    private static final String LAUNCHER = "-launcher";
    private static final String PRODUCT = "-product";
    private static final String APPLICATION = "-application";
    private static final String PROTECT = "-protect";
    private static final String PROTECT_MASTER = "master";
    private static final String PROTECT_BASE = "base";
    private static final String LIBRARY = "--launcher.library";
    private static final String APPEND_VMARGS = "--launcher.appendVmargs";
    private static final String OVERRIDE_VMARGS = "--launcher.overrideVmargs";
    private static final String NL = "-nl";
    private static final String NEW_INSTANCE = "-newInstance";
    private static final String ENDSPLASH = "-endsplash";
    private static final String[] SPLASH_IMAGES = new String[]{"splash.png", "splash.jpg", "splash.jpeg", "splash.gif", "splash.bmp"};
    private static final String CLEAN = "-clean";
    private static final String NOEXIT = "-noExit";
    private static final String OS = "-os";
    private static final String WS = "-ws";
    private static final String ARCH = "-arch";
    private static final String STARTUP = "-startup";
    private static final String ARG_DATA = "-data";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    protected static final String REFERENCE_SCHEME = "reference:";
    protected static final String JAR_SCHEME = "jar:";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PRODUCT_SNAPSHOT_VERSION = "snapshot";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    protected static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_FRAMEWORK_SYSPATH = "osgi.syspath";
    private static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_REQUIRED_JAVA_VERSION = "osgi.requiredJavaVersion";
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PROP_FRAMEWORK_PARENT_CLASSLOADER = "osgi.frameworkParentClassloader";
    private static final String PROP_NL = "osgi.nl";
    static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_DEBUG = "osgi.debug";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_LAUNCHER = "eclipse.launcher";
    private static final String PROP_LAUNCHER_NAME = "eclipse.launcher.name";
    private static final String PROP_LOG_INCLUDE_COMMAND_LINE = "eclipse.log.include.commandline";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_ECLIPSESECURITY = "eclipse.security";
    private static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String XDG_DATA_HOME = "@data.home";
    private static final String PROP_XDG_DATA_HOME_WIN = "APPDATA";
    private static final String PROP_XDG_DATA_HOME_UNIX = "XDG_DATA_HOME";
    private static final String INSTALL_HASH_PLACEHOLDER = "@install.hash";
    private static final String LAUNCHER_DIR = "@launcher.dir";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    private static final String PARENT_CLASSLOADER_CURRENT = "current";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.equinox.launcher";
    protected File logFile = null;
    protected BufferedWriter log = null;
    protected boolean newSession = true;
    private boolean protectBase = false;
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';
    private static final long NO_TIMESTAMP = -1L;
    private static final String BASE_TIMESTAMP_FILE_CONFIGINI = ".baseConfigIniTimestamp";
    private static final String KEY_CONFIGINI_TIMESTAMP = "configIniTimestamp";
    private static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";
    public static final String DBEAVER_DATA_FOLDER = "DBeaverData";
    private static final String DBEAVER_INSTALL_FOLDER = "install-data";
    private static final String DBEAVER_SECURE_DIR = "secure";
    private static final String DBEAVER_SECURE_FILE = "secure_storage";
    public static final String ARG_ECLIPSE_KEYRING = "-eclipse.keyring";
    private static final String DEFAULT_SECURE_STORAGE_FILENAME = ".eclipse/org.eclipse.equinox.security/secure_storage";
    private static final String DBEAVER_CONFIG_FOLDER = "settings";
    private static final String DBEAVER_CONFIG_FILE = "global-settings.ini";
    private static final String DBEAVER_PROP_LANGUAGE = "nl";
    private static final Set<String> INCOMPATIBLE_WINDOWS_VERSIONS = Set.of("Windows 7", "Windows 8", "Windows Server 2012");

    private String getWS() {
        if (this.ws != null) {
            return this.ws;
        }
        String osgiWs = System.getProperty(PROP_WS);
        if (osgiWs != null) {
            this.ws = osgiWs;
            return this.ws;
        }
        String osName = this.getOS();
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals("linux")) {
            return "gtk";
        }
        if (osName.equals("macosx")) {
            return "cocoa";
        }
        if (osName.equals("hpux")) {
            return "gtk";
        }
        if (osName.equals("aix")) {
            return "gtk";
        }
        if (osName.equals("solaris")) {
            return "gtk";
        }
        if (osName.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    private String getOS() {
        if (this.os != null) {
            return this.os;
        }
        String osgiOs = System.getProperty(PROP_OS);
        if (osgiOs != null) {
            this.os = osgiOs;
            return this.os;
        }
        String osName = System.getProperty("os.name");
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase("Linux")) {
            return "linux";
        }
        if (osName.equalsIgnoreCase("QNX")) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase("AIX")) {
            return "aix";
        }
        if (osName.equalsIgnoreCase("HP-UX")) {
            return "hpux";
        }
        if (osName.equalsIgnoreCase("OS/400")) {
            return "os/400";
        }
        if (osName.equalsIgnoreCase("OS/390")) {
            return "os/390";
        }
        if (osName.equalsIgnoreCase("z/OS")) {
            return "z/os";
        }
        if (osName.regionMatches(true, 0, "Mac OS", 0, "Mac OS".length())) {
            return "macosx";
        }
        return "unknown";
    }

    private String getArch() {
        if (this.arch != null) {
            return this.arch;
        }
        String osgiArch = System.getProperty(PROP_ARCH);
        if (osgiArch != null) {
            this.arch = osgiArch;
            return this.arch;
        }
        String name = System.getProperty("os.arch");
        if (name.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        return name;
    }

    private String getFragmentString(String fragmentOS, String fragmentWS, String fragmentArch) {
        StringJoiner buffer = new StringJoiner(".");
        buffer.add(PLUGIN_ID).add(fragmentWS).add(fragmentOS);
        if (!fragmentOS.equals("macosx") || "x86_64".equals(fragmentArch)) {
            buffer.add(fragmentArch);
        }
        return buffer.toString();
    }

    private void setupJNI(URL[] defaultPath) {
        if (this.bridge != null) {
            return;
        }
        String libPath = null;
        if (this.library != null) {
            File lib = new File(this.library);
            if (lib.isDirectory()) {
                libPath = this.searchFor(ECLIPSE, lib.getAbsolutePath());
            } else if (lib.exists()) {
                libPath = lib.getAbsolutePath();
            }
        }
        if (libPath == null) {
            String fragmentOS = this.getOS();
            String fragmentWS = this.getWS();
            String fragmentArch = this.getArch();
            libPath = this.getLibraryPath(this.getFragmentString(fragmentOS, fragmentWS, fragmentArch), defaultPath);
        }
        this.library = libPath;
        if (this.library != null) {
            this.bridge = new JNIBridge(this.library);
        }
    }

    private String getLibraryPath(String fragmentName, URL[] defaultPath) {
        URL[] urls;
        String dir;
        File location;
        String devPathList;
        String[] locations;
        String libPath = null;
        String fragment = null;
        if (this.inDevelopmentMode && this.devClassPathProps != null && (locations = this.getArrayFromList(devPathList = this.devClassPathProps.getProperty(PLUGIN_ID))).length > 0 && (location = new File(locations[0])).isAbsolute() && (fragment = this.searchFor(fragmentName, dir = location.getParent())) != null) {
            libPath = this.getLibraryFromFragment(fragment);
        }
        if (libPath == null && this.bootLocation != null && (urls = defaultPath) != null && urls.length > 0) {
            int i = urls.length - 1;
            while (i >= 0 && libPath == null) {
                File entryFile = new File(urls[i].getFile());
                dir = entryFile.getParent();
                if (this.inDevelopmentMode) {
                    String devDir = dir + "/org.eclipse.equinox.launcher/fragments";
                    fragment = this.searchFor(fragmentName, devDir);
                }
                if (fragment == null) {
                    fragment = this.searchFor(fragmentName, dir);
                }
                if (fragment != null) {
                    libPath = this.getLibraryFromFragment(fragment);
                }
                --i;
            }
        }
        if (libPath == null) {
            URL install = this.getInstallLocation();
            Object location2 = install.getFile();
            fragment = this.searchFor(fragmentName, (String)(location2 = (String)location2 + "/plugins/"));
            if (fragment != null) {
                libPath = this.getLibraryFromFragment(fragment);
            }
        }
        return libPath;
    }

    private String getLibraryFromFragment(String fragment) {
        block18: {
            File frag;
            if (fragment.startsWith(FILE_SCHEME)) {
                fragment = fragment.substring(5);
            }
            if (!(frag = new File(fragment)).exists()) {
                return null;
            }
            if (frag.isDirectory()) {
                return this.searchFor(ECLIPSE, fragment);
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ZipFile fragmentJar = new ZipFile(frag);){
                    Enumeration<? extends ZipEntry> entries = fragmentJar.entries();
                    String entry = null;
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (!zipEntry.getName().startsWith("eclipse_")) continue;
                        entry = zipEntry.getName();
                        break;
                    }
                    if (entry == null) break block18;
                    String lib = this.extractFromJAR(fragment, entry);
                    if (!this.getOS().equals("win32")) {
                        try {
                            Runtime.getRuntime().exec(new String[]{"chmod", "755", lib}).waitFor();
                        }
                        catch (Throwable throwable2) {}
                    }
                    return lib;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log("Exception opening JAR file: " + fragment);
                this.log(e);
                return null;
            }
        }
        return null;
    }

    protected void basicRun(String[] args) throws Exception {
        Path secretStoragePath;
        Path dbeaverDataDir;
        Object[] passThruArgs;
        block17: {
            this.checkCompatibleWindowsVersion();
            System.setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
            this.commands = args;
            passThruArgs = this.processCommandLine(args);
            if (this.debug) {
                System.out.println("Processed command line arguments: " + Arrays.toString(passThruArgs));
            }
            if (!this.debug) {
                this.debug = System.getProperty(PROP_DEBUG) != null;
            }
            this.setupVMProperties();
            this.processConfiguration();
            this.processGlobalConfiguration();
            dbeaverDataDir = DBeaverLauncher.getDataDirectory();
            if (this.log == null) {
                this.openLogFile();
            }
            try {
                CommandLineExecuteResult commandLineExecuteResult = this.processCommandLineAsClient((String[])passThruArgs, dbeaverDataDir);
                if (commandLineExecuteResult.shutdown()) {
                    System.setProperty(PROP_EXITCODE, Integer.toString(commandLineExecuteResult.exitCode()));
                    return;
                }
            }
            catch (Exception e) {
                if (this.log == null) {
                    this.openLogFile();
                }
                this.log.write(e.getMessage());
                if (!this.debug) break block17;
                System.out.println("Error processing remote command line: " + e.getMessage());
            }
        }
        if ((secretStoragePath = this.useCustomSecretStorage(dbeaverDataDir)) != null) {
            String[] keyringParams = new String[]{ARG_ECLIPSE_KEYRING, secretStoragePath.toString()};
            passThruArgs = (String[])Stream.concat(Arrays.stream(passThruArgs), Arrays.stream(keyringParams)).toArray(String[]::new);
        }
        if (this.protectBase && System.getProperty(PROP_SHARED_CONFIG_AREA) == null) {
            System.err.println("This application is configured to run in a cascaded mode only.");
            System.setProperty(PROP_EXITCODE, Integer.toString(14));
            return;
        }
        this.getInstallLocation();
        URL[] bootPath = this.getBootPath(this.bootLocation);
        this.setupJNI(bootPath);
        if (!this.checkVersion(System.getProperty("java.version"), System.getProperty(PROP_REQUIRED_JAVA_VERSION))) {
            return;
        }
        boolean hasAppParams = this.hasAppParameters((String[])passThruArgs);
        if (this.debug) {
            System.out.println("Has application parameters: " + hasAppParams);
        }
        if (!hasAppParams) {
            this.handleSplash(bootPath);
        } else {
            boolean addNoSplash = true;
            Object[] objectArray = passThruArgs;
            int n = passThruArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (((String)arg).equals(APPLICATION)) {
                    addNoSplash = false;
                    break;
                }
                ++n2;
            }
            if (addNoSplash) {
                passThruArgs = (String[])Stream.concat(Arrays.stream(passThruArgs), Arrays.stream(new String[]{NOSPLASH})).toArray(String[]::new);
            }
        }
        this.beforeFwkInvocation();
        if (this.debug) {
            System.out.println("Invoking parameters: " + Arrays.toString(passThruArgs));
        }
        this.invokeFramework((String[])passThruArgs, bootPath);
    }

    private boolean hasAppParameters(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals(PRODUCT) || arg.equals(DEV) || arg.equals(STARTUP) || arg.equals(OS) || arg.equals(WS) || arg.equals(ARCH) || arg.equals(ARG_ECLIPSE_KEYRING) || arg.equals(LAUNCHER)) {
                ++i;
            } else if (!arg.equals("-consoleLog")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkCompatibleWindowsVersion() {
        if (GraphicsEnvironment.isHeadless() || DBeaverLauncher.isCompatibleWindowsVersion()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, "You are using an incompatible operating system version: minimal supported\nversion is Windows 10 (1607) or Windows Server 2016.\n\nYou might experience issues and unexpected behavior when running DBeaver.\n\nConsider using an older version of DBeaver that supports your operating\nsystem, or upgrade your operating system to a newer version.\n", "Incompatible OS", 0));
        }
        catch (Exception exception) {}
    }

    private static boolean isCompatibleWindowsVersion() {
        String name = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        for (String other : INCOMPATIBLE_WINDOWS_VERSIONS) {
            if (!name.startsWith(other.toLowerCase(Locale.ROOT))) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private CommandLineExecuteResult processCommandLineAsClient(String[] args, Path dbeaverDataDir) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLContext initCustomSslContext() throws Exception {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(KeyStore.getInstance(KeyStore.getDefaultType()));
        SSLContext ssl = SSLContext.getInstance("TLS");
        ssl.init(null, factory.getTrustManagers(), null);
        return ssl;
    }

    private Path detectDefaultWorkspaceLocation(String[] args, Path dbeaverDataDir) {
        String productName = "";
        String customWorkspacePath = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (PRODUCT.equals(arg)) {
                productName = args[++i];
            }
            if (ARG_DATA.equals(arg)) {
                customWorkspacePath = args[++i];
                break;
            }
            ++i;
        }
        if (productName.isEmpty()) {
            Properties properties = this.loadEclipseProductProperties();
            if (this.debug) {
                System.out.println("Loaded eclipse product properties: " + String.valueOf(properties));
            }
            if (properties.containsKey(PRODUCT_SITE_ID)) {
                productName = properties.getProperty(PRODUCT_SITE_ID);
            }
        }
        if (this.debug) {
            System.out.println("product name: " + productName);
        }
        if (customWorkspacePath != null) {
            return Path.of(customWorkspacePath, new String[0]);
        }
        if (productName.startsWith("io.cloudbeaver")) {
            return Path.of("workspace", new String[0]);
        }
        if (productName.startsWith("com.dbeaver.app.team")) {
            return dbeaverDataDir.resolve("team-workspace");
        }
        return dbeaverDataDir.resolve("workspace6");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer readDBeaverServerPort(Path workspacePath) {
        Path dbeaverProperties = workspacePath.resolve(".metadata").resolve("dbeaver-instance.properties");
        if (Files.notExists(dbeaverProperties, new LinkOption[0])) {
            if (!this.debug) return null;
            System.out.println("DBeaver properties file not found: " + String.valueOf(dbeaverProperties));
            return null;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = Files.newInputStream(dbeaverProperties, new OpenOption[0]);){
                properties.load(is);
                String portProperty = properties.getProperty("port");
                if (portProperty == null) return null;
                if (!portProperty.isBlank()) return Integer.valueOf(portProperty);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log(e);
            return null;
        }
    }

    private static Path getDataDirectory() {
        return Path.of(DBeaverLauncher.getWorkingDirectory(DBEAVER_DATA_FOLDER), new String[0]);
    }

    protected void beforeFwkInvocation() {
    }

    private void invokeFramework(String[] passThruArgs, URL[] bootPath) throws Error, Exception {
        String type = PARENT_CLASSLOADER_BOOT;
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null && new Identifier(javaVersion).isGreaterEqualTo(new Identifier("1.9"))) {
                type = PARENT_CLASSLOADER_EXT;
            }
        }
        catch (NumberFormatException | SecurityException runtimeException) {}
        type = System.getProperty(PROP_PARENT_CLASSLOADER, type);
        type = System.getProperty(PROP_FRAMEWORK_PARENT_CLASSLOADER, type);
        ClassLoader parent = null;
        if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            parent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type)) {
            ClassLoader appCL = ClassLoader.getSystemClassLoader();
            if (appCL != null) {
                parent = appCL.getParent();
            }
        } else if (PARENT_CLASSLOADER_CURRENT.equalsIgnoreCase(type)) {
            parent = this.getClass().getClassLoader();
        }
        StartupClassLoader loader = new StartupClassLoader(bootPath, parent);
        Class<?> clazz = loader.loadClass(STARTER);
        Method method = clazz.getDeclaredMethod("run", String[].class, Runnable.class);
        try {
            method.invoke(clazz, passThruArgs, this.splashHandler);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            Throwable throwable2 = e.getTargetException();
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            throw e;
        }
    }

    private boolean checkVersion(String availableVersion, String requiredVersion) {
        if (requiredVersion == null || availableVersion == null) {
            return true;
        }
        try {
            Identifier required = new Identifier(requiredVersion);
            Identifier available = new Identifier(availableVersion);
            boolean compatible = available.isGreaterEqualTo(required);
            if (!compatible) {
                System.setProperty(PROP_EXITCODE, "14");
                System.setProperty(PROP_EXITDATA, "<title>Incompatible JVM</title>Version " + availableVersion + " of the JVM is not suitable for this product. Version: " + requiredVersion + " or greater is required.");
            }
            return compatible;
        }
        catch (NumberFormatException | SecurityException runtimeException) {
            return true;
        }
    }

    private boolean checkConfigurationLocation(URL locationUrl) {
        if (locationUrl == null || !"file".equals(locationUrl.getProtocol())) {
            return true;
        }
        if (Boolean.parseBoolean(System.getProperty("osgi.configuration.area.readOnly"))) {
            return true;
        }
        File configDir = new File(locationUrl.getFile()).getAbsoluteFile();
        if (!configDir.exists()) {
            configDir.mkdirs();
            if (!configDir.exists()) {
                return false;
            }
        }
        return LauncherUtils.canWrite(configDir);
    }

    protected String decode(String urlString) {
        if (urlString.indexOf(43) >= 0) {
            int len = urlString.length();
            StringBuilder buf = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = urlString.charAt(i);
                if (c == '+') {
                    buf.append("%2B");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            urlString = buf.toString();
        }
        return URLDecoder.decode(urlString, StandardCharsets.UTF_8);
    }

    protected String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().isEmpty()) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.isEmpty()) continue;
            list.add(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    private URL[] getDevPath(URL base) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(base, result, OSGI);
        }
        this.addBaseJars(base, result);
        return result.toArray(new URL[0]);
    }

    URL constructURL(URL url, String name) {
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith(".jar")) {
            try {
                return new URL(JAR_SCHEME + String.valueOf(url) + "!/" + name);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        try {
            return new URL(url, name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void readFrameworkExtensions(URL base, ArrayList<URL> result) throws IOException {
        String[] extensions = this.getArrayFromList(System.getProperty(PROP_EXTENSIONS));
        String parent = new File(base.getFile()).getParent();
        ArrayList<String> extensionResults = new ArrayList<String>(extensions.length);
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            String path = this.searchForBundle(extension, parent);
            if (path == null) {
                this.log("Could not find extension: " + extension);
            } else {
                String[] stringArray2;
                Properties extensionProperties;
                URL extensionURL;
                block15: {
                    if (this.debug) {
                        System.out.println("Loading extension: " + extension);
                    }
                    if (this.installLocation.getProtocol().equals("file")) {
                        extensionResults.add(path);
                        extensionURL = new File(path).toURL();
                    } else {
                        extensionURL = new URL(this.installLocation.getProtocol(), this.installLocation.getHost(), this.installLocation.getPort(), path);
                    }
                    extensionProperties = null;
                    try {
                        extensionProperties = this.loadProperties(this.constructURL(extensionURL, ECLIPSE_PROPERTIES));
                    }
                    catch (IOException iOException) {
                        if (!this.debug) break block15;
                        System.out.println("\teclipse.properties not found");
                    }
                }
                String extensionClassPath = null;
                if (extensionProperties != null) {
                    extensionClassPath = extensionProperties.getProperty(PROP_CLASSPATH);
                } else {
                    extensionProperties = new Properties();
                }
                if (extensionClassPath == null || extensionClassPath.isEmpty()) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "";
                } else {
                    stringArray2 = this.getArrayFromList(extensionClassPath);
                }
                String[] entries = stringArray2;
                Object qualifiedPath = System.getProperty(PROP_CLASSPATH) == null ? "." : "";
                String[] stringArray4 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    String entry = stringArray4[n4];
                    qualifiedPath = (String)qualifiedPath + ", file:" + path + entry;
                    ++n4;
                }
                extensionProperties.put(PROP_CLASSPATH, qualifiedPath);
                this.mergeWithSystemProperties(extensionProperties, null);
                if (this.inDevelopmentMode) {
                    String name = extension;
                    if (name.startsWith(REFERENCE_SCHEME)) {
                        name = new File(path).getName();
                    }
                    this.addDevEntries(extensionURL, result, name);
                }
            }
            ++n2;
        }
        this.extensionPaths = extensionResults.toArray(new String[0]);
    }

    private void addBaseJars(URL base, ArrayList<URL> result) throws IOException {
        File fwkFile;
        boolean fwkIsDirectory;
        String baseJarList = System.getProperty(PROP_CLASSPATH);
        if (baseJarList == null) {
            this.readFrameworkExtensions(base, result);
            baseJarList = System.getProperty(PROP_CLASSPATH);
        }
        if (fwkIsDirectory = (fwkFile = new File(base.getFile())).isDirectory()) {
            System.setProperty(PROP_FRAMEWORK_SHAPE, "folder");
        } else {
            System.setProperty(PROP_FRAMEWORK_SHAPE, "jar");
        }
        String fwkPath = new File(new File(base.getFile()).getParent()).getAbsolutePath();
        if (Character.isUpperCase(fwkPath.charAt(0))) {
            char[] chars = fwkPath.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            fwkPath = new String(chars);
        }
        System.setProperty(PROP_FRAMEWORK_SYSPATH, fwkPath);
        String[] baseJars = this.getArrayFromList(baseJarList);
        if (baseJars.length == 0) {
            if (!this.inDevelopmentMode && new File(base.getFile()).isDirectory()) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            this.addEntry(base, result);
            return;
        }
        String[] stringArray = baseJars;
        int n = baseJars.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                if (string.equals(".")) {
                    this.addEntry(base, result);
                }
                URL url = string.startsWith(FILE_SCHEME) ? new File(string.substring(5)).toURL() : new URL(string);
                this.addEntry(url, result);
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(base, string), result);
            }
            ++n2;
        }
    }

    protected void addEntry(URL url, List<URL> result) {
        if (new File(url.getFile()).exists()) {
            result.add(url);
        }
    }

    private void addDevEntries(URL base, List<URL> result, String symbolicName) throws MalformedURLException {
        String[] locations;
        if (this.devClassPathProps == null) {
            return;
        }
        String devPathList = this.devClassPathProps.getProperty(symbolicName);
        if (devPathList == null) {
            devPathList = this.devClassPathProps.getProperty("*");
        }
        String[] stringArray = locations = this.getArrayFromList(devPathList);
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URL url;
            String location = stringArray[n2];
            File path = new File(location);
            if (path.isAbsolute()) {
                url = path.toURL();
            } else {
                char lastChar = location.charAt(location.length() - 1);
                url = location.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(base, location) : new URL(base, location + "/");
            }
            this.addEntry(url, result);
            ++n2;
        }
    }

    private URL[] getBootPath(String base) throws IOException {
        URL url;
        if (base != null) {
            url = DBeaverLauncher.buildURL(base, true);
        } else {
            url = this.getInstallLocation();
            String pluginsLocation = new File(url.getFile(), "plugins").toString();
            String path = this.searchFor(this.framework, pluginsLocation);
            if (path == null) {
                throw new FileNotFoundException(String.format("Could not find framework under %s", pluginsLocation));
            }
            url = url.getProtocol().equals("file") ? new File(path).toURL() : new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.setProperty(PROP_FRAMEWORK, url.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + url.toExternalForm());
        }
        URL[] result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Framework classpath:");
            URL[] uRLArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                URL devPath = uRLArray[n2];
                System.out.println("    " + devPath.toExternalForm());
                ++n2;
            }
        }
        return result;
    }

    protected String searchFor(String target, String start) {
        File root = DBeaverLauncher.resolveFile(new File(start));
        String[] candidates = root.list();
        if (candidates == null) {
            return null;
        }
        ArrayList<String> matches = new ArrayList<String>(2);
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (this.isMatchingCandidate(target, candidate, root)) {
                matches.add(candidate);
            }
            ++n2;
        }
        String[] names = matches.toArray(new String[0]);
        int result = this.findMax(target, names);
        if (result == -1) {
            return null;
        }
        File candidate = new File(start, names[result]);
        return candidate.getAbsolutePath().replace(File.separatorChar, '/') + (candidate.isDirectory() ? "/" : "");
    }

    /*
     * Unable to fully structure code
     */
    private boolean isMatchingCandidate(String target, String candidate, File root) {
        if (candidate.equals(target)) {
            return true;
        }
        if (!candidate.startsWith(target + "_")) {
            return false;
        }
        targetLength = target.length();
        lastUnderscore = candidate.lastIndexOf(95);
        candidateFile = new File(root, candidate);
        if (candidateFile.isFile() && (candidate.endsWith(".jar") || candidate.endsWith(".zip"))) {
            extension = candidate.lastIndexOf(46);
            candidate = candidate.substring(0, extension);
        }
        if ((lastDot = candidate.lastIndexOf(46)) >= targetLength) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            lastUnderscore = candidate.lastIndexOf(95, lastUnderscore - 1);
lbl14:
            // 2 sources

            ** while (lastUnderscore > lastDot)
        }
lbl15:
        // 1 sources

        return lastUnderscore == targetLength;
    }

    private String searchForBundle(String target, String start) {
        if (target.startsWith(REFERENCE_SCHEME)) {
            File child;
            if (!(target = target.substring(REFERENCE_SCHEME.length())).startsWith(FILE_SCHEME)) {
                throw new IllegalArgumentException("Bundle URL is invalid: " + target);
            }
            target = target.substring(FILE_SCHEME.length());
            File fileLocation = child = new File(target);
            if (!child.isAbsolute()) {
                File parent = DBeaverLauncher.resolveFile(new File(start));
                fileLocation = new File(parent, child.getPath());
            }
            return this.searchFor(fileLocation.getName(), fileLocation.getParentFile().getAbsolutePath());
        }
        return this.searchFor(target, start);
    }

    protected int findMax(String prefix, String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i] != null ? candidates[i] : "";
            String version = "";
            if (prefix == null) {
                version = name;
            } else if (name.startsWith(prefix + "_")) {
                version = name.substring(prefix.length() + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = i;
                maxVersion = currentVersion;
            }
            ++i;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{0, 0, 0, ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = Integer.valueOf(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                File toAdjust = LauncherUtils.toFileURL(spec);
                if ((toAdjust = DBeaverLauncher.resolveFile(toAdjust)).isDirectory()) {
                    return LauncherUtils.adjustTrailingSlash(toAdjust.toURL(), trailingSlash);
                }
                return toAdjust.toURL();
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                File toAdjust = new File(spec);
                if (toAdjust.isDirectory()) {
                    return LauncherUtils.adjustTrailingSlash(toAdjust.toURL(), trailingSlash);
                }
                return toAdjust.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static File resolveFile(File toAdjust) {
        String installArea;
        if (!toAdjust.isAbsolute() && (installArea = System.getProperty(PROP_INSTALL_AREA)) != null) {
            if (installArea.startsWith(FILE_SCHEME)) {
                toAdjust = new File(installArea.substring(5), toAdjust.getPath());
            } else if (new File(installArea).exists()) {
                toAdjust = new File(installArea, toAdjust.getPath());
            }
        }
        return toAdjust;
    }

    private URL buildLocation(String property, URL defaultLocation, String userDefaultAppendage) {
        URL result = null;
        Object location = System.getProperty(property);
        System.clearProperty(property);
        try {
            if (location == null) {
                result = defaultLocation;
            } else {
                if (((String)location).equalsIgnoreCase(NONE)) {
                    return null;
                }
                if (((String)location).equalsIgnoreCase(NO_DEFAULT)) {
                    result = DBeaverLauncher.buildURL((String)location, true);
                } else {
                    String base;
                    if (((String)location).startsWith(XDG_DATA_HOME)) {
                        base = this.substituteVar((String)location, XDG_DATA_HOME, PROP_XDG_DATA_HOME_UNIX);
                        if ("win32".equals(this.getOS())) {
                            base = this.substituteVar((String)location, XDG_DATA_HOME, PROP_XDG_DATA_HOME_WIN);
                        }
                        location = new File(base, userDefaultAppendage).getAbsolutePath();
                        this.log("Using data configuration location: " + (String)location);
                    }
                    if (((String)location).startsWith(USER_HOME)) {
                        base = this.substituteVar((String)location, USER_HOME, PROP_USER_HOME);
                        location = new File(base, userDefaultAppendage).getAbsolutePath();
                    } else if (((String)location).startsWith(USER_DIR)) {
                        base = this.substituteVar((String)location, USER_DIR, PROP_USER_DIR);
                        location = new File(base, userDefaultAppendage).getAbsolutePath();
                    }
                    int idx = ((String)location).indexOf(INSTALL_HASH_PLACEHOLDER);
                    if (idx == 0) {
                        throw new RuntimeException("The location cannot start with '@install.hash': " + (String)location);
                    }
                    if (idx > 0) {
                        location = ((String)location).substring(0, idx) + this.getInstallDirHash() + ((String)location).substring(idx + INSTALL_HASH_PLACEHOLDER.length());
                    }
                    result = DBeaverLauncher.buildURL((String)location, true);
                }
            }
        }
        finally {
            if (result != null) {
                System.setProperty(property, result.toExternalForm());
            }
        }
        return result;
    }

    private String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return value + source.substring(var.length());
    }

    private String computeDefaultConfigurationLocation() {
        File installDir;
        URL install = this.getInstallLocation();
        if (this.protectBase) {
            return this.computeDefaultUserAreaLocation(CONFIG_DIR);
        }
        if (install.getProtocol().equals("file") && LauncherUtils.canWrite(installDir = new File(install.getFile()))) {
            return installDir.getAbsolutePath() + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private String computeDefaultUserAreaLocation(String pathAppendage) {
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        String installDirHash = this.getInstallDirHash();
        if (this.protectBase && "macosx".equals(this.os)) {
            this.initializeBridgeEarly();
            String macConfiguration = this.computeConfigurationLocationForMacOS();
            if (macConfiguration != null) {
                return macConfiguration;
            }
            if (this.debug) {
                System.out.println("Computation of Mac specific configuration folder failed.");
            }
        }
        Object appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (FileInputStream inStream = new FileInputStream(eclipseProduct);){
                    String appVersion;
                    props.load(inStream);
                    String appId = props.getProperty(PRODUCT_SITE_ID);
                    if (appId == null || appId.trim().isEmpty()) {
                        appId = ECLIPSE;
                    }
                    if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().isEmpty()) {
                        appVersion = "";
                    }
                    appName = (String)appName + File.separator + appId + "_" + appVersion + "_" + installDirHash;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                appName = (String)appName + File.separator + installDirHash;
            }
        } else {
            appName = (String)appName + File.separator + installDirHash;
        }
        appName = (String)appName + "_" + this.OS_WS_ARCHToString();
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, (String)appName + "/" + pathAppendage).getAbsolutePath();
    }

    private String computeConfigurationLocationForMacOS() {
        if (this.bridge != null) {
            String folder = this.bridge.getOSRecommendedFolder();
            if (this.debug) {
                System.out.println("App folder provided by MacOS is: " + folder);
            }
            if (folder != null) {
                return folder + "/configuration/";
            }
        }
        return null;
    }

    private String OS_WS_ARCHToString() {
        return this.getOS() + "_" + this.getWS() + "_" + this.getArch();
    }

    private void initializeBridgeEarly() {
        this.setupJNI(null);
    }

    private String getInstallDirHash() {
        int hashCode;
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return "";
        }
        File installDir = new File(installURL.getFile());
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        return String.valueOf(hashCode);
    }

    private Properties loadEclipseProductProperties() {
        Properties properties;
        block19: {
            URL installURL;
            block18: {
                properties = new Properties();
                installURL = null;
                try {
                    installURL = this.getInstallLocation();
                }
                catch (Exception e) {
                    if (!this.debug) break block18;
                    System.out.println("Could not determine install location to load .eclipseproduct: " + e.getMessage());
                }
            }
            if (installURL == null) {
                if (this.debug) {
                    System.out.println("Install location is null, cannot load .eclipseproduct");
                }
                return properties;
            }
            File eclipseProduct = new File(installURL.getFile(), PRODUCT_SITE_MARKER);
            if (this.debug) {
                System.out.println("Loading product properties from " + String.valueOf(eclipseProduct));
            }
            if (!eclipseProduct.exists()) {
                if (this.debug) {
                    System.out.println("Not exists " + String.valueOf(eclipseProduct));
                }
                return properties;
            }
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileInputStream in = new FileInputStream(eclipseProduct);){
                    properties.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!this.debug) break block19;
                System.out.println("Could not load .eclipseproduct file: " + e.getMessage());
            }
        }
        return properties;
    }

    public static void main(String[] args) {
        int result = 0;
        try {
            try {
                result = new DBeaverLauncher().run(args);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                if (!Boolean.getBoolean(PROP_NOSHUTDOWN) || result == 23) {
                    System.exit(result);
                }
            }
        }
        finally {
            if (!Boolean.getBoolean(PROP_NOSHUTDOWN) || result == 23) {
                System.exit(result);
            }
        }
    }

    public int run(String[] args) {
        int result;
        block12: {
            try {
                try {
                    this.basicRun(args);
                    String exitCode = System.getProperty(PROP_EXITCODE);
                    try {
                        result = exitCode == null ? 0 : Integer.parseInt(exitCode);
                    }
                    catch (NumberFormatException numberFormatException) {
                        result = 17;
                    }
                }
                catch (Throwable e) {
                    if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                        this.log("Exception launching the Eclipse Platform:");
                        this.log(e);
                        Object message = "An error has occurred";
                        message = this.logFile == null ? (String)message + " and could not be logged: \n" + e.getMessage() : (String)message + ".  See the log file\n" + this.logFile.getAbsolutePath();
                        System.setProperty(PROP_EXITDATA, (String)message);
                    } else {
                        this.log("Are you trying to start an 64/32-bit Eclipse on a 32/64-JVM? These must be the same, as Eclipse uses native code.");
                    }
                    result = 13;
                    this.takeDownSplash();
                    if (this.bridge != null) {
                        this.bridge.uninitialize();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.takeDownSplash();
                if (this.bridge != null) {
                    this.bridge.uninitialize();
                }
                throw throwable;
            }
            this.takeDownSplash();
            if (this.bridge != null) {
                this.bridge.uninitialize();
            }
        }
        System.setProperty(PROP_EXITCODE, Integer.toString(result));
        this.setExitData();
        return result;
    }

    private void setExitData() {
        String data = System.getProperty(PROP_EXITDATA);
        if (data == null) {
            return;
        }
        if (this.bridge == null || this.bridge.isLibraryLoadedByJava() && this.exitData == null) {
            System.out.println(data);
        } else {
            this.bridge.setExitData(this.exitData, data);
        }
    }

    protected String[] processCommandLine(String[] args) {
        if (args.length == 0) {
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else {
                if (args[i].equalsIgnoreCase(NOSPLASH)) {
                    this.splashDown = true;
                    found = true;
                }
                if (args[i].equalsIgnoreCase(NOEXIT)) {
                    System.setProperty(PROP_NOSHUTDOWN, "true");
                    found = true;
                }
                if (args[i].equalsIgnoreCase(APPEND_VMARGS) || args[i].equalsIgnoreCase(OVERRIDE_VMARGS)) {
                    found = true;
                }
                if (args[i].equalsIgnoreCase(NEW_INSTANCE)) {
                    this.newInstance = true;
                    found = true;
                }
                if (args[i].equalsIgnoreCase("-cli-mode")) {
                    this.cliMode = true;
                    found = true;
                }
                if (args[i].equalsIgnoreCase(INITIALIZE)) {
                    this.initialize = true;
                } else if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                    this.inDevelopmentMode = true;
                } else {
                    if (args[i].equalsIgnoreCase(SHOWSPLASH)) {
                        this.showSplash = true;
                        found = true;
                        if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                            configArgs[configArgIndex++] = i++;
                            this.splashLocation = args[i];
                        }
                    }
                    if (args[i].equalsIgnoreCase(PROTECT)) {
                        found = true;
                        configArgs[configArgIndex++] = i++;
                        if (args[i].equalsIgnoreCase(PROTECT_MASTER) || args[i].equalsIgnoreCase(PROTECT_BASE)) {
                            this.protectBase = true;
                        }
                    }
                    if (found) {
                        configArgs[configArgIndex++] = i;
                    } else if (args[i].equalsIgnoreCase(VMARGS)) {
                        args[i] = null;
                        this.vmargs = new String[args.length - ++i];
                        int j = 0;
                        while (i < args.length) {
                            this.vmargs[j++] = args[i];
                            args[i] = null;
                            ++i;
                        }
                    } else if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                        if (!args[i].startsWith("-")) {
                            this.splashDown = true;
                        }
                    } else {
                        String arg = args[++i];
                        if (args[i - 1].equalsIgnoreCase(DEV)) {
                            this.inDevelopmentMode = true;
                            this.devClassPathProps = this.processDevArg(arg);
                            if (this.devClassPathProps != null) {
                                this.devClassPath = this.devClassPathProps.getProperty(OSGI);
                                if (this.devClassPath == null) {
                                    this.devClassPath = this.devClassPathProps.getProperty("*");
                                }
                            }
                        } else {
                            if (args[i - 1].equalsIgnoreCase(FRAMEWORK)) {
                                this.framework = arg;
                                found = true;
                            }
                            if (args[i - 1].equalsIgnoreCase(OS)) {
                                this.os = arg;
                            } else if (args[i - 1].equalsIgnoreCase(WS)) {
                                this.ws = arg;
                            } else if (args[i - 1].equalsIgnoreCase(ARCH)) {
                                this.arch = arg;
                            } else {
                                if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                                    System.setProperty(PROP_INSTALL_AREA, arg);
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                                    System.setProperty(PROP_CONFIG_AREA, arg);
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(EXITDATA)) {
                                    this.exitData = arg;
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(NAME)) {
                                    System.setProperty(PROP_LAUNCHER_NAME, arg);
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(STARTUP)) {
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(LAUNCHER)) {
                                    System.setProperty(PROP_LAUNCHER, arg);
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(LIBRARY)) {
                                    this.library = arg;
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                                    this.endSplash = arg;
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(VM)) {
                                    this.vm = arg;
                                    found = true;
                                }
                                if (args[i - 1].equalsIgnoreCase(NL)) {
                                    System.setProperty(PROP_NL, arg);
                                    found = true;
                                }
                                if (found) {
                                    configArgs[configArgIndex++] = i - 1;
                                    configArgs[configArgIndex++] = i;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        String[] passThruArgs = new String[args.length - configArgIndex - (this.vmargs == null ? 0 : this.vmargs.length + 1)];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else if (args[i2] != null) {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private Properties processDevArg(String arg) {
        if (arg == null) {
            return null;
        }
        try {
            URL location = new URL(arg);
            return this.load(location, null);
        }
        catch (MalformedURLException malformedURLException) {
            Properties result = new Properties();
            result.put("*", arg);
            return result;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, null, "");
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "");
            if (this.configurationLocation == null) {
                this.configurationLocation = this.buildProductURL();
                if (this.configurationLocation == null) {
                    this.configurationLocation = DBeaverLauncher.buildURL(this.computeDefaultConfigurationLocation(), true);
                }
            }
        }
        if (this.configurationLocation != null) {
            System.setProperty(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + String.valueOf(this.configurationLocation));
        }
        return this.configurationLocation;
    }

    private URL buildProductURL() {
        block6: {
            try {
                URL installationUrl = new URL(this.getInstallLocation(), CONFIG_DIR);
                if (this.checkConfigurationLocation(installationUrl)) {
                    return installationUrl;
                }
            }
            catch (Exception e) {
                if (!this.debug) break block6;
                System.out.println("Can not read product properties. " + e.getMessage());
            }
        }
        String base = DBeaverLauncher.getWorkingDirectory(DBEAVER_DATA_FOLDER);
        try {
            String productPath = this.getProductProperties();
            Path basePath = Paths.get(base, DBEAVER_INSTALL_FOLDER, productPath);
            String productConfigurationLocation = basePath.toFile().getAbsolutePath();
            return DBeaverLauncher.buildURL(productConfigurationLocation, true);
        }
        catch (IOException e) {
            if (this.debug) {
                System.out.println("Can not read product properties. " + e.getMessage());
            }
            return null;
        }
    }

    public static Path getDefaultSecretStorageLocation() {
        String userHome = System.getProperty(PROP_USER_HOME);
        if (userHome == null) {
            return Path.of(DEFAULT_SECURE_STORAGE_FILENAME, new String[0]);
        }
        return Path.of(userHome, DEFAULT_SECURE_STORAGE_FILENAME);
    }

    private Path useCustomSecretStorage(Path localPath) {
        try {
            if (!Files.exists(localPath, new LinkOption[0])) {
                Files.createDirectories(localPath, new FileAttribute[0]);
            }
            if (Files.exists(localPath, new LinkOption[0])) {
                Path storagePath = localPath.resolve(DBEAVER_SECURE_DIR).resolve(DBEAVER_SECURE_FILE);
                if (!Files.exists(storagePath, new LinkOption[0])) {
                    Files.createDirectories(storagePath.getParent(), new FileAttribute[0]);
                    Path defaultLocation = DBeaverLauncher.getDefaultSecretStorageLocation();
                    if (Files.exists(defaultLocation, new LinkOption[0])) {
                        Files.copy(defaultLocation, storagePath, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.createFile(storagePath, new FileAttribute[0]);
                    }
                }
                return storagePath;
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        return null;
    }

    public static String getWorkingDirectory(String defaultWorkspaceLocation) {
        String workingDirectory;
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WIN")) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty(PROP_USER_HOME);
            }
            workingDirectory = appData + "\\" + defaultWorkspaceLocation;
        } else if (osName.contains("MAC")) {
            workingDirectory = System.getProperty(PROP_USER_HOME) + "/Library/" + defaultWorkspaceLocation;
        } else {
            Object dataHome = System.getProperty(PROP_XDG_DATA_HOME_UNIX);
            if (dataHome == null) {
                dataHome = System.getProperty(PROP_USER_HOME) + "/.local/share";
            }
            String badWorkingDir = (String)dataHome + "/." + defaultWorkspaceLocation;
            String goodWorkingDir = (String)dataHome + "/" + defaultWorkspaceLocation;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        return workingDirectory;
    }

    private String resolveEnv(String source, String var, String prop) {
        String value = System.getenv(prop);
        if (value == null) {
            value = "";
        }
        return value + source.substring(var.length());
    }

    private String resolveLocation(String source, String var, String location) {
        String result = location + source.substring(var.length());
        return result.replaceFirst("^~", System.getProperty(PROP_USER_HOME));
    }

    private String getProductProperties() throws IOException {
        Object productPath = "";
        URL installURL = this.getInstallLocation();
        if (installURL == null) {
            return null;
        }
        File installDir = new File(installURL.getFile());
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileInputStream inStream = new FileInputStream(eclipseProduct);){
                String appVersion;
                props.load(inStream);
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().isEmpty()) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SNAPSHOT_VERSION)) == null || appVersion.isBlank()) {
                    appVersion = props.getProperty(PRODUCT_SITE_VERSION);
                }
                if (appVersion == null || appVersion.trim().isEmpty()) {
                    appVersion = "";
                }
                productPath = appId + File.separator + appVersion;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return productPath;
    }

    private void processGlobalConfiguration() {
        try {
            Properties config = this.readGlobalConfiguration();
            String nlProperty = config.getProperty(DBEAVER_PROP_LANGUAGE);
            if (nlProperty == null || nlProperty.isBlank()) {
                nlProperty = "en";
            }
            DBeaverLauncher.setSystemPropertyIfNotSet(PROP_NL, nlProperty);
        }
        catch (IOException e) {
            this.log("Unable to read global configuration file: " + e.getMessage());
        }
    }

    private Properties readGlobalConfiguration() throws IOException {
        Path root = DBeaverLauncher.getDataDirectory();
        Path file = root.resolve(DBEAVER_CONFIG_FOLDER).resolve(DBEAVER_CONFIG_FILE);
        Properties properties = new Properties();
        if (Files.exists(file, new LinkOption[0])) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(file);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return properties;
    }

    private static void setSystemPropertyIfNotSet(String key, String value) {
        if (value == null || value.isBlank()) {
            return;
        }
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    private void processConfiguration() {
        Properties configuration;
        URL baseConfigurationLocation = null;
        Properties baseConfiguration = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            this.ensureAbsolute(PROP_BASE_CONFIG_AREA);
            String baseLocation = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (baseLocation != null) {
                baseConfigurationLocation = DBeaverLauncher.buildURL(baseLocation, true);
            }
            if (baseConfigurationLocation == null) {
                try {
                    baseConfigurationLocation = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((baseConfiguration = this.loadConfiguration(baseConfigurationLocation)) != null) {
                String location = baseConfiguration.getProperty(PROP_CONFIG_AREA);
                if (location != null) {
                    System.setProperty(PROP_CONFIG_AREA, location);
                }
                if ((location = baseConfiguration.getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.setProperty(PROP_INSTALL_AREA, location);
                }
            }
        }
        if ((configuration = baseConfiguration) == null || !this.getConfigurationLocation().equals(baseConfigurationLocation)) {
            configuration = this.loadConfiguration(this.getConfigurationLocation());
        }
        if (configuration != null && "false".equalsIgnoreCase(configuration.getProperty(PROP_CONFIG_CASCADED))) {
            System.clearProperty(PROP_SHARED_CONFIG_AREA);
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            this.mergeWithSystemProperties(configuration, null);
        } else {
            this.ensureAbsolute(PROP_SHARED_CONFIG_AREA);
            URL sharedConfigURL = this.buildLocation(PROP_SHARED_CONFIG_AREA, null, "");
            if (sharedConfigURL == null) {
                try {
                    sharedConfigURL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (sharedConfigURL != null) {
                if (sharedConfigURL.equals(this.getConfigurationLocation())) {
                    System.clearProperty(PROP_SHARED_CONFIG_AREA);
                    this.mergeWithSystemProperties(configuration, null);
                } else {
                    Properties sharedConfiguration = baseConfiguration;
                    if (!sharedConfigURL.equals(baseConfigurationLocation)) {
                        sharedConfiguration = this.loadConfiguration(sharedConfigURL);
                    }
                    long sharedConfigTimestamp = this.getCurrentConfigIniBaseTimestamp(sharedConfigURL);
                    long lastKnownBaseTimestamp = this.getLastKnownConfigIniBaseTimestamp();
                    if (this.debug) {
                        System.out.println("Timestamps found: \n\t config.ini in the base: " + sharedConfigTimestamp + "\n\t remembered " + lastKnownBaseTimestamp);
                    }
                    if (lastKnownBaseTimestamp == sharedConfigTimestamp || lastKnownBaseTimestamp == -1L) {
                        this.mergeWithSystemProperties(configuration, null);
                    } else {
                        configuration = null;
                        System.setProperty(PROP_IGNORE_USER_CONFIGURATION, Boolean.TRUE.toString());
                    }
                    this.mergeWithSystemProperties(sharedConfiguration, configuration);
                    System.setProperty(PROP_SHARED_CONFIG_AREA, sharedConfigURL.toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + sharedConfigURL.toExternalForm());
                    }
                }
            }
        }
        String urlString = System.getProperty(PROP_FRAMEWORK, null);
        if (urlString != null) {
            urlString = this.resolve(urlString);
            this.getInstallLocation();
            URL url = DBeaverLauncher.buildURL(urlString, true);
            urlString = url.toExternalForm();
            System.setProperty(PROP_FRAMEWORK, urlString);
            this.bootLocation = urlString;
        }
    }

    private long getCurrentConfigIniBaseTimestamp(URL url) {
        URLConnection connection;
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException malformedURLException) {
            return -1L;
        }
        try {
            connection = url.openConnection();
        }
        catch (IOException iOException) {
            return -1L;
        }
        return connection.getLastModified();
    }

    private long getLastKnownConfigIniBaseTimestamp() {
        Properties result;
        if (this.debug) {
            System.out.println("Loading timestamp file from:\n\t " + String.valueOf(this.getConfigurationLocation()) + "   .baseConfigIniTimestamp");
        }
        try {
            result = this.load(this.getConfigurationLocation(), BASE_TIMESTAMP_FILE_CONFIGINI);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println("\tNo timestamp file found");
            }
            return -1L;
        }
        String timestamp = result.getProperty(KEY_CONFIGINI_TIMESTAMP);
        return Long.parseLong(timestamp);
    }

    private void ensureAbsolute(String locationProperty) {
        URL locationURL;
        String propertyValue = System.getProperty(locationProperty);
        if (propertyValue == null) {
            return;
        }
        try {
            locationURL = new URL(propertyValue);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String locationPath = locationURL.getPath();
        if (locationPath.startsWith("/")) {
            return;
        }
        URL installURL = this.getInstallLocation();
        if (!locationURL.getProtocol().equals(installURL.getProtocol())) {
            return;
        }
        try {
            URL absoluteURL = new URL(installURL, locationPath);
            System.setProperty(locationProperty, absoluteURL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String installArea = System.getProperty(PROP_INSTALL_AREA);
        if (installArea != null) {
            if (installArea.startsWith(LAUNCHER_DIR)) {
                String launcher = System.getProperty(PROP_LAUNCHER);
                if (launcher == null) {
                    throw new IllegalStateException("Install location depends on launcher, but launcher is not defined");
                }
                installArea = installArea.replace(LAUNCHER_DIR, new File(launcher).getParent());
            }
            this.installLocation = DBeaverLauncher.buildURL(installArea, true);
            if (this.installLocation == null) {
                throw new IllegalStateException("Install location is invalid: " + installArea);
            }
            System.setProperty(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + String.valueOf(this.installLocation));
            }
            return this.installLocation;
        }
        ProtectionDomain domain = DBeaverLauncher.class.getProtectionDomain();
        CodeSource source = null;
        URL result = null;
        if (domain != null) {
            source = domain.getCodeSource();
        }
        if (source == null || domain == null) {
            if (this.debug) {
                System.out.println("CodeSource location is null. Defaulting the install location to file:startup.jar");
            }
            try {
                result = new URL("file:startup.jar");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (source != null) {
            result = source.getLocation();
        }
        String path = this.decode(result.getFile());
        File file = new File(path);
        path = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(path.charAt(0))) {
            char[] chars = path.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            path = new String(chars);
        }
        if (path.toLowerCase().endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf(47) + 1);
        }
        if (path.toLowerCase().endsWith("/plugins/")) {
            path = path.substring(0, path.length() - "/plugins/".length());
        }
        try {
            try {
                path = new File(path).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            this.installLocation = new URL(result.getProtocol(), result.getHost(), result.getPort(), path);
            System.setProperty(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.debug) {
            System.out.println("Install location:\n    " + String.valueOf(this.installLocation));
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL url) {
        Properties result;
        block6: {
            result = null;
            try {
                url = new URL(url, CONFIG_FILE);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + String.valueOf(url));
                }
                result = this.loadProperties(url);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return this.substituteVars(result);
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties result;
        if (url == null) {
            return null;
        }
        try {
            result = this.load(url, null);
        }
        catch (IOException e1) {
            IOException originalException = e1;
            try {
                result = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    result = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        return result;
    }

    private Properties load(URL url, String suffix) throws IOException {
        if (suffix != null && !suffix.isEmpty()) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + suffix);
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = this.getStream(url);){
            props.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return props;
    }

    private InputStream getStream(URL location) throws IOException {
        File f;
        if ("file".equalsIgnoreCase(location.getProtocol()) && (f = new File(location.getPath())).exists()) {
            return new FileInputStream(f);
        }
        return location.openStream();
    }

    private void handleSplash(URL[] defaultPath) {
        if (this.initialize || this.splashDown || this.bridge == null) {
            this.showSplash = false;
            this.endSplash = null;
            return;
        }
        if (this.showSplash || this.endSplash != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.splashHandler);
            }
            catch (Throwable throwable) {}
        }
        if (this.endSplash != null) {
            this.showSplash = false;
            return;
        }
        if (!this.showSplash) {
            return;
        }
        this.splashLocation = this.getSplashLocation(defaultPath);
        if (this.debug) {
            System.out.println("Splash location:\n    " + this.splashLocation);
        }
        if (this.splashLocation == null) {
            return;
        }
        this.bridge.setLauncherInfo(System.getProperty(PROP_LAUNCHER), System.getProperty(PROP_LAUNCHER_NAME));
        this.bridge.showSplash(this.splashLocation);
        long handle = this.bridge.getSplashHandle();
        if (handle != 0L && handle != -1L) {
            System.setProperty(SPLASH_HANDLE, String.valueOf(handle));
            System.setProperty(SPLASH_LOCATION, this.splashLocation);
            this.bridge.updateSplash();
        } else {
            this.splashDown = true;
        }
    }

    protected void takeDownSplash() {
        if (this.splashDown || this.bridge == null) {
            return;
        }
        this.splashDown = this.bridge.takeDownSplash();
        System.clearProperty(SPLASH_HANDLE);
        try {
            Runtime.getRuntime().removeShutdownHook(this.splashHandler);
        }
        catch (Throwable throwable) {}
    }

    private String getSplashLocation(URL[] bootPath) {
        if (this.splashLocation != null && !Character.isDigit(this.splashLocation.charAt(0)) && new File(this.splashLocation).exists()) {
            System.setProperty(PROP_SPLASHLOCATION, this.splashLocation);
            return this.splashLocation;
        }
        String result = System.getProperty(PROP_SPLASHLOCATION);
        if (result != null) {
            return result;
        }
        String splashPath = System.getProperty(PROP_SPLASHPATH);
        if (splashPath != null) {
            String[] entries = this.getArrayFromList(splashPath);
            ArrayList<String> path = new ArrayList<String>(entries.length);
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                String entry = this.resolve(e);
                if (entry != null && entry.startsWith(FILE_SCHEME)) {
                    File entryFile = new File(entry.substring(5).replace('/', File.separatorChar));
                    if ((entry = this.searchFor(entryFile.getName(), entryFile.getParent())) != null) {
                        path.add(entry);
                    }
                } else {
                    this.log("Invalid splash path entry: " + e);
                }
                ++n2;
            }
            result = this.searchForSplash(path.toArray(new String[0]));
            if (result != null) {
                System.setProperty(PROP_SPLASHLOCATION, result);
                return result;
            }
        }
        return result;
    }

    private String searchForSplash(String[] searchPath) {
        String[] nlVariants;
        if (searchPath == null) {
            return null;
        }
        String locale = System.getProperty(PROP_NL);
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        String[] stringArray = nlVariants = DBeaverLauncher.buildNLVariants(locale);
        int n = nlVariants.length;
        int n2 = 0;
        while (n2 < n) {
            String nlVariant = stringArray[n2];
            String[] stringArray2 = searchPath;
            int n3 = searchPath.length;
            int n4 = 0;
            while (n4 < n3) {
                Object path = stringArray2[n4];
                if (((String)path).startsWith(FILE_SCHEME)) {
                    path = ((String)path).substring(5);
                }
                if (this.isJAR((String)path)) {
                    result = this.extractFromJAR((String)path, nlVariant);
                    if (result != null) {
                        return result;
                    }
                } else {
                    if (!((String)path).endsWith(File.separator)) {
                        path = (String)path + File.separator;
                    }
                    if (((File)(result = new File((String)(path = (String)path + nlVariant)))).exists()) {
                        return ((File)result).getAbsolutePath();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractFromJAR(String jarPath, String jarEntry) {
        String configLocation = System.getProperty(PROP_CONFIG_AREA);
        if (configLocation == null) {
            this.log("Configuration area not set yet. Unable to extract " + jarEntry + " from JAR'd plug-in: " + jarPath);
            return null;
        }
        URL configURL = DBeaverLauncher.buildURL(configLocation, false);
        if (configURL == null) {
            return null;
        }
        File splash = new File(configURL.getPath(), PLUGIN_ID);
        File jarFile = new File(jarPath);
        String cache = jarFile.getName();
        if (cache.endsWith(".jar")) {
            cache = cache.substring(0, cache.length() - 4);
        }
        splash = new File(splash, cache);
        if ((splash = new File(splash, jarEntry)).exists()) {
            boolean clean = false;
            String[] stringArray = this.commands;
            int n = this.commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                if (CLEAN.equalsIgnoreCase(command)) {
                    clean = true;
                    splash.delete();
                    break;
                }
                ++n2;
            }
            if (!clean) {
                return splash.getAbsolutePath();
            }
        }
        try {
            Throwable clean = null;
            Object var9_17 = null;
            try (ZipFile file = new ZipFile(jarPath);){
                String string;
                ZipEntry entry = file.getEntry(jarEntry.replace(File.separatorChar, '/'));
                if (entry == null) {
                    return null;
                }
                Path outputFile = splash.toPath();
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                try {
                    Throwable throwable = null;
                    Object var14_22 = null;
                    try (InputStream input = file.getInputStream(entry);){
                        Files.copy(input, outputFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log("Exception opening splash: " + entry.getName() + " in JAR file: " + jarPath);
                    this.log(e);
                    if (file == null) return null;
                    file.close();
                    return null;
                }
                if (splash.exists()) {
                    string = splash.getAbsolutePath();
                    return string;
                }
                string = null;
                return string;
            }
            catch (Throwable throwable) {
                if (clean == null) {
                    clean = throwable;
                    throw clean;
                }
                if (clean == throwable) throw clean;
                clean.addSuppressed(throwable);
                throw clean;
            }
        }
        catch (IOException e) {
            this.log("Exception looking for " + jarEntry + " in JAR file: " + jarPath);
            this.log(e);
            return null;
        }
    }

    private boolean isJAR(String path) {
        return new File(path).isFile();
    }

    private static String[] buildNLVariants(String locale) {
        String nl = locale;
        ArrayList<CallSite> result = new ArrayList<CallSite>(4);
        while (true) {
            String[] stringArray = SPLASH_IMAGES;
            int n = SPLASH_IMAGES.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                result.add((CallSite)((Object)(DBEAVER_PROP_LANGUAGE + File.separatorChar + nl.replace('_', File.separatorChar) + File.separatorChar + name)));
                ++n2;
            }
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        Collections.addAll(result, SPLASH_IMAGES);
        return result.toArray(new String[0]);
    }

    private String resolve(String urlString) {
        if (urlString.startsWith(REFERENCE_SCHEME)) {
            urlString = urlString.substring(10);
        }
        if (urlString.startsWith(PLATFORM_URL)) {
            String path = urlString.substring(PLATFORM_URL.length());
            return String.valueOf(this.getInstallLocation()) + path;
        }
        return urlString;
    }

    protected synchronized void log(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            try {
                this.openLogFile();
                try {
                    if (this.newSession) {
                        this.log.write(SESSION);
                        this.log.write(32);
                        String timestamp = new Date().toString();
                        this.log.write(timestamp);
                        this.log.write(32);
                        int i = SESSION.length() + timestamp.length();
                        while (i < 78) {
                            this.log.write(45);
                            ++i;
                        }
                        this.log.newLine();
                        this.newSession = false;
                    }
                    this.write(obj);
                }
                finally {
                    if (this.logFile == null) {
                        if (this.log != null) {
                            this.log.flush();
                        }
                    } else {
                        this.closeLogFile();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("An exception occurred while writing to the platform log:");
                e.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.log = this.logForStream(System.err);
                    this.write(obj);
                    this.log.flush();
                }
                catch (Exception e2) {
                    System.err.println("An exception occurred while logging to the console:");
                    e2.printStackTrace(System.err);
                }
                this.log = null;
            }
        }
        finally {
            this.log = null;
        }
    }

    private void write(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Throwable) {
            this.log.write(STACK);
            this.log.newLine();
            ((Throwable)obj).printStackTrace(new PrintWriter(this.log));
        } else {
            this.log.write(ENTRY);
            this.log.write(32);
            this.log.write(PLUGIN_ID);
            this.log.write(32);
            this.log.write(String.valueOf(4));
            this.log.write(32);
            this.log.write(String.valueOf(0));
            this.log.write(32);
            this.log.write(this.getDate(new Date()));
            this.log.newLine();
            this.log.write(MESSAGE);
            this.log.write(32);
            this.log.write(String.valueOf(obj));
        }
        this.log.newLine();
    }

    protected String getDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        StringBuilder sb = new StringBuilder();
        this.appendPaddedInt(c.get(1), 4, sb).append('-');
        this.appendPaddedInt(c.get(2) + 1, 2, sb).append('-');
        this.appendPaddedInt(c.get(5), 2, sb).append(' ');
        this.appendPaddedInt(c.get(11), 2, sb).append(':');
        this.appendPaddedInt(c.get(12), 2, sb).append(':');
        this.appendPaddedInt(c.get(13), 2, sb).append('.');
        this.appendPaddedInt(c.get(14), 3, sb);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuilder appendPaddedInt(int value, int pad, StringBuilder buffer) {
        if (--pad == 0) {
            return buffer.append(value);
        }
        padding = (int)Math.pow(10.0, pad);
        if (value < padding) ** GOTO lbl9
        return buffer.append(value);
lbl-1000:
        // 1 sources

        {
            buffer.append('0');
            padding /= 10;
lbl9:
            // 2 sources

            ** while (padding > value && padding > 1)
        }
lbl10:
        // 1 sources

        buffer.append(value);
        return buffer;
    }

    private void computeLogFileLocation() {
        String logFileProp = System.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            if (this.logFile == null || !logFileProp.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(logFileProp);
                new File(this.logFile.getParent()).mkdirs();
            }
            return;
        }
        URL base = DBeaverLauncher.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (base == null) {
            return;
        }
        this.logFile = new File(base.getPath(), System.currentTimeMillis() + ".log");
        new File(this.logFile.getParent()).mkdirs();
        System.setProperty(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.logFile = null;
            throw e;
        }
    }

    private BufferedWriter logForStream(OutputStream output) {
        return new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        finally {
            this.log = null;
        }
    }

    private void mergeWithSystemProperties(Properties source, Properties userConfiguration) {
        if (source == null) {
            return;
        }
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(PROP_CLASSPATH)) {
                Object destinationClasspath = System.getProperty(PROP_CLASSPATH);
                String sourceClasspath = source.getProperty(PROP_CLASSPATH);
                destinationClasspath = destinationClasspath == null ? sourceClasspath : (String)destinationClasspath + sourceClasspath;
                System.setProperty(PROP_CLASSPATH, (String)destinationClasspath);
                continue;
            }
            String value = source.getProperty(key);
            if (userConfiguration != null && !key.endsWith(".override.user")) {
                boolean shouldOverride;
                String overrideKey = key + ".override.user";
                boolean bl = shouldOverride = System.getProperty(overrideKey) != null || source.getProperty(overrideKey) != null;
                if (shouldOverride && !userConfiguration.contains(key)) {
                    System.setProperty(key, value);
                    continue;
                }
            }
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value);
        }
    }

    private void setupVMProperties() {
        if (this.vmargs != null && Stream.of(this.vmargs).noneMatch(arg -> arg.startsWith("-Declipse.log.include.commandline"))) {
            this.vmargs = Arrays.copyOf(this.vmargs, this.vmargs.length + 1);
            this.vmargs[this.vmargs.length - 1] = "-Declipse.log.include.commandline=false";
        }
        if (this.vm != null) {
            System.setProperty(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String property, String[] values) {
        if (values != null) {
            StringBuilder result = new StringBuilder(300);
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null) {
                    result.append(value);
                    result.append('\n');
                }
                ++n2;
            }
            System.setProperty(property, result.toString());
        }
    }

    private Properties substituteVars(Properties result) {
        if (result == null) {
            return null;
        }
        Enumeration<Object> eKeys = result.keys();
        while (eKeys.hasMoreElements()) {
            String value;
            Object key = eKeys.nextElement();
            if (!(key instanceof String) || (value = result.getProperty((String)key)) == null) continue;
            result.put(key, DBeaverLauncher.substituteVars(value));
        }
        return result;
    }

    public static String substituteVars(String path) {
        StringBuilder buf = new StringBuilder(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && !var.isEmpty()) {
                    prop = System.getProperty(var);
                }
                if (prop == null) {
                    prop = System.getenv(var);
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append('$');
                    buf.append(var == null ? "" : var);
                    buf.append('$');
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    private static /* synthetic */ HttpResponse.BodySubscriber lambda$3(HttpResponse.ResponseInfo response) {
        return HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
    }

    private static /* synthetic */ String lambda$5(String arg) {
        return "\"" + LauncherUtils.escape(arg) + "\"";
    }

    static class Identifier {
        private static final String DELIM = ". _-";
        private int major;
        private int minor;
        private int service;

        Identifier(String versionString) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, DELIM);
            if (tokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(tokenizer.nextToken());
            }
            try {
                if (tokenizer.hasMoreTokens()) {
                    this.minor = Integer.parseInt(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    this.service = Integer.parseInt(tokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        boolean isGreaterEqualTo(Identifier minimum) {
            if (this.major < minimum.major) {
                return false;
            }
            if (this.major > minimum.major) {
                return true;
            }
            if (this.minor < minimum.minor) {
                return false;
            }
            if (this.minor > minimum.minor) {
                return true;
            }
            return this.service >= minimum.service;
        }
    }

    public final class SplashHandler
    extends Thread {
        @Override
        public void run() {
            DBeaverLauncher.this.takeDownSplash();
        }

        public void updateSplash() {
            if (DBeaverLauncher.this.bridge != null && !DBeaverLauncher.this.splashDown) {
                DBeaverLauncher.this.bridge.updateSplash();
            }
        }
    }

    public class StartupClassLoader
    extends URLClassLoader {
        public StartupClassLoader(URL[] urls) {
            super(urls);
        }

        public StartupClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public StartupClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        @Override
        protected String findLibrary(String name) {
            if (DBeaverLauncher.this.extensionPaths == null) {
                return super.findLibrary(name);
            }
            String libName = System.mapLibraryName(name);
            String[] stringArray = DBeaverLauncher.this.extensionPaths;
            int n = DBeaverLauncher.this.extensionPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionPath = stringArray[n2];
                File libFile = new File(extensionPath, libName);
                if (libFile.isFile()) {
                    return libFile.getAbsolutePath();
                }
                ++n2;
            }
            return super.findLibrary(name);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected URL findResource(String moduleName, String name) {
            return this.findResource(name);
        }

        @Override
        protected Class<?> findClass(String moduleName, String name) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

