## Commit Checklist

Thank you for creating a pull request! To help us review / merge this can you make sure that your PR adheres as much as possible to the following.

### The Basics

- Commit is a single logical unit of work, only use multiple commits if doing different tasks
- Commit does not include commented out code or unneeded files
- rebase of main branch

### The Content

- Must include testing for bug or feature
- Must include appropriate documentation changes if it is introducing a new feature or changing existing functionality
- Must pass existing test suites

### The Commit Message

- Short meaningful description (ex: remove deprecated steps)
- Uses the imperative, present tense: "change", not "changed" or "changes"
- Includes motivation for the change, and contrasts its implementation with the previous behavior

### The Pull Request

- What is the reason for this change
- Example usage of the failure for a bug, or configuration and expected output for a feature
- Steps to test the change
