/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;

public class SuppressIfAnyRuleMatchesFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        List<String> ruleIDs = Arrays.asList(this.getRequired("ruleIDs", arguments).split(","));
        JLanguageTool lt = ((PatternRule)match.getRule()).getLanguage().createDefaultJLanguageTool();
        String sentence = match.getSentence().getText();
        for (String replacement : match.getSuggestedReplacements()) {
            String newSentence = sentence.substring(0, match.getFromPos()) + replacement + sentence.substring(match.getToPos());
            AnalyzedSentence analyzedSentence = lt.analyzeText(newSentence).get(0);
            for (Rule r : lt.getAllActiveRules()) {
                RuleMatch[] matches;
                if (!ruleIDs.contains(r.getId())) continue;
                for (RuleMatch m : matches = r.match(analyzedSentence)) {
                    if ((m.getToPos() < match.getFromPos() || m.getToPos() > match.getToPos()) && (match.getToPos() < m.getFromPos() || match.getToPos() > m.getToPos())) continue;
                    return null;
                }
            }
        }
        return match;
    }
}

