/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python.utils;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.python.utils.SdkUtils;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlArrayTable;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeyValue;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0015H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u001e\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u001a\u0010\b\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\"\u001a\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\"\u001a\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006 "}, d2={"UV_LOCK", "", "REQUIREMENTS_TXT", "poetryLockFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/module/Module;", "getPoetryLockFile", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "pipFile", "getPipFile", "pyProjectToml", "getPyProjectToml", "uvLockFile", "getUvLockFile", "sourceRootDirectories", "", "module", "sourceDirectories", "pkg", "Lcom/intellij/packageChecker/model/Package;", "declaredVersion", "Lcom/jetbrains/python/packaging/PyRequirement;", "toPackage", "project", "Lcom/intellij/openapi/project/Project;", "parseTomlNameAndVersionOfPackage", "Lkotlin/Pair;", "packageTable", "Lorg/toml/lang/psi/TomlArrayTable;", "parseLockFilePackages", "lockFile", "Lorg/toml/lang/psi/TomlFile;", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/packageChecker/python/utils/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,144:1\n3829#2:145\n4344#2,2:146\n4135#2,11:148\n13472#2,2:203\n774#3:159\n865#3,2:160\n1617#3,9:162\n1869#3:171\n1870#3:173\n1626#3:174\n1617#3,9:175\n1869#3:184\n1617#3,9:187\n1869#3:196\n1870#3:198\n1626#3:199\n1870#3:201\n1626#3:202\n1#4:172\n1#4:186\n1#4:197\n1#4:200\n57#5:185\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/packageChecker/python/utils/UtilsKt\n*L\n48#1:145\n48#1:146,2\n138#1:148,11\n116#1:203,2\n139#1:159\n139#1:160,2\n140#1:162,9\n140#1:171\n140#1:173\n140#1:174\n63#1:175,9\n63#1:184\n76#1:187,9\n76#1:196\n76#1:198\n76#1:199\n63#1:201\n63#1:202\n140#1:172\n71#1:186\n76#1:197\n63#1:200\n71#1:185\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String UV_LOCK = "uv.lock";
    @NotNull
    public static final String REQUIREMENTS_TXT = "requirements.txt";

    @Nullable
    public static final VirtualFile getPoetryLockFile(@NotNull Module $this$poetryLockFile) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryLockFile, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$poetryLockFile);
        return virtualFile != null ? virtualFile.findChild("poetry.lock") : null;
    }

    @Nullable
    public static final VirtualFile getPipFile(@NotNull Module $this$pipFile) {
        Intrinsics.checkNotNullParameter((Object)$this$pipFile, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$pipFile);
        return virtualFile != null ? virtualFile.findChild("Pipfile") : null;
    }

    @Nullable
    public static final VirtualFile getPyProjectToml(@NotNull Module $this$pyProjectToml) {
        Intrinsics.checkNotNullParameter((Object)$this$pyProjectToml, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$pyProjectToml);
        return virtualFile != null ? virtualFile.findChild("pyproject.toml") : null;
    }

    @Nullable
    public static final VirtualFile getUvLockFile(@NotNull Module $this$uvLockFile) {
        Intrinsics.checkNotNullParameter((Object)$this$uvLockFile, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$uvLockFile);
        return virtualFile != null ? virtualFile.findChild(UV_LOCK) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> sourceRootDirectories(@NotNull Module module) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = SdkUtils.INSTANCE.getSdk(module);
        if (sdk != null) {
            void $this$filterTo$iv$iv;
            Sdk sdk2 = sdk;
            boolean bl = false;
            VirtualFile[] virtualFileArray = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"site-packages")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<VirtualFile> sourceDirectories(@NotNull List<? extends VirtualFile> sourceDirectories, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter(sourceDirectories, (String)"sourceDirectories");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        if (sourceDirectories.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object object = ReadAction.compute(() -> UtilsKt.sourceDirectories$lambda$7(sourceDirectories, pkg));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    @NotNull
    public static final String declaredVersion(@NotNull PyRequirement $this$declaredVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$declaredVersion, (String)"<this>");
        List list = $this$declaredVersion.getVersionSpecs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVersionSpecs(...)");
        List specs = list;
        if (specs.size() > 1) {
            return "0.0.0-ANY";
        }
        PyRequirementVersionSpec pyRequirementVersionSpec = (PyRequirementVersionSpec)CollectionsKt.firstOrNull((List)specs);
        if (pyRequirementVersionSpec == null) {
            return "0.0.0-ANY";
        }
        PyRequirementVersionSpec versionSpec = pyRequirementVersionSpec;
        if (versionSpec.getRelation() == PyRequirementRelation.EQ) {
            String string = versionSpec.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            return string;
        }
        return "0.0.0-ANY";
    }

    @NotNull
    public static final Package toPackage(@NotNull PyRequirement $this$toPackage, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = $this$toPackage.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return Package.Companion.create(project, PackageType.pypi, null, string, UtilsKt.declaredVersion($this$toPackage));
    }

    @Nullable
    public static final Pair<String, String> parseTomlNameAndVersionOfPackage(@NotNull TomlArrayTable packageTable) {
        Intrinsics.checkNotNullParameter((Object)packageTable, (String)"packageTable");
        return (Pair)ReadAction.compute(() -> UtilsKt.parseTomlNameAndVersionOfPackage$lambda$9(packageTable));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Package> parseLockFilePackages(@NotNull Project project, @NotNull TomlFile lockFile) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lockFile, (String)"lockFile");
        Object object = ReadAction.compute(() -> UtilsKt.parseLockFilePackages$lambda$10(lockFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        Object[] $this$filterIsInstance$iv = (Object[])object;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TomlArrayTable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TomlArrayTable it = (TomlArrayTable)element$iv$iv;
            boolean bl = false;
            TomlKey tomlKey = it.getHeader().getKey();
            if (!Intrinsics.areEqual((Object)(tomlKey != null ? tomlKey.getText() : null), (Object)"package")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package package_;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TomlArrayTable packageTable = (TomlArrayTable)element$iv$iv;
            boolean bl2 = false;
            if (UtilsKt.parseTomlNameAndVersionOfPackage(packageTable) == null) {
                package_ = null;
            } else {
                Pair<String, String> pair;
                String name = (String)pair.component1();
                String version = (String)pair.component2();
                package_ = Package.Companion.create(project, PackageType.pypi, null, name, version);
            }
            if (package_ == null) continue;
            Package it$iv$iv = package_;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean sourceDirectories$lambda$7$lambda$6$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List sourceDirectories$lambda$7(List $sourceDirectories, Package $pkg) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $sourceDirectories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            VirtualFile topLevelFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile sourceRoot = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            String possibleFolderName = StringsKt.replace$default((String)$pkg.getName(), (String)"-", (String)"_", (boolean)false, (int)4, null) + "-" + $pkg.getVersion() + ".dist-info";
            VirtualFile metadataDirectory = VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)possibleFolderName);
            if (metadataDirectory != null && (topLevelFile = metadataDirectory.findChild("top_level.txt")) != null && topLevelFile.exists()) {
                void $this$mapNotNullTo$iv$iv2;
                Object it$iv;
                void $this$useLines$iv;
                InputStream inputStream = topLevelFile.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable = inputStream;
                Charset charset = Charsets.UTF_8;
                Object object = new InputStreamReader((InputStream)closeable, charset);
                int n = 8192;
                closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean $i$f$useLines = false;
                object = $this$useLines$iv;
                n = 8192;
                object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                Throwable throwable = null;
                try {
                    it$iv = (BufferedReader)object;
                    boolean bl3 = false;
                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl4 = false;
                    it$iv = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)lines, UtilsKt::sourceDirectories$lambda$7$lambda$6$lambda$3$lambda$2));
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Object directoryNames = it$iv;
                Iterable $this$mapNotNull$iv2 = (Iterable)directoryNames;
                boolean $i$f$mapNotNull2 = false;
                object = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    String name = (String)element$iv$iv2;
                    boolean bl5 = false;
                    if (VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)name) == null) continue;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else if (VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)$pkg.getName()) != null) {
                VirtualFile it;
                boolean bl7 = false;
                list = CollectionsKt.listOf((Object)it);
            } else {
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    private static final Pair parseTomlNameAndVersionOfPackage$lambda$9(TomlArrayTable $packageTable) {
        if (!$packageTable.isValid()) {
            return null;
        }
        String name = null;
        String version = null;
        Object[] $this$forEach$iv = PyAstElementKt.findChildrenByClass((PsiElement)((PsiElement)$packageTable), TomlKeyValue.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tomlValue;
            TomlKeyValue tomlKeyValue = (TomlKeyValue)element$iv;
            boolean bl = false;
            String tomlKey = tomlKeyValue.getKey().getText();
            if (!Intrinsics.areEqual((Object)tomlKey, (Object)"name") && !Intrinsics.areEqual((Object)tomlKey, (Object)"version")) continue;
            Object object = tomlKeyValue.getValue();
            String string = object != null && (object = object.getText()) != null ? StringsKt.replace$default((String)object, (String)"\"", (String)"", (boolean)false, (int)4, null) : (tomlValue = null);
            if (Intrinsics.areEqual((Object)tomlKey, (Object)"name")) {
                name = tomlValue;
                continue;
            }
            version = tomlValue;
        }
        if (name != null && version != null) {
            return new Pair(name, version);
        }
        return null;
    }

    private static final PsiElement[] parseLockFilePackages$lambda$10(TomlFile $lockFile) {
        return $lockFile.getChildren();
    }
}

