/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.codeInsight.typing.PyStubPackagesInstallingStatus;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "ignoredStubPackages", "", "", "getIgnoredStubPackages$annotations", "getIgnoredStubPackages", "()Ljava/util/List;", "setIgnoredStubPackages", "(Ljava/util/List;)V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Lorg/jetbrains/annotations/NotNull;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "Visitor", "intellij.python.community.impl"})
public final class PyStubPackagesCompatibilityInspection
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<String> ignoredStubPackages = new ArrayList();

    @NotNull
    public final List<String> getIgnoredStubPackages() {
        return this.ignoredStubPackages;
    }

    public final void setIgnoredStubPackages(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.ignoredStubPackages = list;
    }

    public static /* synthetic */ void getIgnoredStubPackages$annotations() {
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.stringList((String)"ignoredStubPackages", (String)PyPsiBundle.message("INSP.stub.packages.compatibility.ignored.packages.label", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(this.ignoredStubPackages, holder, typeEvalContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Companion;", "", "<init>", "()V", "findIncompatibleRuntimeToStubPackages", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/packaging/PyPackage;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "stubPkgsFilter", "Lkotlin/Function1;", "", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyStubPackagesCompatibilityInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStubPackagesCompatibilityInspection.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1869#2,2:120\n295#2,2:123\n1#3:122\n*S KotlinDebug\n*F\n+ 1 PyStubPackagesCompatibilityInspection.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Companion\n*L\n36#1:120,2\n47#1:123,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Pair<PyPackage, PyPackage>> findIncompatibleRuntimeToStubPackages(@NotNull Sdk sdk2, @NotNull Function1<? super PyPackage, Boolean> stubPkgsFilter) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Intrinsics.checkNotNullParameter(stubPkgsFilter, (String)"stubPkgsFilter");
            List<PyPackage> list = PyPackageManager.getInstance(sdk2).getPackages();
            if (list == null) {
                return CollectionsKt.emptyList();
            }
            List<PyPackage> installedPackages2 = list;
            if (installedPackages2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Map nameToPkg = new LinkedHashMap();
            Iterable $this$forEach$iv = installedPackages2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyPackage it = (PyPackage)((Object)element$iv);
                boolean bl = false;
                nameToPkg.put(it.getName(), it);
            }
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)installedPackages2), arg_0 -> Companion.findIncompatibleRuntimeToStubPackages$lambda$1(stubPkgsFilter, arg_0)), arg_0 -> Companion.findIncompatibleRuntimeToStubPackages$lambda$3(nameToPkg, arg_0)), Companion::findIncompatibleRuntimeToStubPackages$lambda$5));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean findIncompatibleRuntimeToStubPackages$lambda$1(Function1 $stubPkgsFilter, PyPackage it) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!PyStubPackages.isStubPackage(string)) return false;
            Intrinsics.checkNotNull((Object)((Object)it));
            if ((Boolean)$stubPkgsFilter.invoke((Object)it) == false) return false;
            return true;
        }

        private static final Pair findIncompatibleRuntimeToStubPackages$lambda$3(Map $nameToPkg, PyPackage stubPkg) {
            Pair pair;
            String string = stubPkg.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PyPackage pyPackage = (PyPackage)((Object)$nameToPkg.get(PyStubPackages.stubPackageToPackage(string)));
            if (pyPackage != null) {
                PyPackage it = pyPackage;
                boolean bl = false;
                pair = TuplesKt.to((Object)((Object)it), (Object)((Object)stubPkg));
            } else {
                pair = null;
            }
            return pair;
        }

        private static final boolean findIncompatibleRuntimeToStubPackages$lambda$5(Pair it) {
            Object v2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = ((PyPackage)((Object)it.getFirst())).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String runtimePkgName = string;
                List<PyRequirement> list = ((PyPackage)((Object)it.getSecond())).getRequirements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRequirements(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PyRequirement req = (PyRequirement)element$iv;
                    boolean bl = false;
                    if (!req.equals(runtimePkgName)) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            PyRequirement pyRequirement = v2;
            if (pyRequirement == null) {
                return false;
            }
            PyRequirement requirement = pyRequirement;
            return requirement.match(CollectionsKt.listOf((Object)it.getFirst())) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "ignoredStubPackages", "", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Ljava/util/List;Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getIgnoredStubPackages", "()Ljava/util/List;", "visitPyFile", "", "node", "Lcom/jetbrains/python/psi/PyFile;", "createIgnoreStubPackageQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "stubPkgName", "ignoredStubPkgs", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyStubPackagesCompatibilityInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStubPackagesCompatibilityInspection.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n1869#2,2:120\n1869#2:124\n295#2,2:125\n1870#2:127\n30#3,2:122\n*S KotlinDebug\n*F\n+ 1 PyStubPackagesCompatibilityInspection.kt\ncom/jetbrains/python/codeInsight/typing/PyStubPackagesCompatibilityInspection$Visitor\n*L\n79#1:120,2\n89#1:124\n91#1:125,2\n89#1:127\n81#1:122,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        @NotNull
        private final List<String> ignoredStubPackages;

        public Visitor(@NotNull List<String> ignoredStubPackages, @NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter(ignoredStubPackages, (String)"ignoredStubPackages");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
            this.ignoredStubPackages = ignoredStubPackages;
        }

        @NotNull
        public final List<String> getIgnoredStubPackages() {
            return this.ignoredStubPackages;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyFile(@NotNull PyFile node) {
            void $this$forEach$iv;
            List installedPackages2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Module module2 = ModuleUtilCore.findModuleForFile((PsiFile)node);
            if (module2 == null) {
                return;
            }
            Module module3 = module2;
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module3);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            List list = PyPackageManager.getInstance(sdk3).getPackages();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if ((installedPackages2 = list).isEmpty()) {
                return;
            }
            Map nameToPkg = new LinkedHashMap();
            Iterable $this$forEach$iv2 = installedPackages2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                PyPackage it = (PyPackage)((Object)element$iv);
                boolean bl = false;
                nameToPkg.put(it.getName(), it);
            }
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PyStubPackagesInstallingStatus> serviceClass$iv = PyStubPackagesInstallingStatus.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            PyStubPackagesInstallingStatus status = (PyStubPackagesInstallingStatus)object;
            $this$service$iv = Companion.findIncompatibleRuntimeToStubPackages(sdk3, (Function1<? super PyPackage, Boolean>)((Function1)arg_0 -> Visitor.visitPyFile$lambda$2(status, this, arg_0)));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String message;
                String specsToString;
                String stubPkgName;
                PyRequirement requirement;
                Object v6;
                String runtimePkgName;
                PyPackage stubPkg;
                PyPackage runtimePkg;
                block8: {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    runtimePkg = (PyPackage)((Object)pair.component1());
                    stubPkg = (PyPackage)((Object)pair.component2());
                    Intrinsics.checkNotNullExpressionValue((Object)runtimePkg.getName(), (String)"getName(...)");
                    List<PyRequirement> list2 = stubPkg.getRequirements();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getRequirements(...)");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        PyRequirement it = (PyRequirement)element$iv2;
                        boolean bl2 = false;
                        if (!it.equals(runtimePkgName)) continue;
                        v6 = element$iv2;
                        break block8;
                    }
                    v6 = null;
                }
                if ((PyRequirement)v6 == null || requirement.match(CollectionsKt.listOf((Object)((Object)runtimePkg))) != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)stubPkg.getName(), (String)"getName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.join((Collection)requirement.getVersionSpecs(), arg_0 -> Visitor.visitPyFile$lambda$6$lambda$5(Visitor::visitPyFile$lambda$6$lambda$4, arg_0), (String)", "), (String)"join(...)");
                Object[] objectArray = new Object[]{stubPkgName, PyRequirementRelation.EQ.getPresentableText(), stubPkg.getVersion(), runtimePkgName, PyRequirementRelation.EQ.getPresentableText(), runtimePkg.getVersion(), runtimePkgName, specsToString};
                Intrinsics.checkNotNullExpressionValue((Object)PyPsiBundle.message("INSP.stub.packages.compatibility.incompatible.packages.message", objectArray), (String)"message(...)");
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PyInterpreterInspection.InterpreterSettingsQuickFix(module3), this.createIgnoreStubPackageQuickFix(stubPkgName, this.ignoredStubPackages)};
                this.registerProblem((PsiElement)node, message, localQuickFixArray);
            }
        }

        private final LocalQuickFix createIgnoreStubPackageQuickFix(String stubPkgName, List<String> ignoredStubPkgs) {
            return new LocalQuickFix(stubPkgName, ignoredStubPkgs){
                final /* synthetic */ String $stubPkgName;
                final /* synthetic */ List<String> $ignoredStubPkgs;
                {
                    this.$stubPkgName = $stubPkgName;
                    this.$ignoredStubPkgs = $ignoredStubPkgs;
                }

                public String getFamilyName() {
                    Object[] objectArray = new Object[]{this.$stubPkgName};
                    String string = PyPsiBundle.message("INSP.stub.packages.compatibility.ignore", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                public void applyFix(Project project, ProblemDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    if (this.$ignoredStubPkgs.add(this.$stubPkgName)) {
                        ProjectInspectionProfileManager.Companion.getInstance(project).fireProfileChanged();
                    }
                }
            };
        }

        private static final boolean visitPyFile$lambda$2(PyStubPackagesInstallingStatus $status, Visitor this$0, PyPackage stubPkg) {
            Intrinsics.checkNotNullParameter((Object)((Object)stubPkg), (String)"stubPkg");
            String it = stubPkg.getName();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            return !$status.markedAsInstalling(it) && !this$0.ignoredStubPackages.contains(it);
        }

        private static final String visitPyFile$lambda$6$lambda$4(PyRequirementVersionSpec it) {
            return it.getPresentableText();
        }

        private static final String visitPyFile$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    }
}

