/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.pydev;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import java.util.List;

public abstract class AbstractConsoleCommunication
implements ConsoleCommunication {
    public static final int MAX_ATTEMPTS = 3;
    public static final long TIMEOUT = 10000000000L;
    private VirtualFile myConsoleFile;
    protected final Project myProject;
    public volatile boolean waitingForInput;
    private final List<ConsoleCommunicationListener> communicationListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public AbstractConsoleCommunication(Project project) {
        this.myProject = project;
    }

    public static Pair<String, Boolean> parseExecResponseString(String str) {
        boolean more;
        String errorContents = null;
        String lower = StringUtil.toLowerCase((String)str);
        if (lower.equals("true") || lower.equals("1")) {
            more = true;
        } else if (lower.equals("false") || lower.equals("0")) {
            more = false;
        } else {
            more = false;
            errorContents = str;
        }
        return Pair.create(errorContents, (Object)more);
    }

    @Override
    public boolean isWaitingForInput() {
        return this.waitingForInput;
    }

    @Override
    public void addCommunicationListener(ConsoleCommunicationListener listener2) {
        this.communicationListeners.add(listener2);
    }

    @Override
    public void notifyCommandExecuted(boolean more) {
        for (ConsoleCommunicationListener listener2 : this.communicationListeners) {
            listener2.commandExecuted(more);
        }
    }

    @Override
    public void notifyInputRequested() {
        for (ConsoleCommunicationListener listener2 : this.communicationListeners) {
            listener2.inputRequested();
        }
    }

    public VirtualFile getConsoleFile() {
        return this.myConsoleFile;
    }

    public void setConsoleFile(VirtualFile consoleFile) {
        this.myConsoleFile = consoleFile;
    }

    @Override
    public void notifyInputReceived() {
        if (this.waitingForInput) {
            this.waitingForInput = false;
            for (ConsoleCommunicationListener listener2 : this.communicationListeners) {
                listener2.commandExecuted(false);
            }
        }
    }
}

