/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.DiffContext;
import com.intellij.diff.editor.DiffRequestProcessorEditorCustomizer;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffRequestProcessor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffRequestProcessorEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "processor", "Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffRequestProcessor;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffRequestProcessor;)V", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "dispose", "", "isValid", "", "getFile", "getName", "", "selectNotify", "intellij.platform.vcs.frontend.split"})
final class FrontendDiffRequestProcessorEditor
extends FileEditorBase {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final FrontendDiffRequestProcessor processor;

    public FrontendDiffRequestProcessorEditor(@NotNull VirtualFile file, @NotNull FrontendDiffRequestProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)processor2), (String)"processor");
        this.file = file;
        this.processor = processor2;
        Disposer.register((Disposable)((Disposable)this.processor), () -> FrontendDiffRequestProcessorEditor._init_$lambda$0(this));
        FileEditor fileEditor = (FileEditor)this;
        DiffContext diffContext = this.processor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)diffContext, (String)"<get-context>(...)");
        DiffRequestProcessorEditorCustomizer.Companion.customize(this.file, fileEditor, diffContext);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.processor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"<get-component>(...)");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.processor.getPreferredFocusedComponent();
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.processor));
        super.dispose();
    }

    public boolean isValid() {
        return !this.processor.isDisposed();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public String getName() {
        String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void selectNotify() {
        this.processor.updateRequest();
    }

    private static final void _init_$lambda$0(FrontendDiffRequestProcessorEditor this$0) {
        String string = FileEditor.getPropValid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropValid(...)");
        this$0.firePropertyChange(string, true, false);
    }
}

