/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditComputed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditContextComposed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditDiffAccepted;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditDiffContent;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditDiffShown;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditJumpAccepted;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditJumpShown;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditModelResponse;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditPerformanceMetrics;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditPromptComposed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditProviderPerformanceMetrics;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditProviderSelected;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinishType;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinished;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionInvalidState;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTargetFile;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTriggerReason;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTriggered;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 r2\u00020\u0001:\u0001rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020#J\u0006\u00104\u001a\u00020/J\u000e\u00105\u001a\u00020/2\u0006\u0010$\u001a\u00020\u001eJ\u000e\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020\u001eJ\u000e\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020\u001eJ\u0015\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020<\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020<\u00a2\u0006\u0004\bA\u0010>J\u0015\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020<\u00a2\u0006\u0004\bD\u0010>J\u0015\u0010E\u001a\u00020/2\u0006\u0010F\u001a\u00020<\u00a2\u0006\u0004\bG\u0010>J\u000e\u0010H\u001a\u00020/2\u0006\u00109\u001a\u00020\u001eJ\u000e\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020\u001eJ\u0016\u0010K\u001a\u00020/2\u0006\u0010L\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\u001eJ\u001e\u0010N\u001a\u00020/2\u0006\u0010O\u001a\u00020P2\u0006\u0010\u0018\u001a\u00020P2\u0006\u0010\u0019\u001a\u00020PJ\u0006\u0010Q\u001a\u00020/J\u0006\u0010R\u001a\u00020/J\u0016\u0010S\u001a\u00020/2\u0006\u0010T\u001a\u00020P2\u0006\u0010U\u001a\u00020PJn\u0010V\u001a\u00020/2\u0006\u0010W\u001a\u00020P2\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020P2\u0006\u0010]\u001a\u00020P2\u0006\u0010^\u001a\u00020P2\u0006\u0010_\u001a\u00020P2\u0006\u0010\u0016\u001a\u00020P2\u0006\u0010\u0017\u001a\u00020P2\u0006\u0010`\u001a\u00020\u001e2\u0006\u0010a\u001a\u00020\u001eJ\u000e\u0010b\u001a\u00020/2\u0006\u0010c\u001a\u00020dJ\b\u0010e\u001a\u00020fH\u0002J\b\u0010g\u001a\u00020/H\u0002J\b\u0010h\u001a\u00020/H\u0002J\u001e\u0010i\u001a\u00020/2\u0006\u0010j\u001a\u00020f2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020\u001e0lH\u0002J\u0006\u0010m\u001a\u00020/J\u0006\u0010n\u001a\u00020/J\u0006\u0010o\u001a\u00020/J\u0006\u0010p\u001a\u00020/J\u000e\u0010q\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "", "language", "Lcom/intellij/lang/Language;", "clock", "Ljava/time/Clock;", "<init>", "(Lcom/intellij/lang/Language;Ljava/time/Clock;)V", "requestId", "", "created", "timeToShow", "Ljava/util/concurrent/atomic/AtomicReference;", "shownAt", "shownDuration", "suppressedDurationByInline", "suppressedDurationByLookup", "suppressedStartTimeByInline", "suppressedStartTimeByLookup", "totalDiffs", "Ljava/util/concurrent/atomic/AtomicInteger;", "shownDiffs", "insertedLength", "deletedLength", "totalInsertLength", "totalDeleteLength", "acceptedDiffs", "shownJumps", "acceptedJumps", "filterReason", "", "jumpShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "diffShown", "triggerReason", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditTriggerReason;", "providerId", "taskId", "performanceMetrics", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditProviderPerformanceMetrics;", "invalid", "acceptedDiffsContents", "", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditDiffContent;", "requestContextJson", "rawModelOutput", "fire", "", "nextEditSessionMessage", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionMessagePayload;", "onTriggered", "trigger", "onProviderStarting", "onProviderSelected", "setTaskId", "taskID", "onContextComposed", "prompt", "setRequestWaitingTime", "requestWaitingTime", "Lkotlin/time/Duration;", "setRequestWaitingTime-LRDsOJo", "(J)V", "setContextCollectionTime", "contextCollectionTime", "setContextCollectionTime-LRDsOJo", "setClientExecutionTime", "clientExecutionTime", "setClientExecutionTime-LRDsOJo", "setIterationFilterTime", "iterationFilterTime", "setIterationFilterTime-LRDsOJo", "onPromptComposed", "onClientResponse", "string", "onTargetFile", "before", "after", "onDiffComputed", "diffsCount", "", "onJumpShown", "onJumpAccepted", "onDiffShown", "startOffset", "endOffset", "onDiffAccepted", "diffIndex", "startOffset1", "endOffset1", "startOffset2", "endOffset2", "startLine1", "endLine1", "startLine2", "endLine2", "oldText", "newText", "onSessionFinished", "finishType", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionFinishType;", "isVisible", "", "tryStartShowTime", "tryIncrementShowDuration", "checkValidity", "condition", "lazyMessage", "Lkotlin/Function0;", "onSuppressedByInline", "onSuppressedByLookup", "onUnsuppressedByInline", "onUnsuppressedByLookup", "onFilteredSuggestion", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
public final class NextEditSessionEventsReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final Clock clock;
    private final long requestId;
    private final long created;
    @NotNull
    private final AtomicReference<Long> timeToShow;
    @NotNull
    private final AtomicReference<Long> shownAt;
    @NotNull
    private final AtomicReference<Long> shownDuration;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByInline;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByLookup;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByInline;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByLookup;
    @NotNull
    private final AtomicInteger totalDiffs;
    @NotNull
    private final AtomicInteger shownDiffs;
    @NotNull
    private final AtomicInteger insertedLength;
    @NotNull
    private final AtomicInteger deletedLength;
    @NotNull
    private final AtomicInteger totalInsertLength;
    @NotNull
    private final AtomicInteger totalDeleteLength;
    @NotNull
    private final AtomicInteger acceptedDiffs;
    @NotNull
    private final AtomicInteger shownJumps;
    @NotNull
    private final AtomicInteger acceptedJumps;
    @NotNull
    private final AtomicReference<String> filterReason;
    @NotNull
    private final AtomicBoolean jumpShown;
    @NotNull
    private final AtomicBoolean diffShown;
    @NotNull
    private final AtomicReference<NextEditTriggerReason> triggerReason;
    @NotNull
    private final AtomicReference<String> providerId;
    @NotNull
    private final AtomicReference<String> taskId;
    @NotNull
    private final NextEditProviderPerformanceMetrics performanceMetrics;
    @NotNull
    private final AtomicBoolean invalid;
    @NotNull
    private final List<NextEditDiffContent> acceptedDiffsContents;
    @NotNull
    private final AtomicReference<String> requestContextJson;
    @NotNull
    private final AtomicReference<String> rawModelOutput;

    private NextEditSessionEventsReporter(Language language, Clock clock) {
        this.language = language;
        this.clock = clock;
        this.requestId = Random.Default.nextLong();
        this.created = this.clock.millis();
        this.timeToShow = new AtomicReference<Object>(null);
        this.shownAt = new AtomicReference<Object>(null);
        this.shownDuration = new AtomicReference<Long>(0L);
        this.suppressedDurationByInline = new AtomicReference<Long>(0L);
        this.suppressedDurationByLookup = new AtomicReference<Long>(0L);
        this.suppressedStartTimeByInline = new AtomicReference<Object>(null);
        this.suppressedStartTimeByLookup = new AtomicReference<Object>(null);
        this.totalDiffs = new AtomicInteger(0);
        this.shownDiffs = new AtomicInteger(0);
        this.insertedLength = new AtomicInteger(0);
        this.deletedLength = new AtomicInteger(0);
        this.totalInsertLength = new AtomicInteger(0);
        this.totalDeleteLength = new AtomicInteger(0);
        this.acceptedDiffs = new AtomicInteger(0);
        this.shownJumps = new AtomicInteger(0);
        this.acceptedJumps = new AtomicInteger(0);
        this.filterReason = new AtomicReference<Object>(null);
        this.jumpShown = new AtomicBoolean(false);
        this.diffShown = new AtomicBoolean(false);
        this.triggerReason = new AtomicReference<NextEditTriggerReason>(NextEditTriggerReason.UNKNOWN);
        this.providerId = new AtomicReference<Object>(null);
        this.taskId = new AtomicReference<Object>(null);
        this.performanceMetrics = new NextEditProviderPerformanceMetrics(null, null, null, null, 15, null);
        this.invalid = new AtomicBoolean(false);
        this.acceptedDiffsContents = new ArrayList();
        this.requestContextJson = new AtomicReference<Object>(null);
        this.rawModelOutput = new AtomicReference<Object>(null);
    }

    private final void fire(NextEditSessionMessagePayload nextEditSessionMessage) {
        if (!DiagnosticLoggersKt.access$getDispatcher$p().hasListeners()) {
            return;
        }
        ((MLCompletionEventListener)DiagnosticLoggersKt.access$getDispatcher$p().getMulticaster()).onEvent(new NextEditSessionMessage(this.requestId, nextEditSessionMessage));
    }

    public final void onTriggered(@NotNull NextEditTriggerReason trigger) {
        Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
        this.triggerReason.set(trigger);
        this.fire(new NextEditTriggered(trigger));
    }

    public final void onProviderStarting() {
        this.providerId.set(null);
        this.performanceMetrics.reset();
    }

    public final void onProviderSelected(@NotNull String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.checkValidity(this.providerId.get() == null, (Function0<String>)((Function0)() -> NextEditSessionEventsReporter.onProviderSelected$lambda$0(this, providerId)));
        this.providerId.set(providerId);
        this.fire(new NextEditProviderSelected(providerId));
    }

    public final void setTaskId(@NotNull String taskID) {
        Intrinsics.checkNotNullParameter((Object)taskID, (String)"taskID");
        this.taskId.set(taskID);
    }

    public final void onContextComposed(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        this.requestContextJson.set(prompt);
        this.fire(new NextEditContextComposed(prompt));
    }

    public final void setRequestWaitingTime-LRDsOJo(long requestWaitingTime) {
        this.performanceMetrics.getRequestWaitingTime().set(Duration.getInWholeMilliseconds-impl((long)requestWaitingTime));
    }

    public final void setContextCollectionTime-LRDsOJo(long contextCollectionTime) {
        this.performanceMetrics.getContextCollectionTime().set(Duration.getInWholeMilliseconds-impl((long)contextCollectionTime));
    }

    public final void setClientExecutionTime-LRDsOJo(long clientExecutionTime) {
        this.performanceMetrics.getClientExecutionTime().set(Duration.getInWholeMilliseconds-impl((long)clientExecutionTime));
    }

    public final void setIterationFilterTime-LRDsOJo(long iterationFilterTime) {
        this.performanceMetrics.getIterationFilterTime().set(Duration.getInWholeMilliseconds-impl((long)iterationFilterTime));
    }

    public final void onPromptComposed(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        this.fire(new NextEditPromptComposed(prompt));
    }

    public final void onClientResponse(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.rawModelOutput.set(string);
        this.fire(new NextEditModelResponse(string));
    }

    public final void onTargetFile(@NotNull String before, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.fire(new NextEditTargetFile(before, after));
    }

    public final void onDiffComputed(int diffsCount, int totalInsertLength, int totalDeleteLength) {
        this.totalInsertLength.set(totalInsertLength);
        this.totalDeleteLength.set(totalDeleteLength);
        this.totalDiffs.set(diffsCount);
        this.fire(new NextEditComputed(diffsCount, totalInsertLength, totalDeleteLength));
    }

    public final void onJumpShown() {
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (!this.jumpShown.get()) {
            this.shownJumps.incrementAndGet();
            this.fire(NextEditJumpShown.INSTANCE);
            this.jumpShown.set(true);
        }
    }

    public final void onJumpAccepted() {
        this.checkValidity(this.jumpShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporter::onJumpAccepted$lambda$1));
        this.tryIncrementShowDuration();
        this.acceptedJumps.incrementAndGet();
        this.fire(NextEditJumpAccepted.INSTANCE);
        this.jumpShown.set(false);
    }

    public final void onDiffShown(int startOffset, int endOffset) {
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (!this.diffShown.get()) {
            this.shownDiffs.incrementAndGet();
            this.checkValidity(this.shownDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporter::onDiffShown$lambda$2));
            this.fire(new NextEditDiffShown(startOffset, endOffset));
            this.diffShown.set(true);
        }
    }

    public final void onDiffAccepted(int diffIndex, int startOffset1, int endOffset1, int startOffset2, int endOffset2, int startLine1, int endLine1, int startLine2, int endLine2, int insertedLength, int deletedLength, @NotNull String oldText, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.acceptedDiffs.incrementAndGet();
        this.checkValidity(this.acceptedDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporter::onDiffAccepted$lambda$3));
        this.checkValidity(this.diffShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporter::onDiffAccepted$lambda$4));
        this.tryIncrementShowDuration();
        this.acceptedDiffsContents.add(new NextEditDiffContent(oldText, newText, startLine1, endLine1, startLine2, endLine2));
        this.fire(new NextEditDiffAccepted(diffIndex, this.totalDiffs.get(), startOffset1, endOffset1, startOffset2, endOffset2, insertedLength, deletedLength));
        this.insertedLength.addAndGet(insertedLength);
        this.deletedLength.addAndGet(deletedLength);
        this.diffShown.set(false);
        this.jumpShown.set(false);
    }

    public final void onSessionFinished(@NotNull NextEditSessionFinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        this.tryIncrementShowDuration();
        NextEditTriggerReason nextEditTriggerReason = this.triggerReason.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)nextEditTriggerReason), (String)"get(...)");
        int n = this.acceptedDiffs.get();
        int n2 = this.shownDiffs.get();
        int n3 = this.totalDiffs.get();
        int n4 = this.acceptedJumps.get();
        int n5 = this.shownJumps.get();
        Long l = this.suppressedDurationByInline.get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"get(...)");
        long l2 = ((Number)l).longValue();
        Long l3 = this.suppressedDurationByLookup.get();
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"get(...)");
        this.fire(new NextEditSessionFinished(this.language, nextEditTriggerReason, this.providerId.get(), this.taskId.get(), finishType, this.filterReason.get(), n, n2, n3, n4, n5, this.timeToShow.get(), this.shownDuration.get(), l2, ((Number)l3).longValue(), new NextEditPerformanceMetrics(this.performanceMetrics.getRequestWaitingTime().get(), this.performanceMetrics.getContextCollectionTime().get(), this.performanceMetrics.getClientExecutionTime().get(), this.performanceMetrics.getIterationFilterTime().get(), this.clock.millis() - this.created), this.invalid.get(), this.insertedLength.get(), this.deletedLength.get(), this.totalInsertLength.get(), this.totalDeleteLength.get(), this.acceptedDiffsContents, this.requestContextJson.get(), this.rawModelOutput.get()));
    }

    private final boolean isVisible() {
        return this.suppressedStartTimeByInline.get() == null && this.suppressedStartTimeByLookup.get() == null;
    }

    private final void tryStartShowTime() {
        if (!this.isVisible()) {
            return;
        }
        this.shownAt.set(this.clock.millis());
    }

    private final void tryIncrementShowDuration() {
        if (this.shownAt.get() != null && this.isVisible()) {
            Long l = this.shownAt.get();
            Intrinsics.checkNotNull((Object)l);
            long shown = ((Number)l).longValue();
            this.shownDuration.set(((Number)this.shownDuration.get()).longValue() + this.clock.millis() - shown);
            this.shownAt.set(null);
        }
    }

    private final void checkValidity(boolean condition, Function0<String> lazyMessage) {
        if (!condition) {
            this.fire(new NextEditSessionInvalidState((String)lazyMessage.invoke()));
            this.invalid.set(true);
        }
    }

    public final void onSuppressedByInline() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByInline.set(this.clock.millis());
    }

    public final void onSuppressedByLookup() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByLookup.set(this.clock.millis());
    }

    public final void onUnsuppressedByInline() {
        Long suppressionStartTime = this.suppressedStartTimeByInline.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporter::onUnsuppressedByInline$lambda$5));
        Long l = suppressionStartTime;
        this.suppressedDurationByInline.set(((Number)this.suppressedDurationByInline.get()).longValue() + this.clock.millis() - (l != null ? l : 0L));
        this.suppressedStartTimeByInline.set(null);
        this.tryStartShowTime();
    }

    public final void onUnsuppressedByLookup() {
        Long suppressionStartTime = this.suppressedStartTimeByLookup.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporter::onUnsuppressedByLookup$lambda$6));
        Long l = suppressionStartTime;
        this.suppressedDurationByLookup.set(((Number)this.suppressedDurationByLookup.get()).longValue() + this.clock.millis() - (l != null ? l : 0L));
        this.suppressedStartTimeByLookup.set(null);
        this.tryStartShowTime();
    }

    public final void onFilteredSuggestion(@NotNull String filterReason) {
        Intrinsics.checkNotNullParameter((Object)filterReason, (String)"filterReason");
        this.checkValidity(this.filterReason.get() == null, (Function0<String>)((Function0)NextEditSessionEventsReporter::onFilteredSuggestion$lambda$7));
        this.filterReason.set(filterReason);
    }

    private static final String onProviderSelected$lambda$0(NextEditSessionEventsReporter this$0, String $providerId) {
        return "Provider is already set: was " + this$0.providerId.get() + ", new " + $providerId;
    }

    private static final String onJumpAccepted$lambda$1() {
        return "Accepted jump was not shown";
    }

    private static final String onDiffShown$lambda$2() {
        return "Shown more diffs than total";
    }

    private static final String onDiffAccepted$lambda$3() {
        return "Accepted more diffs than total";
    }

    private static final String onDiffAccepted$lambda$4() {
        return "Accepted diff was not shown";
    }

    private static final String onUnsuppressedByInline$lambda$5() {
        return "Suppress by inline was not called before unsuppress";
    }

    private static final String onUnsuppressedByLookup$lambda$6() {
        return "Suppress by lookup was not called before unsuppress";
    }

    private static final String onFilteredSuggestion$lambda$7() {
        return "Filter reason is already set";
    }

    public /* synthetic */ NextEditSessionEventsReporter(Language language, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(language, clock);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "language", "Lcom/intellij/lang/Language;", "clock", "Ljava/time/Clock;", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditSessionEventsReporter of(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            return new NextEditSessionEventsReporter(language, clock, null);
        }

        @TestOnly
        @NotNull
        public final NextEditSessionEventsReporter of(@NotNull Language language, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            return new NextEditSessionEventsReporter(language, clock, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

