/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ColumnFilteringStrategy
implements ChangeListFilteringStrategy {
    private final JScrollPane myScrollPane;
    private final JList<@Nls String> myValueList;
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ChangeListColumn myColumn;
    private final Class<? extends CommittedChangesProvider> myProviderClass;
    private final MyListModel myModel;
    private final CommittedChangeListToStringConvertor ourConvertorInstance = new CommittedChangeListToStringConvertor();
    private List<String> myPreferredSelection;

    public ColumnFilteringStrategy(ChangeListColumn column, Class<? extends CommittedChangesProvider> providerClass) {
        this.myModel = new MyListModel();
        this.myValueList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane(this.myValueList);
        this.myValueList.setModel(this.myModel);
        this.myValueList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                for (ChangeListener listener2 : ColumnFilteringStrategy.this.myListeners) {
                    listener2.stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.myValueList.setCellRenderer((ListCellRenderer<String>)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, @Nls String value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (index == 0) {
                    this.append(value, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else if (value.isEmpty()) {
                    this.append(VcsBundle.message((String)"committed.changes.filter.none", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy$2", "customizeCellRenderer"));
            }
        });
        this.myColumn = column;
        this.myProviderClass = providerClass;
    }

    @NotNull
    public CommittedChangesFilterKey getKey() {
        return new CommittedChangesFilterKey(this.toString(), CommittedChangesFilterPriority.USER);
    }

    public String toString() {
        return this.myColumn.getTitle();
    }

    @Nullable
    public JComponent getFilterUI() {
        return this.myScrollPane;
    }

    public void setFilterBase(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (changeLists == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(0);
        }
        this.myPreferredSelection = null;
        this.appendFilterBase(changeLists);
    }

    public void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener2);
    }

    public void removeChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener2);
    }

    public void resetFilterBase() {
        this.myPreferredSelection = this.myValueList.getSelectedValuesList();
        this.myValueList.clearSelection();
        this.myModel.clear();
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    public void appendFilterBase(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (changeLists == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(3);
        }
        List<String> oldSelection = this.myModel.isEmpty() ? this.myPreferredSelection : this.myValueList.getSelectedValuesList();
        this.myModel.addNext(changeLists, this.ourConvertorInstance);
        if (oldSelection != null) {
            for (String o : oldSelection) {
                this.myValueList.setSelectedValue(o, false);
            }
        }
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (changeLists == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(4);
        }
        List<String> selection = this.myValueList.getSelectedValuesList();
        if (this.myValueList.getSelectedIndex() == 0 || selection.isEmpty()) {
            return new ArrayList<CommittedChangeList>(changeLists);
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        block0: for (CommittedChangeList committedChangeList : changeLists) {
            if (this.myProviderClass != null && !this.myProviderClass.isInstance(committedChangeList.getVcs().getCommittedChangesProvider())) continue;
            for (String value : selection) {
                if (!value.equals(this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(committedChangeList)).toString())) continue;
                result2.add(committedChangeList);
                continue block0;
            }
        }
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            ColumnFilteringStrategy.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFilterBase";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendFilterBase";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterChangeLists";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private class CommittedChangeListToStringConvertor
    implements Convertor<CommittedChangeList, String> {
        private CommittedChangeListToStringConvertor() {
        }

        public String convert(CommittedChangeList o) {
            if (ColumnFilteringStrategy.this.myProviderClass == null || ColumnFilteringStrategy.this.myProviderClass.isInstance(o.getVcs().getCommittedChangesProvider())) {
                return ColumnFilteringStrategy.this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(o)).toString();
            }
            return null;
        }
    }

    private static final class MyListModel
    extends AbstractListModel<String> {
        private volatile String[] myValues = ArrayUtilRt.EMPTY_STRING_ARRAY;

        private MyListModel() {
        }

        public <T> void addNext(Collection<? extends T> values, Convertor<? super T, @Nls String> convertor) {
            TreeSet<String> set = new TreeSet<String>(Arrays.asList(this.myValues));
            for (T value : values) {
                String converted = (String)convertor.convert(value);
                if (converted == null) continue;
                set.add(converted);
            }
            this.myValues = ArrayUtilRt.toStringArray(set);
            this.fireContentsChanged(this, 0, this.myValues.length);
        }

        @Override
        public int getSize() {
            return this.myValues.length + 1;
        }

        public boolean isEmpty() {
            return this.myValues.length == 0;
        }

        @Override
        public String getElementAt(int index) {
            if (index == 0) {
                return VcsBundle.message((String)"committed.changes.filter.all", (Object[])new Object[0]);
            }
            return this.myValues[index - 1];
        }

        public void clear() {
            this.myValues = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
    }
}

