/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.serial.SerialClobTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerialClobTest
extends TestCase {
    public void testSerialClob$C() throws Exception {
        SerialClob serialClob = new SerialClob(new char[8]);
        SerialClobTest.assertEquals((long)8L, (long)serialClob.length());
        try {
            new SerialClob(null);
            SerialClobTest.fail((String)"should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSerialClobLClob() throws Exception {
        MockSerialClob mockClob = new MockSerialClob();
        mockClob.characterStreamReader = new CharArrayReader(mockClob.buf);
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockClob);
        SerialClobTest.assertEquals((long)mockClob.buf.length, (long)serialClob.length());
        mockClob.characterStreamReader = null;
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockClob.characterStreamReader = new CharArrayReader(new char[]{'\u0001'});
        mockClob.asciiInputStream = null;
        mockClob.characterStreamReader = new MockAbnormalReader();
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        try {
            new SerialClob((Clob)mockClob);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            new SerialClob(null);
            SerialClobTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testLength() {
    }

    public void testGetAsciiStream() throws Exception {
        MockSerialClob mockClob = new MockSerialClob();
        mockClob.characterStreamReader = new CharArrayReader(mockClob.buf);
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockClob);
        InputStream is = serialClob.getAsciiStream();
        SerialClobTest.assertTrue((boolean)mockClob.isGetAsciiStreamInvoked);
        SerialClobTest.assertEquals((Object)mockClob.asciiInputStream, (Object)is);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.getAsciiStream();
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testGetCharacterStream() throws Exception {
        char[] buf = "helloo".toCharArray();
        SerialClob serialClob = new SerialClob(buf);
        Reader reader = serialClob.getCharacterStream();
        char[] data = new char[buf.length];
        int read = reader.read(data);
        SerialClobTest.assertEquals((int)buf.length, (int)read);
        SerialClobTest.assertTrue((boolean)Arrays.equals(buf, data));
        SerialClobTest.assertFalse((boolean)reader.ready());
        MockSerialClob mockClob = new MockSerialClob();
        mockClob.characterStreamReader = new CharArrayReader(mockClob.buf);
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockClob.asciiOutputStream = new ByteArrayOutputStream();
        serialClob = new SerialClob((Clob)mockClob);
        reader = serialClob.getCharacterStream();
        data = new char[mockClob.buf.length];
        read = reader.read(data);
        SerialClobTest.assertEquals((int)mockClob.buf.length, (int)read);
        SerialClobTest.assertTrue((boolean)Arrays.equals(mockClob.buf, data));
        SerialClobTest.assertFalse((boolean)reader.ready());
    }

    public void testGetSubString() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        String sub = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"hello", (String)sub);
        sub = serialClob.getSubString(2L, 3);
        SerialClobTest.assertEquals((String)"ell", (String)sub);
        try {
            sub = serialClob.getSubString(0L, 6);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            sub = serialClob.getSubString(7L, 1);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            sub = serialClob.getSubString(1L, 7);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            sub = serialClob.getSubString(1L, -2);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            sub = serialClob.getSubString(3L, 4);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        LongLengthClob longClob = new LongLengthClob(null);
        serialClob = new SerialClob((Clob)longClob);
        try {
            serialClob.getSubString(1L, 3);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testPositionLClobJ() throws Exception {
        SerialClob serialClob = new SerialClob("helloo".toCharArray());
        SerialClob searchClob = new SerialClob("llo".toCharArray());
        long pos = serialClob.position(searchClob, 1L);
        SerialClobTest.assertEquals((long)3L, (long)pos);
        pos = serialClob.position(searchClob, 3L);
        SerialClobTest.assertEquals((long)3L, (long)pos);
        searchClob = new SerialClob("o".toCharArray());
        pos = serialClob.position(searchClob, 6L);
        SerialClobTest.assertEquals((long)6L, (long)pos);
        searchClob = new SerialClob("ooooooo".toCharArray());
        pos = serialClob.position(searchClob, 1L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        searchClob = new SerialClob("llo".toCharArray());
        pos = serialClob.position(searchClob, 4L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position(searchClob, 0L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position(searchClob, -1L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position(searchClob, 10L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
    }

    public void testPositionLStringJ() throws Exception {
        SerialClob serialClob = new SerialClob("helloo".toCharArray());
        long pos = serialClob.position("llo", 1L);
        SerialClobTest.assertEquals((long)3L, (long)pos);
        pos = serialClob.position("llo", 3L);
        SerialClobTest.assertEquals((long)3L, (long)pos);
        pos = serialClob.position("o", 6L);
        SerialClobTest.assertEquals((long)6L, (long)pos);
        pos = serialClob.position("ooooooo", 1L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position("llo", 4L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position("llo", 0L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position("llo", -1L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
        pos = serialClob.position("llo", 10L);
        SerialClobTest.assertEquals((long)-1L, (long)pos);
    }

    public void testSetAsciiStream() throws Exception {
        MockSerialClob mockClob = new MockSerialClob();
        mockClob.characterStreamReader = new CharArrayReader(mockClob.buf);
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        SerialClob serialClob = new SerialClob((Clob)mockClob);
        OutputStream os = null;
        try {
            os = serialClob.setAsciiStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        mockClob.asciiOutputStream = new ByteArrayOutputStream();
        os = serialClob.setAsciiStream(1L);
        SerialClobTest.assertNotNull((Object)os);
        SerialClobTest.assertTrue((boolean)mockClob.isSetAsciiStreamInvoked);
        SerialClobTest.assertEquals((Object)mockClob.asciiOutputStream, (Object)os);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.setAsciiStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetCharacterStream() throws Exception {
        MockSerialClob mockClob = new MockSerialClob();
        mockClob.characterStreamReader = new CharArrayReader(mockClob.buf);
        mockClob.asciiInputStream = new ByteArrayInputStream(new byte[]{1});
        mockClob.characterStreamWriter = new CharArrayWriter();
        SerialClob serialClob = new SerialClob((Clob)mockClob);
        Writer writer = serialClob.setCharacterStream(1L);
        SerialClobTest.assertTrue((boolean)mockClob.isSetCharacterStreamInvoked);
        SerialClobTest.assertEquals((Object)mockClob.characterStreamWriter, (Object)writer);
        try {
            serialClob = new SerialClob("helloo".toCharArray());
            serialClob.setCharacterStream(1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetStringJLString() throws Exception {
        String s = "hello";
        char[] buf = s.toCharArray();
        SerialClob serialClob = new SerialClob(buf);
        int count = serialClob.setString(1L, "olleh");
        String sub = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"olleh", (String)sub);
        SerialClobTest.assertEquals((int)5, (int)count);
        count = serialClob.setString(2L, "mm");
        sub = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"ommeh", (String)sub);
        SerialClobTest.assertEquals((int)2, (int)count);
        try {
            serialClob.setString(-1L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(6L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(2L, "hello");
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testSetStringJLStringII() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        int count = serialClob.setString(1L, "olleh", 0, 5);
        String sub = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((String)"olleh", (String)sub);
        SerialClobTest.assertEquals((int)5, (int)count);
        count = serialClob.setString(2L, "mmnn", 1, 2);
        sub = serialClob.getSubString(1L, 5);
        SerialClobTest.assertEquals((int)2, (int)count);
        SerialClobTest.assertEquals((String)"omneh", (String)sub);
        try {
            serialClob.setString(-1L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(6L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(1L, "hello", 0, 6);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(2L, "hello", 0, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.setString(1L, "hello", -1, 5);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }

    public void testTruncate() throws Exception {
        SerialClob serialClob = new SerialClob("hello".toCharArray());
        serialClob.truncate(3L);
        SerialClobTest.assertEquals((long)3L, (long)serialClob.length());
        String s = serialClob.getSubString(1L, 3);
        SerialClobTest.assertEquals((String)"hel", (String)s);
        serialClob.truncate(0L);
        SerialClobTest.assertEquals((long)0L, (long)serialClob.length());
        serialClob = new SerialClob("hello".toCharArray());
        try {
            serialClob.truncate(10L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
        try {
            serialClob.truncate(-1L);
            SerialClobTest.fail((String)"should throw SerialException");
        }
        catch (SerialException serialException) {
            // empty catch block
        }
    }
}

