// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociatePhoneNumberWithUser = "AssociatePhoneNumberWithUser"

// AssociatePhoneNumberWithUserRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumberWithUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumberWithUser for more information on using the AssociatePhoneNumberWithUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumberWithUserRequest method.
//	req, resp := client.AssociatePhoneNumberWithUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser
func (c *Chime) AssociatePhoneNumberWithUserRequest(input *AssociatePhoneNumberWithUserInput) (req *request.Request, output *AssociatePhoneNumberWithUserOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumberWithUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=associate-phone-number",
	}

	if input == nil {
		input = &AssociatePhoneNumberWithUserInput{}
	}

	output = &AssociatePhoneNumberWithUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociatePhoneNumberWithUser API operation for Amazon Chime.
//
// Associates a phone number with the specified Amazon Chime user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumberWithUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser
func (c *Chime) AssociatePhoneNumberWithUser(input *AssociatePhoneNumberWithUserInput) (*AssociatePhoneNumberWithUserOutput, error) {
	req, out := c.AssociatePhoneNumberWithUserRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumberWithUserWithContext is the same as AssociatePhoneNumberWithUser with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumberWithUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociatePhoneNumberWithUserWithContext(ctx aws.Context, input *AssociatePhoneNumberWithUserInput, opts ...request.Option) (*AssociatePhoneNumberWithUserOutput, error) {
	req, out := c.AssociatePhoneNumberWithUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumbersWithVoiceConnector = "AssociatePhoneNumbersWithVoiceConnector"

// AssociatePhoneNumbersWithVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnector for more information on using the AssociatePhoneNumbersWithVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorRequest method.
//	req, resp := client.AssociatePhoneNumbersWithVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorRequest(input *AssociatePhoneNumbersWithVoiceConnectorInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AssociatePhoneNumbersWithVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnector API operation for Amazon Chime.
//
// Associates phone numbers with the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, AssociatePhoneNumbersWithVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_AssociatePhoneNumbersWithVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumbersWithVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnector(input *AssociatePhoneNumbersWithVoiceConnectorInput) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorWithContext is the same as AssociatePhoneNumbersWithVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumbersWithVoiceConnectorGroup = "AssociatePhoneNumbersWithVoiceConnectorGroup"

// AssociatePhoneNumbersWithVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for more information on using the AssociatePhoneNumbersWithVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorGroupRequest method.
//	req, resp := client.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, AssociatePhoneNumbersWithVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorGroupInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnectorGroup API operation for Amazon Chime.
//
// Associates phone numbers with the specified Amazon Chime Voice Connector
// group.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, AssociatePhoneNumbersWithVoiceConnectorGroup (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_AssociatePhoneNumbersWithVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumbersWithVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroup(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorGroupWithContext is the same as AssociatePhoneNumbersWithVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by AssociatePhoneNumbersWithVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroupWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorGroupInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSigninDelegateGroupsWithAccount = "AssociateSigninDelegateGroupsWithAccount"

// AssociateSigninDelegateGroupsWithAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSigninDelegateGroupsWithAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSigninDelegateGroupsWithAccount for more information on using the AssociateSigninDelegateGroupsWithAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateSigninDelegateGroupsWithAccountRequest method.
//	req, resp := client.AssociateSigninDelegateGroupsWithAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount
func (c *Chime) AssociateSigninDelegateGroupsWithAccountRequest(input *AssociateSigninDelegateGroupsWithAccountInput) (req *request.Request, output *AssociateSigninDelegateGroupsWithAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateSigninDelegateGroupsWithAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}?operation=associate-signin-delegate-groups",
	}

	if input == nil {
		input = &AssociateSigninDelegateGroupsWithAccountInput{}
	}

	output = &AssociateSigninDelegateGroupsWithAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateSigninDelegateGroupsWithAccount API operation for Amazon Chime.
//
// Associates the specified sign-in delegate groups with the specified Amazon
// Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociateSigninDelegateGroupsWithAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount
func (c *Chime) AssociateSigninDelegateGroupsWithAccount(input *AssociateSigninDelegateGroupsWithAccountInput) (*AssociateSigninDelegateGroupsWithAccountOutput, error) {
	req, out := c.AssociateSigninDelegateGroupsWithAccountRequest(input)
	return out, req.Send()
}

// AssociateSigninDelegateGroupsWithAccountWithContext is the same as AssociateSigninDelegateGroupsWithAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSigninDelegateGroupsWithAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociateSigninDelegateGroupsWithAccountWithContext(ctx aws.Context, input *AssociateSigninDelegateGroupsWithAccountInput, opts ...request.Option) (*AssociateSigninDelegateGroupsWithAccountOutput, error) {
	req, out := c.AssociateSigninDelegateGroupsWithAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateAttendee = "BatchCreateAttendee"

// BatchCreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateAttendee for more information on using the BatchCreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateAttendeeRequest method.
//	req, resp := client.BatchCreateAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee
//
// Deprecated: Replaced by BatchCreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) BatchCreateAttendeeRequest(input *BatchCreateAttendeeInput) (req *request.Request, output *BatchCreateAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, BatchCreateAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opBatchCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateAttendeeInput{}
	}

	output = &BatchCreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateAttendee API operation for Amazon Chime.
//
// Creates up to 100 new attendees for an active Amazon Chime SDK meeting.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, BatchCreateAttendee (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_BatchCreateAttendee.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// For more information about the Amazon Chime SDK, see Using the Amazon Chime
// SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html) in
// the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchCreateAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee
//
// Deprecated: Replaced by BatchCreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) BatchCreateAttendee(input *BatchCreateAttendeeInput) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	return out, req.Send()
}

// BatchCreateAttendeeWithContext is the same as BatchCreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by BatchCreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) BatchCreateAttendeeWithContext(ctx aws.Context, input *BatchCreateAttendeeInput, opts ...request.Option) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateChannelMembership = "BatchCreateChannelMembership"

// BatchCreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateChannelMembership for more information on using the BatchCreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateChannelMembershipRequest method.
//	req, resp := client.BatchCreateChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateChannelMembership
//
// Deprecated: Replaced by BatchCreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) BatchCreateChannelMembershipRequest(input *BatchCreateChannelMembershipInput) (req *request.Request, output *BatchCreateChannelMembershipOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, BatchCreateChannelMembership, has been deprecated")
	}
	op := &request.Operation{
		Name:       opBatchCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateChannelMembershipInput{}
	}

	output = &BatchCreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchCreateChannelMembership API operation for Amazon Chime.
//
// Adds a specified number of users to a channel.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, BatchCreateChannelMembership (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_BatchCreateChannelMembership.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchCreateChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateChannelMembership
//
// Deprecated: Replaced by BatchCreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) BatchCreateChannelMembership(input *BatchCreateChannelMembershipInput) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	return out, req.Send()
}

// BatchCreateChannelMembershipWithContext is the same as BatchCreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by BatchCreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) BatchCreateChannelMembershipWithContext(ctx aws.Context, input *BatchCreateChannelMembershipInput, opts ...request.Option) (*BatchCreateChannelMembershipOutput, error) {
	req, out := c.BatchCreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateRoomMembership = "BatchCreateRoomMembership"

// BatchCreateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateRoomMembership for more information on using the BatchCreateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateRoomMembershipRequest method.
//	req, resp := client.BatchCreateRoomMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership
func (c *Chime) BatchCreateRoomMembershipRequest(input *BatchCreateRoomMembershipInput) (req *request.Request, output *BatchCreateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opBatchCreateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateRoomMembershipInput{}
	}

	output = &BatchCreateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateRoomMembership API operation for Amazon Chime.
//
// Adds up to 50 members to a chat room in an Amazon Chime Enterprise account.
// Members can be users or bots. The member role designates whether the member
// is a chat room administrator or a general chat room member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchCreateRoomMembership for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership
func (c *Chime) BatchCreateRoomMembership(input *BatchCreateRoomMembershipInput) (*BatchCreateRoomMembershipOutput, error) {
	req, out := c.BatchCreateRoomMembershipRequest(input)
	return out, req.Send()
}

// BatchCreateRoomMembershipWithContext is the same as BatchCreateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchCreateRoomMembershipWithContext(ctx aws.Context, input *BatchCreateRoomMembershipInput, opts ...request.Option) (*BatchCreateRoomMembershipOutput, error) {
	req, out := c.BatchCreateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeletePhoneNumber = "BatchDeletePhoneNumber"

// BatchDeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeletePhoneNumber for more information on using the BatchDeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeletePhoneNumberRequest method.
//	req, resp := client.BatchDeletePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber
func (c *Chime) BatchDeletePhoneNumberRequest(input *BatchDeletePhoneNumberInput) (req *request.Request, output *BatchDeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchDeletePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-delete",
	}

	if input == nil {
		input = &BatchDeletePhoneNumberInput{}
	}

	output = &BatchDeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeletePhoneNumber API operation for Amazon Chime.
//
// Moves phone numbers into the Deletion queue. Phone numbers must be disassociated
// from any users or Amazon Chime Voice Connectors before they can be deleted.
//
// Phone numbers remain in the Deletion queue for 7 days before they are deleted
// permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchDeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber
func (c *Chime) BatchDeletePhoneNumber(input *BatchDeletePhoneNumberInput) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchDeletePhoneNumberWithContext is the same as BatchDeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchDeletePhoneNumberWithContext(ctx aws.Context, input *BatchDeletePhoneNumberInput, opts ...request.Option) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchSuspendUser = "BatchSuspendUser"

// BatchSuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchSuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchSuspendUser for more information on using the BatchSuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchSuspendUserRequest method.
//	req, resp := client.BatchSuspendUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUserRequest(input *BatchSuspendUserInput) (req *request.Request, output *BatchSuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchSuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=suspend",
	}

	if input == nil {
		input = &BatchSuspendUserInput{}
	}

	output = &BatchSuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchSuspendUser API operation for Amazon Chime.
//
// Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime account.
// For more information about different account types, see Managing Your Amazon
// Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Users suspended from a Team account are disassociated from the account,but
// they can continue to use Amazon Chime as free users. To remove the suspension
// from suspended Team account users, invite them to the Team account again.
// You can use the InviteUsers action to do so.
//
// Users suspended from an EnterpriseLWA account are immediately signed out
// of Amazon Chime and can no longer sign in. To remove the suspension from
// suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.
//
// To sign out users without suspending them, use the LogoutUser action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchSuspendUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUser(input *BatchSuspendUserInput) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	return out, req.Send()
}

// BatchSuspendUserWithContext is the same as BatchSuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchSuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchSuspendUserWithContext(ctx aws.Context, input *BatchSuspendUserInput, opts ...request.Option) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUnsuspendUser = "BatchUnsuspendUser"

// BatchUnsuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUnsuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUnsuspendUser for more information on using the BatchUnsuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUnsuspendUserRequest method.
//	req, resp := client.BatchUnsuspendUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUserRequest(input *BatchUnsuspendUserInput) (req *request.Request, output *BatchUnsuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchUnsuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=unsuspend",
	}

	if input == nil {
		input = &BatchUnsuspendUserInput{}
	}

	output = &BatchUnsuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUnsuspendUser API operation for Amazon Chime.
//
// Removes the suspension from up to 50 previously suspended users for the specified
// Amazon Chime EnterpriseLWA account. Only users on EnterpriseLWA accounts
// can be unsuspended using this action. For more information about different
// account types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the account types, in the Amazon Chime Administration Guide.
//
// Previously suspended users who are unsuspended using this action are returned
// to Registered status. Users who are not previously suspended are ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUnsuspendUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUser(input *BatchUnsuspendUserInput) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	return out, req.Send()
}

// BatchUnsuspendUserWithContext is the same as BatchUnsuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUnsuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUnsuspendUserWithContext(ctx aws.Context, input *BatchUnsuspendUserInput, opts ...request.Option) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdatePhoneNumber = "BatchUpdatePhoneNumber"

// BatchUpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdatePhoneNumber for more information on using the BatchUpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdatePhoneNumberRequest method.
//	req, resp := client.BatchUpdatePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber
func (c *Chime) BatchUpdatePhoneNumberRequest(input *BatchUpdatePhoneNumberInput) (req *request.Request, output *BatchUpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-update",
	}

	if input == nil {
		input = &BatchUpdatePhoneNumberInput{}
	}

	output = &BatchUpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdatePhoneNumber API operation for Amazon Chime.
//
// Updates phone number product types or calling names. You can update one attribute
// at a time for each UpdatePhoneNumberRequestItem. For example, you can update
// the product type or the calling name.
//
// For toll-free numbers, you cannot use the Amazon Chime Business Calling product
// type. For numbers outside the U.S., you must use the Amazon Chime SIP Media
// Application Dial-In product type.
//
// Updates to outbound calling names can take up to 72 hours to complete. Pending
// updates to outbound calling names must be complete before you can request
// another update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber
func (c *Chime) BatchUpdatePhoneNumber(input *BatchUpdatePhoneNumberInput) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchUpdatePhoneNumberWithContext is the same as BatchUpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUpdatePhoneNumberWithContext(ctx aws.Context, input *BatchUpdatePhoneNumberInput, opts ...request.Option) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateUser = "BatchUpdateUser"

// BatchUpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateUser for more information on using the BatchUpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateUserRequest method.
//	req, resp := client.BatchUpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUserRequest(input *BatchUpdateUserInput) (req *request.Request, output *BatchUpdateUserOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users",
	}

	if input == nil {
		input = &BatchUpdateUserInput{}
	}

	output = &BatchUpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateUser API operation for Amazon Chime.
//
// Updates user details within the UpdateUserRequestItem object for up to 20
// users for the specified Amazon Chime account. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUser(input *BatchUpdateUserInput) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	return out, req.Send()
}

// BatchUpdateUserWithContext is the same as BatchUpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUpdateUserWithContext(ctx aws.Context, input *BatchUpdateUserInput, opts ...request.Option) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccount for more information on using the CreateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountRequest method.
//	req, resp := client.CreateAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccountRequest(input *CreateAccountInput) (req *request.Request, output *CreateAccountOutput) {
	op := &request.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	output = &CreateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccount API operation for Amazon Chime.
//
// Creates an Amazon Chime account under the administrator's AWS account. Only
// Team account types are currently supported for this action. For more information
// about different account types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccount(input *CreateAccountInput) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	return out, req.Send()
}

// CreateAccountWithContext is the same as CreateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateAccountWithContext(ctx aws.Context, input *CreateAccountInput, opts ...request.Option) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstance = "CreateAppInstance"

// CreateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstance for more information on using the CreateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceRequest method.
//	req, resp := client.CreateAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstance
//
// Deprecated: Replaced by CreateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceRequest(input *CreateAppInstanceInput) (req *request.Request, output *CreateAppInstanceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateAppInstance, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateAppInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances",
	}

	if input == nil {
		input = &CreateAppInstanceInput{}
	}

	output = &CreateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAppInstance API operation for Amazon Chime.
//
// Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only
// SDK messaging customers use this API. CreateAppInstance supports idempotency
// behavior as described in the AWS API Standard.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateAppInstance (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstance.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstance
//
// Deprecated: Replaced by CreateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstance(input *CreateAppInstanceInput) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	return out, req.Send()
}

// CreateAppInstanceWithContext is the same as CreateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceWithContext(ctx aws.Context, input *CreateAppInstanceInput, opts ...request.Option) (*CreateAppInstanceOutput, error) {
	req, out := c.CreateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceAdmin = "CreateAppInstanceAdmin"

// CreateAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceAdmin for more information on using the CreateAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceAdminRequest method.
//	req, resp := client.CreateAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstanceAdmin
//
// Deprecated: Replaced by CreateAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceAdminRequest(input *CreateAppInstanceAdminInput) (req *request.Request, output *CreateAppInstanceAdminOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateAppInstanceAdmin, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateAppInstanceAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
	}

	if input == nil {
		input = &CreateAppInstanceAdminInput{}
	}

	output = &CreateAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAppInstanceAdmin API operation for Amazon Chime.
//
// Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can
// perform the following actions.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateAppInstanceAdmin (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstanceAdmin.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
//   - ChannelModerator actions across all channels in the AppInstance.
//
//   - DeleteChannelMessage actions.
//
// Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstanceAdmin
//
// Deprecated: Replaced by CreateAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceAdmin(input *CreateAppInstanceAdminInput) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	return out, req.Send()
}

// CreateAppInstanceAdminWithContext is the same as CreateAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceAdminWithContext(ctx aws.Context, input *CreateAppInstanceAdminInput, opts ...request.Option) (*CreateAppInstanceAdminOutput, error) {
	req, out := c.CreateAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppInstanceUser = "CreateAppInstanceUser"

// CreateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppInstanceUser for more information on using the CreateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAppInstanceUserRequest method.
//	req, resp := client.CreateAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstanceUser
//
// Deprecated: Replaced by CreateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceUserRequest(input *CreateAppInstanceUserInput) (req *request.Request, output *CreateAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateAppInstanceUser,
		HTTPMethod: "POST",
		HTTPPath:   "/app-instance-users",
	}

	if input == nil {
		input = &CreateAppInstanceUserInput{}
	}

	output = &CreateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAppInstanceUser API operation for Amazon Chime.
//
// Creates a user under an Amazon Chime AppInstance. The request consists of
// a unique appInstanceUserId and Name for that user.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAppInstanceUser
//
// Deprecated: Replaced by CreateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceUser(input *CreateAppInstanceUserInput) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	return out, req.Send()
}

// CreateAppInstanceUserWithContext is the same as CreateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) CreateAppInstanceUserWithContext(ctx aws.Context, input *CreateAppInstanceUserInput, opts ...request.Option) (*CreateAppInstanceUserOutput, error) {
	req, out := c.CreateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAttendee = "CreateAttendee"

// CreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the CreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAttendee for more information on using the CreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAttendeeRequest method.
//	req, resp := client.CreateAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee
//
// Deprecated: Replaced by CreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateAttendeeRequest(input *CreateAttendeeInput) (req *request.Request, output *CreateAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees",
	}

	if input == nil {
		input = &CreateAttendeeInput{}
	}

	output = &CreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAttendee API operation for Amazon Chime.
//
// Creates a new attendee for an active Amazon Chime SDK meeting. For more information
// about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateAttendee (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateAttendee.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee
//
// Deprecated: Replaced by CreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateAttendee(input *CreateAttendeeInput) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	return out, req.Send()
}

// CreateAttendeeWithContext is the same as CreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateAttendeeWithContext(ctx aws.Context, input *CreateAttendeeInput, opts ...request.Option) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBot = "CreateBot"

// CreateBotRequest generates a "aws/request.Request" representing the
// client's request for the CreateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBot for more information on using the CreateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotRequest method.
//	req, resp := client.CreateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot
func (c *Chime) CreateBotRequest(input *CreateBotInput) (req *request.Request, output *CreateBotOutput) {
	op := &request.Operation{
		Name:       opCreateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots",
	}

	if input == nil {
		input = &CreateBotInput{}
	}

	output = &CreateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBot API operation for Amazon Chime.
//
// Creates a bot for an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateBot for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot
func (c *Chime) CreateBot(input *CreateBotInput) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	return out, req.Send()
}

// CreateBotWithContext is the same as CreateBot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateBotWithContext(ctx aws.Context, input *CreateBotInput, opts ...request.Option) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannel
//
// Deprecated: Replaced by CreateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateChannel, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateChannel API operation for Amazon Chime.
//
// Creates a channel to which you can add users and send messages.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateChannel (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannel.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannel
//
// Deprecated: Replaced by CreateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelBan = "CreateChannelBan"

// CreateChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelBan for more information on using the CreateChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelBanRequest method.
//	req, resp := client.CreateChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelBan
//
// Deprecated: Replaced by CreateChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelBanRequest(input *CreateChannelBanInput) (req *request.Request, output *CreateChannelBanOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateChannelBan, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateChannelBan,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/bans",
	}

	if input == nil {
		input = &CreateChannelBanInput{}
	}

	output = &CreateChannelBanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateChannelBan API operation for Amazon Chime.
//
// Permanently bans a member from a channel. Moderators can't add banned members
// to a channel. To undo a ban, you first have to DeleteChannelBan, and then
// CreateChannelMembership. Bans are cleaned up when you delete users or channels.
//
// If you ban a user who is already part of a channel, that user is automatically
// kicked from the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateChannelBan (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelBan.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelBan
//
// Deprecated: Replaced by CreateChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelBan(input *CreateChannelBanInput) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	return out, req.Send()
}

// CreateChannelBanWithContext is the same as CreateChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelBanWithContext(ctx aws.Context, input *CreateChannelBanInput, opts ...request.Option) (*CreateChannelBanOutput, error) {
	req, out := c.CreateChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelMembership = "CreateChannelMembership"

// CreateChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelMembership for more information on using the CreateChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelMembershipRequest method.
//	req, resp := client.CreateChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelMembership
//
// Deprecated: Replaced by CreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelMembershipRequest(input *CreateChannelMembershipInput) (req *request.Request, output *CreateChannelMembershipOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateChannelMembership, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateChannelMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/memberships",
	}

	if input == nil {
		input = &CreateChannelMembershipInput{}
	}

	output = &CreateChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateChannelMembership API operation for Amazon Chime.
//
// Adds a user to a channel. The InvitedBy response field is derived from the
// request header. A channel member can:
//
//   - List messages
//
//   - Send messages
//
//   - Receive messages
//
//   - Edit their own messages
//
//   - Leave the channel
//
// Privacy settings impact this action as follows:
//
//   - Public Channels: You do not need to be a member to list messages, but
//     you must be a member to send messages.
//
//   - Private Channels: You must be a member to list or send messages.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateChannelMembership (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelMembership.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelMembership
//
// Deprecated: Replaced by CreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelMembership(input *CreateChannelMembershipInput) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	return out, req.Send()
}

// CreateChannelMembershipWithContext is the same as CreateChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelMembershipWithContext(ctx aws.Context, input *CreateChannelMembershipInput, opts ...request.Option) (*CreateChannelMembershipOutput, error) {
	req, out := c.CreateChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelModerator = "CreateChannelModerator"

// CreateChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelModerator for more information on using the CreateChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelModeratorRequest method.
//	req, resp := client.CreateChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelModerator
//
// Deprecated: Replaced by CreateChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelModeratorRequest(input *CreateChannelModeratorInput) (req *request.Request, output *CreateChannelModeratorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateChannelModerator, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateChannelModerator,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/moderators",
	}

	if input == nil {
		input = &CreateChannelModeratorInput{}
	}

	output = &CreateChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateChannelModerator API operation for Amazon Chime.
//
// Creates a new ChannelModerator. A channel moderator can:
//
//   - Add and remove other members of the channel.
//
//   - Add and remove other moderators of the channel.
//
//   - Add and remove user bans for the channel.
//
//   - Redact messages in the channel.
//
//   - List messages in the channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateChannelModerator (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelModerator.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateChannelModerator
//
// Deprecated: Replaced by CreateChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelModerator(input *CreateChannelModeratorInput) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	return out, req.Send()
}

// CreateChannelModeratorWithContext is the same as CreateChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) CreateChannelModeratorWithContext(ctx aws.Context, input *CreateChannelModeratorInput, opts ...request.Option) (*CreateChannelModeratorOutput, error) {
	req, out := c.CreateChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMediaCapturePipeline = "CreateMediaCapturePipeline"

// CreateMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMediaCapturePipeline for more information on using the CreateMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMediaCapturePipelineRequest method.
//	req, resp := client.CreateMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMediaCapturePipeline
//
// Deprecated: Replaced by CreateMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) CreateMediaCapturePipelineRequest(input *CreateMediaCapturePipelineInput) (req *request.Request, output *CreateMediaCapturePipelineOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateMediaCapturePipeline, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateMediaCapturePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/media-capture-pipelines",
	}

	if input == nil {
		input = &CreateMediaCapturePipelineInput{}
	}

	output = &CreateMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMediaCapturePipeline API operation for Amazon Chime.
//
// Creates a media capture pipeline.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateMediaCapturePipeline (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_CreateMediaCapturePipeline),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMediaCapturePipeline
//
// Deprecated: Replaced by CreateMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) CreateMediaCapturePipeline(input *CreateMediaCapturePipelineInput) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// CreateMediaCapturePipelineWithContext is the same as CreateMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) CreateMediaCapturePipelineWithContext(ctx aws.Context, input *CreateMediaCapturePipelineInput, opts ...request.Option) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeeting = "CreateMeeting"

// CreateMeetingRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeeting for more information on using the CreateMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeetingRequest method.
//	req, resp := client.CreateMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting
//
// Deprecated: Replaced by CreateMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeetingRequest(input *CreateMeetingInput) (req *request.Request, output *CreateMeetingOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateMeeting, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings",
	}

	if input == nil {
		input = &CreateMeetingInput{}
	}

	output = &CreateMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeeting API operation for Amazon Chime.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region with
// no initial attendees. For more information about specifying media Regions,
// see Amazon Chime SDK Media Regions (https://docs.aws.amazon.com/chime-sdk/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime SDK Developer Guide . For more information about the
// Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateMeeting (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting
//
// Deprecated: Replaced by CreateMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeeting(input *CreateMeetingInput) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	return out, req.Send()
}

// CreateMeetingWithContext is the same as CreateMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeetingWithContext(ctx aws.Context, input *CreateMeetingInput, opts ...request.Option) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeetingDialOut = "CreateMeetingDialOut"

// CreateMeetingDialOutRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeetingDialOut operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeetingDialOut for more information on using the CreateMeetingDialOut
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeetingDialOutRequest method.
//	req, resp := client.CreateMeetingDialOutRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeetingDialOut
func (c *Chime) CreateMeetingDialOutRequest(input *CreateMeetingDialOutInput) (req *request.Request, output *CreateMeetingDialOutOutput) {
	op := &request.Operation{
		Name:       opCreateMeetingDialOut,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/dial-outs",
	}

	if input == nil {
		input = &CreateMeetingDialOutInput{}
	}

	output = &CreateMeetingDialOutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeetingDialOut API operation for Amazon Chime.
//
// Uses the join token and call metadata in a meeting request (From number,
// To number, and so forth) to initiate an outbound call to a public switched
// telephone network (PSTN) and join them into a Chime meeting. Also ensures
// that the From number belongs to the customer.
//
// To play welcome audio or implement an interactive voice response (IVR), use
// the CreateSipMediaApplicationCall action with the corresponding SIP media
// application ID.
//
// This API is is not available in a dedicated namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateMeetingDialOut for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeetingDialOut
func (c *Chime) CreateMeetingDialOut(input *CreateMeetingDialOutInput) (*CreateMeetingDialOutOutput, error) {
	req, out := c.CreateMeetingDialOutRequest(input)
	return out, req.Send()
}

// CreateMeetingDialOutWithContext is the same as CreateMeetingDialOut with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeetingDialOut for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateMeetingDialOutWithContext(ctx aws.Context, input *CreateMeetingDialOutInput, opts ...request.Option) (*CreateMeetingDialOutOutput, error) {
	req, out := c.CreateMeetingDialOutRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeetingWithAttendees = "CreateMeetingWithAttendees"

// CreateMeetingWithAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeetingWithAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeetingWithAttendees for more information on using the CreateMeetingWithAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMeetingWithAttendeesRequest method.
//	req, resp := client.CreateMeetingWithAttendeesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeetingWithAttendees
//
// Deprecated: Replaced by CreateMeetingWithAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeetingWithAttendeesRequest(input *CreateMeetingWithAttendeesInput) (req *request.Request, output *CreateMeetingWithAttendeesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateMeetingWithAttendees, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateMeetingWithAttendees,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings?operation=create-attendees",
	}

	if input == nil {
		input = &CreateMeetingWithAttendeesInput{}
	}

	output = &CreateMeetingWithAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeetingWithAttendees API operation for Amazon Chime.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region, with
// attendees. For more information about specifying media Regions, see Amazon
// Chime SDK Media Regions (https://docs.aws.amazon.com/chime-sdk/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime SDK Developer Guide . For more information about the
// Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide .
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateMeetingWithAttendees (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeetingWithAttendees.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateMeetingWithAttendees for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeetingWithAttendees
//
// Deprecated: Replaced by CreateMeetingWithAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeetingWithAttendees(input *CreateMeetingWithAttendeesInput) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	return out, req.Send()
}

// CreateMeetingWithAttendeesWithContext is the same as CreateMeetingWithAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeetingWithAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateMeetingWithAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) CreateMeetingWithAttendeesWithContext(ctx aws.Context, input *CreateMeetingWithAttendeesInput, opts ...request.Option) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePhoneNumberOrder = "CreatePhoneNumberOrder"

// CreatePhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the CreatePhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePhoneNumberOrder for more information on using the CreatePhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePhoneNumberOrderRequest method.
//	req, resp := client.CreatePhoneNumberOrderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder
func (c *Chime) CreatePhoneNumberOrderRequest(input *CreatePhoneNumberOrderInput) (req *request.Request, output *CreatePhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opCreatePhoneNumberOrder,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number-orders",
	}

	if input == nil {
		input = &CreatePhoneNumberOrderInput{}
	}

	output = &CreatePhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePhoneNumberOrder API operation for Amazon Chime.
//
// Creates an order for phone numbers to be provisioned. For toll-free numbers,
// you cannot use the Amazon Chime Business Calling product type. For numbers
// outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In
// product type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreatePhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder
func (c *Chime) CreatePhoneNumberOrder(input *CreatePhoneNumberOrderInput) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	return out, req.Send()
}

// CreatePhoneNumberOrderWithContext is the same as CreatePhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreatePhoneNumberOrderWithContext(ctx aws.Context, input *CreatePhoneNumberOrderInput, opts ...request.Option) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProxySession = "CreateProxySession"

// CreateProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProxySession for more information on using the CreateProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProxySessionRequest method.
//	req, resp := client.CreateProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateProxySession
//
// Deprecated: Replaced by CreateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateProxySessionRequest(input *CreateProxySessionInput) (req *request.Request, output *CreateProxySessionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateProxySession, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateProxySession,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions",
	}

	if input == nil {
		input = &CreateProxySessionInput{}
	}

	output = &CreateProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProxySession API operation for Amazon Chime.
//
// Creates a proxy session on the specified Amazon Chime Voice Connector for
// the specified participant phone numbers.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateProxySession (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateProxySession.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateProxySession
//
// Deprecated: Replaced by CreateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateProxySession(input *CreateProxySessionInput) (*CreateProxySessionOutput, error) {
	req, out := c.CreateProxySessionRequest(input)
	return out, req.Send()
}

// CreateProxySessionWithContext is the same as CreateProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateProxySessionWithContext(ctx aws.Context, input *CreateProxySessionInput, opts ...request.Option) (*CreateProxySessionOutput, error) {
	req, out := c.CreateProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoom = "CreateRoom"

// CreateRoomRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoom for more information on using the CreateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRoomRequest method.
//	req, resp := client.CreateRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom
func (c *Chime) CreateRoomRequest(input *CreateRoomInput) (req *request.Request, output *CreateRoomOutput) {
	op := &request.Operation{
		Name:       opCreateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms",
	}

	if input == nil {
		input = &CreateRoomInput{}
	}

	output = &CreateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoom API operation for Amazon Chime.
//
// Creates a chat room for the specified Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateRoom for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom
func (c *Chime) CreateRoom(input *CreateRoomInput) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	return out, req.Send()
}

// CreateRoomWithContext is the same as CreateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateRoomWithContext(ctx aws.Context, input *CreateRoomInput, opts ...request.Option) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoomMembership = "CreateRoomMembership"

// CreateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoomMembership for more information on using the CreateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRoomMembershipRequest method.
//	req, resp := client.CreateRoomMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership
func (c *Chime) CreateRoomMembershipRequest(input *CreateRoomMembershipInput) (req *request.Request, output *CreateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships",
	}

	if input == nil {
		input = &CreateRoomMembershipInput{}
	}

	output = &CreateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoomMembership API operation for Amazon Chime.
//
// Adds a member to a chat room in an Amazon Chime Enterprise account. A member
// can be either a user or a bot. The member role designates whether the member
// is a chat room administrator or a general chat room member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateRoomMembership for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership
func (c *Chime) CreateRoomMembership(input *CreateRoomMembershipInput) (*CreateRoomMembershipOutput, error) {
	req, out := c.CreateRoomMembershipRequest(input)
	return out, req.Send()
}

// CreateRoomMembershipWithContext is the same as CreateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateRoomMembershipWithContext(ctx aws.Context, input *CreateRoomMembershipInput, opts ...request.Option) (*CreateRoomMembershipOutput, error) {
	req, out := c.CreateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipMediaApplication = "CreateSipMediaApplication"

// CreateSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipMediaApplication for more information on using the CreateSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipMediaApplicationRequest method.
//	req, resp := client.CreateSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipMediaApplication
//
// Deprecated: Replaced by CreateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplicationRequest(input *CreateSipMediaApplicationInput) (req *request.Request, output *CreateSipMediaApplicationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateSipMediaApplication, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateSipMediaApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications",
	}

	if input == nil {
		input = &CreateSipMediaApplicationInput{}
	}

	output = &CreateSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipMediaApplication API operation for Amazon Chime.
//
// Creates a SIP media application.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateSipMediaApplication (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateSipMediaApplication.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipMediaApplication
//
// Deprecated: Replaced by CreateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplication(input *CreateSipMediaApplicationInput) (*CreateSipMediaApplicationOutput, error) {
	req, out := c.CreateSipMediaApplicationRequest(input)
	return out, req.Send()
}

// CreateSipMediaApplicationWithContext is the same as CreateSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplicationWithContext(ctx aws.Context, input *CreateSipMediaApplicationInput, opts ...request.Option) (*CreateSipMediaApplicationOutput, error) {
	req, out := c.CreateSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipMediaApplicationCall = "CreateSipMediaApplicationCall"

// CreateSipMediaApplicationCallRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipMediaApplicationCall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipMediaApplicationCall for more information on using the CreateSipMediaApplicationCall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipMediaApplicationCallRequest method.
//	req, resp := client.CreateSipMediaApplicationCallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipMediaApplicationCall
//
// Deprecated: Replaced by CreateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplicationCallRequest(input *CreateSipMediaApplicationCallInput) (req *request.Request, output *CreateSipMediaApplicationCallOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateSipMediaApplicationCall, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateSipMediaApplicationCall,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/calls",
	}

	if input == nil {
		input = &CreateSipMediaApplicationCallInput{}
	}

	output = &CreateSipMediaApplicationCallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipMediaApplicationCall API operation for Amazon Chime.
//
// Creates an outbound call to a phone number from the phone number specified
// in the request, and it invokes the endpoint of the specified sipMediaApplicationId.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateSipMediaApplicationCall (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateSipMediaApplicationCall.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateSipMediaApplicationCall for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipMediaApplicationCall
//
// Deprecated: Replaced by CreateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplicationCall(input *CreateSipMediaApplicationCallInput) (*CreateSipMediaApplicationCallOutput, error) {
	req, out := c.CreateSipMediaApplicationCallRequest(input)
	return out, req.Send()
}

// CreateSipMediaApplicationCallWithContext is the same as CreateSipMediaApplicationCall with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipMediaApplicationCall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipMediaApplicationCallWithContext(ctx aws.Context, input *CreateSipMediaApplicationCallInput, opts ...request.Option) (*CreateSipMediaApplicationCallOutput, error) {
	req, out := c.CreateSipMediaApplicationCallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSipRule = "CreateSipRule"

// CreateSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSipRule for more information on using the CreateSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSipRuleRequest method.
//	req, resp := client.CreateSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipRule
//
// Deprecated: Replaced by CreateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipRuleRequest(input *CreateSipRuleInput) (req *request.Request, output *CreateSipRuleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateSipRule, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateSipRule,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-rules",
	}

	if input == nil {
		input = &CreateSipRuleInput{}
	}

	output = &CreateSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSipRule API operation for Amazon Chime.
//
// Creates a SIP rule which can be used to run a SIP media application as a
// target for a specific trigger type.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateSipRule (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateSipRule.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateSipRule for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateSipRule
//
// Deprecated: Replaced by CreateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipRule(input *CreateSipRuleInput) (*CreateSipRuleOutput, error) {
	req, out := c.CreateSipRuleRequest(input)
	return out, req.Send()
}

// CreateSipRuleWithContext is the same as CreateSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateSipRuleWithContext(ctx aws.Context, input *CreateSipRuleInput, opts ...request.Option) (*CreateSipRuleOutput, error) {
	req, out := c.CreateSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserRequest method.
//	req, resp := client.CreateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser
func (c *Chime) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=create",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon Chime.
//
// Creates a user under the specified Amazon Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser
func (c *Chime) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnector = "CreateVoiceConnector"

// CreateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnector for more information on using the CreateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVoiceConnectorRequest method.
//	req, resp := client.CreateVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector
//
// Deprecated: Replaced by CreateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnectorRequest(input *CreateVoiceConnectorInput) (req *request.Request, output *CreateVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors",
	}

	if input == nil {
		input = &CreateVoiceConnectorInput{}
	}

	output = &CreateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnector API operation for Amazon Chime.
//
// Creates an Amazon Chime Voice Connector under the administrator's AWS account.
// You can choose to create an Amazon Chime Voice Connector in a specific AWS
// Region.
//
// Enabling CreateVoiceConnectorRequest$RequireEncryption configures your Amazon
// Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP
// (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound
// calls are blocked.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector
//
// Deprecated: Replaced by CreateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnector(input *CreateVoiceConnectorInput) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorWithContext is the same as CreateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnectorWithContext(ctx aws.Context, input *CreateVoiceConnectorInput, opts ...request.Option) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnectorGroup = "CreateVoiceConnectorGroup"

// CreateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnectorGroup for more information on using the CreateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVoiceConnectorGroupRequest method.
//	req, resp := client.CreateVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup
//
// Deprecated: Replaced by CreateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnectorGroupRequest(input *CreateVoiceConnectorGroupInput) (req *request.Request, output *CreateVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups",
	}

	if input == nil {
		input = &CreateVoiceConnectorGroupInput{}
	}

	output = &CreateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnectorGroup API operation for Amazon Chime.
//
// Creates an Amazon Chime Voice Connector group under the administrator's AWS
// account. You can associate Amazon Chime Voice Connectors with the Amazon
// Chime Voice Connector group by including VoiceConnectorItems in the request.
//
// You can include Amazon Chime Voice Connectors from different AWS Regions
// in your group. This creates a fault tolerant mechanism for fallback in case
// of availability events.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, CreateVoiceConnectorGroup (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_CreateVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup
//
// Deprecated: Replaced by CreateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnectorGroup(input *CreateVoiceConnectorGroupInput) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorGroupWithContext is the same as CreateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by CreateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) CreateVoiceConnectorGroupWithContext(ctx aws.Context, input *CreateVoiceConnectorGroupInput, opts ...request.Option) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccount = "DeleteAccount"

// DeleteAccountRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccount for more information on using the DeleteAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountRequest method.
//	req, resp := client.DeleteAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccountRequest(input *DeleteAccountInput) (req *request.Request, output *DeleteAccountOutput) {
	op := &request.Operation{
		Name:       opDeleteAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &DeleteAccountInput{}
	}

	output = &DeleteAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccount API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime account. You must suspend all users before
// deleting Team account. You can use the BatchSuspendUser action to dodo.
//
// For EnterpriseLWA and EnterpriseAD accounts, you must release the claimed
// domains for your Amazon Chime account before deletion. As soon as you release
// the domain, all users under that account are suspended.
//
// Deleted accounts appear in your Disabled accounts list for 90 days. To restore
// deleted account from your Disabled accounts list, you must contact AWS Support.
//
// After 90 days, deleted accounts are permanently removed from your Disabled
// accounts list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccount(input *DeleteAccountInput) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	return out, req.Send()
}

// DeleteAccountWithContext is the same as DeleteAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteAccountWithContext(ctx aws.Context, input *DeleteAccountInput, opts ...request.Option) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstance = "DeleteAppInstance"

// DeleteAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstance for more information on using the DeleteAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceRequest method.
//	req, resp := client.DeleteAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstance
//
// Deprecated: Replaced by DeleteAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceRequest(input *DeleteAppInstanceInput) (req *request.Request, output *DeleteAppInstanceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteAppInstance, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteAppInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceInput{}
	}

	output = &DeleteAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAppInstance API operation for Amazon Chime.
//
// Deletes an AppInstance and all associated data asynchronously.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteAppInstance (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstance.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstance
//
// Deprecated: Replaced by DeleteAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstance(input *DeleteAppInstanceInput) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceWithContext is the same as DeleteAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceWithContext(ctx aws.Context, input *DeleteAppInstanceInput, opts ...request.Option) (*DeleteAppInstanceOutput, error) {
	req, out := c.DeleteAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceAdmin = "DeleteAppInstanceAdmin"

// DeleteAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceAdmin for more information on using the DeleteAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceAdminRequest method.
//	req, resp := client.DeleteAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceAdmin
//
// Deprecated: Replaced by DeleteAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceAdminRequest(input *DeleteAppInstanceAdminInput) (req *request.Request, output *DeleteAppInstanceAdminOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteAppInstanceAdmin, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteAppInstanceAdmin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceAdminInput{}
	}

	output = &DeleteAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAppInstanceAdmin API operation for Amazon Chime.
//
// Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete
// the user.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteAppInstanceAdmin (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstanceAdmin.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceAdmin
//
// Deprecated: Replaced by DeleteAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceAdmin(input *DeleteAppInstanceAdminInput) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceAdminWithContext is the same as DeleteAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceAdminWithContext(ctx aws.Context, input *DeleteAppInstanceAdminInput, opts ...request.Option) (*DeleteAppInstanceAdminOutput, error) {
	req, out := c.DeleteAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceStreamingConfigurations = "DeleteAppInstanceStreamingConfigurations"

// DeleteAppInstanceStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceStreamingConfigurations for more information on using the DeleteAppInstanceStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceStreamingConfigurationsRequest method.
//	req, resp := client.DeleteAppInstanceStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by DeleteAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteAppInstanceStreamingConfigurationsRequest(input *DeleteAppInstanceStreamingConfigurationsInput) (req *request.Request, output *DeleteAppInstanceStreamingConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteAppInstanceStreamingConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteAppInstanceStreamingConfigurations,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &DeleteAppInstanceStreamingConfigurationsInput{}
	}

	output = &DeleteAppInstanceStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppInstanceStreamingConfigurations API operation for Amazon Chime.
//
// Deletes the streaming configurations of an AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteAppInstanceStreamingConfigurations (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstanceStreamingConfigurations.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAppInstanceStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by DeleteAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteAppInstanceStreamingConfigurations(input *DeleteAppInstanceStreamingConfigurationsInput) (*DeleteAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.DeleteAppInstanceStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceStreamingConfigurationsWithContext is the same as DeleteAppInstanceStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteAppInstanceStreamingConfigurationsWithContext(ctx aws.Context, input *DeleteAppInstanceStreamingConfigurationsInput, opts ...request.Option) (*DeleteAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.DeleteAppInstanceStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppInstanceUser = "DeleteAppInstanceUser"

// DeleteAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppInstanceUser for more information on using the DeleteAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAppInstanceUserRequest method.
//	req, resp := client.DeleteAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceUser
//
// Deprecated: Replaced by DeleteAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceUserRequest(input *DeleteAppInstanceUserInput) (req *request.Request, output *DeleteAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteAppInstanceUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DeleteAppInstanceUserInput{}
	}

	output = &DeleteAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAppInstanceUser API operation for Amazon Chime.
//
// Deletes an AppInstanceUser.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAppInstanceUser
//
// Deprecated: Replaced by DeleteAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceUser(input *DeleteAppInstanceUserInput) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	return out, req.Send()
}

// DeleteAppInstanceUserWithContext is the same as DeleteAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DeleteAppInstanceUserWithContext(ctx aws.Context, input *DeleteAppInstanceUserInput, opts ...request.Option) (*DeleteAppInstanceUserOutput, error) {
	req, out := c.DeleteAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttendee = "DeleteAttendee"

// DeleteAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttendee for more information on using the DeleteAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAttendeeRequest method.
//	req, resp := client.DeleteAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee
//
// Deprecated: Replaced by DeleteAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteAttendeeRequest(input *DeleteAttendeeInput) (req *request.Request, output *DeleteAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteAttendee,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}",
	}

	if input == nil {
		input = &DeleteAttendeeInput{}
	}

	output = &DeleteAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAttendee API operation for Amazon Chime.
//
// Deletes an attendee from the specified Amazon Chime SDK meeting and deletes
// their JoinToken. Attendees are automatically deleted when a Amazon Chime
// SDK meeting is deleted. For more information about the Amazon Chime SDK,
// see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteAttendee (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_DeleteAttendee.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee
//
// Deprecated: Replaced by DeleteAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteAttendee(input *DeleteAttendeeInput) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	return out, req.Send()
}

// DeleteAttendeeWithContext is the same as DeleteAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteAttendeeWithContext(ctx aws.Context, input *DeleteAttendeeInput, opts ...request.Option) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannel
//
// Deprecated: Replaced by DeleteChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteChannel, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteChannel API operation for Amazon Chime.
//
// Immediately makes a channel and its memberships inaccessible and marks them
// for deletion. This is an irreversible process.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteChannel (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannel.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannel
//
// Deprecated: Replaced by DeleteChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelBan = "DeleteChannelBan"

// DeleteChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelBan for more information on using the DeleteChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelBanRequest method.
//	req, resp := client.DeleteChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelBan
//
// Deprecated: Replaced by DeleteChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelBanRequest(input *DeleteChannelBanInput) (req *request.Request, output *DeleteChannelBanOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteChannelBan, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteChannelBan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelBanInput{}
	}

	output = &DeleteChannelBanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteChannelBan API operation for Amazon Chime.
//
// Removes a user from a channel's ban list.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteChannelBan (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelBan.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelBan
//
// Deprecated: Replaced by DeleteChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelBan(input *DeleteChannelBanInput) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	return out, req.Send()
}

// DeleteChannelBanWithContext is the same as DeleteChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelBanWithContext(ctx aws.Context, input *DeleteChannelBanInput, opts ...request.Option) (*DeleteChannelBanOutput, error) {
	req, out := c.DeleteChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMembership = "DeleteChannelMembership"

// DeleteChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMembership for more information on using the DeleteChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelMembershipRequest method.
//	req, resp := client.DeleteChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelMembership
//
// Deprecated: Replaced by DeleteChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMembershipRequest(input *DeleteChannelMembershipInput) (req *request.Request, output *DeleteChannelMembershipOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteChannelMembership, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteChannelMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DeleteChannelMembershipInput{}
	}

	output = &DeleteChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteChannelMembership API operation for Amazon Chime.
//
// Removes a member from a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteChannelMembership (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelMembership.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelMembership
//
// Deprecated: Replaced by DeleteChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMembership(input *DeleteChannelMembershipInput) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	return out, req.Send()
}

// DeleteChannelMembershipWithContext is the same as DeleteChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMembershipWithContext(ctx aws.Context, input *DeleteChannelMembershipInput, opts ...request.Option) (*DeleteChannelMembershipOutput, error) {
	req, out := c.DeleteChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelMessage = "DeleteChannelMessage"

// DeleteChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelMessage for more information on using the DeleteChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelMessageRequest method.
//	req, resp := client.DeleteChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelMessage
//
// Deprecated: Replaced by DeleteChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMessageRequest(input *DeleteChannelMessageInput) (req *request.Request, output *DeleteChannelMessageOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteChannelMessage, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteChannelMessage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &DeleteChannelMessageInput{}
	}

	output = &DeleteChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteChannelMessage API operation for Amazon Chime.
//
// Deletes a channel message. Only admins can perform this action. Deletion
// makes messages inaccessible immediately. A background process deletes any
// revisions created by UpdateChannelMessage.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteChannelMessage (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelMessage.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelMessage
//
// Deprecated: Replaced by DeleteChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMessage(input *DeleteChannelMessageInput) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	return out, req.Send()
}

// DeleteChannelMessageWithContext is the same as DeleteChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelMessageWithContext(ctx aws.Context, input *DeleteChannelMessageInput, opts ...request.Option) (*DeleteChannelMessageOutput, error) {
	req, out := c.DeleteChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelModerator = "DeleteChannelModerator"

// DeleteChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelModerator for more information on using the DeleteChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelModeratorRequest method.
//	req, resp := client.DeleteChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelModerator
//
// Deprecated: Replaced by DeleteChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelModeratorRequest(input *DeleteChannelModeratorInput) (req *request.Request, output *DeleteChannelModeratorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteChannelModerator, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteChannelModerator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DeleteChannelModeratorInput{}
	}

	output = &DeleteChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteChannelModerator API operation for Amazon Chime.
//
// Deletes a channel moderator.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteChannelModerator (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelModerator.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteChannelModerator
//
// Deprecated: Replaced by DeleteChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelModerator(input *DeleteChannelModeratorInput) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	return out, req.Send()
}

// DeleteChannelModeratorWithContext is the same as DeleteChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DeleteChannelModeratorWithContext(ctx aws.Context, input *DeleteChannelModeratorInput, opts ...request.Option) (*DeleteChannelModeratorOutput, error) {
	req, out := c.DeleteChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventsConfiguration = "DeleteEventsConfiguration"

// DeleteEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventsConfiguration for more information on using the DeleteEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventsConfigurationRequest method.
//	req, resp := client.DeleteEventsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration
func (c *Chime) DeleteEventsConfigurationRequest(input *DeleteEventsConfigurationInput) (req *request.Request, output *DeleteEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEventsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &DeleteEventsConfigurationInput{}
	}

	output = &DeleteEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventsConfiguration API operation for Amazon Chime.
//
// Deletes the events configuration that allows a bot to receive outgoing events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteEventsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration
func (c *Chime) DeleteEventsConfiguration(input *DeleteEventsConfigurationInput) (*DeleteEventsConfigurationOutput, error) {
	req, out := c.DeleteEventsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteEventsConfigurationWithContext is the same as DeleteEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteEventsConfigurationWithContext(ctx aws.Context, input *DeleteEventsConfigurationInput, opts ...request.Option) (*DeleteEventsConfigurationOutput, error) {
	req, out := c.DeleteEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMediaCapturePipeline = "DeleteMediaCapturePipeline"

// DeleteMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMediaCapturePipeline for more information on using the DeleteMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMediaCapturePipelineRequest method.
//	req, resp := client.DeleteMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMediaCapturePipeline
//
// Deprecated: Replaced by DeleteMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) DeleteMediaCapturePipelineRequest(input *DeleteMediaCapturePipelineInput) (req *request.Request, output *DeleteMediaCapturePipelineOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteMediaCapturePipeline, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteMediaCapturePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &DeleteMediaCapturePipelineInput{}
	}

	output = &DeleteMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMediaCapturePipeline API operation for Amazon Chime.
//
// Deletes the media capture pipeline.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteMediaCapturePipeline (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_DeleteMediaCapturePipeline.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMediaCapturePipeline
//
// Deprecated: Replaced by DeleteMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) DeleteMediaCapturePipeline(input *DeleteMediaCapturePipelineInput) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// DeleteMediaCapturePipelineWithContext is the same as DeleteMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) DeleteMediaCapturePipelineWithContext(ctx aws.Context, input *DeleteMediaCapturePipelineInput, opts ...request.Option) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMeeting = "DeleteMeeting"

// DeleteMeetingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMeeting for more information on using the DeleteMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMeetingRequest method.
//	req, resp := client.DeleteMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting
//
// Deprecated: Replaced by DeleteMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteMeetingRequest(input *DeleteMeetingInput) (req *request.Request, output *DeleteMeetingOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteMeeting, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteMeeting,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{meetingId}",
	}

	if input == nil {
		input = &DeleteMeetingInput{}
	}

	output = &DeleteMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMeeting API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime SDK meeting. The operation deletes all
// attendees, disconnects all clients, and prevents new clients from joining
// the meeting. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteMeeting (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_DeleteMeeting.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting
//
// Deprecated: Replaced by DeleteMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteMeeting(input *DeleteMeetingInput) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	return out, req.Send()
}

// DeleteMeetingWithContext is the same as DeleteMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) DeleteMeetingWithContext(ctx aws.Context, input *DeleteMeetingInput, opts ...request.Option) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePhoneNumber = "DeletePhoneNumber"

// DeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the DeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePhoneNumber for more information on using the DeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePhoneNumberRequest method.
//	req, resp := client.DeletePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber
func (c *Chime) DeletePhoneNumberRequest(input *DeletePhoneNumberInput) (req *request.Request, output *DeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opDeletePhoneNumber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &DeletePhoneNumberInput{}
	}

	output = &DeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePhoneNumber API operation for Amazon Chime.
//
// Moves the specified phone number into the Deletion queue. A phone number
// must be disassociated from any users or Amazon Chime Voice Connectors before
// it can be deleted.
//
// Deleted phone numbers remain in the Deletion queue for 7 days before they
// are deleted permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber
func (c *Chime) DeletePhoneNumber(input *DeletePhoneNumberInput) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	return out, req.Send()
}

// DeletePhoneNumberWithContext is the same as DeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeletePhoneNumberWithContext(ctx aws.Context, input *DeletePhoneNumberInput, opts ...request.Option) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProxySession = "DeleteProxySession"

// DeleteProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProxySession for more information on using the DeleteProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProxySessionRequest method.
//	req, resp := client.DeleteProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteProxySession
//
// Deprecated: Replaced by DeleteProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteProxySessionRequest(input *DeleteProxySessionInput) (req *request.Request, output *DeleteProxySessionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteProxySession, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteProxySession,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &DeleteProxySessionInput{}
	}

	output = &DeleteProxySessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProxySession API operation for Amazon Chime.
//
// Deletes the specified proxy session from the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteProxySession (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteProxySession.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteProxySession
//
// Deprecated: Replaced by DeleteProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteProxySession(input *DeleteProxySessionInput) (*DeleteProxySessionOutput, error) {
	req, out := c.DeleteProxySessionRequest(input)
	return out, req.Send()
}

// DeleteProxySessionWithContext is the same as DeleteProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteProxySessionWithContext(ctx aws.Context, input *DeleteProxySessionInput, opts ...request.Option) (*DeleteProxySessionOutput, error) {
	req, out := c.DeleteProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoom = "DeleteRoom"

// DeleteRoomRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoom for more information on using the DeleteRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRoomRequest method.
//	req, resp := client.DeleteRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom
func (c *Chime) DeleteRoomRequest(input *DeleteRoomInput) (req *request.Request, output *DeleteRoomOutput) {
	op := &request.Operation{
		Name:       opDeleteRoom,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &DeleteRoomInput{}
	}

	output = &DeleteRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoom API operation for Amazon Chime.
//
// Deletes a chat room in an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteRoom for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom
func (c *Chime) DeleteRoom(input *DeleteRoomInput) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	return out, req.Send()
}

// DeleteRoomWithContext is the same as DeleteRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteRoomWithContext(ctx aws.Context, input *DeleteRoomInput, opts ...request.Option) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoomMembership = "DeleteRoomMembership"

// DeleteRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoomMembership for more information on using the DeleteRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRoomMembershipRequest method.
//	req, resp := client.DeleteRoomMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership
func (c *Chime) DeleteRoomMembershipRequest(input *DeleteRoomMembershipInput) (req *request.Request, output *DeleteRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteRoomMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &DeleteRoomMembershipInput{}
	}

	output = &DeleteRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoomMembership API operation for Amazon Chime.
//
// Removes a member from a chat room in an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteRoomMembership for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership
func (c *Chime) DeleteRoomMembership(input *DeleteRoomMembershipInput) (*DeleteRoomMembershipOutput, error) {
	req, out := c.DeleteRoomMembershipRequest(input)
	return out, req.Send()
}

// DeleteRoomMembershipWithContext is the same as DeleteRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteRoomMembershipWithContext(ctx aws.Context, input *DeleteRoomMembershipInput, opts ...request.Option) (*DeleteRoomMembershipOutput, error) {
	req, out := c.DeleteRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSipMediaApplication = "DeleteSipMediaApplication"

// DeleteSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSipMediaApplication for more information on using the DeleteSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSipMediaApplicationRequest method.
//	req, resp := client.DeleteSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteSipMediaApplication
//
// Deprecated: Replaced by DeleteSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipMediaApplicationRequest(input *DeleteSipMediaApplicationInput) (req *request.Request, output *DeleteSipMediaApplicationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteSipMediaApplication, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteSipMediaApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &DeleteSipMediaApplicationInput{}
	}

	output = &DeleteSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSipMediaApplication API operation for Amazon Chime.
//
// Deletes a SIP media application.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteSipMediaApplication (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteSipMediaApplication.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteSipMediaApplication
//
// Deprecated: Replaced by DeleteSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipMediaApplication(input *DeleteSipMediaApplicationInput) (*DeleteSipMediaApplicationOutput, error) {
	req, out := c.DeleteSipMediaApplicationRequest(input)
	return out, req.Send()
}

// DeleteSipMediaApplicationWithContext is the same as DeleteSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipMediaApplicationWithContext(ctx aws.Context, input *DeleteSipMediaApplicationInput, opts ...request.Option) (*DeleteSipMediaApplicationOutput, error) {
	req, out := c.DeleteSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSipRule = "DeleteSipRule"

// DeleteSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSipRule for more information on using the DeleteSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSipRuleRequest method.
//	req, resp := client.DeleteSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteSipRule
//
// Deprecated: Replaced by DeleteSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipRuleRequest(input *DeleteSipRuleInput) (req *request.Request, output *DeleteSipRuleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteSipRule, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteSipRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &DeleteSipRuleInput{}
	}

	output = &DeleteSipRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSipRule API operation for Amazon Chime.
//
// Deletes a SIP rule. You must disable a SIP rule before you can delete it.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteSipRule (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteSipRule.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteSipRule
//
// Deprecated: Replaced by DeleteSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipRule(input *DeleteSipRuleInput) (*DeleteSipRuleOutput, error) {
	req, out := c.DeleteSipRuleRequest(input)
	return out, req.Send()
}

// DeleteSipRuleWithContext is the same as DeleteSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteSipRuleWithContext(ctx aws.Context, input *DeleteSipRuleInput, opts ...request.Option) (*DeleteSipRuleOutput, error) {
	req, out := c.DeleteSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnector = "DeleteVoiceConnector"

// DeleteVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnector for more information on using the DeleteVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorRequest method.
//	req, resp := client.DeleteVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector
//
// Deprecated: Replaced by DeleteVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorRequest(input *DeleteVoiceConnectorInput) (req *request.Request, output *DeleteVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorInput{}
	}

	output = &DeleteVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnector API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated
// with the Amazon Chime Voice Connector must be disassociated from it before
// it can be deleted.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector
//
// Deprecated: Replaced by DeleteVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnector(input *DeleteVoiceConnectorInput) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorWithContext is the same as DeleteVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorWithContext(ctx aws.Context, input *DeleteVoiceConnectorInput, opts ...request.Option) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorEmergencyCallingConfiguration = "DeleteVoiceConnectorEmergencyCallingConfiguration"

// DeleteVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorEmergencyCallingConfiguration for more information on using the DeleteVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by DeleteVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input *DeleteVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *DeleteVoiceConnectorEmergencyCallingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorEmergencyCallingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &DeleteVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime.
//
// Deletes the emergency calling configuration details from the specified Amazon
// Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorEmergencyCallingConfiguration
// (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorEmergencyCallingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by DeleteVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorEmergencyCallingConfiguration(input *DeleteVoiceConnectorEmergencyCallingConfigurationInput) (*DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorEmergencyCallingConfigurationWithContext is the same as DeleteVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *DeleteVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorGroup = "DeleteVoiceConnectorGroup"

// DeleteVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorGroup for more information on using the DeleteVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorGroupRequest method.
//	req, resp := client.DeleteVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup
//
// Deprecated: Replaced by DeleteVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorGroupRequest(input *DeleteVoiceConnectorGroupInput) (req *request.Request, output *DeleteVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorGroupInput{}
	}

	output = &DeleteVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorGroup API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime Voice Connector group. Any VoiceConnectorItems
// and phone numbers associated with the group must be removed before it can
// be deleted.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorGroup (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup
//
// Deprecated: Replaced by DeleteVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorGroup(input *DeleteVoiceConnectorGroupInput) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorGroupWithContext is the same as DeleteVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorGroupWithContext(ctx aws.Context, input *DeleteVoiceConnectorGroupInput, opts ...request.Option) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorOrigination = "DeleteVoiceConnectorOrigination"

// DeleteVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorOrigination for more information on using the DeleteVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorOriginationRequest method.
//	req, resp := client.DeleteVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination
//
// Deprecated: Replaced by DeleteVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorOriginationRequest(input *DeleteVoiceConnectorOriginationInput) (req *request.Request, output *DeleteVoiceConnectorOriginationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorOrigination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorOrigination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorOriginationInput{}
	}

	output = &DeleteVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorOrigination API operation for Amazon Chime.
//
// Deletes the origination settings for the specified Amazon Chime Voice Connector.
//
// If emergency calling is configured for the Amazon Chime Voice Connector,
// it must be deleted prior to deleting the origination settings.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorOrigination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorOrigination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination
//
// Deprecated: Replaced by DeleteVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorOrigination(input *DeleteVoiceConnectorOriginationInput) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorOriginationWithContext is the same as DeleteVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorOriginationWithContext(ctx aws.Context, input *DeleteVoiceConnectorOriginationInput, opts ...request.Option) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorProxy = "DeleteVoiceConnectorProxy"

// DeleteVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorProxy for more information on using the DeleteVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorProxyRequest method.
//	req, resp := client.DeleteVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorProxy
//
// Deprecated: Replaced by DeleteVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorProxyRequest(input *DeleteVoiceConnectorProxyInput) (req *request.Request, output *DeleteVoiceConnectorProxyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorProxy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorProxy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &DeleteVoiceConnectorProxyInput{}
	}

	output = &DeleteVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorProxy API operation for Amazon Chime.
//
// Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceProxy (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorProxy.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorProxy
//
// Deprecated: Replaced by DeleteVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorProxy(input *DeleteVoiceConnectorProxyInput) (*DeleteVoiceConnectorProxyOutput, error) {
	req, out := c.DeleteVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorProxyWithContext is the same as DeleteVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorProxyWithContext(ctx aws.Context, input *DeleteVoiceConnectorProxyInput, opts ...request.Option) (*DeleteVoiceConnectorProxyOutput, error) {
	req, out := c.DeleteVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorStreamingConfiguration = "DeleteVoiceConnectorStreamingConfiguration"

// DeleteVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorStreamingConfiguration for more information on using the DeleteVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.DeleteVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by DeleteVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorStreamingConfigurationRequest(input *DeleteVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *DeleteVoiceConnectorStreamingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorStreamingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorStreamingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorStreamingConfigurationInput{}
	}

	output = &DeleteVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Deletes the streaming configuration for the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorStreamingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorStreamingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by DeleteVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorStreamingConfiguration(input *DeleteVoiceConnectorStreamingConfigurationInput) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorStreamingConfigurationWithContext is the same as DeleteVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *DeleteVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTermination = "DeleteVoiceConnectorTermination"

// DeleteVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTermination for more information on using the DeleteVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorTerminationRequest method.
//	req, resp := client.DeleteVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination
//
// Deprecated: Replaced by DeleteVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTerminationRequest(input *DeleteVoiceConnectorTerminationInput) (req *request.Request, output *DeleteVoiceConnectorTerminationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorTermination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTermination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationInput{}
	}

	output = &DeleteVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTermination API operation for Amazon Chime.
//
// Deletes the termination settings for the specified Amazon Chime Voice Connector.
//
// If emergency calling is configured for the Amazon Chime Voice Connector,
// it must be deleted prior to deleting the termination settings.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorTermination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorTermination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination
//
// Deprecated: Replaced by DeleteVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTermination(input *DeleteVoiceConnectorTerminationInput) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationWithContext is the same as DeleteVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTerminationWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTerminationCredentials = "DeleteVoiceConnectorTerminationCredentials"

// DeleteVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTerminationCredentials for more information on using the DeleteVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.DeleteVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by DeleteVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTerminationCredentialsRequest(input *DeleteVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *DeleteVoiceConnectorTerminationCredentialsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteVoiceConnectorTerminationCredentials, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=delete",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationCredentialsInput{}
	}

	output = &DeleteVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Deletes the specified SIP credentials used by your equipment to authenticate
// during call termination.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DeleteVoiceConnectorTerminationCredentials (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DeleteVoiceConnectorTerminationCredentials.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by DeleteVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTerminationCredentials(input *DeleteVoiceConnectorTerminationCredentialsInput) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationCredentialsWithContext is the same as DeleteVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DeleteVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) DeleteVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstance = "DescribeAppInstance"

// DescribeAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstance for more information on using the DescribeAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceRequest method.
//	req, resp := client.DescribeAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstance
//
// Deprecated: Replaced by DescribeAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceRequest(input *DescribeAppInstanceInput) (req *request.Request, output *DescribeAppInstanceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeAppInstance, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeAppInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceInput{}
	}

	output = &DescribeAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAppInstance API operation for Amazon Chime.
//
// Returns the full details of an AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeAppInstance (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstance.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstance
//
// Deprecated: Replaced by DescribeAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstance(input *DescribeAppInstanceInput) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceWithContext is the same as DescribeAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceWithContext(ctx aws.Context, input *DescribeAppInstanceInput, opts ...request.Option) (*DescribeAppInstanceOutput, error) {
	req, out := c.DescribeAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceAdmin = "DescribeAppInstanceAdmin"

// DescribeAppInstanceAdminRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceAdmin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceAdmin for more information on using the DescribeAppInstanceAdmin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceAdminRequest method.
//	req, resp := client.DescribeAppInstanceAdminRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstanceAdmin
//
// Deprecated: Replaced by DescribeAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceAdminRequest(input *DescribeAppInstanceAdminInput) (req *request.Request, output *DescribeAppInstanceAdminOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeAppInstanceAdmin, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeAppInstanceAdmin,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins/{appInstanceAdminArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceAdminInput{}
	}

	output = &DescribeAppInstanceAdminOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAppInstanceAdmin API operation for Amazon Chime.
//
// Returns the full details of an AppInstanceAdmin.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeAppInstanceAdmin (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstanceAdmin.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeAppInstanceAdmin for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstanceAdmin
//
// Deprecated: Replaced by DescribeAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceAdmin(input *DescribeAppInstanceAdminInput) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceAdminWithContext is the same as DescribeAppInstanceAdmin with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceAdmin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeAppInstanceAdmin in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceAdminWithContext(ctx aws.Context, input *DescribeAppInstanceAdminInput, opts ...request.Option) (*DescribeAppInstanceAdminOutput, error) {
	req, out := c.DescribeAppInstanceAdminRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppInstanceUser = "DescribeAppInstanceUser"

// DescribeAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppInstanceUser for more information on using the DescribeAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAppInstanceUserRequest method.
//	req, resp := client.DescribeAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstanceUser
//
// Deprecated: Replaced by DescribeAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceUserRequest(input *DescribeAppInstanceUserInput) (req *request.Request, output *DescribeAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &DescribeAppInstanceUserInput{}
	}

	output = &DescribeAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeAppInstanceUser API operation for Amazon Chime.
//
// Returns the full details of an AppInstanceUser.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeAppInstanceUser
//
// Deprecated: Replaced by DescribeAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceUser(input *DescribeAppInstanceUserInput) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeAppInstanceUserWithContext is the same as DescribeAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) DescribeAppInstanceUserWithContext(ctx aws.Context, input *DescribeAppInstanceUserInput, opts ...request.Option) (*DescribeAppInstanceUserOutput, error) {
	req, out := c.DescribeAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelRequest method.
//	req, resp := client.DescribeChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannel
//
// Deprecated: Replaced by DescribeChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannel, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannel API operation for Amazon Chime.
//
// Returns the full details of a channel in an Amazon Chime AppInstance.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannel (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannel.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannel
//
// Deprecated: Replaced by DescribeChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelBan = "DescribeChannelBan"

// DescribeChannelBanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelBan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelBan for more information on using the DescribeChannelBan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelBanRequest method.
//	req, resp := client.DescribeChannelBanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelBan
//
// Deprecated: Replaced by DescribeChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelBanRequest(input *DescribeChannelBanInput) (req *request.Request, output *DescribeChannelBanOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannelBan, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannelBan,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelBanInput{}
	}

	output = &DescribeChannelBanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannelBan API operation for Amazon Chime.
//
// Returns the full details of a channel ban.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannelBan (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelBan.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannelBan for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelBan
//
// Deprecated: Replaced by DescribeChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelBan(input *DescribeChannelBanInput) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	return out, req.Send()
}

// DescribeChannelBanWithContext is the same as DescribeChannelBan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelBan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannelBan in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelBanWithContext(ctx aws.Context, input *DescribeChannelBanInput, opts ...request.Option) (*DescribeChannelBanOutput, error) {
	req, out := c.DescribeChannelBanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembership = "DescribeChannelMembership"

// DescribeChannelMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembership for more information on using the DescribeChannelMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelMembershipRequest method.
//	req, resp := client.DescribeChannelMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelMembership
//
// Deprecated: Replaced by DescribeChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembershipRequest(input *DescribeChannelMembershipInput) (req *request.Request, output *DescribeChannelMembershipOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannelMembership, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannelMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships/{memberArn}",
	}

	if input == nil {
		input = &DescribeChannelMembershipInput{}
	}

	output = &DescribeChannelMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannelMembership API operation for Amazon Chime.
//
// Returns the full details of a user's channel membership.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannelMembership (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelMembership.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannelMembership for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelMembership
//
// Deprecated: Replaced by DescribeChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembership(input *DescribeChannelMembershipInput) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipWithContext is the same as DescribeChannelMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannelMembership in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembershipWithContext(ctx aws.Context, input *DescribeChannelMembershipInput, opts ...request.Option) (*DescribeChannelMembershipOutput, error) {
	req, out := c.DescribeChannelMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelMembershipForAppInstanceUser = "DescribeChannelMembershipForAppInstanceUser"

// DescribeChannelMembershipForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelMembershipForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelMembershipForAppInstanceUser for more information on using the DescribeChannelMembershipForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelMembershipForAppInstanceUserRequest method.
//	req, resp := client.DescribeChannelMembershipForAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelMembershipForAppInstanceUser
//
// Deprecated: Replaced by DescribeChannelMembershipForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembershipForAppInstanceUserRequest(input *DescribeChannelMembershipForAppInstanceUserInput) (req *request.Request, output *DescribeChannelMembershipForAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannelMembershipForAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannelMembershipForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-membership",
	}

	if input == nil {
		input = &DescribeChannelMembershipForAppInstanceUserInput{}
	}

	output = &DescribeChannelMembershipForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannelMembershipForAppInstanceUser API operation for Amazon Chime.
//
// Returns the details of a channel based on the membership of the specified
// AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannelMembershipForAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelMembershipForAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannelMembershipForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelMembershipForAppInstanceUser
//
// Deprecated: Replaced by DescribeChannelMembershipForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembershipForAppInstanceUser(input *DescribeChannelMembershipForAppInstanceUserInput) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelMembershipForAppInstanceUserWithContext is the same as DescribeChannelMembershipForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelMembershipForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannelMembershipForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelMembershipForAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelMembershipForAppInstanceUserInput, opts ...request.Option) (*DescribeChannelMembershipForAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelMembershipForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModeratedByAppInstanceUser = "DescribeChannelModeratedByAppInstanceUser"

// DescribeChannelModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModeratedByAppInstanceUser for more information on using the DescribeChannelModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelModeratedByAppInstanceUserRequest method.
//	req, resp := client.DescribeChannelModeratedByAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelModeratedByAppInstanceUser
//
// Deprecated: Replaced by DescribeChannelModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModeratedByAppInstanceUserRequest(input *DescribeChannelModeratedByAppInstanceUserInput) (req *request.Request, output *DescribeChannelModeratedByAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannelModeratedByAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannelModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}?scope=app-instance-user-moderated-channel",
	}

	if input == nil {
		input = &DescribeChannelModeratedByAppInstanceUserInput{}
	}

	output = &DescribeChannelModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannelModeratedByAppInstanceUser API operation for Amazon Chime.
//
// Returns the full details of a channel moderated by the specified AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannelModeratedByAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelModeratedByAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannelModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelModeratedByAppInstanceUser
//
// Deprecated: Replaced by DescribeChannelModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModeratedByAppInstanceUser(input *DescribeChannelModeratedByAppInstanceUserInput) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratedByAppInstanceUserWithContext is the same as DescribeChannelModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannelModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModeratedByAppInstanceUserWithContext(ctx aws.Context, input *DescribeChannelModeratedByAppInstanceUserInput, opts ...request.Option) (*DescribeChannelModeratedByAppInstanceUserOutput, error) {
	req, out := c.DescribeChannelModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannelModerator = "DescribeChannelModerator"

// DescribeChannelModeratorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannelModerator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannelModerator for more information on using the DescribeChannelModerator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelModeratorRequest method.
//	req, resp := client.DescribeChannelModeratorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelModerator
//
// Deprecated: Replaced by DescribeChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModeratorRequest(input *DescribeChannelModeratorInput) (req *request.Request, output *DescribeChannelModeratorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeChannelModerator, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeChannelModerator,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators/{channelModeratorArn}",
	}

	if input == nil {
		input = &DescribeChannelModeratorInput{}
	}

	output = &DescribeChannelModeratorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeChannelModerator API operation for Amazon Chime.
//
// Returns the full details of a single ChannelModerator.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DescribeChannelModerator (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelModerator.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DescribeChannelModerator for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DescribeChannelModerator
//
// Deprecated: Replaced by DescribeChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModerator(input *DescribeChannelModeratorInput) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	return out, req.Send()
}

// DescribeChannelModeratorWithContext is the same as DescribeChannelModerator with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannelModerator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DescribeChannelModerator in the Amazon Chime SDK Messaging Namespace
func (c *Chime) DescribeChannelModeratorWithContext(ctx aws.Context, input *DescribeChannelModeratorInput, opts ...request.Option) (*DescribeChannelModeratorOutput, error) {
	req, out := c.DescribeChannelModeratorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumberFromUser = "DisassociatePhoneNumberFromUser"

// DisassociatePhoneNumberFromUserRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumberFromUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumberFromUser for more information on using the DisassociatePhoneNumberFromUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumberFromUserRequest method.
//	req, resp := client.DisassociatePhoneNumberFromUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser
func (c *Chime) DisassociatePhoneNumberFromUserRequest(input *DisassociatePhoneNumberFromUserInput) (req *request.Request, output *DisassociatePhoneNumberFromUserOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumberFromUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=disassociate-phone-number",
	}

	if input == nil {
		input = &DisassociatePhoneNumberFromUserInput{}
	}

	output = &DisassociatePhoneNumberFromUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociatePhoneNumberFromUser API operation for Amazon Chime.
//
// Disassociates the primary provisioned phone number from the specified Amazon
// Chime user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumberFromUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser
func (c *Chime) DisassociatePhoneNumberFromUser(input *DisassociatePhoneNumberFromUserInput) (*DisassociatePhoneNumberFromUserOutput, error) {
	req, out := c.DisassociatePhoneNumberFromUserRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumberFromUserWithContext is the same as DisassociatePhoneNumberFromUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumberFromUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociatePhoneNumberFromUserWithContext(ctx aws.Context, input *DisassociatePhoneNumberFromUserInput, opts ...request.Option) (*DisassociatePhoneNumberFromUserOutput, error) {
	req, out := c.DisassociatePhoneNumberFromUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnector = "DisassociatePhoneNumbersFromVoiceConnector"

// DisassociatePhoneNumbersFromVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnector for more information on using the DisassociatePhoneNumbersFromVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorRequest method.
//	req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorRequest(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DisassociatePhoneNumbersFromVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnector API operation for Amazon Chime.
//
// Disassociates the specified phone numbers from the specified Amazon Chime
// Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DisassociatePhoneNumbersFromVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DisassociatePhoneNumbersFromVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumbersFromVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnector(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorWithContext is the same as DisassociatePhoneNumbersFromVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnectorGroup = "DisassociatePhoneNumbersFromVoiceConnectorGroup"

// DisassociatePhoneNumbersFromVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for more information on using the DisassociatePhoneNumbersFromVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorGroupRequest method.
//	req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DisassociatePhoneNumbersFromVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorGroupInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnectorGroup API operation for Amazon Chime.
//
// Disassociates the specified phone numbers from the specified Amazon Chime
// Voice Connector group.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, DisassociatePhoneNumbersFromVoiceConnectorGroup
// (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_DisassociatePhoneNumbersFromVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumbersFromVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroup(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext is the same as DisassociatePhoneNumbersFromVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by DisassociatePhoneNumbersFromVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSigninDelegateGroupsFromAccount = "DisassociateSigninDelegateGroupsFromAccount"

// DisassociateSigninDelegateGroupsFromAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSigninDelegateGroupsFromAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSigninDelegateGroupsFromAccount for more information on using the DisassociateSigninDelegateGroupsFromAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateSigninDelegateGroupsFromAccountRequest method.
//	req, resp := client.DisassociateSigninDelegateGroupsFromAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount
func (c *Chime) DisassociateSigninDelegateGroupsFromAccountRequest(input *DisassociateSigninDelegateGroupsFromAccountInput) (req *request.Request, output *DisassociateSigninDelegateGroupsFromAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateSigninDelegateGroupsFromAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}?operation=disassociate-signin-delegate-groups",
	}

	if input == nil {
		input = &DisassociateSigninDelegateGroupsFromAccountInput{}
	}

	output = &DisassociateSigninDelegateGroupsFromAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSigninDelegateGroupsFromAccount API operation for Amazon Chime.
//
// Disassociates the specified sign-in delegate groups from the specified Amazon
// Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociateSigninDelegateGroupsFromAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount
func (c *Chime) DisassociateSigninDelegateGroupsFromAccount(input *DisassociateSigninDelegateGroupsFromAccountInput) (*DisassociateSigninDelegateGroupsFromAccountOutput, error) {
	req, out := c.DisassociateSigninDelegateGroupsFromAccountRequest(input)
	return out, req.Send()
}

// DisassociateSigninDelegateGroupsFromAccountWithContext is the same as DisassociateSigninDelegateGroupsFromAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSigninDelegateGroupsFromAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociateSigninDelegateGroupsFromAccountWithContext(ctx aws.Context, input *DisassociateSigninDelegateGroupsFromAccountInput, opts ...request.Option) (*DisassociateSigninDelegateGroupsFromAccountOutput, error) {
	req, out := c.DisassociateSigninDelegateGroupsFromAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountRequest method.
//	req, resp := client.GetAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *GetAccountOutput) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &GetAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime account, such as account
// type and supported licenses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccount(input *GetAccountInput) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSettingsRequest method.
//	req, resp := client.GetAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for Amazon Chime.
//
// Retrieves account settings for the specified Amazon Chime account ID, such
// as remote control and dialout settings. For more information about these
// settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppInstanceRetentionSettings = "GetAppInstanceRetentionSettings"

// GetAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppInstanceRetentionSettings for more information on using the GetAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppInstanceRetentionSettingsRequest method.
//	req, resp := client.GetAppInstanceRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAppInstanceRetentionSettings
//
// Deprecated: Replaced by GetAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) GetAppInstanceRetentionSettingsRequest(input *GetAppInstanceRetentionSettingsInput) (req *request.Request, output *GetAppInstanceRetentionSettingsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetAppInstanceRetentionSettings, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetAppInstanceRetentionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &GetAppInstanceRetentionSettingsInput{}
	}

	output = &GetAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAppInstanceRetentionSettings API operation for Amazon Chime.
//
// Gets the retention settings for an AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetMessagingRetentionSettings (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_GetAppInstanceRetentionSettings.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAppInstanceRetentionSettings
//
// Deprecated: Replaced by GetAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) GetAppInstanceRetentionSettings(input *GetAppInstanceRetentionSettingsInput) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// GetAppInstanceRetentionSettingsWithContext is the same as GetAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) GetAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *GetAppInstanceRetentionSettingsInput, opts ...request.Option) (*GetAppInstanceRetentionSettingsOutput, error) {
	req, out := c.GetAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAppInstanceStreamingConfigurations = "GetAppInstanceStreamingConfigurations"

// GetAppInstanceStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the GetAppInstanceStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAppInstanceStreamingConfigurations for more information on using the GetAppInstanceStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAppInstanceStreamingConfigurationsRequest method.
//	req, resp := client.GetAppInstanceStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by GetAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetAppInstanceStreamingConfigurationsRequest(input *GetAppInstanceStreamingConfigurationsInput) (req *request.Request, output *GetAppInstanceStreamingConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetAppInstanceStreamingConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetAppInstanceStreamingConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &GetAppInstanceStreamingConfigurationsInput{}
	}

	output = &GetAppInstanceStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAppInstanceStreamingConfigurations API operation for Amazon Chime.
//
// Gets the streaming settings for an AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetMessagingStreamingConfigurations (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetMessagingStreamingConfigurations.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAppInstanceStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by GetAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetAppInstanceStreamingConfigurations(input *GetAppInstanceStreamingConfigurationsInput) (*GetAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.GetAppInstanceStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// GetAppInstanceStreamingConfigurationsWithContext is the same as GetAppInstanceStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See GetAppInstanceStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetAppInstanceStreamingConfigurationsWithContext(ctx aws.Context, input *GetAppInstanceStreamingConfigurationsInput, opts ...request.Option) (*GetAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.GetAppInstanceStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttendee = "GetAttendee"

// GetAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the GetAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttendee for more information on using the GetAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAttendeeRequest method.
//	req, resp := client.GetAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee
//
// Deprecated: Replaced by GetAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetAttendeeRequest(input *GetAttendeeInput) (req *request.Request, output *GetAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetAttendee,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}",
	}

	if input == nil {
		input = &GetAttendeeInput{}
	}

	output = &GetAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttendee API operation for Amazon Chime.
//
// Gets the Amazon Chime SDK attendee details for a specified meeting ID and
// attendee ID. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetAttendee (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetAttendee.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee
//
// Deprecated: Replaced by GetAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetAttendee(input *GetAttendeeInput) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	return out, req.Send()
}

// GetAttendeeWithContext is the same as GetAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetAttendee in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetAttendeeWithContext(ctx aws.Context, input *GetAttendeeInput, opts ...request.Option) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBot = "GetBot"

// GetBotRequest generates a "aws/request.Request" representing the
// client's request for the GetBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBot for more information on using the GetBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBotRequest method.
//	req, resp := client.GetBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot
func (c *Chime) GetBotRequest(input *GetBotInput) (req *request.Request, output *GetBotOutput) {
	op := &request.Operation{
		Name:       opGetBot,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}",
	}

	if input == nil {
		input = &GetBotInput{}
	}

	output = &GetBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBot API operation for Amazon Chime.
//
// Retrieves details for the specified bot, such as bot email address, bot type,
// status, and display name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetBot for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot
func (c *Chime) GetBot(input *GetBotInput) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	return out, req.Send()
}

// GetBotWithContext is the same as GetBot with the addition of
// the ability to pass a context and additional request options.
//
// See GetBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetBotWithContext(ctx aws.Context, input *GetBotInput, opts ...request.Option) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelMessage = "GetChannelMessage"

// GetChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelMessage for more information on using the GetChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelMessageRequest method.
//	req, resp := client.GetChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetChannelMessage
//
// Deprecated: Replaced by GetChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetChannelMessageRequest(input *GetChannelMessageInput) (req *request.Request, output *GetChannelMessageOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetChannelMessage, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetChannelMessage,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &GetChannelMessageInput{}
	}

	output = &GetChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetChannelMessage API operation for Amazon Chime.
//
// Gets the full details of a channel message.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetChannelMessage (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetChannelMessage.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetChannelMessage
//
// Deprecated: Replaced by GetChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetChannelMessage(input *GetChannelMessageInput) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	return out, req.Send()
}

// GetChannelMessageWithContext is the same as GetChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetChannelMessageWithContext(ctx aws.Context, input *GetChannelMessageInput, opts ...request.Option) (*GetChannelMessageOutput, error) {
	req, out := c.GetChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventsConfiguration = "GetEventsConfiguration"

// GetEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventsConfiguration for more information on using the GetEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventsConfigurationRequest method.
//	req, resp := client.GetEventsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration
func (c *Chime) GetEventsConfigurationRequest(input *GetEventsConfigurationInput) (req *request.Request, output *GetEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEventsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &GetEventsConfigurationInput{}
	}

	output = &GetEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventsConfiguration API operation for Amazon Chime.
//
// Gets details for an events configuration that allows a bot to receive outgoing
// events, such as an HTTPS endpoint or Lambda function ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetEventsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration
func (c *Chime) GetEventsConfiguration(input *GetEventsConfigurationInput) (*GetEventsConfigurationOutput, error) {
	req, out := c.GetEventsConfigurationRequest(input)
	return out, req.Send()
}

// GetEventsConfigurationWithContext is the same as GetEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetEventsConfigurationWithContext(ctx aws.Context, input *GetEventsConfigurationInput, opts ...request.Option) (*GetEventsConfigurationOutput, error) {
	req, out := c.GetEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGlobalSettings = "GetGlobalSettings"

// GetGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlobalSettings for more information on using the GetGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGlobalSettingsRequest method.
//	req, resp := client.GetGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings
func (c *Chime) GetGlobalSettingsRequest(input *GetGlobalSettingsInput) (req *request.Request, output *GetGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opGetGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &GetGlobalSettingsInput{}
	}

	output = &GetGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlobalSettings API operation for Amazon Chime.
//
// Retrieves global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings
func (c *Chime) GetGlobalSettings(input *GetGlobalSettingsInput) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	return out, req.Send()
}

// GetGlobalSettingsWithContext is the same as GetGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetGlobalSettingsWithContext(ctx aws.Context, input *GetGlobalSettingsInput, opts ...request.Option) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMediaCapturePipeline = "GetMediaCapturePipeline"

// GetMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMediaCapturePipeline for more information on using the GetMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMediaCapturePipelineRequest method.
//	req, resp := client.GetMediaCapturePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMediaCapturePipeline
//
// Deprecated: Replaced by GetMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) GetMediaCapturePipelineRequest(input *GetMediaCapturePipelineInput) (req *request.Request, output *GetMediaCapturePipelineOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetMediaCapturePipeline, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetMediaCapturePipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &GetMediaCapturePipelineInput{}
	}

	output = &GetMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMediaCapturePipeline API operation for Amazon Chime.
//
// Gets an existing media capture pipeline.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetMediaCapturePipeline (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_GetMediaCapturePipeline.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMediaCapturePipeline
//
// Deprecated: Replaced by GetMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) GetMediaCapturePipeline(input *GetMediaCapturePipelineInput) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// GetMediaCapturePipelineWithContext is the same as GetMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetMediaCapturePipeline in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) GetMediaCapturePipelineWithContext(ctx aws.Context, input *GetMediaCapturePipelineInput, opts ...request.Option) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMeeting = "GetMeeting"

// GetMeetingRequest generates a "aws/request.Request" representing the
// client's request for the GetMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMeeting for more information on using the GetMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMeetingRequest method.
//	req, resp := client.GetMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting
//
// Deprecated: Replaced by GetMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetMeetingRequest(input *GetMeetingInput) (req *request.Request, output *GetMeetingOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetMeeting, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetMeeting,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}",
	}

	if input == nil {
		input = &GetMeetingInput{}
	}

	output = &GetMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMeeting API operation for Amazon Chime.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetMeeting (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetMeeting.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Gets the Amazon Chime SDK meeting details for the specified meeting ID. For
// more information about the Amazon Chime SDK, see Using the Amazon Chime SDK
// (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html) in the
// Amazon Chime SDK Developer Guide .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting
//
// Deprecated: Replaced by GetMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetMeeting(input *GetMeetingInput) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	return out, req.Send()
}

// GetMeetingWithContext is the same as GetMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See GetMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetMeeting in the Amazon Chime SDK Meetings Namespace
func (c *Chime) GetMeetingWithContext(ctx aws.Context, input *GetMeetingInput, opts ...request.Option) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMessagingSessionEndpoint = "GetMessagingSessionEndpoint"

// GetMessagingSessionEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetMessagingSessionEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMessagingSessionEndpoint for more information on using the GetMessagingSessionEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMessagingSessionEndpointRequest method.
//	req, resp := client.GetMessagingSessionEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMessagingSessionEndpoint
//
// Deprecated: Replaced by GetMessagingSessionEndpoint in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetMessagingSessionEndpointRequest(input *GetMessagingSessionEndpointInput) (req *request.Request, output *GetMessagingSessionEndpointOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetMessagingSessionEndpoint, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetMessagingSessionEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/endpoints/messaging-session",
	}

	if input == nil {
		input = &GetMessagingSessionEndpointInput{}
	}

	output = &GetMessagingSessionEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMessagingSessionEndpoint API operation for Amazon Chime.
//
// The details of the endpoint for the messaging session.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetMessagingSessionEndpoint (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetMessagingSessionEndpoint.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetMessagingSessionEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMessagingSessionEndpoint
//
// Deprecated: Replaced by GetMessagingSessionEndpoint in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetMessagingSessionEndpoint(input *GetMessagingSessionEndpointInput) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	return out, req.Send()
}

// GetMessagingSessionEndpointWithContext is the same as GetMessagingSessionEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetMessagingSessionEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetMessagingSessionEndpoint in the Amazon Chime SDK Messaging Namespace
func (c *Chime) GetMessagingSessionEndpointWithContext(ctx aws.Context, input *GetMessagingSessionEndpointInput, opts ...request.Option) (*GetMessagingSessionEndpointOutput, error) {
	req, out := c.GetMessagingSessionEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumber = "GetPhoneNumber"

// GetPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumber for more information on using the GetPhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberRequest method.
//	req, resp := client.GetPhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber
func (c *Chime) GetPhoneNumberRequest(input *GetPhoneNumberInput) (req *request.Request, output *GetPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumber,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &GetPhoneNumberInput{}
	}

	output = &GetPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumber API operation for Amazon Chime.
//
// Retrieves details for the specified phone number ID, such as associations,
// capabilities, and product type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber
func (c *Chime) GetPhoneNumber(input *GetPhoneNumberInput) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	return out, req.Send()
}

// GetPhoneNumberWithContext is the same as GetPhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberWithContext(ctx aws.Context, input *GetPhoneNumberInput, opts ...request.Option) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberOrder = "GetPhoneNumberOrder"

// GetPhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberOrder for more information on using the GetPhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberOrderRequest method.
//	req, resp := client.GetPhoneNumberOrderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder
func (c *Chime) GetPhoneNumberOrderRequest(input *GetPhoneNumberOrderInput) (req *request.Request, output *GetPhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberOrder,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders/{phoneNumberOrderId}",
	}

	if input == nil {
		input = &GetPhoneNumberOrderInput{}
	}

	output = &GetPhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberOrder API operation for Amazon Chime.
//
// Retrieves details for the specified phone number order, such as the order
// creation timestamp, phone numbers in E.164 format, product type, and order
// status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder
func (c *Chime) GetPhoneNumberOrder(input *GetPhoneNumberOrderInput) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	return out, req.Send()
}

// GetPhoneNumberOrderWithContext is the same as GetPhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberOrderWithContext(ctx aws.Context, input *GetPhoneNumberOrderInput, opts ...request.Option) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberSettings = "GetPhoneNumberSettings"

// GetPhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberSettings for more information on using the GetPhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPhoneNumberSettingsRequest method.
//	req, resp := client.GetPhoneNumberSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings
func (c *Chime) GetPhoneNumberSettingsRequest(input *GetPhoneNumberSettingsInput) (req *request.Request, output *GetPhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &GetPhoneNumberSettingsInput{}
	}

	output = &GetPhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberSettings API operation for Amazon Chime.
//
// Retrieves the phone number settings for the administrator's AWS account,
// such as the default outbound calling name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings
func (c *Chime) GetPhoneNumberSettings(input *GetPhoneNumberSettingsInput) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// GetPhoneNumberSettingsWithContext is the same as GetPhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberSettingsWithContext(ctx aws.Context, input *GetPhoneNumberSettingsInput, opts ...request.Option) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProxySession = "GetProxySession"

// GetProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the GetProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProxySession for more information on using the GetProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProxySessionRequest method.
//	req, resp := client.GetProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetProxySession
//
// Deprecated: Replaced by GetProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetProxySessionRequest(input *GetProxySessionInput) (req *request.Request, output *GetProxySessionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetProxySession, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetProxySession,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &GetProxySessionInput{}
	}

	output = &GetProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProxySession API operation for Amazon Chime.
//
// Gets the specified proxy session details for the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetProxySession (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetProxySession.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetProxySession
//
// Deprecated: Replaced by GetProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetProxySession(input *GetProxySessionInput) (*GetProxySessionOutput, error) {
	req, out := c.GetProxySessionRequest(input)
	return out, req.Send()
}

// GetProxySessionWithContext is the same as GetProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See GetProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetProxySessionWithContext(ctx aws.Context, input *GetProxySessionInput, opts ...request.Option) (*GetProxySessionOutput, error) {
	req, out := c.GetProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRetentionSettings = "GetRetentionSettings"

// GetRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRetentionSettings for more information on using the GetRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRetentionSettingsRequest method.
//	req, resp := client.GetRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRetentionSettings
func (c *Chime) GetRetentionSettingsRequest(input *GetRetentionSettingsInput) (req *request.Request, output *GetRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opGetRetentionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/retention-settings",
	}

	if input == nil {
		input = &GetRetentionSettingsInput{}
	}

	output = &GetRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRetentionSettings API operation for Amazon Chime.
//
// Gets the retention settings for the specified Amazon Chime Enterprise account.
// For more information about retention settings, see Managing Chat Retention
// Policies (https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRetentionSettings
func (c *Chime) GetRetentionSettings(input *GetRetentionSettingsInput) (*GetRetentionSettingsOutput, error) {
	req, out := c.GetRetentionSettingsRequest(input)
	return out, req.Send()
}

// GetRetentionSettingsWithContext is the same as GetRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetRetentionSettingsWithContext(ctx aws.Context, input *GetRetentionSettingsInput, opts ...request.Option) (*GetRetentionSettingsOutput, error) {
	req, out := c.GetRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoom = "GetRoom"

// GetRoomRequest generates a "aws/request.Request" representing the
// client's request for the GetRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoom for more information on using the GetRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRoomRequest method.
//	req, resp := client.GetRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom
func (c *Chime) GetRoomRequest(input *GetRoomInput) (req *request.Request, output *GetRoomOutput) {
	op := &request.Operation{
		Name:       opGetRoom,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	output = &GetRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoom API operation for Amazon Chime.
//
// Retrieves room details, such as the room name, for a room in an Amazon Chime
// Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetRoom for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom
func (c *Chime) GetRoom(input *GetRoomInput) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	return out, req.Send()
}

// GetRoomWithContext is the same as GetRoom with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetRoomWithContext(ctx aws.Context, input *GetRoomInput, opts ...request.Option) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipMediaApplication = "GetSipMediaApplication"

// GetSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipMediaApplication for more information on using the GetSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipMediaApplicationRequest method.
//	req, resp := client.GetSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipMediaApplication
//
// Deprecated: Replaced by GetSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplicationRequest(input *GetSipMediaApplicationInput) (req *request.Request, output *GetSipMediaApplicationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetSipMediaApplication, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetSipMediaApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &GetSipMediaApplicationInput{}
	}

	output = &GetSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipMediaApplication API operation for Amazon Chime.
//
// Retrieves the information for a SIP media application, including name, AWS
// Region, and endpoints.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetSipMediaApplication (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetSipMediaApplication.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipMediaApplication
//
// Deprecated: Replaced by GetSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplication(input *GetSipMediaApplicationInput) (*GetSipMediaApplicationOutput, error) {
	req, out := c.GetSipMediaApplicationRequest(input)
	return out, req.Send()
}

// GetSipMediaApplicationWithContext is the same as GetSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplicationWithContext(ctx aws.Context, input *GetSipMediaApplicationInput, opts ...request.Option) (*GetSipMediaApplicationOutput, error) {
	req, out := c.GetSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipMediaApplicationLoggingConfiguration = "GetSipMediaApplicationLoggingConfiguration"

// GetSipMediaApplicationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetSipMediaApplicationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipMediaApplicationLoggingConfiguration for more information on using the GetSipMediaApplicationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipMediaApplicationLoggingConfigurationRequest method.
//	req, resp := client.GetSipMediaApplicationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipMediaApplicationLoggingConfiguration
//
// Deprecated: Replaced by GetSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplicationLoggingConfigurationRequest(input *GetSipMediaApplicationLoggingConfigurationInput) (req *request.Request, output *GetSipMediaApplicationLoggingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetSipMediaApplicationLoggingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetSipMediaApplicationLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/logging-configuration",
	}

	if input == nil {
		input = &GetSipMediaApplicationLoggingConfigurationInput{}
	}

	output = &GetSipMediaApplicationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipMediaApplicationLoggingConfiguration API operation for Amazon Chime.
//
// Returns the logging configuration for the specified SIP media application.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetSipMediaApplicationLoggingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetSipMediaApplicationLoggingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetSipMediaApplicationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipMediaApplicationLoggingConfiguration
//
// Deprecated: Replaced by GetSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplicationLoggingConfiguration(input *GetSipMediaApplicationLoggingConfigurationInput) (*GetSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetSipMediaApplicationLoggingConfigurationWithContext is the same as GetSipMediaApplicationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipMediaApplicationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipMediaApplicationLoggingConfigurationWithContext(ctx aws.Context, input *GetSipMediaApplicationLoggingConfigurationInput, opts ...request.Option) (*GetSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.GetSipMediaApplicationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSipRule = "GetSipRule"

// GetSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSipRule for more information on using the GetSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSipRuleRequest method.
//	req, resp := client.GetSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipRule
//
// Deprecated: Replaced by GetSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipRuleRequest(input *GetSipRuleInput) (req *request.Request, output *GetSipRuleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetSipRule, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetSipRule,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &GetSipRuleInput{}
	}

	output = &GetSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSipRule API operation for Amazon Chime.
//
// Retrieves the details of a SIP rule, such as the rule ID, name, triggers,
// and target endpoints.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetSipRule (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetSipRule.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetSipRule
//
// Deprecated: Replaced by GetSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipRule(input *GetSipRuleInput) (*GetSipRuleOutput, error) {
	req, out := c.GetSipRuleRequest(input)
	return out, req.Send()
}

// GetSipRuleWithContext is the same as GetSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetSipRuleWithContext(ctx aws.Context, input *GetSipRuleInput, opts ...request.Option) (*GetSipRuleOutput, error) {
	req, out := c.GetSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserRequest method.
//	req, resp := client.GetUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUser API operation for Amazon Chime.
//
// Retrieves details for the specified user ID, such as primary email address,
// license type,and personal meeting PIN.
//
// To retrieve user details with an email address instead of a user ID, use
// the ListUsers action, and then filter by email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserSettings = "GetUserSettings"

// GetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserSettings for more information on using the GetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserSettingsRequest method.
//	req, resp := client.GetUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings
func (c *Chime) GetUserSettingsRequest(input *GetUserSettingsInput) (req *request.Request, output *GetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opGetUserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users/{userId}/settings",
	}

	if input == nil {
		input = &GetUserSettingsInput{}
	}

	output = &GetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserSettings API operation for Amazon Chime.
//
// Retrieves settings for the specified user ID, such as any associated phone
// number settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings
func (c *Chime) GetUserSettings(input *GetUserSettingsInput) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	return out, req.Send()
}

// GetUserSettingsWithContext is the same as GetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetUserSettingsWithContext(ctx aws.Context, input *GetUserSettingsInput, opts ...request.Option) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnector = "GetVoiceConnector"

// GetVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnector for more information on using the GetVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorRequest method.
//	req, resp := client.GetVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector
//
// Deprecated: Replaced by GetVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorRequest(input *GetVoiceConnectorInput) (req *request.Request, output *GetVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &GetVoiceConnectorInput{}
	}

	output = &GetVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnector API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime Voice Connector, such as
// timestamps,name, outbound host, and encryption requirements.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector
//
// Deprecated: Replaced by GetVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnector(input *GetVoiceConnectorInput) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorWithContext is the same as GetVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorWithContext(ctx aws.Context, input *GetVoiceConnectorInput, opts ...request.Option) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorEmergencyCallingConfiguration = "GetVoiceConnectorEmergencyCallingConfiguration"

// GetVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorEmergencyCallingConfiguration for more information on using the GetVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorEmergencyCallingConfigurationRequest(input *GetVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *GetVoiceConnectorEmergencyCallingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorEmergencyCallingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &GetVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime.
//
// Gets the emergency calling configuration details for the specified Amazon
// Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorEmergencyCallingConfiguration
// (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorEmergencyCallingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorEmergencyCallingConfiguration(input *GetVoiceConnectorEmergencyCallingConfigurationInput) (*GetVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorEmergencyCallingConfigurationWithContext is the same as GetVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorGroup = "GetVoiceConnectorGroup"

// GetVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorGroup for more information on using the GetVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorGroupRequest method.
//	req, resp := client.GetVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup
//
// Deprecated: Replaced by GetVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorGroupRequest(input *GetVoiceConnectorGroupInput) (req *request.Request, output *GetVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &GetVoiceConnectorGroupInput{}
	}

	output = &GetVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorGroup API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime Voice Connector group, such
// as timestamps,name, and associated VoiceConnectorItems.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorGroup (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup
//
// Deprecated: Replaced by GetVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorGroup(input *GetVoiceConnectorGroupInput) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorGroupWithContext is the same as GetVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorGroupWithContext(ctx aws.Context, input *GetVoiceConnectorGroupInput, opts ...request.Option) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorLoggingConfiguration = "GetVoiceConnectorLoggingConfiguration"

// GetVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorLoggingConfiguration for more information on using the GetVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorLoggingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorLoggingConfigurationRequest(input *GetVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *GetVoiceConnectorLoggingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorLoggingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorLoggingConfigurationInput{}
	}

	output = &GetVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorLoggingConfiguration API operation for Amazon Chime.
//
// Retrieves the logging configuration details for the specified Amazon Chime
// Voice Connector. Shows whether SIP message logs are enabled for sending to
// Amazon CloudWatch Logs.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorLoggingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorLoggingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorLoggingConfiguration(input *GetVoiceConnectorLoggingConfigurationInput) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorLoggingConfigurationWithContext is the same as GetVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorOrigination = "GetVoiceConnectorOrigination"

// GetVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorOrigination for more information on using the GetVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorOriginationRequest method.
//	req, resp := client.GetVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination
//
// Deprecated: Replaced by GetVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorOriginationRequest(input *GetVoiceConnectorOriginationInput) (req *request.Request, output *GetVoiceConnectorOriginationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorOrigination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorOrigination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &GetVoiceConnectorOriginationInput{}
	}

	output = &GetVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorOrigination API operation for Amazon Chime.
//
// Retrieves origination setting details for the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorOrigination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorOrigination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination
//
// Deprecated: Replaced by GetVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorOrigination(input *GetVoiceConnectorOriginationInput) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorOriginationWithContext is the same as GetVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorOriginationWithContext(ctx aws.Context, input *GetVoiceConnectorOriginationInput, opts ...request.Option) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorProxy = "GetVoiceConnectorProxy"

// GetVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorProxy for more information on using the GetVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorProxyRequest method.
//	req, resp := client.GetVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorProxy
//
// Deprecated: Replaced by GetVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorProxyRequest(input *GetVoiceConnectorProxyInput) (req *request.Request, output *GetVoiceConnectorProxyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorProxy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorProxy,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &GetVoiceConnectorProxyInput{}
	}

	output = &GetVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorProxy API operation for Amazon Chime.
//
// Gets the proxy configuration details for the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorProxy (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorProxy.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorProxy
//
// Deprecated: Replaced by GetVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorProxy(input *GetVoiceConnectorProxyInput) (*GetVoiceConnectorProxyOutput, error) {
	req, out := c.GetVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorProxyWithContext is the same as GetVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorProxyWithContext(ctx aws.Context, input *GetVoiceConnectorProxyInput, opts ...request.Option) (*GetVoiceConnectorProxyOutput, error) {
	req, out := c.GetVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorStreamingConfiguration = "GetVoiceConnectorStreamingConfiguration"

// GetVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorStreamingConfiguration for more information on using the GetVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.GetVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorStreamingConfigurationRequest(input *GetVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *GetVoiceConnectorStreamingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorStreamingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorStreamingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorStreamingConfigurationInput{}
	}

	output = &GetVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Retrieves the streaming configuration details for the specified Amazon Chime
// Voice Connector. Shows whether media streaming is enabled for sending to
// Amazon Kinesis. It also shows the retention period, in hours, for the Amazon
// Kinesis data.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorStreamingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorStreamingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by GetVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorStreamingConfiguration(input *GetVoiceConnectorStreamingConfigurationInput) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorStreamingConfigurationWithContext is the same as GetVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTermination = "GetVoiceConnectorTermination"

// GetVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTermination for more information on using the GetVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorTerminationRequest method.
//	req, resp := client.GetVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination
//
// Deprecated: Replaced by GetVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTerminationRequest(input *GetVoiceConnectorTerminationInput) (req *request.Request, output *GetVoiceConnectorTerminationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorTermination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorTermination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationInput{}
	}

	output = &GetVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTermination API operation for Amazon Chime.
//
// Retrieves termination setting details for the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorTermination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorTermination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination
//
// Deprecated: Replaced by GetVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTermination(input *GetVoiceConnectorTerminationInput) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationWithContext is the same as GetVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTerminationWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationInput, opts ...request.Option) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTerminationHealth = "GetVoiceConnectorTerminationHealth"

// GetVoiceConnectorTerminationHealthRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTerminationHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTerminationHealth for more information on using the GetVoiceConnectorTerminationHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVoiceConnectorTerminationHealthRequest method.
//	req, resp := client.GetVoiceConnectorTerminationHealthRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth
//
// Deprecated: Replaced by GetVoiceConnectorTerminationHealth in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTerminationHealthRequest(input *GetVoiceConnectorTerminationHealthInput) (req *request.Request, output *GetVoiceConnectorTerminationHealthOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetVoiceConnectorTerminationHealth, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetVoiceConnectorTerminationHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/health",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationHealthInput{}
	}

	output = &GetVoiceConnectorTerminationHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTerminationHealth API operation for Amazon Chime.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, GetVoiceConnectorTerminationHealth (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_GetVoiceConnectorTerminationHealth.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Retrieves information about the last time a SIP OPTIONS ping was received
// from your SIP infrastructure for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorTerminationHealth for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth
//
// Deprecated: Replaced by GetVoiceConnectorTerminationHealth in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTerminationHealth(input *GetVoiceConnectorTerminationHealthInput) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationHealthWithContext is the same as GetVoiceConnectorTerminationHealth with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTerminationHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by GetVoiceConnectorTerminationHealth in the Amazon Chime SDK Voice Namespace
func (c *Chime) GetVoiceConnectorTerminationHealthWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationHealthInput, opts ...request.Option) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteUsers = "InviteUsers"

// InviteUsersRequest generates a "aws/request.Request" representing the
// client's request for the InviteUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteUsers for more information on using the InviteUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InviteUsersRequest method.
//	req, resp := client.InviteUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsersRequest(input *InviteUsersInput) (req *request.Request, output *InviteUsersOutput) {
	op := &request.Operation{
		Name:       opInviteUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=add",
	}

	if input == nil {
		input = &InviteUsersInput{}
	}

	output = &InviteUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteUsers API operation for Amazon Chime.
//
// Sends email to a maximum of 50 users, inviting them to the specified Amazon
// Chime Team account. Only Team account types are currently supported for this
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation InviteUsers for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsers(input *InviteUsersInput) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	return out, req.Send()
}

// InviteUsersWithContext is the same as InviteUsers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) InviteUsersWithContext(ctx aws.Context, input *InviteUsersInput, opts ...request.Option) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccounts for more information on using the ListAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountsRequest method.
//	req, resp := client.ListAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccountsRequest(input *ListAccountsInput) (req *request.Request, output *ListAccountsOutput) {
	op := &request.Operation{
		Name:       opListAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	output = &ListAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccounts API operation for Amazon Chime.
//
// Lists the Amazon Chime accounts under the administrator's AWS account. You
// can filter accounts by account name prefix. To find out which Amazon Chime
// account a user belongs to, you can filter by the user's email address, which
// returns one account result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAccounts for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccounts(input *ListAccountsInput) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	return out, req.Send()
}

// ListAccountsWithContext is the same as ListAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsWithContext(ctx aws.Context, input *ListAccountsInput, opts ...request.Option) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsPages iterates over the pages of a ListAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccounts operation.
//	pageNum := 0
//	err := client.ListAccountsPages(params,
//	    func(page *chime.ListAccountsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListAccountsPages(input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool) error {
	return c.ListAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsPagesWithContext same as ListAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsPagesWithContext(ctx aws.Context, input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceAdmins = "ListAppInstanceAdmins"

// ListAppInstanceAdminsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceAdmins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceAdmins for more information on using the ListAppInstanceAdmins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceAdminsRequest method.
//	req, resp := client.ListAppInstanceAdminsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstanceAdmins
//
// Deprecated: Replaced by ListAppInstanceAdmins in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceAdminsRequest(input *ListAppInstanceAdminsInput) (req *request.Request, output *ListAppInstanceAdminsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListAppInstanceAdmins, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListAppInstanceAdmins,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances/{appInstanceArn}/admins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceAdminsInput{}
	}

	output = &ListAppInstanceAdminsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAppInstanceAdmins API operation for Amazon Chime.
//
// Returns a list of the administrators in the AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListAppInstanceAdmins (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstanceAdmins.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAppInstanceAdmins for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstanceAdmins
//
// Deprecated: Replaced by ListAppInstanceAdmins in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceAdmins(input *ListAppInstanceAdminsInput) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	return out, req.Send()
}

// ListAppInstanceAdminsWithContext is the same as ListAppInstanceAdmins with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceAdmins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstanceAdmins in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceAdminsWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, opts ...request.Option) (*ListAppInstanceAdminsOutput, error) {
	req, out := c.ListAppInstanceAdminsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceAdminsPages iterates over the pages of a ListAppInstanceAdmins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceAdmins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceAdmins operation.
//	pageNum := 0
//	err := client.ListAppInstanceAdminsPages(params,
//	    func(page *chime.ListAppInstanceAdminsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListAppInstanceAdmins in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceAdminsPages(input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool) error {
	return c.ListAppInstanceAdminsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceAdminsPagesWithContext same as ListAppInstanceAdminsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstanceAdmins in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceAdminsPagesWithContext(ctx aws.Context, input *ListAppInstanceAdminsInput, fn func(*ListAppInstanceAdminsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceAdminsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceAdminsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceAdminsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstanceUsers = "ListAppInstanceUsers"

// ListAppInstanceUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstanceUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstanceUsers for more information on using the ListAppInstanceUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstanceUsersRequest method.
//	req, resp := client.ListAppInstanceUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstanceUsers
//
// Deprecated: Replaced by ListAppInstanceUsers in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceUsersRequest(input *ListAppInstanceUsersInput) (req *request.Request, output *ListAppInstanceUsersOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListAppInstanceUsers, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListAppInstanceUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instance-users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstanceUsersInput{}
	}

	output = &ListAppInstanceUsersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAppInstanceUsers API operation for Amazon Chime.
//
// List all AppInstanceUsers created under a single AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListAppInstanceUsers (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstanceUsers.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAppInstanceUsers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstanceUsers
//
// Deprecated: Replaced by ListAppInstanceUsers in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceUsers(input *ListAppInstanceUsersInput) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	return out, req.Send()
}

// ListAppInstanceUsersWithContext is the same as ListAppInstanceUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstanceUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstanceUsers in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceUsersWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, opts ...request.Option) (*ListAppInstanceUsersOutput, error) {
	req, out := c.ListAppInstanceUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstanceUsersPages iterates over the pages of a ListAppInstanceUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstanceUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstanceUsers operation.
//	pageNum := 0
//	err := client.ListAppInstanceUsersPages(params,
//	    func(page *chime.ListAppInstanceUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListAppInstanceUsers in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceUsersPages(input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool) error {
	return c.ListAppInstanceUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstanceUsersPagesWithContext same as ListAppInstanceUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstanceUsers in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstanceUsersPagesWithContext(ctx aws.Context, input *ListAppInstanceUsersInput, fn func(*ListAppInstanceUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstanceUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstanceUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstanceUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppInstances = "ListAppInstances"

// ListAppInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAppInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppInstances for more information on using the ListAppInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAppInstancesRequest method.
//	req, resp := client.ListAppInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstances
//
// Deprecated: Replaced by ListAppInstances in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstancesRequest(input *ListAppInstancesInput) (req *request.Request, output *ListAppInstancesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListAppInstances, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListAppInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/app-instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppInstancesInput{}
	}

	output = &ListAppInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAppInstances API operation for Amazon Chime.
//
// Lists all Amazon Chime AppInstances created under a single AWS account.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListAppInstances (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstances.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAppInstances for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAppInstances
//
// Deprecated: Replaced by ListAppInstances in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstances(input *ListAppInstancesInput) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	return out, req.Send()
}

// ListAppInstancesWithContext is the same as ListAppInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstances in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstancesWithContext(ctx aws.Context, input *ListAppInstancesInput, opts ...request.Option) (*ListAppInstancesOutput, error) {
	req, out := c.ListAppInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppInstancesPages iterates over the pages of a ListAppInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAppInstances operation.
//	pageNum := 0
//	err := client.ListAppInstancesPages(params,
//	    func(page *chime.ListAppInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListAppInstances in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstancesPages(input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool) error {
	return c.ListAppInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppInstancesPagesWithContext same as ListAppInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAppInstances in the Amazon Chime SDK Identity Namespace
func (c *Chime) ListAppInstancesPagesWithContext(ctx aws.Context, input *ListAppInstancesInput, fn func(*ListAppInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAttendeeTags = "ListAttendeeTags"

// ListAttendeeTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListAttendeeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttendeeTags for more information on using the ListAttendeeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAttendeeTagsRequest method.
//	req, resp := client.ListAttendeeTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendeeTags
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListAttendeeTagsRequest(input *ListAttendeeTagsInput) (req *request.Request, output *ListAttendeeTagsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListAttendeeTags, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListAttendeeTags,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}/tags",
	}

	if input == nil {
		input = &ListAttendeeTagsInput{}
	}

	output = &ListAttendeeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttendeeTags API operation for Amazon Chime.
//
// Lists the tags applied to an Amazon Chime SDK attendee resource.
//
// ListAttendeeTags is not supported in the Amazon Chime SDK Meetings Namespace.
// Update your application to remove calls to this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAttendeeTags for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendeeTags
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListAttendeeTags(input *ListAttendeeTagsInput) (*ListAttendeeTagsOutput, error) {
	req, out := c.ListAttendeeTagsRequest(input)
	return out, req.Send()
}

// ListAttendeeTagsWithContext is the same as ListAttendeeTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttendeeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListAttendeeTagsWithContext(ctx aws.Context, input *ListAttendeeTagsInput, opts ...request.Option) (*ListAttendeeTagsOutput, error) {
	req, out := c.ListAttendeeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttendees = "ListAttendees"

// ListAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttendees for more information on using the ListAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAttendeesRequest method.
//	req, resp := client.ListAttendeesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees
//
// Deprecated: Replaced by ListAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) ListAttendeesRequest(input *ListAttendeesInput) (req *request.Request, output *ListAttendeesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListAttendees, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListAttendees,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttendeesInput{}
	}

	output = &ListAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttendees API operation for Amazon Chime.
//
// Lists the attendees for the specified Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html)
// in the Amazon Chime SDK Developer Guide.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListAttendees (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_ListAttendees.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAttendees for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees
//
// Deprecated: Replaced by ListAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) ListAttendees(input *ListAttendeesInput) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	return out, req.Send()
}

// ListAttendeesWithContext is the same as ListAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) ListAttendeesWithContext(ctx aws.Context, input *ListAttendeesInput, opts ...request.Option) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttendeesPages iterates over the pages of a ListAttendees operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttendees method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAttendees operation.
//	pageNum := 0
//	err := client.ListAttendeesPages(params,
//	    func(page *chime.ListAttendeesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) ListAttendeesPages(input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool) error {
	return c.ListAttendeesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttendeesPagesWithContext same as ListAttendeesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListAttendees in the Amazon Chime SDK Meetings Namespace
func (c *Chime) ListAttendeesPagesWithContext(ctx aws.Context, input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttendeesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttendeesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttendeesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBots = "ListBots"

// ListBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBots for more information on using the ListBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotsRequest method.
//	req, resp := client.ListBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots
func (c *Chime) ListBotsRequest(input *ListBotsInput) (req *request.Request, output *ListBotsOutput) {
	op := &request.Operation{
		Name:       opListBots,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotsInput{}
	}

	output = &ListBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBots API operation for Amazon Chime.
//
// Lists the bots associated with the administrator's Amazon Chime Enterprise
// account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListBots for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots
func (c *Chime) ListBots(input *ListBotsInput) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	return out, req.Send()
}

// ListBotsWithContext is the same as ListBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListBotsWithContext(ctx aws.Context, input *ListBotsInput, opts ...request.Option) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotsPages iterates over the pages of a ListBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBots operation.
//	pageNum := 0
//	err := client.ListBotsPages(params,
//	    func(page *chime.ListBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListBotsPages(input *ListBotsInput, fn func(*ListBotsOutput, bool) bool) error {
	return c.ListBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotsPagesWithContext same as ListBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListBotsPagesWithContext(ctx aws.Context, input *ListBotsInput, fn func(*ListBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelBans = "ListChannelBans"

// ListChannelBansRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelBans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelBans for more information on using the ListChannelBans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelBansRequest method.
//	req, resp := client.ListChannelBansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelBans
//
// Deprecated: Replaced by ListChannelBans in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelBansRequest(input *ListChannelBansInput) (req *request.Request, output *ListChannelBansOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelBans, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelBans,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/bans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelBansInput{}
	}

	output = &ListChannelBansOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelBans API operation for Amazon Chime.
//
// Lists all the users banned from a particular channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelBans (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelBans.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelBans for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelBans
//
// Deprecated: Replaced by ListChannelBans in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelBans(input *ListChannelBansInput) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	return out, req.Send()
}

// ListChannelBansWithContext is the same as ListChannelBans with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelBans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelBans in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelBansWithContext(ctx aws.Context, input *ListChannelBansInput, opts ...request.Option) (*ListChannelBansOutput, error) {
	req, out := c.ListChannelBansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelBansPages iterates over the pages of a ListChannelBans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelBans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelBans operation.
//	pageNum := 0
//	err := client.ListChannelBansPages(params,
//	    func(page *chime.ListChannelBansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelBans in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelBansPages(input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool) error {
	return c.ListChannelBansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelBansPagesWithContext same as ListChannelBansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelBans in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelBansPagesWithContext(ctx aws.Context, input *ListChannelBansInput, fn func(*ListChannelBansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelBansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelBansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelBansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMemberships = "ListChannelMemberships"

// ListChannelMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMemberships for more information on using the ListChannelMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMembershipsRequest method.
//	req, resp := client.ListChannelMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMemberships
//
// Deprecated: Replaced by ListChannelMemberships in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsRequest(input *ListChannelMembershipsInput) (req *request.Request, output *ListChannelMembershipsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelMemberships, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsInput{}
	}

	output = &ListChannelMembershipsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelMemberships API operation for Amazon Chime.
//
// Lists all channel memberships in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelMemberships (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMemberships.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelMemberships for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMemberships
//
// Deprecated: Replaced by ListChannelMemberships in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMemberships(input *ListChannelMembershipsInput) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsWithContext is the same as ListChannelMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMemberships in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsWithContext(ctx aws.Context, input *ListChannelMembershipsInput, opts ...request.Option) (*ListChannelMembershipsOutput, error) {
	req, out := c.ListChannelMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsPages iterates over the pages of a ListChannelMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMemberships operation.
//	pageNum := 0
//	err := client.ListChannelMembershipsPages(params,
//	    func(page *chime.ListChannelMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelMemberships in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsPages(input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool) error {
	return c.ListChannelMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsPagesWithContext same as ListChannelMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMemberships in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsPagesWithContext(ctx aws.Context, input *ListChannelMembershipsInput, fn func(*ListChannelMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMembershipsForAppInstanceUser = "ListChannelMembershipsForAppInstanceUser"

// ListChannelMembershipsForAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMembershipsForAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMembershipsForAppInstanceUser for more information on using the ListChannelMembershipsForAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMembershipsForAppInstanceUserRequest method.
//	req, resp := client.ListChannelMembershipsForAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMembershipsForAppInstanceUser
//
// Deprecated: Replaced by ListChannelMembershipsForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsForAppInstanceUserRequest(input *ListChannelMembershipsForAppInstanceUserInput) (req *request.Request, output *ListChannelMembershipsForAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelMembershipsForAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelMembershipsForAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMembershipsForAppInstanceUserInput{}
	}

	output = &ListChannelMembershipsForAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelMembershipsForAppInstanceUser API operation for Amazon Chime.
//
// Lists all channels that a particular AppInstanceUser is a part of. Only an
// AppInstanceAdmin can call the API with a user ARN that is not their own.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelMembershipsForAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelMembershipsForAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMembershipsForAppInstanceUser
//
// Deprecated: Replaced by ListChannelMembershipsForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsForAppInstanceUser(input *ListChannelMembershipsForAppInstanceUserInput) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserWithContext is the same as ListChannelMembershipsForAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMembershipsForAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMembershipsForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsForAppInstanceUserWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, opts ...request.Option) (*ListChannelMembershipsForAppInstanceUserOutput, error) {
	req, out := c.ListChannelMembershipsForAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMembershipsForAppInstanceUserPages iterates over the pages of a ListChannelMembershipsForAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMembershipsForAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMembershipsForAppInstanceUser operation.
//	pageNum := 0
//	err := client.ListChannelMembershipsForAppInstanceUserPages(params,
//	    func(page *chime.ListChannelMembershipsForAppInstanceUserOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelMembershipsForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsForAppInstanceUserPages(input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelMembershipsForAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMembershipsForAppInstanceUserPagesWithContext same as ListChannelMembershipsForAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMembershipsForAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMembershipsForAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelMembershipsForAppInstanceUserInput, fn func(*ListChannelMembershipsForAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMembershipsForAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMembershipsForAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMembershipsForAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelMessages = "ListChannelMessages"

// ListChannelMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelMessages for more information on using the ListChannelMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelMessagesRequest method.
//	req, resp := client.ListChannelMessagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMessages
//
// Deprecated: Replaced by ListChannelMessages in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMessagesRequest(input *ListChannelMessagesInput) (req *request.Request, output *ListChannelMessagesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelMessages, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelMessages,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/messages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelMessagesInput{}
	}

	output = &ListChannelMessagesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelMessages API operation for Amazon Chime.
//
// List all the messages in a channel. Returns a paginated list of ChannelMessages.
// By default, sorted by creation timestamp in descending order.
//
// Redacted messages appear in the results as empty, since they are only redacted,
// not deleted. Deleted messages do not appear in the results. This action always
// returns the latest version of an edited message.
//
// Also, the x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelMessages (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMessages.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelMessages for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelMessages
//
// Deprecated: Replaced by ListChannelMessages in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMessages(input *ListChannelMessagesInput) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	return out, req.Send()
}

// ListChannelMessagesWithContext is the same as ListChannelMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMessages in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMessagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, opts ...request.Option) (*ListChannelMessagesOutput, error) {
	req, out := c.ListChannelMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelMessagesPages iterates over the pages of a ListChannelMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelMessages operation.
//	pageNum := 0
//	err := client.ListChannelMessagesPages(params,
//	    func(page *chime.ListChannelMessagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelMessages in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMessagesPages(input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool) error {
	return c.ListChannelMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelMessagesPagesWithContext same as ListChannelMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelMessages in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelMessagesPagesWithContext(ctx aws.Context, input *ListChannelMessagesInput, fn func(*ListChannelMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelMessagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelModerators = "ListChannelModerators"

// ListChannelModeratorsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelModerators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelModerators for more information on using the ListChannelModerators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelModeratorsRequest method.
//	req, resp := client.ListChannelModeratorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelModerators
//
// Deprecated: Replaced by ListChannelModerators in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelModeratorsRequest(input *ListChannelModeratorsInput) (req *request.Request, output *ListChannelModeratorsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelModerators, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelModerators,
		HTTPMethod: "GET",
		HTTPPath:   "/channels/{channelArn}/moderators",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelModeratorsInput{}
	}

	output = &ListChannelModeratorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelModerators API operation for Amazon Chime.
//
// Lists all the moderators for a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelModerators (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelModerators.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelModerators for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelModerators
//
// Deprecated: Replaced by ListChannelModerators in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelModerators(input *ListChannelModeratorsInput) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	return out, req.Send()
}

// ListChannelModeratorsWithContext is the same as ListChannelModerators with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelModerators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelModerators in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelModeratorsWithContext(ctx aws.Context, input *ListChannelModeratorsInput, opts ...request.Option) (*ListChannelModeratorsOutput, error) {
	req, out := c.ListChannelModeratorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelModeratorsPages iterates over the pages of a ListChannelModerators operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelModerators method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelModerators operation.
//	pageNum := 0
//	err := client.ListChannelModeratorsPages(params,
//	    func(page *chime.ListChannelModeratorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelModerators in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelModeratorsPages(input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool) error {
	return c.ListChannelModeratorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelModeratorsPagesWithContext same as ListChannelModeratorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelModerators in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelModeratorsPagesWithContext(ctx aws.Context, input *ListChannelModeratorsInput, fn func(*ListChannelModeratorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelModeratorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelModeratorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelModeratorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannels
//
// Deprecated: Replaced by ListChannels in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannels, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannels API operation for Amazon Chime.
//
// Lists all Channels created under a single Chime App as a paginated list.
// You can specify filters to narrow results.
//
// Functionality & restrictions
//
//   - Use privacy = PUBLIC to retrieve all public channels in the account.
//
//   - Only an AppInstanceAdmin can set privacy = PRIVATE to list the private
//     channels in an account.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannels (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannels.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannels
//
// Deprecated: Replaced by ListChannels in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannels in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *chime.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannels in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannels in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannelsModeratedByAppInstanceUser = "ListChannelsModeratedByAppInstanceUser"

// ListChannelsModeratedByAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelsModeratedByAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelsModeratedByAppInstanceUser for more information on using the ListChannelsModeratedByAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsModeratedByAppInstanceUserRequest method.
//	req, resp := client.ListChannelsModeratedByAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelsModeratedByAppInstanceUser
//
// Deprecated: Replaced by ListChannelsModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsModeratedByAppInstanceUserRequest(input *ListChannelsModeratedByAppInstanceUserInput) (req *request.Request, output *ListChannelsModeratedByAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListChannelsModeratedByAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListChannelsModeratedByAppInstanceUser,
		HTTPMethod: "GET",
		HTTPPath:   "/channels?scope=app-instance-user-moderated-channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsModeratedByAppInstanceUserInput{}
	}

	output = &ListChannelsModeratedByAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListChannelsModeratedByAppInstanceUser API operation for Amazon Chime.
//
// A list of the channels moderated by an AppInstanceUser.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListChannelsModeratedByAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelsModeratedByAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListChannelsModeratedByAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListChannelsModeratedByAppInstanceUser
//
// Deprecated: Replaced by ListChannelsModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsModeratedByAppInstanceUser(input *ListChannelsModeratedByAppInstanceUserInput) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserWithContext is the same as ListChannelsModeratedByAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelsModeratedByAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelsModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsModeratedByAppInstanceUserWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, opts ...request.Option) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	req, out := c.ListChannelsModeratedByAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsModeratedByAppInstanceUserPages iterates over the pages of a ListChannelsModeratedByAppInstanceUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelsModeratedByAppInstanceUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelsModeratedByAppInstanceUser operation.
//	pageNum := 0
//	err := client.ListChannelsModeratedByAppInstanceUserPages(params,
//	    func(page *chime.ListChannelsModeratedByAppInstanceUserOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListChannelsModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsModeratedByAppInstanceUserPages(input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool) error {
	return c.ListChannelsModeratedByAppInstanceUserPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsModeratedByAppInstanceUserPagesWithContext same as ListChannelsModeratedByAppInstanceUserPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListChannelsModeratedByAppInstanceUser in the Amazon Chime SDK Messaging Namespace
func (c *Chime) ListChannelsModeratedByAppInstanceUserPagesWithContext(ctx aws.Context, input *ListChannelsModeratedByAppInstanceUserInput, fn func(*ListChannelsModeratedByAppInstanceUserOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsModeratedByAppInstanceUserInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsModeratedByAppInstanceUserRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsModeratedByAppInstanceUserOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMediaCapturePipelines = "ListMediaCapturePipelines"

// ListMediaCapturePipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListMediaCapturePipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMediaCapturePipelines for more information on using the ListMediaCapturePipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMediaCapturePipelinesRequest method.
//	req, resp := client.ListMediaCapturePipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMediaCapturePipelines
//
// Deprecated: Replaced by ListMediaCapturePipelines in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) ListMediaCapturePipelinesRequest(input *ListMediaCapturePipelinesInput) (req *request.Request, output *ListMediaCapturePipelinesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListMediaCapturePipelines, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListMediaCapturePipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/media-capture-pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMediaCapturePipelinesInput{}
	}

	output = &ListMediaCapturePipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMediaCapturePipelines API operation for Amazon Chime.
//
// Returns a list of media capture pipelines.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListMediaCapturePipelines (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_ListMediaCapturePipelines.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListMediaCapturePipelines for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMediaCapturePipelines
//
// Deprecated: Replaced by ListMediaCapturePipelines in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) ListMediaCapturePipelines(input *ListMediaCapturePipelinesInput) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	return out, req.Send()
}

// ListMediaCapturePipelinesWithContext is the same as ListMediaCapturePipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListMediaCapturePipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListMediaCapturePipelines in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) ListMediaCapturePipelinesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, opts ...request.Option) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMediaCapturePipelinesPages iterates over the pages of a ListMediaCapturePipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMediaCapturePipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMediaCapturePipelines operation.
//	pageNum := 0
//	err := client.ListMediaCapturePipelinesPages(params,
//	    func(page *chime.ListMediaCapturePipelinesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListMediaCapturePipelines in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) ListMediaCapturePipelinesPages(input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool) error {
	return c.ListMediaCapturePipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMediaCapturePipelinesPagesWithContext same as ListMediaCapturePipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListMediaCapturePipelines in the Amazon Chime SDK Media Pipelines Namespace
func (c *Chime) ListMediaCapturePipelinesPagesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMediaCapturePipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMediaCapturePipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMediaCapturePipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMeetingTags = "ListMeetingTags"

// ListMeetingTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListMeetingTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeetingTags for more information on using the ListMeetingTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMeetingTagsRequest method.
//	req, resp := client.ListMeetingTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetingTags
//
// Deprecated: Use ListTagsForResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) ListMeetingTagsRequest(input *ListMeetingTagsInput) (req *request.Request, output *ListMeetingTagsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListMeetingTags, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListMeetingTags,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/tags",
	}

	if input == nil {
		input = &ListMeetingTagsInput{}
	}

	output = &ListMeetingTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeetingTags API operation for Amazon Chime.
//
// Lists the tags applied to an Amazon Chime SDK meeting resource.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListTagsForResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_ListTagsForResource.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListMeetingTags for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetingTags
//
// Deprecated: Use ListTagsForResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) ListMeetingTags(input *ListMeetingTagsInput) (*ListMeetingTagsOutput, error) {
	req, out := c.ListMeetingTagsRequest(input)
	return out, req.Send()
}

// ListMeetingTagsWithContext is the same as ListMeetingTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeetingTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use ListTagsForResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) ListMeetingTagsWithContext(ctx aws.Context, input *ListMeetingTagsInput, opts ...request.Option) (*ListMeetingTagsOutput, error) {
	req, out := c.ListMeetingTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMeetings = "ListMeetings"

// ListMeetingsRequest generates a "aws/request.Request" representing the
// client's request for the ListMeetings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeetings for more information on using the ListMeetings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMeetingsRequest method.
//	req, resp := client.ListMeetingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings
//
// Deprecated: ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListMeetingsRequest(input *ListMeetingsInput) (req *request.Request, output *ListMeetingsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListMeetings, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListMeetings,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeetingsInput{}
	}

	output = &ListMeetingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeetings API operation for Amazon Chime.
//
// Lists up to 100 active Amazon Chime SDK meetings.
//
// ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace.
// Update your application to remove calls to this API.
//
// For more information about the Amazon Chime SDK, see Using the Amazon Chime
// SDK (https://docs.aws.amazon.com/chime-sdk/latest/dg/meetings-sdk.html) in
// the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListMeetings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings
//
// Deprecated: ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListMeetings(input *ListMeetingsInput) (*ListMeetingsOutput, error) {
	req, out := c.ListMeetingsRequest(input)
	return out, req.Send()
}

// ListMeetingsWithContext is the same as ListMeetings with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeetings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListMeetingsWithContext(ctx aws.Context, input *ListMeetingsInput, opts ...request.Option) (*ListMeetingsOutput, error) {
	req, out := c.ListMeetingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeetingsPages iterates over the pages of a ListMeetings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeetings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMeetings operation.
//	pageNum := 0
//	err := client.ListMeetingsPages(params,
//	    func(page *chime.ListMeetingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListMeetingsPages(input *ListMeetingsInput, fn func(*ListMeetingsOutput, bool) bool) error {
	return c.ListMeetingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeetingsPagesWithContext same as ListMeetingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: ListMeetings is not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) ListMeetingsPagesWithContext(ctx aws.Context, input *ListMeetingsInput, fn func(*ListMeetingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeetingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeetingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMeetingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumberOrders = "ListPhoneNumberOrders"

// ListPhoneNumberOrdersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumberOrders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumberOrders for more information on using the ListPhoneNumberOrders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumberOrdersRequest method.
//	req, resp := client.ListPhoneNumberOrdersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders
func (c *Chime) ListPhoneNumberOrdersRequest(input *ListPhoneNumberOrdersInput) (req *request.Request, output *ListPhoneNumberOrdersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumberOrders,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumberOrdersInput{}
	}

	output = &ListPhoneNumberOrdersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumberOrders API operation for Amazon Chime.
//
// Lists the phone number orders for the administrator's Amazon Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListPhoneNumberOrders for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders
func (c *Chime) ListPhoneNumberOrders(input *ListPhoneNumberOrdersInput) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	return out, req.Send()
}

// ListPhoneNumberOrdersWithContext is the same as ListPhoneNumberOrders with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumberOrders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumberOrdersWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, opts ...request.Option) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumberOrdersPages iterates over the pages of a ListPhoneNumberOrders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumberOrders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumberOrders operation.
//	pageNum := 0
//	err := client.ListPhoneNumberOrdersPages(params,
//	    func(page *chime.ListPhoneNumberOrdersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListPhoneNumberOrdersPages(input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool) error {
	return c.ListPhoneNumberOrdersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumberOrdersPagesWithContext same as ListPhoneNumberOrdersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumberOrdersPagesWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumberOrdersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumberOrdersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumberOrdersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbers for more information on using the ListPhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumbersRequest method.
//	req, resp := client.ListPhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers
func (c *Chime) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) (req *request.Request, output *ListPhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	output = &ListPhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbers API operation for Amazon Chime.
//
// Lists the phone numbers for the specified Amazon Chime account, Amazon Chime
// user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListPhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers
func (c *Chime) ListPhoneNumbers(input *ListPhoneNumbersInput) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	return out, req.Send()
}

// ListPhoneNumbersWithContext is the same as ListPhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumbersWithContext(ctx aws.Context, input *ListPhoneNumbersInput, opts ...request.Option) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersPages iterates over the pages of a ListPhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumbers operation.
//	pageNum := 0
//	err := client.ListPhoneNumbersPages(params,
//	    func(page *chime.ListPhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListPhoneNumbersPages(input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool) error {
	return c.ListPhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersPagesWithContext same as ListPhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumbersPagesWithContext(ctx aws.Context, input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProxySessions = "ListProxySessions"

// ListProxySessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListProxySessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProxySessions for more information on using the ListProxySessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProxySessionsRequest method.
//	req, resp := client.ListProxySessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions
//
// Deprecated: Replaced by ListProxySessions in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListProxySessionsRequest(input *ListProxySessionsInput) (req *request.Request, output *ListProxySessionsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListProxySessions, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListProxySessions,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProxySessionsInput{}
	}

	output = &ListProxySessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProxySessions API operation for Amazon Chime.
//
// Lists the proxy sessions for the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListProxySessions (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListProxySessions.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListProxySessions for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListProxySessions
//
// Deprecated: Replaced by ListProxySessions in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListProxySessions(input *ListProxySessionsInput) (*ListProxySessionsOutput, error) {
	req, out := c.ListProxySessionsRequest(input)
	return out, req.Send()
}

// ListProxySessionsWithContext is the same as ListProxySessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListProxySessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListProxySessions in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListProxySessionsWithContext(ctx aws.Context, input *ListProxySessionsInput, opts ...request.Option) (*ListProxySessionsOutput, error) {
	req, out := c.ListProxySessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProxySessionsPages iterates over the pages of a ListProxySessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProxySessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProxySessions operation.
//	pageNum := 0
//	err := client.ListProxySessionsPages(params,
//	    func(page *chime.ListProxySessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListProxySessions in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListProxySessionsPages(input *ListProxySessionsInput, fn func(*ListProxySessionsOutput, bool) bool) error {
	return c.ListProxySessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProxySessionsPagesWithContext same as ListProxySessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListProxySessions in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListProxySessionsPagesWithContext(ctx aws.Context, input *ListProxySessionsInput, fn func(*ListProxySessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProxySessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProxySessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProxySessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoomMemberships = "ListRoomMemberships"

// ListRoomMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoomMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoomMemberships for more information on using the ListRoomMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoomMembershipsRequest method.
//	req, resp := client.ListRoomMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships
func (c *Chime) ListRoomMembershipsRequest(input *ListRoomMembershipsInput) (req *request.Request, output *ListRoomMembershipsOutput) {
	op := &request.Operation{
		Name:       opListRoomMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomMembershipsInput{}
	}

	output = &ListRoomMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoomMemberships API operation for Amazon Chime.
//
// Lists the membership details for the specified room in an Amazon Chime Enterprise
// account, such as the members' IDs, email addresses, and names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListRoomMemberships for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships
func (c *Chime) ListRoomMemberships(input *ListRoomMembershipsInput) (*ListRoomMembershipsOutput, error) {
	req, out := c.ListRoomMembershipsRequest(input)
	return out, req.Send()
}

// ListRoomMembershipsWithContext is the same as ListRoomMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoomMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomMembershipsWithContext(ctx aws.Context, input *ListRoomMembershipsInput, opts ...request.Option) (*ListRoomMembershipsOutput, error) {
	req, out := c.ListRoomMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoomMembershipsPages iterates over the pages of a ListRoomMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoomMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoomMemberships operation.
//	pageNum := 0
//	err := client.ListRoomMembershipsPages(params,
//	    func(page *chime.ListRoomMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListRoomMembershipsPages(input *ListRoomMembershipsInput, fn func(*ListRoomMembershipsOutput, bool) bool) error {
	return c.ListRoomMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoomMembershipsPagesWithContext same as ListRoomMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomMembershipsPagesWithContext(ctx aws.Context, input *ListRoomMembershipsInput, fn func(*ListRoomMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoomMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoomMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoomMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRooms = "ListRooms"

// ListRoomsRequest generates a "aws/request.Request" representing the
// client's request for the ListRooms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRooms for more information on using the ListRooms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoomsRequest method.
//	req, resp := client.ListRoomsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms
func (c *Chime) ListRoomsRequest(input *ListRoomsInput) (req *request.Request, output *ListRoomsOutput) {
	op := &request.Operation{
		Name:       opListRooms,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomsInput{}
	}

	output = &ListRoomsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRooms API operation for Amazon Chime.
//
// Lists the room details for the specified Amazon Chime Enterprise account.
// Optionally, filter the results by a member ID (user ID or bot ID) to see
// a list of rooms that the member belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListRooms for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms
func (c *Chime) ListRooms(input *ListRoomsInput) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	return out, req.Send()
}

// ListRoomsWithContext is the same as ListRooms with the addition of
// the ability to pass a context and additional request options.
//
// See ListRooms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomsWithContext(ctx aws.Context, input *ListRoomsInput, opts ...request.Option) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoomsPages iterates over the pages of a ListRooms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRooms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRooms operation.
//	pageNum := 0
//	err := client.ListRoomsPages(params,
//	    func(page *chime.ListRoomsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListRoomsPages(input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool) error {
	return c.ListRoomsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoomsPagesWithContext same as ListRoomsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomsPagesWithContext(ctx aws.Context, input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoomsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoomsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoomsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSipMediaApplications = "ListSipMediaApplications"

// ListSipMediaApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSipMediaApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSipMediaApplications for more information on using the ListSipMediaApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSipMediaApplicationsRequest method.
//	req, resp := client.ListSipMediaApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSipMediaApplications
//
// Deprecated: Replaced by ListSipMediaApplications in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipMediaApplicationsRequest(input *ListSipMediaApplicationsInput) (req *request.Request, output *ListSipMediaApplicationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListSipMediaApplications, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListSipMediaApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-media-applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSipMediaApplicationsInput{}
	}

	output = &ListSipMediaApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSipMediaApplications API operation for Amazon Chime.
//
// Lists the SIP media applications under the administrator's AWS account.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListSipMediaApplications (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListSipMediaApplications.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListSipMediaApplications for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSipMediaApplications
//
// Deprecated: Replaced by ListSipMediaApplications in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipMediaApplications(input *ListSipMediaApplicationsInput) (*ListSipMediaApplicationsOutput, error) {
	req, out := c.ListSipMediaApplicationsRequest(input)
	return out, req.Send()
}

// ListSipMediaApplicationsWithContext is the same as ListSipMediaApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListSipMediaApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListSipMediaApplications in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipMediaApplicationsWithContext(ctx aws.Context, input *ListSipMediaApplicationsInput, opts ...request.Option) (*ListSipMediaApplicationsOutput, error) {
	req, out := c.ListSipMediaApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSipMediaApplicationsPages iterates over the pages of a ListSipMediaApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSipMediaApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSipMediaApplications operation.
//	pageNum := 0
//	err := client.ListSipMediaApplicationsPages(params,
//	    func(page *chime.ListSipMediaApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListSipMediaApplications in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipMediaApplicationsPages(input *ListSipMediaApplicationsInput, fn func(*ListSipMediaApplicationsOutput, bool) bool) error {
	return c.ListSipMediaApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSipMediaApplicationsPagesWithContext same as ListSipMediaApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListSipMediaApplications in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipMediaApplicationsPagesWithContext(ctx aws.Context, input *ListSipMediaApplicationsInput, fn func(*ListSipMediaApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSipMediaApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSipMediaApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSipMediaApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSipRules = "ListSipRules"

// ListSipRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListSipRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSipRules for more information on using the ListSipRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSipRulesRequest method.
//	req, resp := client.ListSipRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSipRules
//
// Deprecated: Replaced by ListSipRules in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipRulesRequest(input *ListSipRulesInput) (req *request.Request, output *ListSipRulesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListSipRules, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListSipRules,
		HTTPMethod: "GET",
		HTTPPath:   "/sip-rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSipRulesInput{}
	}

	output = &ListSipRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSipRules API operation for Amazon Chime.
//
// Lists the SIP rules under the administrator's AWS account.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListSipRules (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListSipRules.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListSipRules for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSipRules
//
// Deprecated: Replaced by ListSipRules in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipRules(input *ListSipRulesInput) (*ListSipRulesOutput, error) {
	req, out := c.ListSipRulesRequest(input)
	return out, req.Send()
}

// ListSipRulesWithContext is the same as ListSipRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListSipRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListSipRules in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipRulesWithContext(ctx aws.Context, input *ListSipRulesInput, opts ...request.Option) (*ListSipRulesOutput, error) {
	req, out := c.ListSipRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSipRulesPages iterates over the pages of a ListSipRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSipRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSipRules operation.
//	pageNum := 0
//	err := client.ListSipRulesPages(params,
//	    func(page *chime.ListSipRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListSipRules in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipRulesPages(input *ListSipRulesInput, fn func(*ListSipRulesOutput, bool) bool) error {
	return c.ListSipRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSipRulesPagesWithContext same as ListSipRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListSipRules in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListSipRulesPagesWithContext(ctx aws.Context, input *ListSipRulesInput, fn func(*ListSipRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSipRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSipRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSipRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSupportedPhoneNumberCountries = "ListSupportedPhoneNumberCountries"

// ListSupportedPhoneNumberCountriesRequest generates a "aws/request.Request" representing the
// client's request for the ListSupportedPhoneNumberCountries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSupportedPhoneNumberCountries for more information on using the ListSupportedPhoneNumberCountries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSupportedPhoneNumberCountriesRequest method.
//	req, resp := client.ListSupportedPhoneNumberCountriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSupportedPhoneNumberCountries
func (c *Chime) ListSupportedPhoneNumberCountriesRequest(input *ListSupportedPhoneNumberCountriesInput) (req *request.Request, output *ListSupportedPhoneNumberCountriesOutput) {
	op := &request.Operation{
		Name:       opListSupportedPhoneNumberCountries,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-countries",
	}

	if input == nil {
		input = &ListSupportedPhoneNumberCountriesInput{}
	}

	output = &ListSupportedPhoneNumberCountriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSupportedPhoneNumberCountries API operation for Amazon Chime.
//
// Lists supported phone number countries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListSupportedPhoneNumberCountries for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListSupportedPhoneNumberCountries
func (c *Chime) ListSupportedPhoneNumberCountries(input *ListSupportedPhoneNumberCountriesInput) (*ListSupportedPhoneNumberCountriesOutput, error) {
	req, out := c.ListSupportedPhoneNumberCountriesRequest(input)
	return out, req.Send()
}

// ListSupportedPhoneNumberCountriesWithContext is the same as ListSupportedPhoneNumberCountries with the addition of
// the ability to pass a context and additional request options.
//
// See ListSupportedPhoneNumberCountries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListSupportedPhoneNumberCountriesWithContext(ctx aws.Context, input *ListSupportedPhoneNumberCountriesInput, opts ...request.Option) (*ListSupportedPhoneNumberCountriesOutput, error) {
	req, out := c.ListSupportedPhoneNumberCountriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListTagsForResource
//
// Deprecated: Replaced by ListTagsForResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListTagsForResource, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime.
//
// Lists the tags applied to an Amazon Chime SDK meeting and messaging resources.
//
// This API is is no longer supported and will not be updated. We recommend
// using the applicable latest version in the Amazon Chime SDK.
//
//   - For meetings: ListTagsForResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_ListTagsForResource.html).
//
//   - For messaging: ListTagsForResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListTagsForResource.html).
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListTagsForResource
//
// Deprecated: Replaced by ListTagsForResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListTagsForResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsersRequest method.
//	req, resp := client.ListUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Chime.
//
// Lists the users that belong to the specified Amazon Chime account. You can
// specify an email address to list only the user that the email address belongs
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsers operation.
//	pageNum := 0
//	err := client.ListUsersPages(params,
//	    func(page *chime.ListUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVoiceConnectorGroups = "ListVoiceConnectorGroups"

// ListVoiceConnectorGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorGroups for more information on using the ListVoiceConnectorGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorGroupsRequest method.
//	req, resp := client.ListVoiceConnectorGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups
//
// Deprecated: Replaced by ListVoiceConnectorGroups in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorGroupsRequest(input *ListVoiceConnectorGroupsInput) (req *request.Request, output *ListVoiceConnectorGroupsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListVoiceConnectorGroups, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListVoiceConnectorGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorGroupsInput{}
	}

	output = &ListVoiceConnectorGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorGroups API operation for Amazon Chime.
//
// Lists the Amazon Chime Voice Connector groups for the administrator's AWS
// account.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListVoiceConnectorGroups (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListVoiceConnectorGroups.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectorGroups for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups
//
// Deprecated: Replaced by ListVoiceConnectorGroups in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorGroups(input *ListVoiceConnectorGroupsInput) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorGroupsWithContext is the same as ListVoiceConnectorGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListVoiceConnectorGroups in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorGroupsWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, opts ...request.Option) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorGroupsPages iterates over the pages of a ListVoiceConnectorGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectorGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVoiceConnectorGroups operation.
//	pageNum := 0
//	err := client.ListVoiceConnectorGroupsPages(params,
//	    func(page *chime.ListVoiceConnectorGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListVoiceConnectorGroups in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorGroupsPages(input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool) error {
	return c.ListVoiceConnectorGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorGroupsPagesWithContext same as ListVoiceConnectorGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListVoiceConnectorGroups in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorGroupsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVoiceConnectorTerminationCredentials = "ListVoiceConnectorTerminationCredentials"

// ListVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorTerminationCredentials for more information on using the ListVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.ListVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by ListVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorTerminationCredentialsRequest(input *ListVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *ListVoiceConnectorTerminationCredentialsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListVoiceConnectorTerminationCredentials, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListVoiceConnectorTerminationCredentials,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials",
	}

	if input == nil {
		input = &ListVoiceConnectorTerminationCredentialsInput{}
	}

	output = &ListVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Lists the SIP credentials for the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListVoiceConnectorTerminationCredentials (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListVoiceConnectorTerminationCredentials.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by ListVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorTerminationCredentials(input *ListVoiceConnectorTerminationCredentialsInput) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorTerminationCredentialsWithContext is the same as ListVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *ListVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVoiceConnectors = "ListVoiceConnectors"

// ListVoiceConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectors for more information on using the ListVoiceConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVoiceConnectorsRequest method.
//	req, resp := client.ListVoiceConnectorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors
//
// Deprecated: Replaced by ListVoiceConnectors in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorsRequest(input *ListVoiceConnectorsInput) (req *request.Request, output *ListVoiceConnectorsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ListVoiceConnectors, has been deprecated")
	}
	op := &request.Operation{
		Name:       opListVoiceConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorsInput{}
	}

	output = &ListVoiceConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectors API operation for Amazon Chime.
//
// Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ListVoiceConnectors (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ListVoiceConnectors.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectors for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors
//
// Deprecated: Replaced by ListVoiceConnectors in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectors(input *ListVoiceConnectorsInput) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorsWithContext is the same as ListVoiceConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListVoiceConnectors in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorsWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, opts ...request.Option) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorsPages iterates over the pages of a ListVoiceConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVoiceConnectors operation.
//	pageNum := 0
//	err := client.ListVoiceConnectorsPages(params,
//	    func(page *chime.ListVoiceConnectorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Replaced by ListVoiceConnectors in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorsPages(input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool) error {
	return c.ListVoiceConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorsPagesWithContext same as ListVoiceConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ListVoiceConnectors in the Amazon Chime SDK Voice Namespace
func (c *Chime) ListVoiceConnectorsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opLogoutUser = "LogoutUser"

// LogoutUserRequest generates a "aws/request.Request" representing the
// client's request for the LogoutUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LogoutUser for more information on using the LogoutUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the LogoutUserRequest method.
//	req, resp := client.LogoutUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUserRequest(input *LogoutUserInput) (req *request.Request, output *LogoutUserOutput) {
	op := &request.Operation{
		Name:       opLogoutUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=logout",
	}

	if input == nil {
		input = &LogoutUserInput{}
	}

	output = &LogoutUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// LogoutUser API operation for Amazon Chime.
//
// Logs out the specified user from all of the devices they are currently logged
// into.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation LogoutUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUser(input *LogoutUserInput) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	return out, req.Send()
}

// LogoutUserWithContext is the same as LogoutUser with the addition of
// the ability to pass a context and additional request options.
//
// See LogoutUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) LogoutUserWithContext(ctx aws.Context, input *LogoutUserInput, opts ...request.Option) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppInstanceRetentionSettings = "PutAppInstanceRetentionSettings"

// PutAppInstanceRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutAppInstanceRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppInstanceRetentionSettings for more information on using the PutAppInstanceRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAppInstanceRetentionSettingsRequest method.
//	req, resp := client.PutAppInstanceRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutAppInstanceRetentionSettings
//
// Deprecated: Replaced by PutAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) PutAppInstanceRetentionSettingsRequest(input *PutAppInstanceRetentionSettingsInput) (req *request.Request, output *PutAppInstanceRetentionSettingsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutAppInstanceRetentionSettings, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutAppInstanceRetentionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}/retention-settings",
	}

	if input == nil {
		input = &PutAppInstanceRetentionSettingsInput{}
	}

	output = &PutAppInstanceRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAppInstanceRetentionSettings API operation for Amazon Chime.
//
// Sets the amount of time in days that a given AppInstance retains data.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutAppInstanceRetentionSettings (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_PutAppInstanceRetentionSettings.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutAppInstanceRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutAppInstanceRetentionSettings
//
// Deprecated: Replaced by PutAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) PutAppInstanceRetentionSettings(input *PutAppInstanceRetentionSettingsInput) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	return out, req.Send()
}

// PutAppInstanceRetentionSettingsWithContext is the same as PutAppInstanceRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppInstanceRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutAppInstanceRetentionSettings in the Amazon Chime SDK Identity Namespace
func (c *Chime) PutAppInstanceRetentionSettingsWithContext(ctx aws.Context, input *PutAppInstanceRetentionSettingsInput, opts ...request.Option) (*PutAppInstanceRetentionSettingsOutput, error) {
	req, out := c.PutAppInstanceRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAppInstanceStreamingConfigurations = "PutAppInstanceStreamingConfigurations"

// PutAppInstanceStreamingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the PutAppInstanceStreamingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAppInstanceStreamingConfigurations for more information on using the PutAppInstanceStreamingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAppInstanceStreamingConfigurationsRequest method.
//	req, resp := client.PutAppInstanceStreamingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by PutAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) PutAppInstanceStreamingConfigurationsRequest(input *PutAppInstanceStreamingConfigurationsInput) (req *request.Request, output *PutAppInstanceStreamingConfigurationsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutAppInstanceStreamingConfigurations, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutAppInstanceStreamingConfigurations,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}/streaming-configurations",
	}

	if input == nil {
		input = &PutAppInstanceStreamingConfigurationsInput{}
	}

	output = &PutAppInstanceStreamingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAppInstanceStreamingConfigurations API operation for Amazon Chime.
//
// The data streaming configurations of an AppInstance.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutMessagingStreamingConfigurations (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_PutMessagingStreamingConfigurations.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutAppInstanceStreamingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutAppInstanceStreamingConfigurations
//
// Deprecated: Replaced by PutAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) PutAppInstanceStreamingConfigurations(input *PutAppInstanceStreamingConfigurationsInput) (*PutAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.PutAppInstanceStreamingConfigurationsRequest(input)
	return out, req.Send()
}

// PutAppInstanceStreamingConfigurationsWithContext is the same as PutAppInstanceStreamingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See PutAppInstanceStreamingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutAppInstanceStreamingConfigurations in the Amazon Chime SDK Messaging Namespace
func (c *Chime) PutAppInstanceStreamingConfigurationsWithContext(ctx aws.Context, input *PutAppInstanceStreamingConfigurationsInput, opts ...request.Option) (*PutAppInstanceStreamingConfigurationsOutput, error) {
	req, out := c.PutAppInstanceStreamingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventsConfiguration = "PutEventsConfiguration"

// PutEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventsConfiguration for more information on using the PutEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEventsConfigurationRequest method.
//	req, resp := client.PutEventsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration
func (c *Chime) PutEventsConfigurationRequest(input *PutEventsConfigurationInput) (req *request.Request, output *PutEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutEventsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &PutEventsConfigurationInput{}
	}

	output = &PutEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventsConfiguration API operation for Amazon Chime.
//
// Creates an events configuration that allows a bot to receive outgoing events
// sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function
// ARN. For more information, see Bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutEventsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration
func (c *Chime) PutEventsConfiguration(input *PutEventsConfigurationInput) (*PutEventsConfigurationOutput, error) {
	req, out := c.PutEventsConfigurationRequest(input)
	return out, req.Send()
}

// PutEventsConfigurationWithContext is the same as PutEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutEventsConfigurationWithContext(ctx aws.Context, input *PutEventsConfigurationInput, opts ...request.Option) (*PutEventsConfigurationOutput, error) {
	req, out := c.PutEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRetentionSettings = "PutRetentionSettings"

// PutRetentionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the PutRetentionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRetentionSettings for more information on using the PutRetentionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRetentionSettingsRequest method.
//	req, resp := client.PutRetentionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutRetentionSettings
func (c *Chime) PutRetentionSettingsRequest(input *PutRetentionSettingsInput) (req *request.Request, output *PutRetentionSettingsOutput) {
	op := &request.Operation{
		Name:       opPutRetentionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/retention-settings",
	}

	if input == nil {
		input = &PutRetentionSettingsInput{}
	}

	output = &PutRetentionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRetentionSettings API operation for Amazon Chime.
//
// Puts retention settings for the specified Amazon Chime Enterprise account.
// We recommend using AWS CloudTrail to monitor usage of this API for your account.
// For more information, see Logging Amazon Chime API Calls with AWS CloudTrail
// (https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the Amazon
// Chime Administration Guide.
//
// To turn off existing retention settings, remove the number of days from the
// corresponding RetentionDays field in the RetentionSettings object. For more
// information about retention settings, see Managing Chat Retention Policies
// (https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the
// Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutRetentionSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutRetentionSettings
func (c *Chime) PutRetentionSettings(input *PutRetentionSettingsInput) (*PutRetentionSettingsOutput, error) {
	req, out := c.PutRetentionSettingsRequest(input)
	return out, req.Send()
}

// PutRetentionSettingsWithContext is the same as PutRetentionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See PutRetentionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutRetentionSettingsWithContext(ctx aws.Context, input *PutRetentionSettingsInput, opts ...request.Option) (*PutRetentionSettingsOutput, error) {
	req, out := c.PutRetentionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSipMediaApplicationLoggingConfiguration = "PutSipMediaApplicationLoggingConfiguration"

// PutSipMediaApplicationLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutSipMediaApplicationLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSipMediaApplicationLoggingConfiguration for more information on using the PutSipMediaApplicationLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSipMediaApplicationLoggingConfigurationRequest method.
//	req, resp := client.PutSipMediaApplicationLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutSipMediaApplicationLoggingConfiguration
//
// Deprecated: Replaced by PutSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutSipMediaApplicationLoggingConfigurationRequest(input *PutSipMediaApplicationLoggingConfigurationInput) (req *request.Request, output *PutSipMediaApplicationLoggingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutSipMediaApplicationLoggingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutSipMediaApplicationLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/logging-configuration",
	}

	if input == nil {
		input = &PutSipMediaApplicationLoggingConfigurationInput{}
	}

	output = &PutSipMediaApplicationLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSipMediaApplicationLoggingConfiguration API operation for Amazon Chime.
//
// Updates the logging configuration for the specified SIP media application.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutSipMediaApplicationLoggingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutSipMediaApplicationLoggingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutSipMediaApplicationLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutSipMediaApplicationLoggingConfiguration
//
// Deprecated: Replaced by PutSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutSipMediaApplicationLoggingConfiguration(input *PutSipMediaApplicationLoggingConfigurationInput) (*PutSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutSipMediaApplicationLoggingConfigurationWithContext is the same as PutSipMediaApplicationLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutSipMediaApplicationLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutSipMediaApplicationLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutSipMediaApplicationLoggingConfigurationWithContext(ctx aws.Context, input *PutSipMediaApplicationLoggingConfigurationInput, opts ...request.Option) (*PutSipMediaApplicationLoggingConfigurationOutput, error) {
	req, out := c.PutSipMediaApplicationLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorEmergencyCallingConfiguration = "PutVoiceConnectorEmergencyCallingConfiguration"

// PutVoiceConnectorEmergencyCallingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorEmergencyCallingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorEmergencyCallingConfiguration for more information on using the PutVoiceConnectorEmergencyCallingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorEmergencyCallingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorEmergencyCallingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorEmergencyCallingConfigurationRequest(input *PutVoiceConnectorEmergencyCallingConfigurationInput) (req *request.Request, output *PutVoiceConnectorEmergencyCallingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorEmergencyCallingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	output = &PutVoiceConnectorEmergencyCallingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorEmergencyCallingConfiguration API operation for Amazon Chime.
//
// Puts emergency calling configuration details to the specified Amazon Chime
// Voice Connector, such as emergency phone numbers and calling countries. Origination
// and termination settings must be enabled for the Amazon Chime Voice Connector
// before emergency calling can be configured.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorEmergencyCallingConfiguration
// (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorEmergencyCallingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorEmergencyCallingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorEmergencyCallingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorEmergencyCallingConfiguration(input *PutVoiceConnectorEmergencyCallingConfigurationInput) (*PutVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorEmergencyCallingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorEmergencyCallingConfigurationWithContext is the same as PutVoiceConnectorEmergencyCallingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorEmergencyCallingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorEmergencyCallingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorEmergencyCallingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorEmergencyCallingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorEmergencyCallingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorEmergencyCallingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorLoggingConfiguration = "PutVoiceConnectorLoggingConfiguration"

// PutVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorLoggingConfiguration for more information on using the PutVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorLoggingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorLoggingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorLoggingConfigurationRequest(input *PutVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *PutVoiceConnectorLoggingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorLoggingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorLoggingConfigurationInput{}
	}

	output = &PutVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorLoggingConfiguration API operation for Amazon Chime.
//
// Adds a logging configuration for the specified Amazon Chime Voice Connector.
// The logging configuration specifies whether SIP message logs are enabled
// for sending to Amazon CloudWatch Logs.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorLoggingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorLoggingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorLoggingConfiguration(input *PutVoiceConnectorLoggingConfigurationInput) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorLoggingConfigurationWithContext is the same as PutVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorLoggingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorOrigination = "PutVoiceConnectorOrigination"

// PutVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorOrigination for more information on using the PutVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorOriginationRequest method.
//	req, resp := client.PutVoiceConnectorOriginationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination
//
// Deprecated: Replaced by PutVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorOriginationRequest(input *PutVoiceConnectorOriginationInput) (req *request.Request, output *PutVoiceConnectorOriginationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorOrigination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorOrigination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &PutVoiceConnectorOriginationInput{}
	}

	output = &PutVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorOrigination API operation for Amazon Chime.
//
// Adds origination settings for the specified Amazon Chime Voice Connector.
//
// If emergency calling is configured for the Amazon Chime Voice Connector,
// it must be deleted prior to turning off origination settings.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorOrigination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorOrigination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination
//
// Deprecated: Replaced by PutVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorOrigination(input *PutVoiceConnectorOriginationInput) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorOriginationWithContext is the same as PutVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorOrigination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorOriginationWithContext(ctx aws.Context, input *PutVoiceConnectorOriginationInput, opts ...request.Option) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorProxy = "PutVoiceConnectorProxy"

// PutVoiceConnectorProxyRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorProxy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorProxy for more information on using the PutVoiceConnectorProxy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorProxyRequest method.
//	req, resp := client.PutVoiceConnectorProxyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorProxy
//
// Deprecated: Replaced by PutVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorProxyRequest(input *PutVoiceConnectorProxyInput) (req *request.Request, output *PutVoiceConnectorProxyOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorProxy, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorProxy,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &PutVoiceConnectorProxyInput{}
	}

	output = &PutVoiceConnectorProxyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorProxy API operation for Amazon Chime.
//
// Puts the specified proxy configuration to the specified Amazon Chime Voice
// Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorProxy (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorProxy.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorProxy for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorProxy
//
// Deprecated: Replaced by PutVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorProxy(input *PutVoiceConnectorProxyInput) (*PutVoiceConnectorProxyOutput, error) {
	req, out := c.PutVoiceConnectorProxyRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorProxyWithContext is the same as PutVoiceConnectorProxy with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorProxy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorProxy in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorProxyWithContext(ctx aws.Context, input *PutVoiceConnectorProxyInput, opts ...request.Option) (*PutVoiceConnectorProxyOutput, error) {
	req, out := c.PutVoiceConnectorProxyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorStreamingConfiguration = "PutVoiceConnectorStreamingConfiguration"

// PutVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorStreamingConfiguration for more information on using the PutVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorStreamingConfigurationRequest method.
//	req, resp := client.PutVoiceConnectorStreamingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorStreamingConfigurationRequest(input *PutVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *PutVoiceConnectorStreamingConfigurationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorStreamingConfiguration, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorStreamingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorStreamingConfigurationInput{}
	}

	output = &PutVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Adds a streaming configuration for the specified Amazon Chime Voice Connector.
// The streaming configuration specifies whether media streaming is enabled
// for sending to Kinesis. It also sets the retention period, in hours, for
// the Amazon Kinesis data.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorStreamingConfiguration (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorStreamingConfiguration.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration
//
// Deprecated: Replaced by PutVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorStreamingConfiguration(input *PutVoiceConnectorStreamingConfigurationInput) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorStreamingConfigurationWithContext is the same as PutVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorStreamingConfiguration in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTermination = "PutVoiceConnectorTermination"

// PutVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTermination for more information on using the PutVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorTerminationRequest method.
//	req, resp := client.PutVoiceConnectorTerminationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination
//
// Deprecated: Replaced by PutVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTerminationRequest(input *PutVoiceConnectorTerminationInput) (req *request.Request, output *PutVoiceConnectorTerminationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorTermination, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorTermination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationInput{}
	}

	output = &PutVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorTermination API operation for Amazon Chime.
//
// Adds termination settings for the specified Amazon Chime Voice Connector.
//
// If emergency calling is configured for the Amazon Chime Voice Connector,
// it must be deleted prior to turning off termination settings.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorTermination (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorTermination.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination
//
// Deprecated: Replaced by PutVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTermination(input *PutVoiceConnectorTerminationInput) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationWithContext is the same as PutVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorTermination in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTerminationWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationInput, opts ...request.Option) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTerminationCredentials = "PutVoiceConnectorTerminationCredentials"

// PutVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTerminationCredentials for more information on using the PutVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutVoiceConnectorTerminationCredentialsRequest method.
//	req, resp := client.PutVoiceConnectorTerminationCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by PutVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTerminationCredentialsRequest(input *PutVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *PutVoiceConnectorTerminationCredentialsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutVoiceConnectorTerminationCredentials, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=put",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationCredentialsInput{}
	}

	output = &PutVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, PutVoiceConnectorTerminationCredentials (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_PutVoiceConnectorTerminationCredentials.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials
//
// Deprecated: Replaced by PutVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTerminationCredentials(input *PutVoiceConnectorTerminationCredentialsInput) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationCredentialsWithContext is the same as PutVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by PutVoiceConnectorTerminationCredentials in the Amazon Chime SDK Voice Namespace
func (c *Chime) PutVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRedactChannelMessage = "RedactChannelMessage"

// RedactChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the RedactChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RedactChannelMessage for more information on using the RedactChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RedactChannelMessageRequest method.
//	req, resp := client.RedactChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactChannelMessage
//
// Deprecated: Replaced by RedactChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) RedactChannelMessageRequest(input *RedactChannelMessageInput) (req *request.Request, output *RedactChannelMessageOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, RedactChannelMessage, has been deprecated")
	}
	op := &request.Operation{
		Name:       opRedactChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactChannelMessageInput{}
	}

	output = &RedactChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// RedactChannelMessage API operation for Amazon Chime.
//
// Redacts message content, but not metadata. The message exists in the back
// end, but the action returns null content, and the state shows as redacted.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, RedactChannelMessage (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_RedactChannelMessage.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RedactChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactChannelMessage
//
// Deprecated: Replaced by RedactChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) RedactChannelMessage(input *RedactChannelMessageInput) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	return out, req.Send()
}

// RedactChannelMessageWithContext is the same as RedactChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See RedactChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by RedactChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) RedactChannelMessageWithContext(ctx aws.Context, input *RedactChannelMessageInput, opts ...request.Option) (*RedactChannelMessageOutput, error) {
	req, out := c.RedactChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRedactConversationMessage = "RedactConversationMessage"

// RedactConversationMessageRequest generates a "aws/request.Request" representing the
// client's request for the RedactConversationMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RedactConversationMessage for more information on using the RedactConversationMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RedactConversationMessageRequest method.
//	req, resp := client.RedactConversationMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactConversationMessage
func (c *Chime) RedactConversationMessageRequest(input *RedactConversationMessageInput) (req *request.Request, output *RedactConversationMessageOutput) {
	op := &request.Operation{
		Name:       opRedactConversationMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/conversations/{conversationId}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactConversationMessageInput{}
	}

	output = &RedactConversationMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RedactConversationMessage API operation for Amazon Chime.
//
// Redacts the specified message from the specified Amazon Chime conversation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RedactConversationMessage for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactConversationMessage
func (c *Chime) RedactConversationMessage(input *RedactConversationMessageInput) (*RedactConversationMessageOutput, error) {
	req, out := c.RedactConversationMessageRequest(input)
	return out, req.Send()
}

// RedactConversationMessageWithContext is the same as RedactConversationMessage with the addition of
// the ability to pass a context and additional request options.
//
// See RedactConversationMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RedactConversationMessageWithContext(ctx aws.Context, input *RedactConversationMessageInput, opts ...request.Option) (*RedactConversationMessageOutput, error) {
	req, out := c.RedactConversationMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRedactRoomMessage = "RedactRoomMessage"

// RedactRoomMessageRequest generates a "aws/request.Request" representing the
// client's request for the RedactRoomMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RedactRoomMessage for more information on using the RedactRoomMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RedactRoomMessageRequest method.
//	req, resp := client.RedactRoomMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactRoomMessage
func (c *Chime) RedactRoomMessageRequest(input *RedactRoomMessageInput) (req *request.Request, output *RedactRoomMessageOutput) {
	op := &request.Operation{
		Name:       opRedactRoomMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactRoomMessageInput{}
	}

	output = &RedactRoomMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RedactRoomMessage API operation for Amazon Chime.
//
// Redacts the specified message from the specified Amazon Chime channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RedactRoomMessage for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactRoomMessage
func (c *Chime) RedactRoomMessage(input *RedactRoomMessageInput) (*RedactRoomMessageOutput, error) {
	req, out := c.RedactRoomMessageRequest(input)
	return out, req.Send()
}

// RedactRoomMessageWithContext is the same as RedactRoomMessage with the addition of
// the ability to pass a context and additional request options.
//
// See RedactRoomMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RedactRoomMessageWithContext(ctx aws.Context, input *RedactRoomMessageInput, opts ...request.Option) (*RedactRoomMessageOutput, error) {
	req, out := c.RedactRoomMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegenerateSecurityToken = "RegenerateSecurityToken"

// RegenerateSecurityTokenRequest generates a "aws/request.Request" representing the
// client's request for the RegenerateSecurityToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegenerateSecurityToken for more information on using the RegenerateSecurityToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegenerateSecurityTokenRequest method.
//	req, resp := client.RegenerateSecurityTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken
func (c *Chime) RegenerateSecurityTokenRequest(input *RegenerateSecurityTokenInput) (req *request.Request, output *RegenerateSecurityTokenOutput) {
	op := &request.Operation{
		Name:       opRegenerateSecurityToken,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}?operation=regenerate-security-token",
	}

	if input == nil {
		input = &RegenerateSecurityTokenInput{}
	}

	output = &RegenerateSecurityTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegenerateSecurityToken API operation for Amazon Chime.
//
// Regenerates the security token for a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RegenerateSecurityToken for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken
func (c *Chime) RegenerateSecurityToken(input *RegenerateSecurityTokenInput) (*RegenerateSecurityTokenOutput, error) {
	req, out := c.RegenerateSecurityTokenRequest(input)
	return out, req.Send()
}

// RegenerateSecurityTokenWithContext is the same as RegenerateSecurityToken with the addition of
// the ability to pass a context and additional request options.
//
// See RegenerateSecurityToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RegenerateSecurityTokenWithContext(ctx aws.Context, input *RegenerateSecurityTokenInput, opts ...request.Option) (*RegenerateSecurityTokenOutput, error) {
	req, out := c.RegenerateSecurityTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPersonalPIN = "ResetPersonalPIN"

// ResetPersonalPINRequest generates a "aws/request.Request" representing the
// client's request for the ResetPersonalPIN operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetPersonalPIN for more information on using the ResetPersonalPIN
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResetPersonalPINRequest method.
//	req, resp := client.ResetPersonalPINRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPINRequest(input *ResetPersonalPINInput) (req *request.Request, output *ResetPersonalPINOutput) {
	op := &request.Operation{
		Name:       opResetPersonalPIN,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=reset-personal-pin",
	}

	if input == nil {
		input = &ResetPersonalPINInput{}
	}

	output = &ResetPersonalPINOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetPersonalPIN API operation for Amazon Chime.
//
// Resets the personal meeting PIN for the specified user on an Amazon Chime
// account. Returns the User object with the updated personal meeting PIN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ResetPersonalPIN for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPIN(input *ResetPersonalPINInput) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	return out, req.Send()
}

// ResetPersonalPINWithContext is the same as ResetPersonalPIN with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPersonalPIN for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ResetPersonalPINWithContext(ctx aws.Context, input *ResetPersonalPINInput, opts ...request.Option) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestorePhoneNumber = "RestorePhoneNumber"

// RestorePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the RestorePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestorePhoneNumber for more information on using the RestorePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestorePhoneNumberRequest method.
//	req, resp := client.RestorePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber
func (c *Chime) RestorePhoneNumberRequest(input *RestorePhoneNumberInput) (req *request.Request, output *RestorePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opRestorePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}?operation=restore",
	}

	if input == nil {
		input = &RestorePhoneNumberInput{}
	}

	output = &RestorePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestorePhoneNumber API operation for Amazon Chime.
//
// Moves a phone number from the Deletion queue back into the phone number Inventory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RestorePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber
func (c *Chime) RestorePhoneNumber(input *RestorePhoneNumberInput) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	return out, req.Send()
}

// RestorePhoneNumberWithContext is the same as RestorePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See RestorePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RestorePhoneNumberWithContext(ctx aws.Context, input *RestorePhoneNumberInput, opts ...request.Option) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAvailablePhoneNumbers = "SearchAvailablePhoneNumbers"

// SearchAvailablePhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the SearchAvailablePhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAvailablePhoneNumbers for more information on using the SearchAvailablePhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAvailablePhoneNumbersRequest method.
//	req, resp := client.SearchAvailablePhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers
func (c *Chime) SearchAvailablePhoneNumbersRequest(input *SearchAvailablePhoneNumbersInput) (req *request.Request, output *SearchAvailablePhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opSearchAvailablePhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/search?type=phone-numbers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAvailablePhoneNumbersInput{}
	}

	output = &SearchAvailablePhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAvailablePhoneNumbers API operation for Amazon Chime.
//
// Searches for phone numbers that can be ordered. For US numbers, provide at
// least one of the following search filters: AreaCode, City, State, or TollFreePrefix.
// If you provide City, you must also provide State. Numbers outside the US
// only support the PhoneNumberType filter, which you must use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation SearchAvailablePhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers
func (c *Chime) SearchAvailablePhoneNumbers(input *SearchAvailablePhoneNumbersInput) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersWithContext is the same as SearchAvailablePhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAvailablePhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) SearchAvailablePhoneNumbersWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, opts ...request.Option) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersPages iterates over the pages of a SearchAvailablePhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAvailablePhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAvailablePhoneNumbers operation.
//	pageNum := 0
//	err := client.SearchAvailablePhoneNumbersPages(params,
//	    func(page *chime.SearchAvailablePhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Chime) SearchAvailablePhoneNumbersPages(input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool) error {
	return c.SearchAvailablePhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAvailablePhoneNumbersPagesWithContext same as SearchAvailablePhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) SearchAvailablePhoneNumbersPagesWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAvailablePhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAvailablePhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAvailablePhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendChannelMessage = "SendChannelMessage"

// SendChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendChannelMessage for more information on using the SendChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SendChannelMessageRequest method.
//	req, resp := client.SendChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SendChannelMessage
//
// Deprecated: Replaced by SendChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) SendChannelMessageRequest(input *SendChannelMessageInput) (req *request.Request, output *SendChannelMessageOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, SendChannelMessage, has been deprecated")
	}
	op := &request.Operation{
		Name:       opSendChannelMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/channels/{channelArn}/messages",
	}

	if input == nil {
		input = &SendChannelMessageInput{}
	}

	output = &SendChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SendChannelMessage API operation for Amazon Chime.
//
// Sends a message to a particular channel that the member is a part of.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// Also, STANDARD messages can contain 4KB of data and the 1KB of metadata.
// CONTROL messages can contain 30 bytes of data and no metadata.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, SendChannelMessage (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_SendChannelMessage.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation SendChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SendChannelMessage
//
// Deprecated: Replaced by SendChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) SendChannelMessage(input *SendChannelMessageInput) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	return out, req.Send()
}

// SendChannelMessageWithContext is the same as SendChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by SendChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) SendChannelMessageWithContext(ctx aws.Context, input *SendChannelMessageInput, opts ...request.Option) (*SendChannelMessageOutput, error) {
	req, out := c.SendChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMeetingTranscription = "StartMeetingTranscription"

// StartMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMeetingTranscription for more information on using the StartMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMeetingTranscriptionRequest method.
//	req, resp := client.StartMeetingTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/StartMeetingTranscription
//
// Deprecated: Replaced by StartMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StartMeetingTranscriptionRequest(input *StartMeetingTranscriptionInput) (req *request.Request, output *StartMeetingTranscriptionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, StartMeetingTranscription, has been deprecated")
	}
	op := &request.Operation{
		Name:       opStartMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/transcription?operation=start",
	}

	if input == nil {
		input = &StartMeetingTranscriptionInput{}
	}

	output = &StartMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMeetingTranscription API operation for Amazon Chime.
//
// Starts transcription for the specified meetingId. For more information, refer
// to Using Amazon Chime SDK live transcription (https://docs.aws.amazon.com/chime-sdk/latest/dg/meeting-transcription.html)
// in the Amazon Chime SDK Developer Guide.
//
// If you specify an invalid configuration, a TranscriptFailed event will be
// sent with the contents of the BadRequestException generated by Amazon Transcribe.
// For more information on each parameter and which combinations are valid,
// refer to the StartStreamTranscription (https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html)
// API in the Amazon Transcribe Developer Guide.
//
// Amazon Chime SDK live transcription is powered by Amazon Transcribe. Use
// of Amazon Transcribe is subject to the AWS Service Terms (https://aws.amazon.com/service-terms/),
// including the terms specific to the AWS Machine Learning and Artificial Intelligence
// Services.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, StartMeetingTranscription (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_StartMeetingTranscription.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation StartMeetingTranscription for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/StartMeetingTranscription
//
// Deprecated: Replaced by StartMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StartMeetingTranscription(input *StartMeetingTranscriptionInput) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StartMeetingTranscriptionWithContext is the same as StartMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by StartMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StartMeetingTranscriptionWithContext(ctx aws.Context, input *StartMeetingTranscriptionInput, opts ...request.Option) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMeetingTranscription = "StopMeetingTranscription"

// StopMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StopMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMeetingTranscription for more information on using the StopMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopMeetingTranscriptionRequest method.
//	req, resp := client.StopMeetingTranscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/StopMeetingTranscription
//
// Deprecated: Replaced by StopMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StopMeetingTranscriptionRequest(input *StopMeetingTranscriptionInput) (req *request.Request, output *StopMeetingTranscriptionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, StopMeetingTranscription, has been deprecated")
	}
	op := &request.Operation{
		Name:       opStopMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/transcription?operation=stop",
	}

	if input == nil {
		input = &StopMeetingTranscriptionInput{}
	}

	output = &StopMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMeetingTranscription API operation for Amazon Chime.
//
// Stops transcription for the specified meetingId.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, StopMeetingTranscription (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_StopMeetingTranscription.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation StopMeetingTranscription for usage and error information.
//
// Returned Error Types:
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - UnprocessableEntityException
//     The request was well-formed but was unable to be followed due to semantic
//     errors.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/StopMeetingTranscription
//
// Deprecated: Replaced by StopMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StopMeetingTranscription(input *StopMeetingTranscriptionInput) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StopMeetingTranscriptionWithContext is the same as StopMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StopMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by StopMeetingTranscription in the Amazon Chime SDK Meetings Namespace
func (c *Chime) StopMeetingTranscriptionWithContext(ctx aws.Context, input *StopMeetingTranscriptionInput, opts ...request.Option) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagAttendee = "TagAttendee"

// TagAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the TagAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagAttendee for more information on using the TagAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagAttendeeRequest method.
//	req, resp := client.TagAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagAttendee
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) TagAttendeeRequest(input *TagAttendeeInput) (req *request.Request, output *TagAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, TagAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opTagAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}/tags?operation=add",
	}

	if input == nil {
		input = &TagAttendeeInput{}
	}

	output = &TagAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagAttendee API operation for Amazon Chime.
//
// Applies the specified tags to the specified Amazon Chime attendee.
//
// TagAttendee is not supported in the Amazon Chime SDK Meetings Namespace.
// Update your application to remove calls to this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation TagAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagAttendee
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) TagAttendee(input *TagAttendeeInput) (*TagAttendeeOutput, error) {
	req, out := c.TagAttendeeRequest(input)
	return out, req.Send()
}

// TagAttendeeWithContext is the same as TagAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See TagAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) TagAttendeeWithContext(ctx aws.Context, input *TagAttendeeInput, opts ...request.Option) (*TagAttendeeOutput, error) {
	req, out := c.TagAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagMeeting = "TagMeeting"

// TagMeetingRequest generates a "aws/request.Request" representing the
// client's request for the TagMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagMeeting for more information on using the TagMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagMeetingRequest method.
//	req, resp := client.TagMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagMeeting
//
// Deprecated: Use TagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) TagMeetingRequest(input *TagMeetingInput) (req *request.Request, output *TagMeetingOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, TagMeeting, has been deprecated")
	}
	op := &request.Operation{
		Name:       opTagMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/tags?operation=add",
	}

	if input == nil {
		input = &TagMeetingInput{}
	}

	output = &TagMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagMeeting API operation for Amazon Chime.
//
// Applies the specified tags to the specified Amazon Chime SDK meeting.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, TagResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_TagResource.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation TagMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagMeeting
//
// Deprecated: Use TagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) TagMeeting(input *TagMeetingInput) (*TagMeetingOutput, error) {
	req, out := c.TagMeetingRequest(input)
	return out, req.Send()
}

// TagMeetingWithContext is the same as TagMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See TagMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use TagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) TagMeetingWithContext(ctx aws.Context, input *TagMeetingInput, opts ...request.Option) (*TagMeetingOutput, error) {
	req, out := c.TagMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagResource
//
// Deprecated: Replaced by TagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, TagResource, has been deprecated")
	}
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime.
//
// Applies the specified tags to the specified Amazon Chime SDK meeting resource.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, TagResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_TagResource.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/TagResource
//
// Deprecated: Replaced by TagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by TagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagAttendee = "UntagAttendee"

// UntagAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the UntagAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagAttendee for more information on using the UntagAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagAttendeeRequest method.
//	req, resp := client.UntagAttendeeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagAttendee
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) UntagAttendeeRequest(input *UntagAttendeeInput) (req *request.Request, output *UntagAttendeeOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UntagAttendee, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUntagAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}/tags?operation=delete",
	}

	if input == nil {
		input = &UntagAttendeeInput{}
	}

	output = &UntagAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagAttendee API operation for Amazon Chime.
//
// Untags the specified tags from the specified Amazon Chime SDK attendee.
//
// UntagAttendee is not supported in the Amazon Chime SDK Meetings Namespace.
// Update your application to remove calls to this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UntagAttendee for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagAttendee
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) UntagAttendee(input *UntagAttendeeInput) (*UntagAttendeeOutput, error) {
	req, out := c.UntagAttendeeRequest(input)
	return out, req.Send()
}

// UntagAttendeeWithContext is the same as UntagAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See UntagAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Attendee Tags are not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
func (c *Chime) UntagAttendeeWithContext(ctx aws.Context, input *UntagAttendeeInput, opts ...request.Option) (*UntagAttendeeOutput, error) {
	req, out := c.UntagAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagMeeting = "UntagMeeting"

// UntagMeetingRequest generates a "aws/request.Request" representing the
// client's request for the UntagMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagMeeting for more information on using the UntagMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagMeetingRequest method.
//	req, resp := client.UntagMeetingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagMeeting
//
// Deprecated: Use UntagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) UntagMeetingRequest(input *UntagMeetingInput) (req *request.Request, output *UntagMeetingOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UntagMeeting, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUntagMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/tags?operation=delete",
	}

	if input == nil {
		input = &UntagMeetingInput{}
	}

	output = &UntagMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagMeeting API operation for Amazon Chime.
//
// Untags the specified tags from the specified Amazon Chime SDK meeting.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UntagResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_UntagResource.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UntagMeeting for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagMeeting
//
// Deprecated: Use UntagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) UntagMeeting(input *UntagMeetingInput) (*UntagMeetingOutput, error) {
	req, out := c.UntagMeetingRequest(input)
	return out, req.Send()
}

// UntagMeetingWithContext is the same as UntagMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See UntagMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use UntagResource in the Amazon Chime SDK Meetings Namespace.
func (c *Chime) UntagMeetingWithContext(ctx aws.Context, input *UntagMeetingInput, opts ...request.Option) (*UntagMeetingOutput, error) {
	req, out := c.UntagMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagResource
//
// Deprecated: Replaced by UntagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UntagResource, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime.
//
// Untags the specified tags from the specified Amazon Chime SDK meeting resource.
//
// Applies the specified tags to the specified Amazon Chime SDK meeting resource.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UntagResource (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_UntagResource.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagResource
//
// Deprecated: Replaced by UntagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UntagResource in the Amazon Chime SDK Voice, Amazon Chime SDK Meetings, Amazon Chime SDK Identity, Amazon Chime SDK Messaging, and Amazon Chime SDK Media Pipelines Namespaces
func (c *Chime) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccount = "UpdateAccount"

// UpdateAccountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccount for more information on using the UpdateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountRequest method.
//	req, resp := client.UpdateAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccountRequest(input *UpdateAccountInput) (req *request.Request, output *UpdateAccountOutput) {
	op := &request.Operation{
		Name:       opUpdateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &UpdateAccountInput{}
	}

	output = &UpdateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccount API operation for Amazon Chime.
//
// Updates account details for the specified Amazon Chime account. Currently,
// only account name and default license updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccount for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccount(input *UpdateAccountInput) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	return out, req.Send()
}

// UpdateAccountWithContext is the same as UpdateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountWithContext(ctx aws.Context, input *UpdateAccountInput, opts ...request.Option) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSettingsRequest method.
//	req, resp := client.UpdateAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountSettings API operation for Amazon Chime.
//
// Updates the settings for the specified Amazon Chime account. You can update
// settings for remote control of shared screens, or for the dial-out option.
// For more information about these settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstance = "UpdateAppInstance"

// UpdateAppInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstance for more information on using the UpdateAppInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceRequest method.
//	req, resp := client.UpdateAppInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAppInstance
//
// Deprecated: Replaced by UpdateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstanceRequest(input *UpdateAppInstanceInput) (req *request.Request, output *UpdateAppInstanceOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateAppInstance, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateAppInstance,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instances/{appInstanceArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceInput{}
	}

	output = &UpdateAppInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAppInstance API operation for Amazon Chime.
//
// Updates AppInstance metadata.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateAppInstance (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_UpdateAppInstance.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAppInstance for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAppInstance
//
// Deprecated: Replaced by UpdateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstance(input *UpdateAppInstanceInput) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceWithContext is the same as UpdateAppInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateAppInstance in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstanceWithContext(ctx aws.Context, input *UpdateAppInstanceInput, opts ...request.Option) (*UpdateAppInstanceOutput, error) {
	req, out := c.UpdateAppInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppInstanceUser = "UpdateAppInstanceUser"

// UpdateAppInstanceUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppInstanceUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppInstanceUser for more information on using the UpdateAppInstanceUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAppInstanceUserRequest method.
//	req, resp := client.UpdateAppInstanceUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAppInstanceUser
//
// Deprecated: Replaced by UpdateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstanceUserRequest(input *UpdateAppInstanceUserInput) (req *request.Request, output *UpdateAppInstanceUserOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateAppInstanceUser, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateAppInstanceUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/app-instance-users/{appInstanceUserArn}",
	}

	if input == nil {
		input = &UpdateAppInstanceUserInput{}
	}

	output = &UpdateAppInstanceUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("identity-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateAppInstanceUser API operation for Amazon Chime.
//
// Updates the details of an AppInstanceUser. You can update names and metadata.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateAppInstanceUser (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_UpdateAppInstanceUser.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAppInstanceUser for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAppInstanceUser
//
// Deprecated: Replaced by UpdateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstanceUser(input *UpdateAppInstanceUserInput) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	return out, req.Send()
}

// UpdateAppInstanceUserWithContext is the same as UpdateAppInstanceUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppInstanceUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateAppInstanceUser in the Amazon Chime SDK Identity Namespace
func (c *Chime) UpdateAppInstanceUserWithContext(ctx aws.Context, input *UpdateAppInstanceUserInput, opts ...request.Option) (*UpdateAppInstanceUserOutput, error) {
	req, out := c.UpdateAppInstanceUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBot = "UpdateBot"

// UpdateBotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBot for more information on using the UpdateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotRequest method.
//	req, resp := client.UpdateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot
func (c *Chime) UpdateBotRequest(input *UpdateBotInput) (req *request.Request, output *UpdateBotOutput) {
	op := &request.Operation{
		Name:       opUpdateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}",
	}

	if input == nil {
		input = &UpdateBotInput{}
	}

	output = &UpdateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBot API operation for Amazon Chime.
//
// Updates the status of the specified bot, such as starting or stopping the
// bot from running in your Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateBot for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot
func (c *Chime) UpdateBot(input *UpdateBotInput) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	return out, req.Send()
}

// UpdateBotWithContext is the same as UpdateBot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateBotWithContext(ctx aws.Context, input *UpdateBotInput, opts ...request.Option) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannel
//
// Deprecated: Replaced by UpdateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateChannel, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateChannel API operation for Amazon Chime.
//
// Update a channel's attributes.
//
// Restriction: You can't change a channel's privacy.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateChannel (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannel.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannel
//
// Deprecated: Replaced by UpdateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateChannel in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelMessage = "UpdateChannelMessage"

// UpdateChannelMessageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelMessage for more information on using the UpdateChannelMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelMessageRequest method.
//	req, resp := client.UpdateChannelMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannelMessage
//
// Deprecated: Replaced by UpdateChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelMessageRequest(input *UpdateChannelMessageInput) (req *request.Request, output *UpdateChannelMessageOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateChannelMessage, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateChannelMessage,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/messages/{messageId}",
	}

	if input == nil {
		input = &UpdateChannelMessageInput{}
	}

	output = &UpdateChannelMessageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateChannelMessage API operation for Amazon Chime.
//
// Updates the content of a message.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateChannelMessage (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannelMessage.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateChannelMessage for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannelMessage
//
// Deprecated: Replaced by UpdateChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelMessage(input *UpdateChannelMessageInput) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	return out, req.Send()
}

// UpdateChannelMessageWithContext is the same as UpdateChannelMessage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateChannelMessage in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelMessageWithContext(ctx aws.Context, input *UpdateChannelMessageInput, opts ...request.Option) (*UpdateChannelMessageOutput, error) {
	req, out := c.UpdateChannelMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelReadMarker = "UpdateChannelReadMarker"

// UpdateChannelReadMarkerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelReadMarker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelReadMarker for more information on using the UpdateChannelReadMarker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelReadMarkerRequest method.
//	req, resp := client.UpdateChannelReadMarkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannelReadMarker
//
// Deprecated: Replaced by UpdateChannelReadMarker in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelReadMarkerRequest(input *UpdateChannelReadMarkerInput) (req *request.Request, output *UpdateChannelReadMarkerOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateChannelReadMarker, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateChannelReadMarker,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels/{channelArn}/readMarker",
	}

	if input == nil {
		input = &UpdateChannelReadMarkerInput{}
	}

	output = &UpdateChannelReadMarkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("messaging-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateChannelReadMarker API operation for Amazon Chime.
//
// The details of the time when a user last read messages in a channel.
//
// The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn
// of the user that makes the API call as the value in the header.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateChannelReadMarker (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannelReadMarker.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateChannelReadMarker for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateChannelReadMarker
//
// Deprecated: Replaced by UpdateChannelReadMarker in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelReadMarker(input *UpdateChannelReadMarkerInput) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	return out, req.Send()
}

// UpdateChannelReadMarkerWithContext is the same as UpdateChannelReadMarker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelReadMarker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateChannelReadMarker in the Amazon Chime SDK Messaging Namespace
func (c *Chime) UpdateChannelReadMarkerWithContext(ctx aws.Context, input *UpdateChannelReadMarkerInput, opts ...request.Option) (*UpdateChannelReadMarkerOutput, error) {
	req, out := c.UpdateChannelReadMarkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalSettings for more information on using the UpdateGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlobalSettingsRequest method.
//	req, resp := client.UpdateGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings
func (c *Chime) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) (req *request.Request, output *UpdateGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	output = &UpdateGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGlobalSettings API operation for Amazon Chime.
//
// Updates global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings
func (c *Chime) UpdateGlobalSettings(input *UpdateGlobalSettingsInput) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalSettingsWithContext is the same as UpdateGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateGlobalSettingsWithContext(ctx aws.Context, input *UpdateGlobalSettingsInput, opts ...request.Option) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumber = "UpdatePhoneNumber"

// UpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumber for more information on using the UpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePhoneNumberRequest method.
//	req, resp := client.UpdatePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber
func (c *Chime) UpdatePhoneNumberRequest(input *UpdatePhoneNumberInput) (req *request.Request, output *UpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &UpdatePhoneNumberInput{}
	}

	output = &UpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePhoneNumber API operation for Amazon Chime.
//
// Updates phone number details, such as product type or calling name, for the
// specified phone number ID. You can update one phone number detail at a time.
// For example, you can update either the product type or the calling name in
// one action.
//
// For toll-free numbers, you cannot use the Amazon Chime Business Calling product
// type. For numbers outside the U.S., you must use the Amazon Chime SIP Media
// Application Dial-In product type.
//
// Updates to outbound calling names can take 72 hours to complete. Pending
// updates to outbound calling names must be complete before you can request
// another update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber
func (c *Chime) UpdatePhoneNumber(input *UpdatePhoneNumberInput) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberWithContext is the same as UpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdatePhoneNumberWithContext(ctx aws.Context, input *UpdatePhoneNumberInput, opts ...request.Option) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumberSettings = "UpdatePhoneNumberSettings"

// UpdatePhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumberSettings for more information on using the UpdatePhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePhoneNumberSettingsRequest method.
//	req, resp := client.UpdatePhoneNumberSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings
func (c *Chime) UpdatePhoneNumberSettingsRequest(input *UpdatePhoneNumberSettingsInput) (req *request.Request, output *UpdatePhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumberSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &UpdatePhoneNumberSettingsInput{}
	}

	output = &UpdatePhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePhoneNumberSettings API operation for Amazon Chime.
//
// Updates the phone number settings for the administrator's AWS account, such
// as the default outbound calling name. You can update the default outbound
// calling name once every seven days. Outbound calling names can take up to
// 72 hours to update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdatePhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings
func (c *Chime) UpdatePhoneNumberSettings(input *UpdatePhoneNumberSettingsInput) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberSettingsWithContext is the same as UpdatePhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdatePhoneNumberSettingsWithContext(ctx aws.Context, input *UpdatePhoneNumberSettingsInput, opts ...request.Option) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProxySession = "UpdateProxySession"

// UpdateProxySessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProxySession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProxySession for more information on using the UpdateProxySession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProxySessionRequest method.
//	req, resp := client.UpdateProxySessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateProxySession
//
// Deprecated: Replaced by UpdateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateProxySessionRequest(input *UpdateProxySessionInput) (req *request.Request, output *UpdateProxySessionOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateProxySession, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateProxySession,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/proxy-sessions/{proxySessionId}",
	}

	if input == nil {
		input = &UpdateProxySessionInput{}
	}

	output = &UpdateProxySessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProxySession API operation for Amazon Chime.
//
// Updates the specified proxy session details, such as voice or SMS capabilities.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateProxySession (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateProxySession.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateProxySession for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateProxySession
//
// Deprecated: Replaced by UpdateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateProxySession(input *UpdateProxySessionInput) (*UpdateProxySessionOutput, error) {
	req, out := c.UpdateProxySessionRequest(input)
	return out, req.Send()
}

// UpdateProxySessionWithContext is the same as UpdateProxySession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProxySession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateProxySession in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateProxySessionWithContext(ctx aws.Context, input *UpdateProxySessionInput, opts ...request.Option) (*UpdateProxySessionOutput, error) {
	req, out := c.UpdateProxySessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoom for more information on using the UpdateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoomRequest method.
//	req, resp := client.UpdateRoomRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom
func (c *Chime) UpdateRoomRequest(input *UpdateRoomInput) (req *request.Request, output *UpdateRoomOutput) {
	op := &request.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	output = &UpdateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoom API operation for Amazon Chime.
//
// Updates room details, such as the room name, for a room in an Amazon Chime
// Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateRoom for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom
func (c *Chime) UpdateRoom(input *UpdateRoomInput) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	return out, req.Send()
}

// UpdateRoomWithContext is the same as UpdateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateRoomWithContext(ctx aws.Context, input *UpdateRoomInput, opts ...request.Option) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoomMembership = "UpdateRoomMembership"

// UpdateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoomMembership for more information on using the UpdateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoomMembershipRequest method.
//	req, resp := client.UpdateRoomMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership
func (c *Chime) UpdateRoomMembershipRequest(input *UpdateRoomMembershipInput) (req *request.Request, output *UpdateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opUpdateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &UpdateRoomMembershipInput{}
	}

	output = &UpdateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoomMembership API operation for Amazon Chime.
//
// Updates room membership details, such as the member role, for a room in an
// Amazon Chime Enterprise account. The member role designates whether the member
// is a chat room administrator or a general chat room member. The member role
// can be updated only for user IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateRoomMembership for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership
func (c *Chime) UpdateRoomMembership(input *UpdateRoomMembershipInput) (*UpdateRoomMembershipOutput, error) {
	req, out := c.UpdateRoomMembershipRequest(input)
	return out, req.Send()
}

// UpdateRoomMembershipWithContext is the same as UpdateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateRoomMembershipWithContext(ctx aws.Context, input *UpdateRoomMembershipInput, opts ...request.Option) (*UpdateRoomMembershipOutput, error) {
	req, out := c.UpdateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipMediaApplication = "UpdateSipMediaApplication"

// UpdateSipMediaApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipMediaApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipMediaApplication for more information on using the UpdateSipMediaApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipMediaApplicationRequest method.
//	req, resp := client.UpdateSipMediaApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipMediaApplication
//
// Deprecated: Replaced by UpdateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplicationRequest(input *UpdateSipMediaApplicationInput) (req *request.Request, output *UpdateSipMediaApplicationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateSipMediaApplication, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateSipMediaApplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}",
	}

	if input == nil {
		input = &UpdateSipMediaApplicationInput{}
	}

	output = &UpdateSipMediaApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipMediaApplication API operation for Amazon Chime.
//
// Updates the details of the specified SIP media application.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateSipMediaApplication (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateSipMediaApplication.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateSipMediaApplication for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipMediaApplication
//
// Deprecated: Replaced by UpdateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplication(input *UpdateSipMediaApplicationInput) (*UpdateSipMediaApplicationOutput, error) {
	req, out := c.UpdateSipMediaApplicationRequest(input)
	return out, req.Send()
}

// UpdateSipMediaApplicationWithContext is the same as UpdateSipMediaApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipMediaApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateSipMediaApplication in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplicationWithContext(ctx aws.Context, input *UpdateSipMediaApplicationInput, opts ...request.Option) (*UpdateSipMediaApplicationOutput, error) {
	req, out := c.UpdateSipMediaApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipMediaApplicationCall = "UpdateSipMediaApplicationCall"

// UpdateSipMediaApplicationCallRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipMediaApplicationCall operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipMediaApplicationCall for more information on using the UpdateSipMediaApplicationCall
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipMediaApplicationCallRequest method.
//	req, resp := client.UpdateSipMediaApplicationCallRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipMediaApplicationCall
//
// Deprecated: Replaced by UpdateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplicationCallRequest(input *UpdateSipMediaApplicationCallInput) (req *request.Request, output *UpdateSipMediaApplicationCallOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateSipMediaApplicationCall, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateSipMediaApplicationCall,
		HTTPMethod: "POST",
		HTTPPath:   "/sip-media-applications/{sipMediaApplicationId}/calls/{transactionId}",
	}

	if input == nil {
		input = &UpdateSipMediaApplicationCallInput{}
	}

	output = &UpdateSipMediaApplicationCallOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipMediaApplicationCall API operation for Amazon Chime.
//
// Invokes the AWS Lambda function associated with the SIP media application
// and transaction ID in an update request. The Lambda function can then return
// a new set of actions.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateSipMediaApplicationCall (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateSipMediaApplicationCall.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateSipMediaApplicationCall for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipMediaApplicationCall
//
// Deprecated: Replaced by UpdateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplicationCall(input *UpdateSipMediaApplicationCallInput) (*UpdateSipMediaApplicationCallOutput, error) {
	req, out := c.UpdateSipMediaApplicationCallRequest(input)
	return out, req.Send()
}

// UpdateSipMediaApplicationCallWithContext is the same as UpdateSipMediaApplicationCall with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipMediaApplicationCall for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateSipMediaApplicationCall in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipMediaApplicationCallWithContext(ctx aws.Context, input *UpdateSipMediaApplicationCallInput, opts ...request.Option) (*UpdateSipMediaApplicationCallOutput, error) {
	req, out := c.UpdateSipMediaApplicationCallRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSipRule = "UpdateSipRule"

// UpdateSipRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSipRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSipRule for more information on using the UpdateSipRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSipRuleRequest method.
//	req, resp := client.UpdateSipRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipRule
//
// Deprecated: Replaced by UpdateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipRuleRequest(input *UpdateSipRuleInput) (req *request.Request, output *UpdateSipRuleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateSipRule, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateSipRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/sip-rules/{sipRuleId}",
	}

	if input == nil {
		input = &UpdateSipRuleInput{}
	}

	output = &UpdateSipRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSipRule API operation for Amazon Chime.
//
// Updates the details of the specified SIP rule.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateSipRule (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateSipRule.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateSipRule for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ResourceLimitExceededException
//     The request exceeds the resource limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateSipRule
//
// Deprecated: Replaced by UpdateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipRule(input *UpdateSipRuleInput) (*UpdateSipRuleOutput, error) {
	req, out := c.UpdateSipRuleRequest(input)
	return out, req.Send()
}

// UpdateSipRuleWithContext is the same as UpdateSipRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSipRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateSipRule in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateSipRuleWithContext(ctx aws.Context, input *UpdateSipRuleInput, opts ...request.Option) (*UpdateSipRuleOutput, error) {
	req, out := c.UpdateSipRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon Chime.
//
// Updates user details for a specified user ID. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSettings = "UpdateUserSettings"

// UpdateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSettings for more information on using the UpdateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserSettingsRequest method.
//	req, resp := client.UpdateUserSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings
func (c *Chime) UpdateUserSettingsRequest(input *UpdateUserSettingsInput) (req *request.Request, output *UpdateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/users/{userId}/settings",
	}

	if input == nil {
		input = &UpdateUserSettingsInput{}
	}

	output = &UpdateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserSettings API operation for Amazon Chime.
//
// Updates the settings for the specified user, such as phone number settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateUserSettings for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings
func (c *Chime) UpdateUserSettings(input *UpdateUserSettingsInput) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	return out, req.Send()
}

// UpdateUserSettingsWithContext is the same as UpdateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateUserSettingsWithContext(ctx aws.Context, input *UpdateUserSettingsInput, opts ...request.Option) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnector = "UpdateVoiceConnector"

// UpdateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnector for more information on using the UpdateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVoiceConnectorRequest method.
//	req, resp := client.UpdateVoiceConnectorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector
//
// Deprecated: Replaced by UpdateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnectorRequest(input *UpdateVoiceConnectorInput) (req *request.Request, output *UpdateVoiceConnectorOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateVoiceConnector, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateVoiceConnector,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorInput{}
	}

	output = &UpdateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnector API operation for Amazon Chime.
//
// Updates details for the specified Amazon Chime Voice Connector.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateVoiceConnector (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateVoiceConnector.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateVoiceConnector for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector
//
// Deprecated: Replaced by UpdateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnector(input *UpdateVoiceConnectorInput) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorWithContext is the same as UpdateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateVoiceConnector in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnectorWithContext(ctx aws.Context, input *UpdateVoiceConnectorInput, opts ...request.Option) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnectorGroup = "UpdateVoiceConnectorGroup"

// UpdateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnectorGroup for more information on using the UpdateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVoiceConnectorGroupRequest method.
//	req, resp := client.UpdateVoiceConnectorGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup
//
// Deprecated: Replaced by UpdateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnectorGroupRequest(input *UpdateVoiceConnectorGroupInput) (req *request.Request, output *UpdateVoiceConnectorGroupOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, UpdateVoiceConnectorGroup, has been deprecated")
	}
	op := &request.Operation{
		Name:       opUpdateVoiceConnectorGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorGroupInput{}
	}

	output = &UpdateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnectorGroup API operation for Amazon Chime.
//
// Updates details of the specified Amazon Chime Voice Connector group, such
// as the name and Amazon Chime Voice Connector priority ranking.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, UpdateVoiceConnectorGroup (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_UpdateVoiceConnectorGroup.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ConflictException
//     The request could not be processed because of conflict in the current state
//     of the resource.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup
//
// Deprecated: Replaced by UpdateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnectorGroup(input *UpdateVoiceConnectorGroupInput) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorGroupWithContext is the same as UpdateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by UpdateVoiceConnectorGroup in the Amazon Chime SDK Voice Namespace
func (c *Chime) UpdateVoiceConnectorGroupWithContext(ctx aws.Context, input *UpdateVoiceConnectorGroupInput, opts ...request.Option) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateE911Address = "ValidateE911Address"

// ValidateE911AddressRequest generates a "aws/request.Request" representing the
// client's request for the ValidateE911Address operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateE911Address for more information on using the ValidateE911Address
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateE911AddressRequest method.
//	req, resp := client.ValidateE911AddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ValidateE911Address
//
// Deprecated: Replaced by ValidateE911Address in the Amazon Chime SDK Voice Namespace
func (c *Chime) ValidateE911AddressRequest(input *ValidateE911AddressInput) (req *request.Request, output *ValidateE911AddressOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ValidateE911Address, has been deprecated")
	}
	op := &request.Operation{
		Name:       opValidateE911Address,
		HTTPMethod: "POST",
		HTTPPath:   "/emergency-calling/address",
	}

	if input == nil {
		input = &ValidateE911AddressInput{}
	}

	output = &ValidateE911AddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateE911Address API operation for Amazon Chime.
//
// Validates an address to be used for 911 calls made with Amazon Chime Voice
// Connectors. You can use validated addresses in a Presence Information Data
// Format Location Object file that you include in SIP requests. That helps
// ensure that addresses are routed to the appropriate Public Safety Answering
// Point.
//
// This API is is no longer supported and will not be updated. We recommend
// using the latest version, ValidateE911Address (https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_voice-chime_ValidateE911Address.html),
// in the Amazon Chime SDK.
//
// Using the latest version requires migrating to a dedicated namespace. For
// more information, refer to Migrating from the Amazon Chime namespace (https://docs.aws.amazon.com/chime-sdk/latest/dg/migrate-from-chm-namespace.html)
// in the Amazon Chime SDK Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ValidateE911Address for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedClientException
//     The client is not currently authorized to make the request.
//
//   - NotFoundException
//     One or more of the resources in the request does not exist in the system.
//
//   - ForbiddenException
//     The client is permanently forbidden from making the request.
//
//   - BadRequestException
//     The input parameters don't match the service's restrictions.
//
//   - ThrottledClientException
//     The client exceeded its request rate limit.
//
//   - ServiceUnavailableException
//     The service is currently unavailable.
//
//   - ServiceFailureException
//     The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ValidateE911Address
//
// Deprecated: Replaced by ValidateE911Address in the Amazon Chime SDK Voice Namespace
func (c *Chime) ValidateE911Address(input *ValidateE911AddressInput) (*ValidateE911AddressOutput, error) {
	req, out := c.ValidateE911AddressRequest(input)
	return out, req.Send()
}

// ValidateE911AddressWithContext is the same as ValidateE911Address with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateE911Address for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Replaced by ValidateE911Address in the Amazon Chime SDK Voice Namespace
func (c *Chime) ValidateE911AddressWithContext(ctx aws.Context, input *ValidateE911AddressInput, opts ...request.Option) (*ValidateE911AddressOutput, error) {
	req, out := c.ValidateE911AddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon Chime account details. An AWS account can have multiple Amazon
// Chime accounts.
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The status of the account.
	AccountStatus *string `type:"string" enum:"AccountStatus"`

	// The Amazon Chime account type. For more information about different account
	// types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
	// in the Amazon Chime Administration Guide.
	AccountType *string `type:"string" enum:"AccountType"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The default license for the Amazon Chime account.
	DefaultLicense *string `type:"string" enum:"License"`

	// The Amazon Chime account name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The sign-in delegate groups associated with the account.
	SigninDelegateGroups []*SigninDelegateGroup `type:"list"`

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []*string `type:"list" enum:"License"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetAccountStatus sets the AccountStatus field's value.
func (s *Account) SetAccountStatus(v string) *Account {
	s.AccountStatus = &v
	return s
}

// SetAccountType sets the AccountType field's value.
func (s *Account) SetAccountType(v string) *Account {
	s.AccountType = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Account) SetAwsAccountId(v string) *Account {
	s.AwsAccountId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Account) SetCreatedTimestamp(v time.Time) *Account {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultLicense sets the DefaultLicense field's value.
func (s *Account) SetDefaultLicense(v string) *Account {
	s.DefaultLicense = &v
	return s
}

// SetName sets the Name field's value.
func (s *Account) SetName(v string) *Account {
	s.Name = &v
	return s
}

// SetSigninDelegateGroups sets the SigninDelegateGroups field's value.
func (s *Account) SetSigninDelegateGroups(v []*SigninDelegateGroup) *Account {
	s.SigninDelegateGroups = v
	return s
}

// SetSupportedLicenses sets the SupportedLicenses field's value.
func (s *Account) SetSupportedLicenses(v []*string) *Account {
	s.SupportedLicenses = v
	return s
}

// Settings related to the Amazon Chime account. This includes settings that
// start or stop remote control of shared screens, or start or stop the dial-out
// option in the Amazon Chime web application. For more information about these
// settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool `type:"boolean"`

	// Setting that allows meeting participants to choose the Call me at a phone
	// number option. For more information, see Join a Meeting without the Amazon
	// Chime App (https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
	EnableDialOut *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetDisableRemoteControl sets the DisableRemoteControl field's value.
func (s *AccountSettings) SetDisableRemoteControl(v bool) *AccountSettings {
	s.DisableRemoteControl = &v
	return s
}

// SetEnableDialOut sets the EnableDialOut field's value.
func (s *AccountSettings) SetEnableDialOut(v bool) *AccountSettings {
	s.EnableDialOut = &v
	return s
}

// A validated address.
type Address struct {
	_ struct{} `type:"structure"`

	// The city of an address.
	//
	// City is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	City *string `locationName:"city" type:"string" sensitive:"true"`

	// The country of an address.
	//
	// Country is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	Country *string `locationName:"country" type:"string" sensitive:"true"`

	// An address suffix location, such as the S. Unit A in Central Park S. Unit
	// A.
	//
	// PostDirectional is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostDirectional *string `locationName:"postDirectional" type:"string" sensitive:"true"`

	// The postal code of an address.
	//
	// PostalCode is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostalCode *string `locationName:"postalCode" type:"string" sensitive:"true"`

	// The Zip + 4 or postal code + 4 of an address.
	//
	// PostalCodePlus4 is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PostalCodePlus4 *string `locationName:"postalCodePlus4" type:"string" sensitive:"true"`

	// An address prefix location, such as the N in N. Third St..
	//
	// PreDirectional is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	PreDirectional *string `locationName:"preDirectional" type:"string" sensitive:"true"`

	// The state of an address.
	//
	// State is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	State *string `locationName:"state" type:"string" sensitive:"true"`

	// The address street, such as 8th Avenue.
	//
	// StreetName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetName *string `locationName:"streetName" type:"string" sensitive:"true"`

	// The numeric portion of an address.
	//
	// StreetNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetNumber *string `locationName:"streetNumber" type:"string" sensitive:"true"`

	// The address suffix, such as the N in 8th Avenue N.
	//
	// StreetSuffix is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Address's
	// String and GoString methods.
	StreetSuffix *string `locationName:"streetSuffix" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Address) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetPostDirectional sets the PostDirectional field's value.
func (s *Address) SetPostDirectional(v string) *Address {
	s.PostDirectional = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetPostalCodePlus4 sets the PostalCodePlus4 field's value.
func (s *Address) SetPostalCodePlus4(v string) *Address {
	s.PostalCodePlus4 = &v
	return s
}

// SetPreDirectional sets the PreDirectional field's value.
func (s *Address) SetPreDirectional(v string) *Address {
	s.PreDirectional = &v
	return s
}

// SetState sets the State field's value.
func (s *Address) SetState(v string) *Address {
	s.State = &v
	return s
}

// SetStreetName sets the StreetName field's value.
func (s *Address) SetStreetName(v string) *Address {
	s.StreetName = &v
	return s
}

// SetStreetNumber sets the StreetNumber field's value.
func (s *Address) SetStreetNumber(v string) *Address {
	s.StreetNumber = &v
	return s
}

// SetStreetSuffix sets the StreetSuffix field's value.
func (s *Address) SetStreetSuffix(v string) *Address {
	s.StreetSuffix = &v
	return s
}

// The Alexa for Business metadata associated with an Amazon Chime user, used
// to integrate Alexa for Business with a device.
type AlexaForBusinessMetadata struct {
	_ struct{} `type:"structure"`

	// The ARN of the room resource.
	//
	// AlexaForBusinessRoomArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AlexaForBusinessMetadata's
	// String and GoString methods.
	AlexaForBusinessRoomArn *string `type:"string" sensitive:"true"`

	// Starts or stops Alexa for Business.
	IsAlexaForBusinessEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlexaForBusinessMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlexaForBusinessMetadata) GoString() string {
	return s.String()
}

// SetAlexaForBusinessRoomArn sets the AlexaForBusinessRoomArn field's value.
func (s *AlexaForBusinessMetadata) SetAlexaForBusinessRoomArn(v string) *AlexaForBusinessMetadata {
	s.AlexaForBusinessRoomArn = &v
	return s
}

// SetIsAlexaForBusinessEnabled sets the IsAlexaForBusinessEnabled field's value.
func (s *AlexaForBusinessMetadata) SetIsAlexaForBusinessEnabled(v bool) *AlexaForBusinessMetadata {
	s.IsAlexaForBusinessEnabled = &v
	return s
}

// The details of an AppInstance, an instance of an Amazon Chime SDK messaging
// application.
type AppInstance struct {
	_ struct{} `type:"structure"`

	// The ARN of the messaging instance.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an AppInstance was created. In epoch milliseconds.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time an AppInstance was last updated. In epoch milliseconds.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of an AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstance's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstance) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstance) SetAppInstanceArn(v string) *AppInstance {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstance) SetCreatedTimestamp(v time.Time) *AppInstance {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstance) SetLastUpdatedTimestamp(v time.Time) *AppInstance {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstance) SetMetadata(v string) *AppInstance {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstance) SetName(v string) *AppInstance {
	s.Name = &v
	return s
}

// The details of an AppInstanceAdmin.
type AppInstanceAdmin struct {
	_ struct{} `type:"structure"`

	// The AppInstanceAdmin data.
	Admin *Identity `type:"structure"`

	// The ARN of the AppInstance for which the user is an administrator.
	AppInstanceArn *string `min:"5" type:"string"`

	// The time at which an administrator was created.
	CreatedTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdmin) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdmin) SetAdmin(v *Identity) *AppInstanceAdmin {
	s.Admin = v
	return s
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceAdmin) SetAppInstanceArn(v string) *AppInstanceAdmin {
	s.AppInstanceArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceAdmin) SetCreatedTimestamp(v time.Time) *AppInstanceAdmin {
	s.CreatedTimestamp = &v
	return s
}

// Summary of the details of an AppInstanceAdmin.
type AppInstanceAdminSummary struct {
	_ struct{} `type:"structure"`

	// The details of the AppInstanceAdmin.
	Admin *Identity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceAdminSummary) GoString() string {
	return s.String()
}

// SetAdmin sets the Admin field's value.
func (s *AppInstanceAdminSummary) SetAdmin(v *Identity) *AppInstanceAdminSummary {
	s.Admin = v
	return s
}

// The details of the data-retention settings for an AppInstance.
type AppInstanceRetentionSettings struct {
	_ struct{} `type:"structure"`

	// The length of time in days to retain the messages in a channel.
	ChannelRetentionSettings *ChannelRetentionSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceRetentionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppInstanceRetentionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppInstanceRetentionSettings"}
	if s.ChannelRetentionSettings != nil {
		if err := s.ChannelRetentionSettings.Validate(); err != nil {
			invalidParams.AddNested("ChannelRetentionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelRetentionSettings sets the ChannelRetentionSettings field's value.
func (s *AppInstanceRetentionSettings) SetChannelRetentionSettings(v *ChannelRetentionSettings) *AppInstanceRetentionSettings {
	s.ChannelRetentionSettings = v
	return s
}

// The details of the streaming configuration of an AppInstance.
type AppInstanceStreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of data to be streamed.
	//
	// AppInstanceDataType is a required field
	AppInstanceDataType *string `type:"string" required:"true" enum:"AppInstanceDataType"`

	// The resource ARN.
	//
	// ResourceArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceStreamingConfiguration's
	// String and GoString methods.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceStreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceStreamingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppInstanceStreamingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppInstanceStreamingConfiguration"}
	if s.AppInstanceDataType == nil {
		invalidParams.Add(request.NewErrParamRequired("AppInstanceDataType"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppInstanceDataType sets the AppInstanceDataType field's value.
func (s *AppInstanceStreamingConfiguration) SetAppInstanceDataType(v string) *AppInstanceStreamingConfiguration {
	s.AppInstanceDataType = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AppInstanceStreamingConfiguration) SetResourceArn(v string) *AppInstanceStreamingConfiguration {
	s.ResourceArn = &v
	return s
}

// Summary of the data for an AppInstance.
type AppInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The AppInstance ARN.
	AppInstanceArn *string `min:"5" type:"string"`

	// The metadata of the AppInstance.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstance.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceSummary) GoString() string {
	return s.String()
}

// SetAppInstanceArn sets the AppInstanceArn field's value.
func (s *AppInstanceSummary) SetAppInstanceArn(v string) *AppInstanceSummary {
	s.AppInstanceArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceSummary) SetMetadata(v string) *AppInstanceSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceSummary) SetName(v string) *AppInstanceSummary {
	s.Name = &v
	return s
}

// The details of an AppInstanceUser.
type AppInstanceUser struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The time at which the AppInstanceUser was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The time at which the AppInstanceUser was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of the AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUser's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUser) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUser) SetAppInstanceUserArn(v string) *AppInstanceUser {
	s.AppInstanceUserArn = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *AppInstanceUser) SetCreatedTimestamp(v time.Time) *AppInstanceUser {
	s.CreatedTimestamp = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *AppInstanceUser) SetLastUpdatedTimestamp(v time.Time) *AppInstanceUser {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUser) SetMetadata(v string) *AppInstanceUser {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUser) SetName(v string) *AppInstanceUser {
	s.Name = &v
	return s
}

// Summary of the membership details of an AppInstanceUser.
type AppInstanceUserMembershipSummary struct {
	_ struct{} `type:"structure"`

	// The time at which a message was last read.
	ReadMarkerTimestamp *time.Time `type:"timestamp"`

	// The type of ChannelMembership.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserMembershipSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserMembershipSummary) GoString() string {
	return s.String()
}

// SetReadMarkerTimestamp sets the ReadMarkerTimestamp field's value.
func (s *AppInstanceUserMembershipSummary) SetReadMarkerTimestamp(v time.Time) *AppInstanceUserMembershipSummary {
	s.ReadMarkerTimestamp = &v
	return s
}

// SetType sets the Type field's value.
func (s *AppInstanceUserMembershipSummary) SetType(v string) *AppInstanceUserMembershipSummary {
	s.Type = &v
	return s
}

// Summary of the details of an AppInstanceUser.
type AppInstanceUserSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the AppInstanceUser.
	AppInstanceUserArn *string `min:"5" type:"string"`

	// The metadata of the AppInstanceUser.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Metadata *string `type:"string" sensitive:"true"`

	// The name of an AppInstanceUser.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AppInstanceUserSummary's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppInstanceUserSummary) GoString() string {
	return s.String()
}

// SetAppInstanceUserArn sets the AppInstanceUserArn field's value.
func (s *AppInstanceUserSummary) SetAppInstanceUserArn(v string) *AppInstanceUserSummary {
	s.AppInstanceUserArn = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *AppInstanceUserSummary) SetMetadata(v string) *AppInstanceUserSummary {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *AppInstanceUserSummary) SetName(v string) *AppInstanceUserSummary {
	s.Name = &v
	return s
}

// The configuration for the artifacts.
type ArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the audio artifacts.
	//
	// Audio is a required field
	Audio *AudioArtifactsConfiguration `type:"structure" required:"true"`

	// The configuration for the content artifacts.
	//
	// Content is a required field
	Content *ContentArtifactsConfiguration `type:"structure" required:"true"`

	// The configuration for the video artifacts.
	//
	// Video is a required field
	Video *VideoArtifactsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactsConfiguration"}
	if s.Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("Audio"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.Audio != nil {
		if err := s.Audio.Validate(); err != nil {
			invalidParams.AddNested("Audio", err.(request.ErrInvalidParams))
		}
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *ArtifactsConfiguration) SetAudio(v *AudioArtifactsConfiguration) *ArtifactsConfiguration {
	s.Audio = v
	return s
}

// SetContent sets the Content field's value.
func (s *ArtifactsConfiguration) SetContent(v *ContentArtifactsConfiguration) *ArtifactsConfiguration {
	s.Content = v
	return s
}

// SetVideo sets the Video field's value.
func (s *ArtifactsConfiguration) SetVideo(v *VideoArtifactsConfiguration) *ArtifactsConfiguration {
	s.Video = v
	return s
}

type AssociatePhoneNumberWithUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The phone number, in E.164 format.
	//
	// E164PhoneNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssociatePhoneNumberWithUserInput's
	// String and GoString methods.
	//
	// E164PhoneNumber is a required field
	E164PhoneNumber *string `type:"string" required:"true" sensitive:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberWithUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberWithUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumberWithUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumberWithUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.E164PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumber"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociatePhoneNumberWithUserInput) SetAccountId(v string) *AssociatePhoneNumberWithUserInput {
	s.AccountId = &v
	return s
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *AssociatePhoneNumberWithUserInput) SetE164PhoneNumber(v string) *AssociatePhoneNumberWithUserInput {
	s.E164PhoneNumber = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AssociatePhoneNumberWithUserInput) SetUserId(v string) *AssociatePhoneNumberWithUserInput {
	s.UserId = &v
	return s
}

type AssociatePhoneNumberWithUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberWithUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberWithUserOutput) GoString() string {
	return s.String()
}

type AssociatePhoneNumbersWithVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	//
	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// If true, associates the provided phone numbers with the provided Amazon Chime
	// Voice Connector Group and removes any previously existing associations. If
	// false, does not associate any phone numbers that have previously existing
	// associations.
	ForceAssociate *bool `type:"boolean"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorGroupInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorGroupOutput {
	s.PhoneNumberErrors = v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	//
	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// If true, associates the provided phone numbers with the provided Amazon Chime
	// Voice Connector and removes any previously existing associations. If false,
	// does not associate any phone numbers that have previously existing associations.
	ForceAssociate *bool `type:"boolean"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetVoiceConnectorId(v string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorOutput {
	s.PhoneNumberErrors = v
	return s
}

type AssociateSigninDelegateGroupsWithAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The sign-in delegate groups.
	//
	// SigninDelegateGroups is a required field
	SigninDelegateGroups []*SigninDelegateGroup `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSigninDelegateGroupsWithAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSigninDelegateGroupsWithAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSigninDelegateGroupsWithAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSigninDelegateGroupsWithAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.SigninDelegateGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("SigninDelegateGroups"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociateSigninDelegateGroupsWithAccountInput) SetAccountId(v string) *AssociateSigninDelegateGroupsWithAccountInput {
	s.AccountId = &v
	return s
}

// SetSigninDelegateGroups sets the SigninDelegateGroups field's value.
func (s *AssociateSigninDelegateGroupsWithAccountInput) SetSigninDelegateGroups(v []*SigninDelegateGroup) *AssociateSigninDelegateGroupsWithAccountInput {
	s.SigninDelegateGroups = v
	return s
}

type AssociateSigninDelegateGroupsWithAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSigninDelegateGroupsWithAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSigninDelegateGroupsWithAccountOutput) GoString() string {
	return s.String()
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken
// . The JoinToken allows a client to authenticate and join as the specified
// attendee. The JoinToken expires when the meeting ends or when DeleteAttendee
// is called. After that, the attendee is unable to join the meeting.
//
// We recommend securely transferring each JoinToken from your server application
// to the client so that no other client has access to the token except for
// the one authorized to represent the attendee.
type Attendee struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string `type:"string"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`

	// The join token used by the Amazon Chime SDK attendee.
	//
	// JoinToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	JoinToken *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) GoString() string {
	return s.String()
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *Attendee) SetAttendeeId(v string) *Attendee {
	s.AttendeeId = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *Attendee) SetExternalUserId(v string) *Attendee {
	s.ExternalUserId = &v
	return s
}

// SetJoinToken sets the JoinToken field's value.
func (s *Attendee) SetJoinToken(v string) *Attendee {
	s.JoinToken = &v
	return s
}

// The audio artifact configuration object.
type AudioArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the audio artifact configuration object.
	//
	// MuxType is a required field
	MuxType *string `type:"string" required:"true" enum:"AudioMuxType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioArtifactsConfiguration"}
	if s.MuxType == nil {
		invalidParams.Add(request.NewErrParamRequired("MuxType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *AudioArtifactsConfiguration) SetMuxType(v string) *AudioArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The membership information, including member ARNs, the channel ARN, and membership
// types.
type BatchChannelMemberships struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel to which you're adding users.
	ChannelArn *string `min:"5" type:"string"`

	// The identifier of the member who invited another member.
	InvitedBy *Identity `type:"structure"`

	// The users successfully added to the request.
	Members []*Identity `type:"list"`

	// The membership types set for the channel users.
	Type *string `type:"string" enum:"ChannelMembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchChannelMemberships) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchChannelMemberships) GoString() string {
	return s.String()
}

// SetChannelArn sets the ChannelArn field's value.
func (s *BatchChannelMemberships) SetChannelArn(v string) *BatchChannelMemberships {
	s.ChannelArn = &v
	return s
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *BatchChannelMemberships) SetInvitedBy(v *Identity) *BatchChannelMemberships {
	s.InvitedBy = v
	return s
}

// SetMembers sets the Members field's value.
func (s *BatchChannelMemberships) SetMembers(v []*Identity) *BatchChannelMemberships {
	s.Members = v
	return s
}

// SetType sets the Type field's value.
func (s *BatchChannelMemberships) SetType(v string) *BatchChannelMemberships {
	s.Type = &v
	return s
}

type BatchCreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The request containing the attendees to create.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `type:"list" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeInput) String() string {
	return awsutil.P