// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ConsumptionPoolUpdateInfo ConsumptionPoolUpdateInfo represents information about any updates made to the consumption pool
//
// swagger:model billing_20201105ConsumptionPoolUpdateInfo
type Billing20201105ConsumptionPoolUpdateInfo struct {

	// new_state is the current state of the consumption pool field after the update.
	NewState string `json:"new_state,omitempty"`

	// prev_state is the previous state of the consumption pool field before it was updated.
	PrevState string `json:"prev_state,omitempty"`

	// update_cause is the reason for the update to the consumption pool (ex. addon, rollover)
	UpdateCause *Billing20201105ConsumptionPoolUpdateInfoUpdateCause `json:"update_cause,omitempty"`

	// update_date is the timestamp of when the consumption pool was updated.
	// Format: date-time
	UpdateDate strfmt.DateTime `json:"update_date,omitempty"`

	// created_at is the time when consumption pool update has been created.
	// Format: date-time
	UpdateEffectiveAt strfmt.DateTime `json:"update_effective_at,omitempty"`

	// updated_field is the field of the consumption pool that was updated.
	UpdatedField string `json:"updated_field,omitempty"`

	// updated_product is the product that was updated if product-specific support or discount levels were updated
	UpdatedProduct string `json:"updated_product,omitempty"`
}

// Validate validates this billing 20201105 consumption pool update info
func (m *Billing20201105ConsumptionPoolUpdateInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUpdateCause(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateEffectiveAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ConsumptionPoolUpdateInfo) validateUpdateCause(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateCause) { // not required
		return nil
	}

	if m.UpdateCause != nil {
		if err := m.UpdateCause.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("update_cause")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("update_cause")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105ConsumptionPoolUpdateInfo) validateUpdateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateDate) { // not required
		return nil
	}

	if err := validate.FormatOf("update_date", "body", "date-time", m.UpdateDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPoolUpdateInfo) validateUpdateEffectiveAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateEffectiveAt) { // not required
		return nil
	}

	if err := validate.FormatOf("update_effective_at", "body", "date-time", m.UpdateEffectiveAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this billing 20201105 consumption pool update info based on the context it is used
func (m *Billing20201105ConsumptionPoolUpdateInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUpdateCause(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ConsumptionPoolUpdateInfo) contextValidateUpdateCause(ctx context.Context, formats strfmt.Registry) error {

	if m.UpdateCause != nil {

		if swag.IsZero(m.UpdateCause) { // not required
			return nil
		}

		if err := m.UpdateCause.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("update_cause")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("update_cause")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ConsumptionPoolUpdateInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ConsumptionPoolUpdateInfo) UnmarshalBinary(b []byte) error {
	var res Billing20201105ConsumptionPoolUpdateInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
