// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ConsumptionPoolsSummary ConsumptionPoolsSummary is a summary/overview info of consumption pools of a
// single billing account
//
// swagger:model billing_20201105ConsumptionPoolsSummary
type Billing20201105ConsumptionPoolsSummary struct {

	// active_from is the timestamp of when the earliest of active consumption pools became active.
	// Format: date-time
	ActiveFrom strfmt.DateTime `json:"active_from,omitempty"`

	// active_until is the timestamp of when the the latest of active consumption pools became inactive.
	// Format: date-time
	ActiveUntil strfmt.DateTime `json:"active_until,omitempty"`

	// estimated_remaining_balance is the total estimated remaining balance.
	// of all the active consumption pools in USD.
	EstimatedRemainingBalance string `json:"estimated_remaining_balance,omitempty"`

	// initial_amount is the total initial amount of all active consumption pools in USD.
	InitialAmount string `json:"initial_amount,omitempty"`

	// updated_at is the last time the any of active consumption pools has been updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this billing 20201105 consumption pools summary
func (m *Billing20201105ConsumptionPoolsSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActiveUntil(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ConsumptionPoolsSummary) validateActiveFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("active_from", "body", "date-time", m.ActiveFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPoolsSummary) validateActiveUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("active_until", "body", "date-time", m.ActiveUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPoolsSummary) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this billing 20201105 consumption pools summary based on context it is used
func (m *Billing20201105ConsumptionPoolsSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ConsumptionPoolsSummary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ConsumptionPoolsSummary) UnmarshalBinary(b []byte) error {
	var res Billing20201105ConsumptionPoolsSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
