// Code generated by go-swagger; DO NOT EDIT.

package s_s_o_management_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// SSOManagementServiceVerifyDomainOwnershipReader is a Reader for the SSOManagementServiceVerifyDomainOwnership structure.
type SSOManagementServiceVerifyDomainOwnershipReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SSOManagementServiceVerifyDomainOwnershipReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSSOManagementServiceVerifyDomainOwnershipOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSSOManagementServiceVerifyDomainOwnershipDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSSOManagementServiceVerifyDomainOwnershipOK creates a SSOManagementServiceVerifyDomainOwnershipOK with default headers values
func NewSSOManagementServiceVerifyDomainOwnershipOK() *SSOManagementServiceVerifyDomainOwnershipOK {
	return &SSOManagementServiceVerifyDomainOwnershipOK{}
}

/*
SSOManagementServiceVerifyDomainOwnershipOK describes a response with status code 200, with default header values.

A successful response.
*/
type SSOManagementServiceVerifyDomainOwnershipOK struct {
	Payload *models.HashicorpCloudIamVerifyDomainOwnershipResponse
}

// IsSuccess returns true when this s s o management service verify domain ownership o k response has a 2xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s s o management service verify domain ownership o k response has a 3xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s s o management service verify domain ownership o k response has a 4xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s s o management service verify domain ownership o k response has a 5xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s s o management service verify domain ownership o k response a status code equal to that given
func (o *SSOManagementServiceVerifyDomainOwnershipOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s s o management service verify domain ownership o k response
func (o *SSOManagementServiceVerifyDomainOwnershipOK) Code() int {
	return 200
}

func (o *SSOManagementServiceVerifyDomainOwnershipOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/verify-domain-ownership][%d] sSOManagementServiceVerifyDomainOwnershipOK %s", 200, payload)
}

func (o *SSOManagementServiceVerifyDomainOwnershipOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/verify-domain-ownership][%d] sSOManagementServiceVerifyDomainOwnershipOK %s", 200, payload)
}

func (o *SSOManagementServiceVerifyDomainOwnershipOK) GetPayload() *models.HashicorpCloudIamVerifyDomainOwnershipResponse {
	return o.Payload
}

func (o *SSOManagementServiceVerifyDomainOwnershipOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamVerifyDomainOwnershipResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSSOManagementServiceVerifyDomainOwnershipDefault creates a SSOManagementServiceVerifyDomainOwnershipDefault with default headers values
func NewSSOManagementServiceVerifyDomainOwnershipDefault(code int) *SSOManagementServiceVerifyDomainOwnershipDefault {
	return &SSOManagementServiceVerifyDomainOwnershipDefault{
		_statusCode: code,
	}
}

/*
SSOManagementServiceVerifyDomainOwnershipDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type SSOManagementServiceVerifyDomainOwnershipDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this s s o management service verify domain ownership default response has a 2xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s s o management service verify domain ownership default response has a 3xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s s o management service verify domain ownership default response has a 4xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s s o management service verify domain ownership default response has a 5xx status code
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s s o management service verify domain ownership default response a status code equal to that given
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s s o management service verify domain ownership default response
func (o *SSOManagementServiceVerifyDomainOwnershipDefault) Code() int {
	return o._statusCode
}

func (o *SSOManagementServiceVerifyDomainOwnershipDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/verify-domain-ownership][%d] SSOManagementService_VerifyDomainOwnership default %s", o._statusCode, payload)
}

func (o *SSOManagementServiceVerifyDomainOwnershipDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/verify-domain-ownership][%d] SSOManagementService_VerifyDomainOwnership default %s", o._statusCode, payload)
}

func (o *SSOManagementServiceVerifyDomainOwnershipDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *SSOManagementServiceVerifyDomainOwnershipDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SSOManagementServiceVerifyDomainOwnershipBody VerifyDomainOwnershipRequest is the request to verify an organization's
// ownership/control of a domain.
swagger:model SSOManagementServiceVerifyDomainOwnershipBody
*/
type SSOManagementServiceVerifyDomainOwnershipBody struct {

	// domain is the domain for which ownership will be verified.
	Domain string `json:"domain,omitempty"`
}

// Validate validates this s s o management service verify domain ownership body
func (o *SSOManagementServiceVerifyDomainOwnershipBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this s s o management service verify domain ownership body based on context it is used
func (o *SSOManagementServiceVerifyDomainOwnershipBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SSOManagementServiceVerifyDomainOwnershipBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SSOManagementServiceVerifyDomainOwnershipBody) UnmarshalBinary(b []byte) error {
	var res SSOManagementServiceVerifyDomainOwnershipBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
